/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.util.OffhandMirrorGuard;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityEquipMixin
extends Entity {
    protected LivingEntityEquipMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"setItemSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void punchy$blockOffhandEquip(EquipmentSlot slot, ItemStack stack, CallbackInfo ci) {
        if (slot != EquipmentSlot.OFFHAND || stack.isEmpty()) {
            return;
        }
        LivingEntityEquipMixin livingEntityEquipMixin = this;
        if (!(livingEntityEquipMixin instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntityEquipMixin;
        if (OffhandMirrorGuard.isOffhandLocked(player)) {
            OffhandMirrorGuard.notifyLocked(player);
            ci.cancel();
        }
    }
}

