/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.networking;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.combat.ImpactServer;
import com.henrique.punchy.networking.packet.AxeStripPayload;
import com.henrique.punchy.networking.packet.BlockImpactPayload;
import com.henrique.punchy.networking.packet.HoeTillPayload;
import com.henrique.punchy.networking.packet.ImpactAttackPayload;
import com.henrique.punchy.networking.packet.ShovelPathPayload;
import com.henrique.punchy.platform.PlatformServices;
import com.henrique.punchy.server.TapMiningManager;
import com.henrique.punchy.util.AxeStripHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ServerPacketHandlers {
    public static void handleBlockImpact(BlockImpactPayload payload, PlatformServices.ServerPacketContext context) {
        BlockPos pos = payload.pos();
        ServerPlayer player = context.player();
        context.queue(() -> {
            if (!Punchy.TAP_MINING_ENABLED) {
                return;
            }
            ServerLevel world = player.level();
            TapMiningManager.onClick(player, world, pos);
        });
    }

    public static void handleHoeTill(HoeTillPayload payload, PlatformServices.ServerPacketContext context) {
        BlockPos pos = payload.pos();
        ServerPlayer player = context.player();
        context.queue(() -> {
            ServerLevel world = player.level();
            if (world == null) {
                return;
            }
            BlockPos above = pos.above();
            if (!world.getBlockState(above).isAir()) {
                return;
            }
            BlockState state = world.getBlockState(pos);
            if (state.is(Blocks.COARSE_DIRT)) {
                world.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                world.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
            } else if (state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT) || state.is(Blocks.DIRT_PATH) || state.is(Blocks.ROOTED_DIRT)) {
                world.setBlockAndUpdate(pos, Blocks.FARMLAND.defaultBlockState());
                world.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
            }
        });
    }

    public static void handleAxeStrip(AxeStripPayload payload, PlatformServices.ServerPacketContext context) {
        BlockPos pos = payload.pos();
        ServerPlayer player = context.player();
        context.queue(() -> {
            ServerLevel world = player.level();
            if (world == null) {
                return;
            }
            BlockState state = world.getBlockState(pos);
            AxeStripHelper.CopperResult copper = AxeStripHelper.tryCopper(state);
            if (copper != null) {
                world.setBlockAndUpdate(pos, copper.state());
                world.playSound(null, pos, copper.sound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
                return;
            }
            BlockState stripped = AxeStripHelper.getStrippedState(state);
            if (stripped != null) {
                world.setBlockAndUpdate(pos, stripped);
                world.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
            }
        });
    }

    public static void handleShovelPath(ShovelPathPayload payload, PlatformServices.ServerPacketContext context) {
        BlockPos pos = payload.pos();
        ServerPlayer player = context.player();
        context.queue(() -> {
            ServerLevel world = player.level();
            if (world == null) {
                return;
            }
            BlockPos above = pos.above();
            if (!world.getBlockState(above).isAir()) {
                return;
            }
            BlockState state = world.getBlockState(pos);
            if (state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT) || state.is(Blocks.COARSE_DIRT) || state.is(Blocks.ROOTED_DIRT)) {
                world.setBlockAndUpdate(pos, Blocks.DIRT_PATH.defaultBlockState());
                world.playSound(null, pos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                try {
                    player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static void handleImpactAttack(ImpactAttackPayload payload, PlatformServices.ServerPacketContext context) {
        ServerPlayer player = context.player();
        context.queue(() -> ImpactServer.handleImpact(player, payload));
    }
}

