/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.platform.neoforge;

import com.henrique.punchy.platform.ClientPlatformServices;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

public final class NeoForgeClientPlatformServices
implements ClientPlatformServices {
    public static final NeoForgeClientPlatformServices INSTANCE = new NeoForgeClientPlatformServices();
    private final List<Runnable> startCallbacks = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> tickCallbacks = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> renderCallbacks = new CopyOnWriteArrayList<Runnable>();
    private final List<KeyMapping> pendingKeyMappings = new CopyOnWriteArrayList<KeyMapping>();
    private volatile boolean started = false;

    private NeoForgeClientPlatformServices() {
    }

    public void registerModListeners(IEventBus modEventBus) {
        modEventBus.addListener(this::onRegisterKeyMappings);
        NeoForge.EVENT_BUS.addListener(this::onClientTick);
        NeoForge.EVENT_BUS.addListener(this::onRenderStage);
    }

    @Override
    public void registerClientStarted(Runnable runnable) {
        this.startCallbacks.add(runnable);
    }

    @Override
    public void registerClientTick(Runnable runnable) {
        this.tickCallbacks.add(runnable);
    }

    @Override
    public void registerRenderFrame(Runnable runnable) {
        this.renderCallbacks.add(runnable);
    }

    @Override
    public KeyMapping registerKeyBinding(KeyMapping mapping) {
        this.pendingKeyMappings.add(mapping);
        return mapping;
    }

    @Override
    public void sendToServer(CustomPacketPayload payload) {
        if (payload == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client == null || client.getConnection() == null) {
            return;
        }
        client.getConnection().send(payload);
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        this.pendingKeyMappings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private void onClientTick(ClientTickEvent.Post event) {
        if (!this.started) {
            this.started = true;
            this.startCallbacks.forEach(Runnable::run);
        }
        for (Runnable runnable : this.tickCallbacks) {
            runnable.run();
        }
    }

    private void onRenderStage(RenderLevelStageEvent.AfterTranslucentBlocks event) {
        for (Runnable runnable : this.renderCallbacks) {
            runnable.run();
        }
    }
}

