/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.platform.neoforge;

import com.henrique.punchy.platform.PlatformServices;
import com.henrique.punchy.platform.neoforge.NeoForgeServerPacketContext;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class NeoForgePlatformServices
implements PlatformServices {
    public static final NeoForgePlatformServices INSTANCE = new NeoForgePlatformServices();
    private final List<Consumer<BuildCreativeModeTabContentsEvent>> creativeTabCallbacks = new CopyOnWriteArrayList<Consumer<BuildCreativeModeTabContentsEvent>>();
    private final List<PacketRegistration<?>> pendingPackets = new CopyOnWriteArrayList();
    private volatile PayloadRegistrar registrar;

    private NeoForgePlatformServices() {
    }

    public void registerModEventListeners(IEventBus modEventBus) {
        modEventBus.addListener(this::onBuildCreativeTabs);
        modEventBus.addListener(this::onRegisterPayloadHandlers);
    }

    private void onBuildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        for (Consumer<BuildCreativeModeTabContentsEvent> callback : this.creativeTabCallbacks) {
            callback.accept(event);
        }
    }

    private void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        this.registrar = event.registrar("punchy");
        this.flushPendingPackets();
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.isProduction();
    }

    @Override
    public void addCreativeTabEntry(ResourceKey<CreativeModeTab> tab, Item item) {
        this.creativeTabCallbacks.add(event -> {
            if (event.getTabKey().equals(tab)) {
                event.accept((ItemLike)item);
            }
        });
    }

    @Override
    public void registerWorldTick(PlatformServices.WorldTickHandler handler) {
        NeoForge.EVENT_BUS.addListener(event -> {
            Level patt0$temp = event.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                handler.onWorldTick(serverLevel);
            }
        });
    }

    @Override
    public void registerAttackBlockListener(PlatformServices.AttackBlockListener listener) {
        NeoForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = listener.onAttackBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace());
            if (result != InteractionResult.PASS && (result.consumesAction() || result == InteractionResult.FAIL)) {
                event.setCanceled(true);
            }
        });
    }

    @Override
    public void registerAttackEntityListener(PlatformServices.AttackEntityListener listener) {
        NeoForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = listener.onAttackEntity(event.getEntity(), event.getEntity().level(), InteractionHand.MAIN_HAND, event.getTarget(), null);
            if (result != InteractionResult.PASS && result.consumesAction()) {
                event.setCanceled(true);
            }
        });
    }

    @Override
    public <T extends CustomPacketPayload> void registerServerReceiver(CustomPacketPayload.Type<T> type, StreamCodec<FriendlyByteBuf, T> codec, PlatformServices.ServerPacketHandler<T> handler) {
        PacketRegistration<T> packet = new PacketRegistration<T>(type, codec, handler);
        PayloadRegistrar registrarRef = this.registrar;
        if (registrarRef != null) {
            packet.register(registrarRef);
        } else {
            this.pendingPackets.add(packet);
        }
    }

    private void flushPendingPackets() {
        PayloadRegistrar registrarRef = this.registrar;
        if (registrarRef == null) {
            return;
        }
        for (PacketRegistration<?> packet : this.pendingPackets) {
            packet.register(registrarRef);
        }
        this.pendingPackets.clear();
    }

    private record PacketRegistration<T extends CustomPacketPayload>(CustomPacketPayload.Type<T> type, StreamCodec<FriendlyByteBuf, T> codec, PlatformServices.ServerPacketHandler<T> handler) {
        void register(PayloadRegistrar registrar) {
            registrar.playToServer(this.type, this.codec, (payload, context) -> this.handler.handle(payload, new NeoForgeServerPacketContext(context)));
        }
    }
}

