/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.client.render.AxolotlBucketRenderer;
import com.henrique.punchy.mixin.accessor.ItemStackRenderStateAccessor;
import com.henrique.punchy.mixin.accessor.ItemStackRenderStateLayerAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_1058;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_777;
import net.minecraft.class_804;
import org.joml.Vector3f;

public final class AxolotlBucketAnimator {
    private AxolotlBucketAnimator() {
    }

    public static void apply(class_1799 stack, class_10444 renderState, class_1268 hand) {
        if (!AxolotlBucketAnimator.shouldAnimate(stack)) {
            return;
        }
        ItemStackRenderStateAccessor accessor = (ItemStackRenderStateAccessor)renderState;
        int layerCount = accessor.punchy$activeLayerCount();
        if (layerCount <= 0) {
            return;
        }
        class_10444.class_10446[] layers = accessor.punchy$layers();
        ArrayList<ExtractedLayer> extracted = new ArrayList<ExtractedLayer>();
        for (int i = 0; i < layerCount && i < layers.length; ++i) {
            List quads;
            class_10444.class_10446 layer = layers[i];
            if (layer == null || (quads = layer.method_67997()).isEmpty()) continue;
            ArrayList<class_777> creatureQuads = new ArrayList<class_777>();
            Iterator it = quads.iterator();
            while (it.hasNext()) {
                class_1058 sprite;
                class_777 quad = (class_777)it.next();
                if (quad == null || (sprite = quad.comp_3724()) == null || !AxolotlBucketAnimator.isCreatureTexture(sprite.method_45851().method_45816())) continue;
                creatureQuads.add(quad);
                it.remove();
            }
            if (creatureQuads.isEmpty()) continue;
            ItemStackRenderStateLayerAccessor layerAccessor = (ItemStackRenderStateLayerAccessor)layer;
            class_1921 renderType = layerAccessor.punchy$renderType();
            if (renderType == null) {
                quads.addAll(creatureQuads);
                continue;
            }
            class_10444.class_10445 foilType = layerAccessor.punchy$foilType();
            class_804 transform = layerAccessor.punchy$transform();
            int[] tintLayers = layerAccessor.punchy$tintLayers();
            int[] tintCopy = tintLayers == null || tintLayers.length == 0 ? new int[]{} : (int[])tintLayers.clone();
            class_1058 particle = layerAccessor.punchy$particleIcon();
            Supplier<Vector3f[]> extents = layerAccessor.punchy$extents();
            boolean usesBlockLight = layerAccessor.punchy$usesBlockLight();
            extracted.add(new ExtractedLayer(creatureQuads, renderType, foilType, transform, tintCopy, particle, extents, usesBlockLight));
        }
        if (extracted.isEmpty()) {
            return;
        }
        for (ExtractedLayer entry : extracted) {
            class_10444.class_10446 target = renderState.method_65601();
            target.method_67992(entry.renderType());
            target.method_65615(entry.foilType());
            target.method_67993(entry.transform());
            target.method_67996(entry.usesBlockLight());
            if (entry.particle() != null) {
                target.method_67994(entry.particle());
            }
            if (entry.extents() != null) {
                target.method_67995(entry.extents());
            }
            int[] tint = entry.tintLayers();
            int[] dst = target.method_65613(tint.length);
            if (tint.length > 0) {
                System.arraycopy(tint, 0, dst, 0, tint.length);
            }
            target.method_65617((class_10515)AxolotlBucketRenderer.INSTANCE, (Object)new AxolotlBucketRenderer.LayerData(hand, entry.renderType(), entry.foilType(), dst, entry.quads()));
        }
    }

    private static boolean shouldAnimate(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        return stack.method_31574(class_1802.field_28354) || stack.method_31574(class_1802.field_8478) || stack.method_31574(class_1802.field_8108) || stack.method_31574(class_1802.field_8666) || stack.method_31574(class_1802.field_8714) || stack.method_31574(class_1802.field_37533);
    }

    private static boolean isCreatureTexture(class_2960 name) {
        if (name == null) {
            return false;
        }
        String path = name.method_12832();
        if (path == null) {
            return false;
        }
        String normalized = path.toLowerCase(Locale.ROOT);
        if (!normalized.startsWith("item/")) {
            return false;
        }
        if (normalized.equals("item/axolotl_bucket") || normalized.equals("item/tropical_fish_bucket") || normalized.equals("item/pufferfish_bucket") || normalized.equals("item/cod_bucket") || normalized.equals("item/salmon_bucket") || normalized.equals("item/tadpole_bucket")) {
            return false;
        }
        if (normalized.contains("_water")) {
            return false;
        }
        return normalized.contains("axolotl") || normalized.contains("tropical_fish") || normalized.contains("pufferfish") || normalized.contains("cod") || normalized.contains("salmon") || normalized.contains("tadpole");
    }

    private record ExtractedLayer(List<class_777> quads, class_1921 renderType, class_10444.class_10445 foilType, class_804 transform, int[] tintLayers, class_1058 particle, Supplier<Vector3f[]> extents, boolean usesBlockLight) {
    }
}

