/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import java.util.EnumMap;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class HandSwayPhysics {
    private static final HandSwayPhysics INSTANCE = new HandSwayPhysics();
    private final EnumMap<class_1268, SwayState> states = new EnumMap(class_1268.class);
    private float stretchDeformation = 0.0f;
    private float stretchVelocity = 0.0f;
    private float stretchDeformationH = 0.0f;
    private float stretchVelocityH = 0.0f;
    private float inertiaPitch = 0.0f;
    private float inertiaPitchVel = 0.0f;
    private float inertiaRoll = 0.0f;
    private float inertiaRollVel = 0.0f;
    private double lastX;
    private double lastZ;
    private float lastPlayerYaw;
    private long lastTime = System.nanoTime();

    public static HandSwayPhysics get() {
        return INSTANCE;
    }

    private HandSwayPhysics() {
        this.states.put(class_1268.field_5808, new SwayState());
        this.states.put(class_1268.field_5810, new SwayState());
    }

    public void tick(class_310 client) {
        double currZ;
        double dz;
        this.states.values().forEach(SwayState::tick);
        long now = System.nanoTime();
        float dt = (float)(now - this.lastTime) / 1.0E9f * 20.0f;
        this.lastTime = now;
        if (client.field_1724 == null) {
            this.stretchDeformationH = 0.0f;
            this.stretchDeformation = 0.0f;
            this.stretchVelocityH = 0.0f;
            this.stretchVelocity = 0.0f;
            this.inertiaRollVel = 0.0f;
            this.inertiaRoll = 0.0f;
            this.inertiaPitchVel = 0.0f;
            this.inertiaPitch = 0.0f;
            return;
        }
        double animSpeed = 8.0;
        double tt = (double)dt * animSpeed;
        if (tt > 1.0) {
            tt = 1.0;
        }
        class_243 vel = client.field_1724.method_18798();
        this.stretchVelocity += (float)(vel.field_1351 * (double)0.05f * tt);
        this.stretchVelocity -= (float)((double)(0.12f * this.stretchDeformation) * tt);
        this.stretchVelocity *= (float)Math.pow(0.9, tt);
        this.stretchDeformation += (float)((double)this.stretchVelocity * tt);
        float yaw = client.field_1724.method_36454();
        float yawDelta = yaw - this.lastPlayerYaw;
        if (yawDelta > 180.0f) {
            yawDelta -= 360.0f;
        }
        if (yawDelta < -180.0f) {
            yawDelta += 360.0f;
        }
        this.lastPlayerYaw = yaw;
        float lateralForce = Math.abs(yawDelta) * 0.001f;
        this.stretchVelocityH = (float)((double)this.stretchVelocityH + (double)lateralForce * tt);
        this.stretchVelocityH -= (float)((double)(0.12f * this.stretchDeformationH) * tt);
        this.stretchVelocityH *= (float)Math.pow(0.9, tt);
        this.stretchDeformationH += (float)((double)this.stretchVelocityH * tt);
        double currX = client.field_1724.method_23317();
        double dx = currX - this.lastX;
        double speedSqr = dx * dx + (dz = (currZ = client.field_1724.method_23321()) - this.lastZ) * dz;
        if (speedSqr > 1.0E-4 || (double)Math.abs(this.inertiaPitch) > 0.001) {
            float speed = (float)Math.sqrt(speedSqr);
            float targetPitch = speed * 20.0f;
            float targetRoll = speed * 10.0f * (float)(client.field_1724.field_6012 % 20 > 10 ? 1 : -1);
            float pushForce = speed * 3.0f;
            float pitchForce = (0.0f - this.inertiaPitch) * 0.15f;
            pitchForce += pushForce;
            this.inertiaPitchVel += (pitchForce -= this.inertiaPitchVel * 0.3f) * dt;
            this.inertiaPitch += this.inertiaPitchVel * dt;
        }
        if (speedSqr < 1.0E-4) {
            float pitchForce = (0.0f - this.inertiaPitch) * 0.1f;
            this.inertiaPitchVel += (pitchForce -= this.inertiaPitchVel * 0.5f) * dt;
            this.inertiaPitch += this.inertiaPitchVel * dt;
        }
        this.lastX = currX;
        this.lastZ = currZ;
    }

    public void applyElasticity(class_4587 matrices, class_1799 stack) {
        if (!this.shouldAnimate(stack)) {
            return;
        }
        float intensity = 1.0f;
        if (stack.method_31574(class_1802.field_8323)) {
            intensity = 0.65f;
        }
        this.applyElasticity(matrices, intensity);
    }

    public void applyElasticity(class_4587 matrices, float intensity) {
        float scaleH = 1.0f + this.stretchDeformationH * -1.0f * intensity;
        float scaleV = 1.0f + this.stretchDeformation * -1.0f * intensity;
        matrices.method_22905(1.0f, scaleV, scaleH);
    }

    public void applyMotionInertia(class_4587 matrices) {
        float pitchLimit = 15.0f;
        float p = class_3532.method_15363((float)this.inertiaPitch, (float)(-pitchLimit), (float)pitchLimit);
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-p));
    }

    public float getStretchDeformation() {
        return this.stretchDeformation;
    }

    private boolean shouldAnimate(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return stack.method_31574(class_1802.field_8777) || stack.method_31574(class_1802.field_8828);
    }

    public void trigger(class_1268 hand) {
        if (hand == null) {
            return;
        }
        this.states.get(hand).impulse();
    }

    public float getX(class_1268 hand) {
        return this.states.get((Object)hand).valX;
    }

    public float getY(class_1268 hand) {
        return this.states.get((Object)hand).valY;
    }

    public float getRoll(class_1268 hand) {
        return this.states.get((Object)hand).valRoll;
    }

    public void reset() {
        this.states.values().forEach(SwayState::reset);
    }

    private static class SwayState {
        private static final float STIFFNESS = 0.08f;
        private static final float DAMPING = 0.85f;
        private float valX;
        private float velX;
        private float valY;
        private float velY;
        private float valRoll;
        private float velRoll;
        private float direction = 1.0f;

        private SwayState() {
        }

        void tick() {
            this.velX += -this.valX * 0.08f;
            this.velX *= 0.85f;
            this.valX += this.velX;
            this.velY += -this.valY * 0.08f;
            this.velY *= 0.85f;
            this.valY += this.velY;
            this.velRoll += -this.valRoll * 0.08f;
            this.velRoll *= 0.85f;
            this.valRoll += this.velRoll;
            if (Math.abs(this.valX) < 0.001f && Math.abs(this.velX) < 0.001f) {
                this.velX = 0.0f;
                this.valX = 0.0f;
            }
            if (Math.abs(this.valY) < 0.001f && Math.abs(this.velY) < 0.001f) {
                this.velY = 0.0f;
                this.valY = 0.0f;
            }
            if (Math.abs(this.valRoll) < 0.001f && Math.abs(this.velRoll) < 0.001f) {
                this.velRoll = 0.0f;
                this.valRoll = 0.0f;
            }
        }

        void impulse() {
            this.direction = -this.direction;
            float strength = 0.01f;
            this.velX += strength * this.direction;
            this.velY += 0.02f;
            this.velRoll += -0.7f * this.direction;
        }

        void reset() {
            this.velX = 0.0f;
            this.valX = 0.0f;
            this.velY = 0.0f;
            this.valY = 0.0f;
            this.velRoll = 0.0f;
            this.valRoll = 0.0f;
            this.direction = 1.0f;
        }
    }
}

