/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.client.render.HandRenderState;
import com.henrique.punchy.client.render.RenderSneakSuppressor;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_243;

public final class VanillaProxyContext {
    private static final Map<class_1268, HandRenderState> STATES = new EnumMap<class_1268, HandRenderState>(class_1268.class);
    private static final ThreadLocal<HandRenderState> ACTIVE = ThreadLocal.withInitial(() -> VanillaProxyContext.states().get(class_1268.field_5808));

    private VanillaProxyContext() {
    }

    private static Map<class_1268, HandRenderState> states() {
        return STATES;
    }

    public static HandRenderState state(class_1268 hand) {
        return VanillaProxyContext.states().get(hand == null ? class_1268.field_5808 : hand);
    }

    public static HandRenderState current() {
        return ACTIVE.get();
    }

    public static void setActiveHand(class_1268 hand) {
        ACTIVE.set(VanillaProxyContext.state(hand));
    }

    public static class_1268 getHand() {
        return VanillaProxyContext.current().getHand();
    }

    public static void setOriginal(class_1799 stack) {
        VanillaProxyContext.current().setOriginalStack(stack);
    }

    public static class_1799 getOriginal() {
        return VanillaProxyContext.current().getOriginalStack();
    }

    public static void setPlayer(Object player) {
        VanillaProxyContext.current().setPlayer(player);
    }

    public static Object getPlayer() {
        return VanillaProxyContext.current().getPlayer();
    }

    public static void setLogicalHand(class_1268 hand) {
        VanillaProxyContext.current().setLogicalHand(hand);
    }

    public static class_1268 getLogicalHand() {
        return VanillaProxyContext.current().getLogicalHand();
    }

    public static void clearHand(class_1268 hand) {
        VanillaProxyContext.state(hand).clear();
        if (VanillaProxyContext.current().getHand() == hand) {
            ACTIVE.set(VanillaProxyContext.state(class_1268.field_5808));
        }
    }

    public static void clearAll() {
        for (HandRenderState state : VanillaProxyContext.states().values()) {
            state.clear();
        }
        ACTIVE.set(VanillaProxyContext.state(class_1268.field_5808));
        RenderSneakSuppressor.clear();
    }

    public static void setSpringPivot(class_1268 hand, float x, float y, float z) {
        VanillaProxyContext.state(hand).setSpringPivot(x, y, z);
    }

    public static void clearSpringPivot(class_1268 hand) {
        VanillaProxyContext.state(hand).clearSpringPivot();
    }

    public static class_243 getSpringPivot(class_1268 hand) {
        HandRenderState state = VanillaProxyContext.state(hand);
        if (state.hasSpringPivot()) {
            return new class_243((double)state.springPivotX(), (double)state.springPivotY(), (double)state.springPivotZ());
        }
        return null;
    }

    public static void setItemPivot(class_1268 hand, float x, float y, float z) {
        VanillaProxyContext.state(hand).setItemPivot(x, y, z);
    }

    public static void clearItemPivot(class_1268 hand) {
        VanillaProxyContext.state(hand).clearItemPivot();
    }

    public static class_243 getItemPivot(class_1268 hand) {
        HandRenderState state = VanillaProxyContext.state(hand);
        if (state.hasItemPivot()) {
            return new class_243((double)state.itemPivotX(), (double)state.itemPivotY(), (double)state.itemPivotZ());
        }
        return null;
    }

    public static void setBoneExtraZ(class_1268 hand, float z) {
        VanillaProxyContext.state(hand).setBoneExtraZ(z);
    }

    public static float getBoneExtraZ(class_1268 hand) {
        return VanillaProxyContext.state(hand).boneExtraZ();
    }

    static {
        STATES.put(class_1268.field_5808, new HandRenderState(class_1268.field_5808));
        STATES.put(class_1268.field_5810, new HandRenderState(class_1268.field_5810));
    }
}

