/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.renderer.layer;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.debug.AnchorDebugProbe;
import com.henrique.punchy.client.render.ArmAnimationOverrides;
import com.henrique.punchy.client.render.AxolotlBucketAnimator;
import com.henrique.punchy.client.render.ChestLidAnimator;
import com.henrique.punchy.client.render.HandItemOverrides;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.RenderSneakSuppressor;
import com.henrique.punchy.client.render.ToolAnimationOverrides;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.render.UseAnimationSuppressor;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.mixin.accessor.ItemStackRenderStateAccessor;
import com.henrique.punchy.mixin.accessor.ItemStackRenderStateLayerAccessor;
import com.henrique.punchy.util.ProxyItemHelper;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_804;
import net.minecraft.class_811;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class VanillaFirstPersonItemLayer<T extends class_1792>
extends GeoRenderLayer<T, GeoItemRenderer.RenderData, GeoRenderState> {
    private static final class_1799 DEBUG_PIVOT_MARKER = new class_1799((class_1935)class_1802.field_8197);
    private static final class_1799 SPRING_PIVOT_MARKER = new class_1799((class_1935)class_1802.field_8737);
    private final String anchorBoneName;
    private final String infoBoneName;
    private final ToolKind kind;
    private final Boolean leftHandGate;
    private final Predicate<class_1799> stackFilter;
    private static boolean loggedEmptyItemMain = false;
    private static boolean loggedEmptyItemOff = false;
    private static boolean loggedNonEmptyItemMain = false;
    private static boolean loggedNonEmptyItemOff = false;
    private static class_2960 lastLoggedItemMainId = null;
    private static class_2960 lastLoggedItemOffId = null;
    private static final IdentityHashMap<GeoBone, Baseline> BASELINES = new IdentityHashMap();

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName) {
        this(renderer, boneName, boneName, ToolKind.AXE, null, null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind) {
        this(renderer, boneName, boneName, kind, null, null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind, boolean leftArm) {
        this(renderer, boneName, boneName, kind, (Boolean)leftArm, (Predicate<class_1799>)null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind, boolean leftArm, Predicate<class_1799> filter) {
        this(renderer, boneName, boneName, kind, (Boolean)leftArm, filter);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String anchorBoneName, String infoBoneName, ToolKind kind, boolean leftArm, Predicate<class_1799> filter) {
        this(renderer, anchorBoneName, infoBoneName, kind, (Boolean)leftArm, filter);
    }

    private VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String anchorBoneName, String infoBoneName, ToolKind kind, Boolean leftHandGate, Predicate<class_1799> filter) {
        super(renderer);
        this.anchorBoneName = anchorBoneName;
        this.infoBoneName = infoBoneName == null ? anchorBoneName : infoBoneName;
        this.kind = kind;
        this.leftHandGate = leftHandGate;
        this.stackFilter = filter == null ? stack -> true : filter;
    }

    public void addPerBoneRender(GeoRenderState state, BakedGeoModel bakedModel, boolean includeChildren, BiConsumer<GeoBone, PerBoneRender<GeoRenderState>> consumer) {
        Optional anchorOpt = bakedModel.getBone(this.anchorBoneName);
        if (anchorOpt.isEmpty()) {
            return;
        }
        final Optional infoOpt = this.infoBoneName.equals(this.anchorBoneName) ? anchorOpt : bakedModel.getBone(this.infoBoneName);
        consumer.accept((GeoBone)anchorOpt.get(), new PerBoneRender<GeoRenderState>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void submitRenderTask(GeoRenderState s, class_4587 matrices, GeoBone bone, class_11659 queue, class_12075 camera, int light, int overlay, int unknown) {
                class_1268 hand = VanillaProxyContext.getHand();
                if (VanillaFirstPersonItemLayer.this.leftHandGate != null) {
                    if (VanillaFirstPersonItemLayer.this.leftHandGate.booleanValue() && hand != class_1268.field_5810) {
                        return;
                    }
                    if (!VanillaFirstPersonItemLayer.this.leftHandGate.booleanValue() && hand != class_1268.field_5808) {
                        return;
                    }
                }
                class_1268 effectiveHand = hand == null ? class_1268.field_5808 : hand;
                boolean left = effectiveHand == class_1268.field_5810;
                class_310 client = class_310.method_1551();
                class_1799 original = VanillaProxyContext.getOriginal();
                if (original == null) {
                    original = class_1799.field_8037;
                }
                boolean forceRender = ArmAnimationOverrides.isForceRender(effectiveHand);
                if (HandItemOverrides.isHidden(effectiveHand)) {
                    return;
                }
                if (client != null && !ProxyItemHelper.requiresProxy(original) && !forceRender) {
                    return;
                }
                if (original.method_7960()) {
                    VanillaFirstPersonItemLayer.resetNonEmptyItemLog(effectiveHand);
                } else {
                    VanillaFirstPersonItemLayer.clearEmptyItemLog(effectiveHand);
                }
                if (!VanillaFirstPersonItemLayer.this.stackFilter.test(original)) {
                    return;
                }
                if (client == null) {
                    return;
                }
                class_10442 imm = client.method_65386();
                class_10444 renderState = new class_10444();
                class_811 ctx = left ? class_811.field_4321 : class_811.field_4322;
                final class_638 world = client.field_1687;
                class_746 player = client.field_1724;
                final class_243 entityPos = class_243.field_1353;
                class_11566 held = new class_11566(){
                    final /* synthetic */ class_1309 val$player;
                    {
                        this.val$player = class_13092;
                    }

                    public class_1937 method_73183() {
                        return world;
                    }

                    public class_243 method_73189() {
                        return entityPos;
                    }

                    public float method_73188() {
                        return this.val$player != null ? this.val$player.field_6283 : 0.0f;
                    }

                    public class_1309 method_72393() {
                        return this.val$player;
                    }
                };
                boolean freezeVanillaUse = VanillaFirstPersonItemLayer.shouldFreezeVanillaUse(original, effectiveHand);
                if (freezeVanillaUse) {
                    UseAnimationSuppressor.push();
                }
                try {
                    imm.method_65598(renderState, original, ctx, (class_1937)world, held, 0);
                }
                finally {
                    if (freezeVanillaUse) {
                        UseAnimationSuppressor.pop();
                    }
                }
                VanillaFirstPersonItemLayer.neutralizeDisplayTransforms(renderState);
                AxolotlBucketAnimator.apply(original, renderState, effectiveHand);
                ChestLidAnimator.apply(original, renderState, effectiveHand);
                RenderSneakSuppressor.push();
                try {
                    boolean showPivotDebug;
                    float sneakOffset;
                    PunchyClient.IdleSpringPose idlePose;
                    class_243 cameraOffset;
                    float totalPivotZ;
                    float totalPivotY;
                    float totalPivotX;
                    boolean hasPivot;
                    PunchyClient.LanternPose pose;
                    boolean hasSpringPivot;
                    ToolKind resolvedKind = ToolKindResolver.resolveItemKind(original, VanillaFirstPersonItemLayer.this.kind);
                    ToolTuning.Profile tuning = ToolTuning.resolveProfile(original, resolvedKind, left);
                    ToolAnimationOverrides.RotationOffset overrides = ToolAnimationOverrides.rotationOffset(effectiveHand);
                    class_2960 itemId = class_7923.field_41178.method_10221((Object)original.method_7909());
                    boolean logItemSample = VanillaFirstPersonItemLayer.shouldLogItemSample(effectiveHand, itemId);
                    boolean proxyItem = ProxyItemHelper.requiresProxy(original);
                    PunchyClient.JumpSpringPose springPose = PunchyClient.jumpSpringPose(effectiveHand);
                    PunchyClient.JumpSpringPivot springPivot = PunchyClient.jumpSpringPivot();
                    float springPivotRawX = springPivot.x();
                    float springPivotX = left ? -springPivotRawX : springPivotRawX;
                    float springPivotY = springPivot.y();
                    float springPivotZ = springPivot.z();
                    boolean bl = hasSpringPivot = springPivotX != 0.0f || springPivotY != 0.0f || springPivotZ != 0.0f;
                    if (hasSpringPivot) {
                        VanillaProxyContext.setSpringPivot(effectiveHand, springPivotRawX, springPivotY, springPivotZ);
                    } else {
                        VanillaProxyContext.clearSpringPivot(effectiveHand);
                    }
                    GeoBone infoBone = infoOpt.orElse(bone);
                    Baseline baseline = BASELINES.computeIfAbsent(infoBone, b -> new Baseline(b.getRotX(), b.getRotY(), b.getRotZ(), b.getPivotX() - bone.getPivotX(), b.getPivotY() - bone.getPivotY(), b.getPivotZ() - bone.getPivotZ(), b.getPosX(), b.getPosY(), b.getPosZ()));
                    float basePivotDiffX = baseline.diffX() / 16.0f;
                    float basePivotDiffY = baseline.diffY() / 16.0f;
                    float basePivotDiffZ = baseline.diffZ() / 16.0f;
                    float currPivotDiffX = (infoBone.getPivotX() - bone.getPivotX()) / 16.0f;
                    float currPivotDiffY = (infoBone.getPivotY() - bone.getPivotY()) / 16.0f;
                    float currPivotDiffZ = (infoBone.getPivotZ() - bone.getPivotZ()) / 16.0f;
                    float pivotDeltaX = currPivotDiffX - basePivotDiffX;
                    float pivotDeltaY = currPivotDiffY - basePivotDiffY;
                    float pivotDeltaZ = currPivotDiffZ - basePivotDiffZ;
                    float animOffX = (infoBone.getPosX() - baseline.posX()) / 16.0f;
                    float animOffY = (infoBone.getPosY() - baseline.posY()) / 16.0f;
                    float animOffZ = (infoBone.getPosZ() - baseline.posZ()) / 16.0f;
                    float offX = tuning.offX;
                    float offY = tuning.offY;
                    float offZ = tuning.offZ;
                    float baseOffX = offX;
                    float baseOffY = offY;
                    float baseOffZ = offZ;
                    float boneExtraZ = PlayerArmModelLayer.springExtraZ(effectiveHand);
                    float animRotXRad = infoBone.getRotX() - baseline.rotX();
                    float animRotYRad = infoBone.getRotY() - baseline.rotY();
                    float animRotZRad = infoBone.getRotZ() - baseline.rotZ();
                    float rotXRad = animRotXRad + tuning.rotXRad() + overrides.rotXRad();
                    float rotYRad = animRotYRad + tuning.rotYRad() + overrides.rotYRad();
                    float rotZRad = animRotZRad + tuning.rotZRad() + overrides.rotZRad();
                    float finalRotXDeg = (float)Math.toDegrees(rotXRad);
                    float finalRotYDeg = (float)Math.toDegrees(rotYRad);
                    float finalRotZDeg = (float)Math.toDegrees(rotZRad);
                    float animRotXDeg = (float)Math.toDegrees(animRotXRad);
                    float animRotYDeg = (float)Math.toDegrees(animRotYRad);
                    float animRotZDeg = (float)Math.toDegrees(animRotZRad);
                    float tuningRotXDeg = (float)Math.toDegrees(tuning.rotXRad());
                    float tuningRotYDeg = (float)Math.toDegrees(tuning.rotYRad());
                    float tuningRotZDeg = (float)Math.toDegrees(tuning.rotZRad());
                    float overridesRotXDeg = (float)Math.toDegrees(overrides.rotXRad());
                    float overridesRotYDeg = (float)Math.toDegrees(overrides.rotYRad());
                    float overridesRotZDeg = (float)Math.toDegrees(overrides.rotZRad());
                    float scale = tuning.scale;
                    float pivotX = tuning.pivotX;
                    float pivotY = tuning.pivotY;
                    float pivotZ = tuning.pivotZ;
                    boolean lanternLike = resolvedKind == ToolKind.LANTERN || resolvedKind == ToolKind.FLOWER_PENDULUM;
                    PunchyClient.LanternPose lanternPoseToApply = null;
                    if (lanternLike && (pose = PunchyClient.lanternPhysics(effectiveHand)) != null) {
                        lanternPoseToApply = pose;
                        offX = baseOffX;
                        offY = baseOffY;
                        offZ = baseOffZ;
                    }
                    boolean hasInfoPivot = Math.abs(pivotDeltaX) > 1.0E-4f || Math.abs(pivotDeltaY) > 1.0E-4f || Math.abs(pivotDeltaZ) > 1.0E-4f;
                    boolean bl2 = hasPivot = Math.abs(pivotX) > 1.0E-4f || Math.abs(pivotY) > 1.0E-4f || Math.abs(pivotZ) > 1.0E-4f;
                    if (hasInfoPivot || hasPivot) {
                        totalPivotX = (hasInfoPivot ? pivotDeltaX : 0.0f) + (hasPivot ? pivotX : 0.0f);
                        totalPivotY = (hasInfoPivot ? pivotDeltaY : 0.0f) + (hasPivot ? pivotY : 0.0f);
                        totalPivotZ = (hasInfoPivot ? pivotDeltaZ : 0.0f) + (hasPivot ? pivotZ : 0.0f);
                        VanillaProxyContext.setItemPivot(effectiveHand, totalPivotX, totalPivotY, totalPivotZ);
                    } else {
                        VanillaProxyContext.clearItemPivot(effectiveHand);
                    }
                    if (hasInfoPivot || hasPivot) {
                        totalPivotX = (hasInfoPivot ? pivotDeltaX : 0.0f) + (hasPivot ? pivotX : 0.0f);
                        totalPivotY = (hasInfoPivot ? pivotDeltaY : 0.0f) + (hasPivot ? pivotY : 0.0f);
                        totalPivotZ = (hasInfoPivot ? pivotDeltaZ : 0.0f) + (hasPivot ? pivotZ : 0.0f);
                        VanillaProxyContext.setItemPivot(effectiveHand, totalPivotX, totalPivotY, totalPivotZ);
                    } else {
                        VanillaProxyContext.clearItemPivot(effectiveHand);
                    }
                    boolean hasOffset = offX != 0.0f || offY != 0.0f || offZ != 0.0f;
                    float armTilt = PunchyClient.cameraTiltRadians(effectiveHand);
                    if (armTilt != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(armTilt));
                    }
                    if ((cameraOffset = PunchyClient.cameraTiltOffset(effectiveHand)).method_1027() > 1.0E-6) {
                        matrices.method_22904(cameraOffset.method_10216(), cameraOffset.method_10214(), cameraOffset.method_10215());
                    }
                    float armTiltDeg = (float)Math.toDegrees(armTilt);
                    float springPitch = springPose.rotX();
                    float springRoll = springPose.rotZ();
                    float springOffY = springPose.offY();
                    float springPitchDeg = (float)Math.toDegrees(springPitch);
                    float springRollDeg = (float)Math.toDegrees(springRoll);
                    if (hasSpringPivot) {
                        matrices.method_46416(springPivotX, springPivotY, springPivotZ);
                    }
                    if (Punchy.DEBUG_POSITION && hasSpringPivot) {
                        matrices.method_22903();
                        matrices.method_22905(0.12f, 0.12f, 0.12f);
                        class_10444 springState = new class_10444();
                        imm.method_65598(springState, SPRING_PIVOT_MARKER, ctx, (class_1937)world, held, 0);
                        int debugLight = VanillaFirstPersonItemLayer.resolveLight((class_1937)world, (class_1309)player, light);
                        springState.method_65604(matrices, queue, debugLight, class_4608.field_21444, 0);
                        matrices.method_22909();
                    }
                    if (springPitch != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(springPitch));
                    }
                    if (springRoll + boneExtraZ != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(springRoll + boneExtraZ));
                    }
                    if (hasSpringPivot) {
                        matrices.method_46416(-springPivotX, -springPivotY, -springPivotZ);
                    }
                    if (springOffY != 0.0f) {
                        matrices.method_46416(0.0f, springOffY, 0.0f);
                    }
                    if ((idlePose = PunchyClient.idleSpringPose(effectiveHand)).rotX() != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(idlePose.rotX()));
                    }
                    if (idlePose.rotY() != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(idlePose.rotY()));
                    }
                    if (idlePose.rotZ() != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(idlePose.rotZ()));
                    }
                    if (idlePose.offY() != 0.0f) {
                        matrices.method_46416(0.0f, idlePose.offY(), 0.0f);
                    }
                    if ((sneakOffset = PunchyClient.sneakOffset(effectiveHand)) != 0.0f) {
                        matrices.method_46416(0.0f, sneakOffset, 0.0f);
                    }
                    HandSwayPhysics sway = HandSwayPhysics.get();
                    float swayX = sway.getX(effectiveHand);
                    float swayY = sway.getY(effectiveHand);
                    float swayRoll = sway.getRoll(effectiveHand);
                    if (swayX != 0.0f || swayY != 0.0f || swayRoll != 0.0f) {
                        matrices.method_46416(0.0f, swayY, swayX);
                        if (swayRoll != 0.0f) {
                            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(swayRoll));
                        }
                    }
                    sway.applyElasticity(matrices, original);
                    sway.applyMotionInertia(matrices);
                    ArmToolTuning.Profile armProfile = ArmToolTuning.resolveProfile(original, VanillaFirstPersonItemLayer.this.resolveArmKind(original), left);
                    float armShiftX = 0.0f;
                    float armShiftY = 0.0f;
                    float armShiftZ = 0.0f;
                    float armProfileRotX = 0.0f;
                    float armProfileRotY = 0.0f;
                    float armProfileRotZ = 0.0f;
                    float armProfileScale = 1.0f;
                    if (armProfile != null) {
                        armShiftX = armProfile.offX;
                        armShiftY = armProfile.offY;
                        armShiftZ = armProfile.offZ;
                        if (armShiftX != 0.0f || armShiftY != 0.0f || armShiftZ != 0.0f) {
                            matrices.method_46416(armShiftX, armShiftY, armShiftZ);
                        }
                        armProfileRotX = armProfile.rotX;
                        armProfileRotY = armProfile.rotY;
                        armProfileRotZ = armProfile.rotZ;
                        if (armProfileRotX != 0.0f) {
                            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(armProfileRotX));
                        }
                        if (armProfileRotY != 0.0f) {
                            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(armProfileRotY));
                        }
                        if (armProfileRotZ != 0.0f) {
                            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(armProfileRotZ));
                        }
                        if ((armProfileScale = armProfile.scale) != 1.0f) {
                            matrices.method_22905(armProfileScale, armProfileScale, armProfileScale);
                        }
                    }
                    if (hasInfoPivot) {
                        matrices.method_46416(pivotDeltaX, pivotDeltaY, pivotDeltaZ);
                    }
                    if (hasPivot) {
                        matrices.method_46416(pivotX, pivotY, pivotZ);
                    }
                    if (showPivotDebug = Punchy.DEBUG_POSITION) {
                        matrices.method_22903();
                        matrices.method_22905(0.12f, 0.12f, 0.12f);
                        class_10444 debugState = new class_10444();
                        imm.method_65598(debugState, DEBUG_PIVOT_MARKER, ctx, (class_1937)world, held, 0);
                        int debugLight = VanillaFirstPersonItemLayer.resolveLight((class_1937)world, (class_1309)player, light);
                        debugState.method_65604(matrices, queue, debugLight, class_4608.field_21444, 0);
                        matrices.method_22909();
                    }
                    if (rotZRad != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(rotZRad));
                    }
                    if (rotXRad != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(rotXRad));
                    }
                    if (rotYRad != 0.0f) {
                        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(rotYRad));
                    }
                    if (lanternPoseToApply != null) {
                        if (lanternPoseToApply.rotZ() != 0.0f) {
                            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(lanternPoseToApply.rotZ()));
                        }
                        if (lanternPoseToApply.rotX() != 0.0f) {
                            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(lanternPoseToApply.rotX()));
                        }
                    }
                    float anchorOffX = animOffX;
                    float anchorOffY = animOffY;
                    float anchorOffZ = animOffZ;
                    if (hasPivot) {
                        matrices.method_46416(-pivotX, -pivotY, -pivotZ);
                        anchorOffX += pivotX;
                        anchorOffY += pivotY;
                        anchorOffZ += pivotZ;
                    }
                    if (hasInfoPivot) {
                        matrices.method_46416(-pivotDeltaX, -pivotDeltaY, -pivotDeltaZ);
                        anchorOffX += pivotDeltaX;
                        anchorOffY += pivotDeltaY;
                        anchorOffZ += pivotDeltaZ;
                    }
                    float finalOffX = anchorOffX + offX;
                    float finalOffY = anchorOffY + offY;
                    float finalOffZ = anchorOffZ + offZ;
                    if (finalOffX != 0.0f || finalOffY != 0.0f || finalOffZ != 0.0f) {
                        matrices.method_46416(finalOffX, finalOffY, finalOffZ);
                    }
                    if (logItemSample) {
                        String string;
                        String string2 = string = itemId == null ? "unknown" : itemId.toString();
                    }
                    if (scale != 1.0f) {
                        matrices.method_22905(scale, scale, scale);
                    }
                    if (client.field_1687 != null) {
                        AnchorDebugProbe.sampleItem(effectiveHand, matrices.method_23760(), client.field_1687.method_8510());
                    }
                    int resolvedLight = VanillaFirstPersonItemLayer.resolveLight((class_1937)world, (class_1309)player, light);
                    renderState.method_65604(matrices, queue, resolvedLight, class_4608.field_21444, 0);
                }
                finally {
                    RenderSneakSuppressor.pop();
                }
            }
        });
    }

    private static void neutralizeDisplayTransforms(class_10444 renderState) {
        if (!(renderState instanceof ItemStackRenderStateAccessor)) {
            return;
        }
        ItemStackRenderStateAccessor accessor = (ItemStackRenderStateAccessor)renderState;
        class_10444.class_10446[] layers = accessor.punchy$layers();
        int count = accessor.punchy$activeLayerCount();
        if (layers == null || count <= 0) {
            return;
        }
        for (int i = 0; i < count && i < layers.length; ++i) {
            ItemStackRenderStateLayerAccessor layerAccessor;
            class_804 transform;
            class_10444.class_10446 layer = layers[i];
            if (!(layer instanceof ItemStackRenderStateLayerAccessor) || (transform = (layerAccessor = (ItemStackRenderStateLayerAccessor)layer).punchy$transform()) == null || transform == class_804.field_4284) continue;
            layerAccessor.punchy$setTransform(class_804.field_4284);
        }
    }

    private static int resolveLight(class_1937 world, class_1309 player, int fallback) {
        if (fallback > 0 && fallback != 0xF000F0) {
            return fallback;
        }
        if (world == null || player == null) {
            return 0xF000F0;
        }
        class_243 eye = player.method_33571();
        class_2338 pos = class_2338.method_49637((double)eye.field_1352, (double)eye.field_1351, (double)eye.field_1350);
        int block = world.method_8314(class_1944.field_9282, pos);
        block = class_3532.method_15340((int)block, (int)0, (int)15);
        int sky = world.method_8314(class_1944.field_9284, pos) - world.method_8594();
        sky = class_3532.method_15340((int)sky, (int)0, (int)15);
        return class_765.method_23687((int)block, (int)sky);
    }

    private static boolean shouldFreezeVanillaUse(class_1799 stack, class_1268 hand) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (!PunchyClient.isBowHandSuppressed(hand)) {
            return false;
        }
        if (stack.method_7976() == class_1839.field_8953) {
            return true;
        }
        class_1792 item = stack.method_7909();
        return item instanceof class_1753 || item instanceof class_1764;
    }

    private static void resetNonEmptyItemLog(class_1268 hand) {
        if (hand == class_1268.field_5810) {
            loggedNonEmptyItemOff = false;
            lastLoggedItemOffId = null;
        } else {
            loggedNonEmptyItemMain = false;
            lastLoggedItemMainId = null;
        }
    }

    private static void clearEmptyItemLog(class_1268 hand) {
        if (hand == class_1268.field_5810) {
            loggedEmptyItemOff = false;
        } else {
            loggedEmptyItemMain = false;
        }
    }

    private static boolean shouldLogEmptyItem(class_1268 hand) {
        boolean already;
        boolean left = hand == class_1268.field_5810;
        boolean bl = already = left ? loggedEmptyItemOff : loggedEmptyItemMain;
        if (!already) {
            if (left) {
                loggedEmptyItemOff = true;
            } else {
                loggedEmptyItemMain = true;
            }
            return true;
        }
        return false;
    }

    private static boolean shouldLogItemSample(class_1268 hand, class_2960 itemId) {
        boolean needsLog;
        boolean left = hand == class_1268.field_5810;
        class_2960 lastId = left ? lastLoggedItemOffId : lastLoggedItemMainId;
        boolean alreadyLogged = left ? loggedNonEmptyItemOff : loggedNonEmptyItemMain;
        boolean bl = needsLog = !alreadyLogged || !Objects.equals(lastId, itemId);
        if (needsLog) {
            if (left) {
                loggedNonEmptyItemOff = true;
                lastLoggedItemOffId = itemId;
            } else {
                loggedNonEmptyItemMain = true;
                lastLoggedItemMainId = itemId;
            }
        }
        return needsLog;
    }

    private PlayerArmModelLayer.ToolKind resolveArmKind(class_1799 stack) {
        ToolKind itemKind = ToolKindResolver.resolveItemKind(stack, this.kind);
        if (itemKind != null) {
            try {
                return PlayerArmModelLayer.ToolKind.valueOf(itemKind.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return PlayerArmModelLayer.ToolKind.AXE;
    }

    public static enum ToolKind {
        AXE,
        PICKAXE,
        HOE,
        SWORD,
        SHOVEL,
        SHIELD,
        BLOCK,
        TORCH,
        LANTERN,
        FLOWER_PENDULUM,
        CREATURE_BUCKET,
        MINECART,
        BOAT,
        BUTTON_PLATE,
        TRAPDOOR,
        CARPET,
        BED,
        BOW,
        ARROW,
        CROSSBOW,
        SPYGLASS,
        FLINT,
        FOOD,
        SHUBBA_DUCK,
        MACE,
        TRIDENT,
        FISHING_ROD,
        REDSTONE,
        INGREDIENT;

    }

    private record Baseline(float rotX, float rotY, float rotZ, float diffX, float diffY, float diffZ, float posX, float posY, float posZ) {
    }
}

