/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.combat;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.networking.packet.ImpactAttackPayload;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public final class ImpactServer {
    private static final long MAX_LATENCY_MS = 300L;
    private static final Map<UUID, Integer> LAST_SWING = new ConcurrentHashMap<UUID, Integer>();

    private ImpactServer() {
    }

    public static void handleImpact(class_3222 player, ImpactAttackPayload payload) {
        if (!Punchy.USE_IMPACT_TIMING || player.method_7325() || player.method_31481()) {
            return;
        }
        long now = class_156.method_658();
        if (now - payload.sentAt() > 300L) {
            return;
        }
        UUID uuid = player.method_5667();
        Integer previous = LAST_SWING.put(uuid, payload.swingId());
        if (previous != null && previous.intValue() == payload.swingId()) {
            return;
        }
        class_1297 target = ImpactServer.resolveTarget(player, payload.targetId());
        if (target != null && ImpactServer.isValidTarget(player, target)) {
            player.method_7324(target);
        }
    }

    private static class_1297 resolveTarget(class_3222 player, int hintedId) {
        class_1297 hinted;
        class_3218 world = player.method_51469();
        double reach = Math.max(3.0, player.method_45325(class_5134.field_47759));
        if (hintedId >= 0 && ImpactServer.isValidTarget(player, hinted = world.method_8469(hintedId), reach)) {
            return hinted;
        }
        return ImpactServer.raycastForEntity(player, reach);
    }

    private static boolean isValidTarget(class_3222 player, class_1297 target) {
        double reach = Math.max(3.0, player.method_45325(class_5134.field_47759));
        return ImpactServer.isValidTarget(player, target, reach);
    }

    private static boolean isValidTarget(class_3222 player, class_1297 target, double reach) {
        if (target == null || !target.method_5732() || target == player) {
            return false;
        }
        double maxDistance = (reach + 1.0) * (reach + 1.0);
        return player.method_5858(target) <= maxDistance;
    }

    private static class_1297 raycastForEntity(class_3222 player, double reach) {
        class_238 box;
        class_243 look;
        class_243 end;
        class_243 start = player.method_5836(1.0f);
        class_3966 hit = class_1675.method_18075((class_1297)player, (class_243)start, (class_243)(end = start.method_1019((look = player.method_5828(1.0f)).method_1021(reach))), (class_238)(box = player.method_5829().method_18804(look.method_1021(reach)).method_1014(1.0)), entity -> ImpactServer.isValidTarget(player, entity, reach), (double)(reach * reach));
        return hit != null ? hit.method_17782() : null;
    }
}

