/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.item;

import com.henrique.punchy.client.ClientBridge;
import com.henrique.punchy.geo.model.SharedBoneModel;
import com.henrique.punchy.item.AnimatedTool;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animation.Animation;

public class AnimatedBoneProxy
extends AnimatedTool {
    private static final SharedBoneModel<AnimatedBoneProxy> RIGHT_MODEL = new SharedBoneModel(false);
    private static final SharedBoneModel<AnimatedBoneProxy> LEFT_MODEL = new SharedBoneModel(true);

    public AnimatedBoneProxy() {
        super(new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"punchy", (String)"animated_bone_proxy"))));
    }

    @Override
    protected String anim(String key, class_1268 hand) {
        return switch (key) {
            case "mining" -> AnimatedBoneProxy.clip("punch", hand);
            case "sway_forward" -> AnimatedBoneProxy.clip("sway_forward", hand);
            case "sway_forward_2" -> AnimatedBoneProxy.clip("sway_forward_2", hand);
            case "sway_forward_3" -> AnimatedBoneProxy.clip("sway_forward_3", hand);
            case "sway_sideways" -> AnimatedBoneProxy.clip("sway_sideways", hand);
            case "sway_sideways_2" -> AnimatedBoneProxy.clip("sway_sideways_2", hand);
            case "sway_sideways_3" -> AnimatedBoneProxy.clip("sway_sideways_3", hand);
            case "sway_digging" -> AnimatedBoneProxy.clip("sway_digging", hand);
            case "sway_throw" -> AnimatedBoneProxy.clip("sway_throw", hand);
            case "jump" -> AnimatedBoneProxy.clip("jump", hand);
            case "landing" -> AnimatedBoneProxy.clip("landing", hand);
            case "swiming" -> AnimatedBoneProxy.clip("swiming", hand);
            case "swiming_left" -> AnimatedBoneProxy.clip("swiming_left", hand);
            case "swiming_right" -> AnimatedBoneProxy.clip("swiming_right", hand);
            case "walk_on_water" -> AnimatedBoneProxy.clip("walk_on_water", hand);
            case "attack" -> AnimatedBoneProxy.clip("attack", hand);
            case "attack_2" -> AnimatedBoneProxy.clip("attack_2", hand);
            case "attack_3" -> AnimatedBoneProxy.clip("attack_3", hand);
            case "attack_mace" -> AnimatedBoneProxy.clip("attack_mace", hand);
            case "attack_mace_charge" -> AnimatedBoneProxy.clip("attack_mace_charge", hand);
            case "punch_attack" -> AnimatedBoneProxy.clip("punch_attack", hand);
            case "eat" -> AnimatedBoneProxy.clip("eat", hand);
            case "drink" -> AnimatedBoneProxy.clip("drink", hand);
            case "bucket_fill" -> AnimatedBoneProxy.clip("bucket_fill", hand);
            case "bucket_throw" -> AnimatedBoneProxy.clip("bucket_throw", hand);
            case "fishing" -> AnimatedBoneProxy.clip("fishing", hand);
            case "usebrush" -> AnimatedBoneProxy.clip("usebrush", hand);
            case "rise_shield" -> AnimatedBoneProxy.clip("rise_shield", hand);
            case "shield_hit" -> AnimatedBoneProxy.clip("shield_hit", hand);
            case "trident_throw" -> AnimatedBoneProxy.clip("trident_throw", hand);
            case "trident_throw_release" -> AnimatedBoneProxy.clip("trident_throw_release", hand);
            case "trident_attack" -> AnimatedBoneProxy.clip("trident_attack", hand);
            case "bow_load_bow_hand" -> AnimatedBoneProxy.clip("bow_load_bow_hand", hand);
            case "bow_load_arrow_hand" -> AnimatedBoneProxy.clip("bow_load_arrow_hand", hand);
            case "crossbow_load_crossbow_hand" -> AnimatedBoneProxy.clip("crossbow_load_crossbow_hand", hand);
            case "crossbow_load_arrow_hand" -> AnimatedBoneProxy.clip("crossbow_load_arrow_hand", hand);
            case "use_spyglass", "usespyglass" -> AnimatedBoneProxy.clip("usespyglass", hand);
            case "falling_in_water" -> AnimatedBoneProxy.clip("falling_in_water", hand);
            case "inspect_my_item" -> AnimatedBoneProxy.clip("inspect_my_item", hand);
            case "hand_in", "hand_in_left" -> AnimatedBoneProxy.clip("hand_in", hand);
            case "hand_out", "hand_out_left" -> AnimatedBoneProxy.clip("hand_out", hand);
            case "select", "select_left" -> AnimatedBoneProxy.clip("hand_in", hand);
            case "select_out", "select_out_left" -> AnimatedBoneProxy.clip("hand_out", hand);
            case "transition_to_idle_select" -> AnimatedBoneProxy.clip("transition_to_idle_select", hand);
            case "transition_to_idle_select_out" -> AnimatedBoneProxy.clip("transition_to_idle_select_out", hand);
            case "transition" -> AnimatedBoneProxy.clip("transition_to_idle_punch", hand);
            case "transition_to_idle_sway_forward" -> AnimatedBoneProxy.clip("transition_to_idle_sway_forward", hand);
            case "transition_to_idle_sway_sideways" -> AnimatedBoneProxy.clip("transition_to_idle_sway_sideways", hand);
            case "transition_to_idle_punch" -> AnimatedBoneProxy.clip("transition_to_idle_punch", hand);
            case "transition_to_idle_sway_digging" -> AnimatedBoneProxy.clip("transition_to_idle_sway_digging", hand);
            case "transition_to_idle_insert" -> AnimatedBoneProxy.clip("transition_to_idle_insert", hand);
            case "insert" -> AnimatedBoneProxy.clip("insert", hand);
            case "flint_and_steel" -> AnimatedBoneProxy.clip("flint_and_steel", hand);
            default -> "";
        };
    }

    private static String clip(String name, class_1268 hand) {
        return name == null ? "" : name.trim();
    }

    private static String remapClipName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return switch (name) {
            case "idle_lantern" -> "idle";
            case "walk_lantern" -> "walk";
            case "mining", "mining_2", "mining_3", "activate", "activate_block" -> "punch";
            case "mining_block", "mining_2_block", "mining_3_block" -> "insert";
            case "sway_forward", "sway_sideways", "sway_digging" -> name;
            default -> name;
        };
    }

    @Override
    protected Collection<String> animationVariants() {
        return List.of(AnimationVariant.BLOCK.suffix(), AnimationVariant.FOOD.suffix(), AnimationVariant.BOW.suffix(), AnimationVariant.CROSSBOW.suffix(), AnimationVariant.SWAY_SIDEWAYS.suffix());
    }

    @Override
    protected String clipForVariant(String clipKey, String variant, class_1268 hand) {
        AnimationVariant kind = AnimationVariant.fromSuffix(variant);
        if (kind == null) {
            return "";
        }
        String clip = kind.clipFor(clipKey, hand);
        return clip == null ? "" : clip;
    }

    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        ClientBridge.hooks().createAnimatedBoneRenderer(consumer);
    }

    public class_2960 getTextureId() {
        return class_2960.method_60655((String)"minecraft", (String)"textures/block/stone.png");
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
    }

    public double getAnimationDurationSeconds(String animationName) {
        Animation animation = this.lookupAnimation(animationName);
        return animation != null ? animation.length() : 0.0;
    }

    public boolean hasVariantClip(String clipKey, String variantSuffix, class_1268 hand) {
        if (variantSuffix == null || variantSuffix.isEmpty()) {
            return false;
        }
        String clip = this.clipForVariant(clipKey, variantSuffix, hand);
        return clip != null && !clip.isEmpty();
    }

    public boolean hasAnimation(String animationName) {
        return this.lookupAnimation(animationName) != null;
    }

    private Animation lookupAnimation(String animationName) {
        if (animationName == null || animationName.isEmpty()) {
            return null;
        }
        String normalized = animationName == null ? "" : animationName.trim();
        boolean leftHandClip = false;
        if (normalized.endsWith("_left")) {
            leftHandClip = true;
            normalized = normalized.substring(0, normalized.length() - "_left".length());
        } else if (normalized.endsWith("_right")) {
            normalized = normalized.substring(0, normalized.length() - "_right".length());
        }
        normalized = AnimatedBoneProxy.remapClipName(normalized);
        if ("walk".equals(normalized) || "idle".equals(normalized)) {
            return null;
        }
        SharedBoneModel<AnimatedBoneProxy> model = leftHandClip ? LEFT_MODEL : RIGHT_MODEL;
        try {
            return model.getAnimation((GeoAnimatable)this, normalized);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    private static enum AnimationVariant {
        BLOCK("block"),
        FOOD("food"),
        BOW("bow"),
        CROSSBOW("crossbow"),
        SWAY_SIDEWAYS("sway_sideways");

        private final String suffix;

        private AnimationVariant(String suffix) {
            this.suffix = suffix;
        }

        public String suffix() {
            return this.suffix;
        }

        public static AnimationVariant fromSuffix(String suffix) {
            for (AnimationVariant variant : AnimationVariant.values()) {
                if (!variant.suffix.equals(suffix)) continue;
                return variant;
            }
            return null;
        }

        public String clipFor(String clipKey, class_1268 hand) {
            return switch (clipKey) {
                case "activate" -> {
                    switch (this.ordinal()) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            yield AnimatedBoneProxy.clip("punch", hand);
                        }
                    }
                    yield "";
                }
                case "mining", "mining_2", "mining_3" -> {
                    switch (this.ordinal()) {
                        case 0: {
                            yield AnimatedBoneProxy.clip("punch", hand);
                        }
                    }
                    yield "";
                }
                default -> {
                    switch (this.ordinal()) {
                        case 1: {
                            if (clipKey.equals("drink")) {
                                yield AnimatedBoneProxy.clip("drink", hand);
                            }
                            if (clipKey.equals("eat")) {
                                yield AnimatedBoneProxy.clip("eat", hand);
                            }
                            yield "";
                        }
                        case 4: {
                            if (clipKey.equals("sway_sideways_2")) {
                                yield AnimatedBoneProxy.clip("sway_sideways_2", hand);
                            }
                            if (clipKey.equals("sway_sideways_3")) {
                                yield AnimatedBoneProxy.clip("sway_sideways_3", hand);
                            }
                            yield "";
                        }
                    }
                    yield "";
                }
            };
        }
    }
}

