/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.debug;

import com.henrique.punchy.Punchy;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public final class AnchorDebugProbe {
    private static final Map<ProbeKey, Sample> SAMPLES = new EnumMap<ProbeKey, Sample>(ProbeKey.class);

    private AnchorDebugProbe() {
    }

    public static void sampleArm(class_1268 hand, class_4587.class_4665 entry, long worldTime) {
        if (!Punchy.DEBUG_POSITION) {
            return;
        }
        SAMPLES.put(ProbeKey.arm(hand), AnchorDebugProbe.capture(entry, worldTime));
    }

    public static void sampleItem(class_1268 hand, class_4587.class_4665 entry, long worldTime) {
        if (!Punchy.DEBUG_POSITION) {
            return;
        }
        SAMPLES.put(ProbeKey.item(hand), AnchorDebugProbe.capture(entry, worldTime));
    }

    private static Sample capture(class_4587.class_4665 entry, long worldTime) {
        Matrix4f mat = new Matrix4f((Matrix4fc)entry.method_23761());
        Vector3f forward = new Vector3f(0.0f, 0.0f, -1.0f);
        forward.mulDirection((Matrix4fc)mat);
        if (forward.lengthSquared() > 1.0E-6f) {
            forward.normalize();
        }
        float yaw = (float)Math.toDegrees(Math.atan2(-forward.x, forward.z));
        float pitch = (float)Math.toDegrees(Math.asin(Math.max(-1.0f, Math.min(1.0f, forward.y))));
        Vector3f pos = mat.transformPosition(new Vector3f());
        return new Sample(yaw, pitch, forward, pos, worldTime);
    }

    public static void tick(class_310 client) {
        if (!Punchy.DEBUG_POSITION || client == null || client.field_1687 == null) {
            SAMPLES.clear();
            return;
        }
        long time = client.field_1687.method_8510();
        SAMPLES.entrySet().removeIf(entry -> ((Sample)entry.getValue()).worldTime != time);
    }

    public static float getArmYaw(class_1268 hand) {
        Sample sample = SAMPLES.get((Object)ProbeKey.arm(hand));
        return sample == null ? Float.NaN : sample.yaw;
    }

    public static float getItemYaw(class_1268 hand) {
        Sample sample = SAMPLES.get((Object)ProbeKey.item(hand));
        return sample == null ? Float.NaN : sample.yaw;
    }

    public static void pushMessage(class_310 client, String message) {
        if (client == null || client.field_1724 == null) {
            return;
        }
        client.field_1705.method_1758((class_2561)class_2561.method_43470((String)message), false);
    }

    private static enum ProbeKey {
        ARM_MAIN,
        ARM_OFF,
        ITEM_MAIN,
        ITEM_OFF;


        static ProbeKey arm(class_1268 hand) {
            return hand == class_1268.field_5810 ? ARM_OFF : ARM_MAIN;
        }

        static ProbeKey item(class_1268 hand) {
            return hand == class_1268.field_5810 ? ITEM_OFF : ITEM_MAIN;
        }
    }

    private static final class Sample {
        final float yaw;
        final float pitch;
        final float forwardX;
        final float forwardY;
        final float forwardZ;
        final float posX;
        final float posY;
        final float posZ;
        final long worldTime;

        Sample(float yaw, float pitch, Vector3f forward, Vector3f pos, long worldTime) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.forwardX = forward.x;
            this.forwardY = forward.y;
            this.forwardZ = forward.z;
            this.posX = pos.x;
            this.posY = pos.y;
            this.posZ = pos.z;
            this.worldTime = worldTime;
        }
    }
}

