/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.render.LightingHelper;
import com.henrique.punchy.mixin.accessor.BakedQuadAccessor;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class ChestLidRenderer
implements class_10515<LayerData> {
    static final ChestLidRenderer INSTANCE = new ChestLidRenderer();
    private static final EnumMap<class_1268, ChestLidPhysics> PHYSICS = new EnumMap(class_1268.class);
    private static final float PIVOT_X = 0.0f;
    private static final float PIVOT_Y = 0.703125f;
    private static final float PIVOT_Z = 0.859375f;

    private ChestLidRenderer() {
    }

    public void render(@Nullable LayerData data, class_811 context, class_4587 matrices, class_4597 buffer, int packedLight, int packedOverlay, boolean isGlinting) {
        if (data == null || data.renderType == null) {
            return;
        }
        List<class_777> quads = data.quads();
        if (quads == null || quads.isEmpty()) {
            return;
        }
        class_1268 hand = data.hand == null ? class_1268.field_5808 : data.hand;
        ChestLidPhysics physics = ChestLidRenderer.stateFor(hand);
        PunchyClient.JumpSpringPose pose = PunchyClient.jumpSpringPose(hand);
        PunchyClient.CameraDrift drift = PunchyClient.cameraDrift();
        physics.update(pose, drift, hand);
        float tilt = physics.getAngle();
        matrices.method_22903();
        ChestLidRenderer.applyLidRotation(matrices, tilt);
        class_310 client = class_310.method_1551();
        int resolvedLight = data.usesBlockLight() ? LightingHelper.resolveLight((class_1937)client.field_1687, (class_1309)client.field_1724, 0) : 0xF000F0;
        class_4588 vertexConsumer = buffer.getBuffer(data.renderType);
        for (class_777 quad : quads) {
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (quad.method_3360()) {
                int tintIndex = ((BakedQuadAccessor)quad).punchy$tintIndex();
                if (data.tintLayers != null && tintIndex >= 0 && tintIndex < data.tintLayers.length) {
                    int color = data.tintLayers[tintIndex];
                    r = (float)(color >> 16 & 0xFF) / 255.0f;
                    g = (float)(color >> 8 & 0xFF) / 255.0f;
                    b = (float)(color & 0xFF) / 255.0f;
                }
            }
            vertexConsumer.method_22919(matrices.method_23760(), quad, r, g, b, 1.0f, resolvedLight, packedOverlay);
        }
        matrices.method_22909();
    }

    public void method_72175(Set<Vector3f> extents) {
    }

    @Nullable
    public LayerData extractArgument(class_1799 stack) {
        return null;
    }

    private static ChestLidPhysics stateFor(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return PHYSICS.computeIfAbsent(resolved, h -> new ChestLidPhysics());
    }

    private static void applyLidRotation(class_4587 stack, float angle) {
        if (angle == 0.0f) {
            return;
        }
        stack.method_46416(0.0f, 0.703125f, 0.859375f);
        stack.method_22907((Quaternionfc)class_7833.field_40714.rotation(angle));
        stack.method_46416(-0.0f, -0.703125f, -0.859375f);
    }

    public record LayerData(class_1268 hand, class_1921 renderType, class_10444.class_10445 foilType, int[] tintLayers, List<class_777> quads, boolean usesBlockLight) {
    }

    private static final class ChestLidPhysics {
        private final SpringAxis axis = new SpringAxis(0.15f, 0.87f, 0.55f);
        private float angle;

        private ChestLidPhysics() {
        }

        void update(PunchyClient.JumpSpringPose pose, PunchyClient.CameraDrift drift, class_1268 hand) {
            class_746 player;
            if (pose == null) {
                this.angle = this.axis.update(0.0f);
                return;
            }
            float target = -pose.offY() * 2.4f - pose.rotX() * 0.35f + drift.pitchDeg() * 0.001f;
            if (PunchyClient.isJumpActive() && target > 0.0f) {
                target *= 2.5f;
            }
            if ((player = class_310.method_1551().field_1724) != null) {
                double vy = player.method_18798().field_1351;
                if (vy < -0.01) {
                    target = Math.max(target, (float)(-vy) * 0.6f);
                } else if (vy > 0.01) {
                    boolean creativeFlying = player.method_31549().field_7479 && player.method_68878();
                    target = creativeFlying ? Math.min(target, 0.0f) : Math.max(target, (float)vy * 0.45f);
                }
            }
            if (PunchyClient.isLanding(hand)) {
                target = Math.min(target, 0.0f);
            }
            target = class_3532.method_15363((float)target, (float)-0.9f, (float)1.0f);
            this.angle = this.axis.update(target);
        }

        float getAngle() {
            return this.angle;
        }
    }

    private static final class SpringAxis {
        private final float stiffness;
        private final float damping;
        private final float maxVelocity;
        private float value;
        private float velocity;

        SpringAxis(float stiffness, float damping, float maxVelocity) {
            this.stiffness = stiffness;
            this.damping = damping;
            this.maxVelocity = maxVelocity;
        }

        float update(float target) {
            float accel = (target - this.value) * this.stiffness;
            this.velocity += accel;
            this.velocity = class_3532.method_15363((float)this.velocity, (float)(-this.maxVelocity), (float)this.maxVelocity);
            this.velocity *= this.damping;
            this.value += this.velocity;
            float delta = target - this.value;
            if (Math.signum(this.velocity) != Math.signum(delta)) {
                this.velocity *= 0.32f;
            }
            if (Math.abs(delta) < 0.003f && Math.abs(this.velocity) < 0.003f) {
                this.value = target;
                this.velocity = 0.0f;
            }
            return this.value;
        }
    }
}

