/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.renderer.layer.ArmMeshTuning;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import com.henrique.punchy.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public final class PunchyTuningConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "punchy_tuning.json";
    private static final class_2960 DEFAULTS_ID = class_2960.method_60655((String)"punchy", (String)"default_tuning.json");
    private static final String COMPAT_DIR_NAME = "punchy/compat";
    private static final float EPSILON = 1.0E-6f;
    private static final String[] BUNDLED_COMPAT_PROFILES = new String[]{"items_compat"};
    private static final String ARM_MESH_SIDE_KEY = "global";
    private static Data BASELINE_STATE;
    private static Data INITIAL_STATE;

    private PunchyTuningConfig() {
    }

    private static File getFile() {
        Path configDir = Platform.get().getConfigDirectory();
        if (configDir == null) {
            class_310 client = class_310.method_1551();
            configDir = client != null ? client.field_1697.toPath().resolve("config") : Path.of("config", new String[0]);
        }
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configDir.resolve("punchy").resolve(FILE_NAME).toFile();
    }

    public static void loadAndApply() {
        try {
            Data defaults = PunchyTuningConfig.loadDefaultsFromResource();
            if (defaults != null) {
                PunchyTuningConfig.saveData(defaults);
                ToolTuning.resetAttachments();
                ToolTuning.clearSpecifics();
                PunchyTuningConfig.applyData(defaults);
                PunchyTuningConfig.rememberBaseline();
                PunchyTuningConfig.applyCompatOverlays();
                INITIAL_STATE = PunchyTuningConfig.captureCurrent();
                return;
            }
            Data data = null;
            File file = PunchyTuningConfig.getFile();
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    data = (Data)GSON.fromJson((Reader)reader, Data.class);
                }
            }
            if (data != null) {
                ToolTuning.resetAttachments();
                ToolTuning.clearSpecifics();
                PunchyTuningConfig.applyData(data);
                PunchyTuningConfig.rememberBaseline();
                PunchyTuningConfig.applyCompatOverlays();
            } else {
                BASELINE_STATE = null;
            }
            INITIAL_STATE = PunchyTuningConfig.captureCurrent();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Data loadDefaultsFromResource() {
        try {
            class_3298 res;
            InputStream stream = null;
            class_310 client = class_310.method_1551();
            if (client != null && (res = (class_3298)client.method_1478().method_14486(DEFAULTS_ID).orElse(null)) != null) {
                stream = res.method_14482();
            }
            if (stream == null) {
                stream = PunchyTuningConfig.class.getResourceAsStream("/assets/punchy/default_tuning.json");
            }
            if (stream == null) {
                return null;
            }
            try (InputStream in = stream;){
                Data data;
                try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    data = (Data)GSON.fromJson((Reader)reader, Data.class);
                }
                return data;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void applyData(Data data) {
        SideSet meshSet;
        SideSet globalItem;
        if (data == null) {
            return;
        }
        if (data.item == null) {
            data.item = new HashMap<String, GroupEntry>();
        }
        if ((globalItem = PunchyTuningConfig.resolveGlobalItem(data)) != null) {
            if (globalItem.right != null) {
                ToolTuning.applyGlobal(false, globalItem.right.toTool());
            }
            if (globalItem.left != null) {
                ToolTuning.applyGlobal(true, globalItem.left.toTool());
            }
        }
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            SideSet armSet;
            SideSet set;
            GroupEntry entry = data.item.get(kind.name());
            if (entry == null) continue;
            if (entry.transforms == null && (entry.right != null || entry.left != null)) {
                entry.transforms = new SideSet();
                entry.transforms.right = entry.right;
                entry.transforms.left = entry.left;
            }
            if ((set = entry.transforms) != null) {
                if (set.right != null) {
                    ToolTuning.apply(kind, false, set.right.toTool());
                    ToolTuning.markKindDetached(kind, false);
                }
                if (set.left != null) {
                    ToolTuning.apply(kind, true, set.left.toTool());
                    ToolTuning.markKindDetached(kind, true);
                }
            }
            if ((armSet = entry.armTransforms) == null) continue;
            PlayerArmModelLayer.ToolKind armKind = null;
            try {
                armKind = PlayerArmModelLayer.ToolKind.valueOf(kind.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (armKind == null) continue;
            if (armSet.right != null) {
                ArmToolTuning.apply(armKind, false, armSet.right.toArm());
                ArmToolTuning.markKindDetached(armKind, false);
            }
            if (armSet.left == null) continue;
            ArmToolTuning.apply(armKind, true, armSet.left.toArm());
            ArmToolTuning.markKindDetached(armKind, true);
        }
        SideSet globalArm = PunchyTuningConfig.resolveGlobalArm(data);
        if (globalArm != null) {
            if (globalArm.right != null) {
                ArmToolTuning.applyGlobal(false, globalArm.right.toArm());
            }
            if (globalArm.left != null) {
                ArmToolTuning.applyGlobal(true, globalArm.left.toArm());
            }
            ArmMeshTuning.resetGlobal(false);
            ArmMeshTuning.resetGlobal(true);
        }
        if (data.armMesh != null && (meshSet = data.armMesh.get(ARM_MESH_SIDE_KEY)) != null) {
            if (meshSet.right != null) {
                ArmMeshTuning.applyGlobal(false, meshSet.right.toArmMesh());
            }
            if (meshSet.left != null) {
                ArmMeshTuning.applyGlobal(true, meshSet.left.toArmMesh());
            }
        }
        if (data.itemSpecific != null) {
            for (Map.Entry<String, SpecificEntry> entry : data.itemSpecific.entrySet()) {
                SideSet armTransforms;
                ToolTuning.Profile left;
                SideSet transforms;
                class_2960 id;
                if (entry == null || entry.getValue() == null || (id = class_2960.method_12829((String)entry.getKey())) == null) continue;
                VanillaFirstPersonItemLayer.ToolKind kind = null;
                if (entry.getValue().kind != null) {
                    try {
                        kind = VanillaFirstPersonItemLayer.ToolKind.valueOf(entry.getValue().kind);
                    }
                    catch (IllegalArgumentException set) {
                        // empty catch block
                    }
                }
                ToolTuning.Profile right = (transforms = entry.getValue().transforms) != null && transforms.right != null ? transforms.right.toTool() : null;
                ToolTuning.Profile profile = left = transforms != null && transforms.left != null ? transforms.left.toTool() : null;
                if (kind != null) {
                    ToolTuning.applySpecific(id, kind, right, left);
                }
                if ((armTransforms = entry.getValue().armTransforms) == null) continue;
                PlayerArmModelLayer.ToolKind armKind = null;
                if (entry.getValue().armKind != null) {
                    try {
                        armKind = PlayerArmModelLayer.ToolKind.valueOf(entry.getValue().armKind);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (armKind == null && entry.getValue().kind != null) {
                    try {
                        armKind = PlayerArmModelLayer.ToolKind.valueOf(entry.getValue().kind);
                    }
                    catch (IllegalArgumentException ignored) {
                        armKind = PlayerArmModelLayer.ToolKind.AXE;
                    }
                }
                if (armKind == null) {
                    armKind = PlayerArmModelLayer.ToolKind.AXE;
                }
                ArmToolTuning.Profile armRight = armTransforms.right != null ? armTransforms.right.toArm() : null;
                ArmToolTuning.Profile armLeft = armTransforms.left != null ? armTransforms.left.toArm() : null;
                ArmToolTuning.applySpecific(id, armKind, armRight, armLeft);
            }
        }
        ToolTuning.refreshAll();
    }

    public static void saveCurrent() {
        try {
            String compatTarget;
            Data data = PunchyTuningConfig.captureCurrent();
            if (INITIAL_STATE != null) {
                Data sessionDelta = PunchyTuningConfig.computeDelta(INITIAL_STATE, data);
                sessionDelta.globalItem = null;
                sessionDelta.globalArm = null;
                sessionDelta.armMesh = null;
                PunchyTuningConfig.saveHelperData(sessionDelta);
            }
            if ((compatTarget = Punchy.ACTIVE_COMPAT_EDIT_TARGET) != null && !compatTarget.isBlank()) {
                Data toSave = BASELINE_STATE != null ? PunchyTuningConfig.computeDelta(BASELINE_STATE, data) : data;
                PunchyTuningConfig.saveCompatData(compatTarget, toSave);
            } else {
                PunchyTuningConfig.saveData(data);
                BASELINE_STATE = data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveHelperData(Data data) {
        Path configDir = Platform.get().getConfigDirectory();
        if (configDir == null) {
            return;
        }
        try {
            Files.createDirectories(configDir.resolve("punchy"), new FileAttribute[0]);
            File file = configDir.resolve("punchy").resolve("creator_tuning_helper.json").toFile();
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Data captureCurrent() {
        Data d = new Data();
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            GroupEntry entry = new GroupEntry();
            boolean hasData = false;
            SideSet ss = null;
            if (!ToolTuning.isKindAttached(kind, false)) {
                ss = new SideSet();
                ss.right = Pose.fromTool(ToolTuning.snapshot(kind, false));
            }
            if (!ToolTuning.isKindAttached(kind, true)) {
                if (ss == null) {
                    ss = new SideSet();
                }
                ss.left = Pose.fromTool(ToolTuning.snapshot(kind, true));
            }
            if (ss != null) {
                entry.transforms = ss;
                hasData = true;
            }
            PlayerArmModelLayer.ToolKind armKind = null;
            try {
                armKind = PlayerArmModelLayer.ToolKind.valueOf(kind.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (armKind != null) {
                SideSet armSS = null;
                if (!ArmToolTuning.isKindAttached(armKind, false)) {
                    armSS = new SideSet();
                    armSS.right = Pose.fromArm(ArmToolTuning.snapshot(armKind, false));
                }
                if (!ArmToolTuning.isKindAttached(armKind, true)) {
                    if (armSS == null) {
                        armSS = new SideSet();
                    }
                    armSS.left = Pose.fromArm(ArmToolTuning.snapshot(armKind, true));
                }
                if (armSS != null) {
                    entry.armTransforms = armSS;
                    hasData = true;
                }
            }
            if (!hasData) continue;
            d.item.put(kind.name(), entry);
        }
        SideSet globalItem = new SideSet();
        globalItem.right = Pose.fromTool(ToolTuning.snapshotGlobal(false));
        globalItem.left = Pose.fromTool(ToolTuning.snapshotGlobal(true));
        d.globalItem = globalItem;
        SideSet globalArm = new SideSet();
        globalArm.right = Pose.fromArm(ArmToolTuning.snapshotGlobal(false));
        globalArm.left = Pose.fromArm(ArmToolTuning.snapshotGlobal(true));
        d.globalArm = globalArm;
        SideSet meshSet = new SideSet();
        meshSet.right = Pose.fromArmMesh(ArmMeshTuning.snapshotGlobal(false));
        meshSet.left = Pose.fromArmMesh(ArmMeshTuning.snapshotGlobal(true));
        d.armMesh.put(ARM_MESH_SIDE_KEY, meshSet);
        d.itemSpecific = PunchyTuningConfig.captureSpecificCurrent();
        return d;
    }

    private static void rememberBaseline() {
        BASELINE_STATE = PunchyTuningConfig.captureCurrent();
    }

    private static Map<String, SpecificEntry> captureSpecificCurrent() {
        HashMap<String, SpecificEntry> out = new HashMap<String, SpecificEntry>();
        Map<class_2960, ToolTuning.SpecificSnapshot> itemSnapshot = ToolTuning.snapshotSpecifics();
        Map<class_2960, ArmToolTuning.SpecificSnapshot> armSnapshot = ArmToolTuning.snapshotSpecifics();
        HashSet<class_2960> allIds = new HashSet<class_2960>();
        allIds.addAll(itemSnapshot.keySet());
        allIds.addAll(armSnapshot.keySet());
        for (class_2960 id : allIds) {
            SideSet set;
            Object spec;
            SpecificEntry entry = new SpecificEntry();
            if (itemSnapshot.containsKey(id)) {
                spec = itemSnapshot.get(id);
                entry.kind = ((ToolTuning.SpecificSnapshot)spec).kind() == null ? null : ((ToolTuning.SpecificSnapshot)spec).kind().name();
                set = new SideSet();
                if (((ToolTuning.SpecificSnapshot)spec).right() != null) {
                    set.right = Pose.fromTool(((ToolTuning.SpecificSnapshot)spec).right());
                }
                if (((ToolTuning.SpecificSnapshot)spec).left() != null) {
                    set.left = Pose.fromTool(((ToolTuning.SpecificSnapshot)spec).left());
                }
                entry.transforms = set;
            }
            if (armSnapshot.containsKey(id)) {
                spec = armSnapshot.get(id);
                if (((ArmToolTuning.SpecificSnapshot)spec).kind() != null) {
                    String sk;
                    entry.armKind = sk = ((ArmToolTuning.SpecificSnapshot)spec).kind().name();
                }
                set = new SideSet();
                if (((ArmToolTuning.SpecificSnapshot)spec).right() != null) {
                    set.right = Pose.fromArm(((ArmToolTuning.SpecificSnapshot)spec).right());
                }
                if (((ArmToolTuning.SpecificSnapshot)spec).left() != null) {
                    set.left = Pose.fromArm(((ArmToolTuning.SpecificSnapshot)spec).left());
                }
                entry.armTransforms = set;
            }
            out.put(id.toString(), entry);
        }
        return out;
    }

    private static Data computeDelta(Data base, Data current) {
        SideSet baseSet;
        SideSet currentSet;
        SideSet diff;
        if (base == null) {
            return current;
        }
        Data delta = new Data();
        boolean hasData = false;
        delta.globalItem = PunchyTuningConfig.diffSideSet(current.globalItem, base.globalItem);
        if (delta.globalItem != null) {
            hasData = true;
        }
        delta.globalArm = PunchyTuningConfig.diffSideSet(current.globalArm, base.globalArm);
        if (delta.globalArm != null) {
            hasData = true;
        }
        HashMap<String, GroupEntry> itemDiff = new HashMap<String, GroupEntry>();
        if (current.item != null) {
            for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
                GroupEntry currentEntry = current.item.get(kind.name());
                GroupEntry baseEntry = base.item != null ? base.item.get(kind.name()) : null;
                SideSet diffTransforms = null;
                SideSet diffArmTransforms = null;
                if (currentEntry != null) {
                    diffTransforms = PunchyTuningConfig.diffSideSet(currentEntry.transforms, baseEntry != null ? baseEntry.transforms : null);
                    diffArmTransforms = PunchyTuningConfig.diffSideSet(currentEntry.armTransforms, baseEntry != null ? baseEntry.armTransforms : null);
                }
                if (diffTransforms == null && diffArmTransforms == null) continue;
                GroupEntry diffEntry = new GroupEntry();
                diffEntry.transforms = diffTransforms;
                diffEntry.armTransforms = diffArmTransforms;
                itemDiff.put(kind.name(), diffEntry);
                hasData = true;
            }
        }
        delta.item = itemDiff.isEmpty() ? null : itemDiff;
        HashMap<String, SideSet> meshDiff = new HashMap<String, SideSet>();
        if (current.armMesh != null && (diff = PunchyTuningConfig.diffSideSet(currentSet = current.armMesh.get(ARM_MESH_SIDE_KEY), baseSet = base.armMesh != null ? base.armMesh.get(ARM_MESH_SIDE_KEY) : null)) != null) {
            meshDiff.put(ARM_MESH_SIDE_KEY, diff);
            hasData = true;
        }
        delta.armMesh = meshDiff.isEmpty() ? null : meshDiff;
        HashMap<String, SpecificEntry> specificDiff = new HashMap<String, SpecificEntry>();
        Map<Object, Object> currentSpecific = current.itemSpecific != null ? current.itemSpecific : Collections.emptyMap();
        Map<Object, Object> baseSpecific = base.itemSpecific != null ? base.itemSpecific : Collections.emptyMap();
        for (Map.Entry<Object, Object> entry : currentSpecific.entrySet()) {
            boolean armKindDiffers;
            SpecificEntry currentEntry = (SpecificEntry)entry.getValue();
            if (currentEntry == null) continue;
            SpecificEntry baseEntry = (SpecificEntry)baseSpecific.get(entry.getKey());
            SideSet transforms = baseEntry == null ? PunchyTuningConfig.copySideSet(currentEntry.transforms) : PunchyTuningConfig.diffSideSet(currentEntry.transforms, baseEntry.transforms);
            boolean kindDiffers = baseEntry == null ? currentEntry.kind != null : !Objects.equals(currentEntry.kind, baseEntry.kind);
            SideSet armTransforms = baseEntry == null ? PunchyTuningConfig.copySideSet(currentEntry.armTransforms) : PunchyTuningConfig.diffSideSet(currentEntry.armTransforms, baseEntry.armTransforms);
            boolean bl = baseEntry == null ? currentEntry.armKind != null : (armKindDiffers = !Objects.equals(currentEntry.armKind, baseEntry.armKind));
            if (transforms == null && armTransforms == null && !kindDiffers && !armKindDiffers) continue;
            SpecificEntry copy = new SpecificEntry();
            copy.kind = currentEntry.kind;
            copy.armKind = currentEntry.armKind;
            copy.transforms = transforms != null ? transforms : PunchyTuningConfig.copySideSet(currentEntry.transforms);
            copy.armTransforms = armTransforms != null ? armTransforms : PunchyTuningConfig.copySideSet(currentEntry.armTransforms);
            specificDiff.put((String)entry.getKey(), copy);
            hasData = true;
        }
        delta.itemSpecific = specificDiff.isEmpty() ? null : specificDiff;
        PunchyTuningConfig.pruneEmptyCollections(delta);
        if (!hasData && delta.itemSpecific == null && delta.item == null && delta.globalItem == null && delta.globalArm == null) {
            return new Data();
        }
        return delta;
    }

    private static SideSet diffSideSet(SideSet current, SideSet base) {
        if (current == null) {
            return null;
        }
        SideSet diff = new SideSet();
        if (current.right != null) {
            diff.right = PunchyTuningConfig.diffPose(current.right, base != null ? base.right : null);
        }
        if (current.left != null) {
            diff.left = PunchyTuningConfig.diffPose(current.left, base != null ? base.left : null);
        }
        if (diff.right == null && diff.left == null) {
            return null;
        }
        return diff;
    }

    private static Pose diffPose(Pose current, Pose base) {
        if (current == null) {
            return null;
        }
        if (base == null || !PunchyTuningConfig.poseEquals(current, base)) {
            return PunchyTuningConfig.copyPose(current);
        }
        return null;
    }

    private static Pose copyPose(Pose src) {
        if (src == null) {
            return null;
        }
        return new Pose(src.scale, src.offX, src.offY, src.offZ, src.rotX, src.rotY, src.rotZ, src.pivotX, src.pivotY, src.pivotZ);
    }

    private static SideSet copySideSet(SideSet src) {
        if (src == null) {
            return null;
        }
        SideSet copy = new SideSet();
        copy.right = PunchyTuningConfig.copyPose(src.right);
        copy.left = PunchyTuningConfig.copyPose(src.left);
        if (copy.right == null && copy.left == null) {
            return null;
        }
        return copy;
    }

    private static boolean poseEquals(Pose a, Pose b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return PunchyTuningConfig.nearlyEqual(a.scale, b.scale) && PunchyTuningConfig.nearlyEqual(a.offX, b.offX) && PunchyTuningConfig.nearlyEqual(a.offY, b.offY) && PunchyTuningConfig.nearlyEqual(a.offZ, b.offZ) && PunchyTuningConfig.nearlyEqual(a.rotX, b.rotX) && PunchyTuningConfig.nearlyEqual(a.rotY, b.rotY) && PunchyTuningConfig.nearlyEqual(a.rotZ, b.rotZ) && PunchyTuningConfig.nearlyEqual(a.pivotX, b.pivotX) && PunchyTuningConfig.nearlyEqual(a.pivotY, b.pivotY) && PunchyTuningConfig.nearlyEqual(a.pivotZ, b.pivotZ);
    }

    private static boolean nearlyEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    private static void pruneEmptyCollections(Data data) {
        if (data.item != null && data.item.isEmpty()) {
            data.item = null;
        }
        if (data.armMesh != null && data.armMesh.isEmpty()) {
            data.armMesh = null;
        }
        if (data.itemSpecific != null && data.itemSpecific.isEmpty()) {
            data.itemSpecific = null;
        }
    }

    private static boolean isSideSetEqual(SideSet a, SideSet b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return PunchyTuningConfig.poseEquals(a.right, b.right) && PunchyTuningConfig.poseEquals(a.left, b.left);
    }

    private static boolean isGroupEntryEqual(GroupEntry a, GroupEntry b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return PunchyTuningConfig.isSideSetEqual(a.transforms, b.transforms) && PunchyTuningConfig.isSideSetEqual(a.armTransforms, b.armTransforms);
    }

    private static boolean isDataEmpty(Data data) {
        if (data == null) {
            return true;
        }
        boolean globalsEmpty = (data.globalItem == null || data.globalItem.right == null && data.globalItem.left == null) && (data.globalArm == null || data.globalArm.right == null && data.globalArm.left == null);
        boolean mapsEmpty = !(data.item != null && !data.item.isEmpty() || data.itemSpecific != null && !data.itemSpecific.isEmpty());
        return globalsEmpty && mapsEmpty;
    }

    private static void stripRedundantEntries(Data data) {
        Map<String, Object> base;
        if (data == null || BASELINE_STATE == null) {
            return;
        }
        if (PunchyTuningConfig.isSideSetEqual(data.globalItem, PunchyTuningConfig.BASELINE_STATE.globalItem)) {
            data.globalItem = null;
        }
        if (PunchyTuningConfig.isSideSetEqual(data.globalArm, PunchyTuningConfig.BASELINE_STATE.globalArm)) {
            data.globalArm = null;
        }
        if (data.item != null) {
            base = PunchyTuningConfig.BASELINE_STATE.item;
            data.item.entrySet().removeIf(entry -> PunchyTuningConfig.isGroupEntryEqual((GroupEntry)entry.getValue(), base != null ? (GroupEntry)base.get(entry.getKey()) : null));
            if (data.item.isEmpty()) {
                data.item = null;
            }
        }
        if (data.armMesh != null) {
            base = PunchyTuningConfig.BASELINE_STATE.armMesh;
            data.armMesh.entrySet().removeIf(entry -> PunchyTuningConfig.isSideSetEqual((SideSet)entry.getValue(), base != null ? (SideSet)base.get(entry.getKey()) : null));
            if (data.armMesh.isEmpty()) {
                data.armMesh = null;
            }
        }
        if (data.itemSpecific != null) {
            Map<String, SpecificEntry> baseSpecific = PunchyTuningConfig.BASELINE_STATE.itemSpecific;
            data.itemSpecific.entrySet().removeIf(entry -> {
                SpecificEntry base = baseSpecific != null ? (SpecificEntry)baseSpecific.get(entry.getKey()) : null;
                boolean kindMatches = Objects.equals(((SpecificEntry)entry.getValue()).kind, base != null ? base.kind : null);
                boolean armKindMatches = Objects.equals(((SpecificEntry)entry.getValue()).armKind, base != null ? base.armKind : null);
                boolean transformsMatch = PunchyTuningConfig.isSideSetEqual(((SpecificEntry)entry.getValue()).transforms, base != null ? base.transforms : null);
                boolean armTransformsMatch = PunchyTuningConfig.isSideSetEqual(((SpecificEntry)entry.getValue()).armTransforms, base != null ? base.armTransforms : null);
                return kindMatches && armKindMatches && transformsMatch && armTransformsMatch;
            });
            if (data.itemSpecific.isEmpty()) {
                data.itemSpecific = null;
            }
        }
        PunchyTuningConfig.pruneEmptyCollections(data);
    }

    private static void saveData(Data data) {
        File file = PunchyTuningConfig.getFile();
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveCompatData(String profile, Data data) {
        Path compatDir = PunchyTuningConfig.getCompatDirectory();
        try {
            Files.createDirectories(compatDir, new FileAttribute[0]);
            Path target = compatDir.resolve(profile + ".json");
            try (FileWriter writer = new FileWriter(target.toFile());){
                GSON.toJson((Object)data, (Appendable)writer);
            }
            PunchyTuningConfig.mirrorCompatResource(profile, target);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void mirrorCompatResource(String profile, Path source) {
        if (!"items_compat".equals(profile) || source == null) {
            return;
        }
        try {
            Path workspace = Path.of("", new String[0]).toAbsolutePath();
            Path srcRoot = workspace.resolve("src");
            if (!Files.exists(srcRoot, new LinkOption[0])) {
                return;
            }
            Path compatDir = srcRoot.resolve("main").resolve("resources").resolve("assets").resolve("punchy").resolve("compat");
            Files.createDirectories(compatDir, new FileAttribute[0]);
            Path dest = compatDir.resolve(source.getFileName());
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyCompatOverlays() {
        PunchyTuningConfig.installBundledCompatProfiles();
        Set<String> profiles = PunchyTuningConfig.discoverCompatProfilesFromResourcePacks();
        if (profiles.isEmpty()) {
            return;
        }
        for (String profile : profiles) {
            Data compat;
            if (profile == null || profile.isBlank() || (compat = PunchyTuningConfig.loadCompatProfile(profile)) == null) continue;
            PunchyTuningConfig.applyData(compat);
        }
    }

    private static Set<String> discoverCompatProfilesFromResourcePacks() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        class_310 client = class_310.method_1551();
        if (client == null) {
            return result;
        }
        class_3300 manager = client.method_1478();
        PunchyTuningConfig.collectCompatProfiles(manager, "compat", "punchy", "compat/", result);
        PunchyTuningConfig.collectCompatProfiles(manager, COMPAT_DIR_NAME, "minecraft", "punchy/compat/", result);
        return result;
    }

    private static void collectCompatProfiles(class_3300 manager, String searchPath, String namespace, String prefix, Set<String> result) {
        Map found = manager.method_14488(searchPath, loc -> loc.method_12836().equals(namespace) && loc.method_12832().startsWith(prefix) && loc.method_12832().endsWith(".json"));
        for (class_2960 id : found.keySet()) {
            String path = id.method_12832();
            String file = path.substring(prefix.length());
            if (file.endsWith(".json")) {
                file = file.substring(0, file.length() - 5);
            }
            if (file.isBlank()) continue;
            result.add(file.toLowerCase(Locale.ROOT));
        }
    }

    private static SideSet resolveGlobalArm(Data data) {
        if (data == null) {
            return null;
        }
        return data.globalArm;
    }

    private static SideSet resolveGlobalItem(Data data) {
        if (data == null) {
            return null;
        }
        if (data.globalItem != null) {
            return data.globalItem;
        }
        if (data.item != null) {
            for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
                GroupEntry entry = data.item.get(kind.name());
                if (entry == null || entry.transforms == null) continue;
                return entry.transforms;
            }
        }
        return null;
    }

    private static Data loadCompatProfile(String profile) {
        class_310 client;
        String normalized = profile.endsWith(".json") ? profile.substring(0, profile.length() - 5) : profile;
        Path compatDir = PunchyTuningConfig.getCompatDirectory();
        try {
            Files.createDirectories(compatDir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Path filePath = compatDir.resolve(normalized + ".json");
        if (Files.exists(filePath, new LinkOption[0])) {
            Data data;
            FileReader reader2 = new FileReader(filePath.toFile());
            try {
                data = PunchyTuningConfig.finalizeCompatData(normalized, (Data)GSON.fromJson((Reader)reader2, Data.class));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception reader2) {
                    // empty catch block
                }
            }
            reader2.close();
            return data;
        }
        if ((client = class_310.method_1551()) != null) {
            Data bundled = PunchyTuningConfig.loadCompatProfileFromResource(client, "punchy", "compat/" + normalized + ".json", normalized);
            if (bundled != null) {
                return bundled;
            }
            Data minecraft = PunchyTuningConfig.loadCompatProfileFromResource(client, "minecraft", "punchy/compat/" + normalized + ".json", normalized);
            if (minecraft != null) {
                return minecraft;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Data loadCompatProfileFromResource(class_310 client, String namespace, String path, String profile) {
        block13: {
            class_2960 id = class_2960.method_60655((String)namespace, (String)path);
            try {
                Optional resource = client.method_1478().method_14486(id);
                if (!resource.isPresent()) break block13;
                try (InputStream stream = ((class_3298)resource.get()).method_14482();){
                    Data data;
                    try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        data = PunchyTuningConfig.finalizeCompatData(profile, (Data)GSON.fromJson((Reader)reader, Data.class));
                    }
                    return data;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Data finalizeCompatData(String profile, Data data) {
        return data;
    }

    private static Path getCompatDirectory() {
        Path configDir = Platform.get().getConfigDirectory();
        return configDir.resolve(COMPAT_DIR_NAME);
    }

    private static void installBundledCompatProfiles() {
        for (String profile : BUNDLED_COMPAT_PROFILES) {
            PunchyTuningConfig.copyBundledCompatProfile(profile);
        }
    }

    private static void copyBundledCompatProfile(String profile) {
        try (InputStream stream = PunchyTuningConfig.openBundledCompatStream(profile);){
            if (stream == null) {
                return;
            }
            Path compatDir = PunchyTuningConfig.getCompatDirectory();
            Files.createDirectories(compatDir, new FileAttribute[0]);
            Path target = compatDir.resolve(profile + ".json");
            Files.copy(stream, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream openBundledCompatStream(String profile) {
        class_2960 id = class_2960.method_60655((String)"punchy", (String)("compat/" + profile + ".json"));
        class_310 client = class_310.method_1551();
        if (client != null) {
            try {
                Optional resource = client.method_1478().method_14486(id);
                if (resource.isPresent()) {
                    return ((class_3298)resource.get()).method_14482();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PunchyTuningConfig.class.getResourceAsStream("/assets/punchy/compat/" + profile + ".json");
    }

    public static final class Data {
        public Map<String, GroupEntry> item = new HashMap<String, GroupEntry>();
        public Map<String, SideSet> armMesh = new HashMap<String, SideSet>();
        public SideSet globalItem;
        public SideSet globalArm;
        public Map<String, SpecificEntry> itemSpecific = new HashMap<String, SpecificEntry>();
    }

    public static final class SideSet {
        public Pose right;
        public Pose left;
    }

    public static final class Pose {
        public float scale;
        public float offX;
        public float offY;
        public float offZ;
        public float rotX;
        public float rotY;
        public float rotZ;
        public float pivotX;
        public float pivotY;
        public float pivotZ;

        public Pose() {
        }

        public Pose(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
            this(scale, offX, offY, offZ, rotX, rotY, rotZ, 0.0f, 0.0f, 0.0f);
        }

        public Pose(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ, float pivotX, float pivotY, float pivotZ) {
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.offZ = offZ;
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
            this.pivotX = pivotX;
            this.pivotY = pivotY;
            this.pivotZ = pivotZ;
        }

        public static Pose fromTool(ToolTuning.Profile p) {
            return new Pose(p.scale, p.offX, p.offY, p.offZ, p.rotX, p.rotY, p.rotZ, p.pivotX, p.pivotY, p.pivotZ);
        }

        public static Pose fromArm(ArmToolTuning.Profile p) {
            return new Pose(p.scale, p.offX, p.offY, p.offZ, p.rotX, p.rotY, p.rotZ);
        }

        public ToolTuning.Profile toTool() {
            return new ToolTuning.Profile(this.scale, this.offX, this.offY, this.offZ, this.rotX, this.rotY, this.rotZ, this.pivotX, this.pivotY, this.pivotZ);
        }

        public ArmToolTuning.Profile toArm() {
            return new ArmToolTuning.Profile(this.scale, this.offX, this.offY, this.offZ, this.rotX, this.rotY, this.rotZ);
        }

        public static Pose fromArmMesh(ArmMeshTuning.Profile p) {
            if (p == null) {
                return null;
            }
            return new Pose(p.scale, p.offX, p.offY, p.offZ, p.rotX, p.rotY, p.rotZ);
        }

        public ArmMeshTuning.Profile toArmMesh() {
            return new ArmMeshTuning.Profile(this.scale, this.offX, this.offY, this.offZ, this.rotX, this.rotY, this.rotZ);
        }
    }

    public static final class GroupEntry {
        public SideSet transforms;
        public SideSet armTransforms;
        public Pose right;
        public Pose left;
    }

    public static final class SpecificEntry {
        public String kind;
        public String armKind;
        public SideSet transforms;
        public SideSet armTransforms;
    }
}

