/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.geo.compat.PunchyCameraRenderState;
import com.henrique.punchy.geo.compat.PunchyCompatDataTickets;
import com.henrique.punchy.geo.compat.PunchyPerBoneRender;
import com.henrique.punchy.geo.compat.PunchyPerBoneRenderTasks;
import com.henrique.punchy.geo.compat.PunchySubmitNodeCollector;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.util.RenderUtil;

@Mixin(value={GeoRenderer.class})
public interface PunchyGeoRendererMixin<T extends GeoAnimatable, O, R extends GeoRenderState> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"applyRenderLayers(Lsoftware/bernie/geckolib/renderer/base/GeoRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lsoftware/bernie/geckolib/cache/object/BakedGeoModel;Lnet/minecraft/client/renderer/RenderType;Lnet/minecraft/client/renderer/MultiBufferSource;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V"}, at={@At(value="HEAD")})
    private void punchy$runPerBoneTasks(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, int packedLight, int packedOverlay, int renderColor, CallbackInfo ci) {
        GeoRenderer renderer = (GeoRenderer)this;
        PunchyPerBoneRenderTasks tasksContainer = (PunchyPerBoneRenderTasks)renderState.getGeckolibData(PunchyCompatDataTickets.PER_BONE_TASKS);
        if (tasksContainer == null) {
            return;
        }
        Map<GeoRenderer<?, ?, ?>, PunchyPerBoneRenderTasks.ForRenderer<?>> map = tasksContainer.map();
        PunchyPerBoneRenderTasks.ForRenderer<?> taskBucket = map.get(renderer);
        if (taskBucket == null || taskBucket.isEmpty()) {
            return;
        }
        PunchySubmitNodeCollector queue = new PunchySubmitNodeCollector(bufferSource);
        PunchyCameraRenderState cameraState = PunchyCameraRenderState.capture();
        AutoCloseable tiltGuard = PunchyClient.pushDisableCameraTilt();
        try {
            for (Map.Entry<GeoBone, List<PunchyPerBoneRender<?>>> entry : taskBucket) {
                GeoBone bone = entry.getKey();
                poseStack.method_22903();
                PunchyGeoRendererMixin.applyBoneTransform(poseStack, bone);
                PunchyGeoRendererMixin.applyBoneAnchorRotation(poseStack, bone);
                for (PunchyPerBoneRender<?> task : entry.getValue()) {
                    task.submitRenderTask(renderState, poseStack, bone, queue, cameraState, packedLight, packedOverlay, renderColor);
                }
                poseStack.method_22909();
            }
        }
        finally {
            try {
                tiltGuard.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        taskBucket.clear();
        map.remove(renderer);
    }

    private static void applyBoneTransform(class_4587 poseStack, GeoBone bone) {
        ObjectArrayList boneQueue = new ObjectArrayList();
        GeoBone current = bone;
        boneQueue.add((Object)current);
        while (current.getParent() != null) {
            current = current.getParent();
            boneQueue.add((Object)current);
        }
        Collections.reverse(boneQueue);
        for (GeoBone queueBone : boneQueue) {
            RenderUtil.prepMatrixForBone((class_4587)poseStack, (GeoBone)queueBone);
        }
    }

    private static void applyBoneAnchorRotation(class_4587 poseStack, GeoBone bone) {
        float pitchRotation;
        GeoBone anchor = PunchyGeoRendererMixin.findBoneAnchor(bone);
        if (anchor == null) {
            return;
        }
        float yawRotation = PunchyClient.cameraAnchorYawRadiansRaw();
        if (yawRotation != 0.0f) {
            if ("bone_anchor_right".equals(anchor.getName())) {
                yawRotation = -yawRotation;
            }
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(yawRotation));
        }
        if ((pitchRotation = PunchyClient.cameraAnchorPitchRadiansRaw()) != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation(pitchRotation));
        }
    }

    private static GeoBone findBoneAnchor(GeoBone bone) {
        for (GeoBone current = bone; current != null; current = current.getParent()) {
            String name = current.getName();
            if (name == null || !name.equals("bone_anchor_right") && !name.equals("bone_anchor_left")) continue;
            return current;
        }
        return null;
    }
}

