/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.server;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.util.HandHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class TapMiningManager {
    private static final Map<UUID, Map<class_2338, Double>> PROGRESS = new HashMap<UUID, Map<class_2338, Double>>();
    private static final Map<UUID, Map<class_2338, Integer>> BREAKER_IDS = new HashMap<UUID, Map<class_2338, Integer>>();
    private static final Map<UUID, Map<class_2338, Long>> LAST_CLICK_TICKS = new HashMap<UUID, Map<class_2338, Long>>();
    private static final int CLICK_TICKS = 5;
    private static final long RESET_TICKS = 100L;

    private TapMiningManager() {
    }

    public static void onClick(class_3222 player, class_3218 world, class_2338 pos) {
        if (!Punchy.TAP_MINING_ENABLED) {
            return;
        }
        if (player == null || world == null || pos == null) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return;
        }
        if (player.method_31549().field_7477) {
            TapMiningManager.clearProgress(world, player, pos);
            world.method_8651(pos, false, (class_1297)player);
            return;
        }
        double deltaPerTick = state.method_26165((class_1657)player, (class_1922)world, pos);
        if (deltaPerTick <= 0.0) {
            return;
        }
        double add = deltaPerTick * 5.0 * Punchy.MINING_SPEED_MULTIPLIER;
        long nowTick = world.method_8510();
        Map map = PROGRESS.computeIfAbsent(player.method_5667(), k -> new HashMap());
        Map lastClick = LAST_CLICK_TICKS.computeIfAbsent(player.method_5667(), k -> new HashMap());
        double prev = map.getOrDefault(pos, 0.0);
        double now = Math.min(1.0, prev + add);
        if (now >= 1.0) {
            TapMiningManager.clearProgress(world, player, pos);
            world.method_8651(pos, true, (class_1297)player);
            HandHelper.getConfiguredMainHandItem((class_1657)player).method_71012(1, (class_1309)player, player.method_6058());
        } else {
            map.put(pos, now);
            lastClick.put(pos, nowTick);
            int stage = Math.min(9, Math.max(0, (int)Math.floor(now * 10.0)));
            int id = TapMiningManager.getBreakerId(player, pos);
            world.method_8517(id, pos, stage);
        }
    }

    public static void tickWorld(class_3218 world) {
        if (!Punchy.TAP_MINING_ENABLED) {
            for (class_3222 player : world.method_18456()) {
                TapMiningManager.clearPlayerProgress(world, player);
            }
            return;
        }
        long nowTick = world.method_8510();
        for (class_3222 player : world.method_18456()) {
            Map<class_2338, Double> map = PROGRESS.get(player.method_5667());
            if (map == null || map.isEmpty()) continue;
            Map<class_2338, Long> lastClick = LAST_CLICK_TICKS.get(player.method_5667());
            Iterator<Map.Entry<class_2338, Double>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                long lastTick;
                Map.Entry<class_2338, Double> entry = it.next();
                class_2338 pos = entry.getKey();
                double prog = entry.getValue();
                class_2680 state = world.method_8320(pos);
                if (state.method_26215()) {
                    TapMiningManager.endProgressOverlay(world, player, pos);
                    if (lastClick != null) {
                        lastClick.remove(pos);
                    }
                    it.remove();
                    continue;
                }
                long l = lastTick = lastClick != null ? lastClick.getOrDefault(pos, nowTick) : nowTick;
                if (nowTick - lastTick >= 100L) {
                    TapMiningManager.endProgressOverlay(world, player, pos);
                    if (lastClick != null) {
                        lastClick.remove(pos);
                    }
                    it.remove();
                    continue;
                }
                if (prog >= 1.0) {
                    TapMiningManager.endProgressOverlay(world, player, pos);
                    if (lastClick != null) {
                        lastClick.remove(pos);
                    }
                    it.remove();
                    world.method_8651(pos, true, (class_1297)player);
                    HandHelper.getConfiguredMainHandItem((class_1657)player).method_71012(1, (class_1309)player, player.method_6058());
                    continue;
                }
                int stage = Math.min(9, Math.max(0, (int)Math.floor(prog * 10.0)));
                int id = TapMiningManager.getBreakerId(player, pos);
                world.method_8517(id, pos, stage);
            }
        }
    }

    private static void clearPlayerProgress(class_3218 world, class_3222 player) {
        if (player == null) {
            return;
        }
        Map<class_2338, Integer> ids = BREAKER_IDS.remove(player.method_5667());
        if (ids != null) {
            ids.forEach((pos, id) -> world.method_8517(id.intValue(), pos, -1));
        }
        PROGRESS.remove(player.method_5667());
        LAST_CLICK_TICKS.remove(player.method_5667());
    }

    private static void clearProgress(class_3218 world, class_3222 player, class_2338 pos) {
        Map<class_2338, Long> lastClick;
        if (player == null || pos == null) {
            return;
        }
        Map<class_2338, Double> map = PROGRESS.get(player.method_5667());
        if (map != null) {
            map.remove(pos);
        }
        if ((lastClick = LAST_CLICK_TICKS.get(player.method_5667())) != null) {
            lastClick.remove(pos);
        }
        TapMiningManager.endProgressOverlay(world, player, pos);
    }

    private static void endProgressOverlay(class_3218 world, class_3222 player, class_2338 pos) {
        int id = TapMiningManager.getBreakerId(player, pos);
        world.method_8517(id, pos, -1);
        TapMiningManager.clearBreakerId(player, pos);
    }

    private static int getBreakerId(class_3222 player, class_2338 pos) {
        Map ids = BREAKER_IDS.computeIfAbsent(player.method_5667(), k -> new HashMap());
        Integer id = (Integer)ids.get(pos);
        if (id != null) {
            return id;
        }
        int newId = 0x40000000 ^ player.method_5667().hashCode() ^ pos.hashCode();
        if (newId == player.method_5628()) {
            newId ^= 0x1FFFFF;
        }
        ids.put(pos, newId);
        return newId;
    }

    private static void clearBreakerId(class_3222 player, class_2338 pos) {
        Map<class_2338, Integer> ids = BREAKER_IDS.get(player.method_5667());
        if (ids != null) {
            ids.remove(pos);
        }
    }
}

