/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.render.AxolotlPhysics;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.LightingHelper;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.mixin.accessor.BakedQuadAccessor;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class AxolotlBucketRenderer
implements class_10515<LayerData> {
    static final AxolotlBucketRenderer INSTANCE = new AxolotlBucketRenderer();
    private static final EnumMap<class_1268, AxolotlPhysics> PHYSICS = new EnumMap(class_1268.class);

    private AxolotlBucketRenderer() {
    }

    public void render(LayerData data, class_811 context, class_4587 matrices, class_4597 buffer, int packedLight, int packedOverlay, boolean isGlinting) {
        float pivotZ;
        float pivotY;
        float pivotX;
        class_243 contextPivot;
        if (data == null || data.quads == null || data.quads.isEmpty() || data.renderType == null) {
            return;
        }
        class_1268 hand = data.hand == null ? class_1268.field_5808 : data.hand;
        PunchyClient.JumpSpringPose pose = PunchyClient.jumpSpringPose(class_1268.field_5808);
        boolean left = hand == class_1268.field_5810;
        class_243 tuningPivot = VanillaProxyContext.getItemPivot(hand);
        class_243 class_2432 = contextPivot = tuningPivot != null ? tuningPivot : VanillaProxyContext.getSpringPivot(hand);
        if (contextPivot != null) {
            pivotX = (float)contextPivot.method_10216();
            pivotY = (float)contextPivot.method_10214();
            pivotZ = (float)contextPivot.method_10215();
        } else {
            PunchyClient.JumpSpringPivot pivot = PunchyClient.jumpSpringPivot();
            pivotX = pivot.x();
            pivotY = pivot.y();
            pivotZ = pivot.z();
        }
        if (left) {
            pivotX = -pivotX;
        }
        matrices.method_46416(pivotX, pivotY, pivotZ);
        AxolotlPhysics physics = AxolotlBucketRenderer.stateFor(hand);
        PunchyClient.CameraDrift drift = PunchyClient.cameraDrift();
        physics.update(pose, left, drift);
        float pitch = physics.getPitch();
        float roll = physics.getRoll();
        if (left) {
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)Math.PI));
        }
        if (pitch != 0.0f) {
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(pitch));
        }
        if (roll != 0.0f) {
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(roll));
        }
        if (left) {
            matrices.method_22907((Quaternionfc)class_7833.field_40715.rotation((float)Math.PI));
        }
        matrices.method_46416(-pivotX, -pivotY, -pivotZ);
        float deformation = physics.getDeformation();
        if (Math.abs(deformation) > 0.001f) {
            float sy = 1.0f + deformation;
            float sxz = 1.0f - deformation * 0.5f;
            matrices.method_22905(sxz, sy, sxz);
        }
        HandSwayPhysics.get().applyElasticity(matrices, 1.0f);
        class_310 client = class_310.method_1551();
        int resolvedLight = data.usesBlockLight ? LightingHelper.resolveLight((class_1937)client.field_1687, (class_1309)client.field_1724, 0) : 0xF000F0;
        class_4588 vertexConsumer = buffer.getBuffer(data.renderType);
        for (class_777 quad : data.quads) {
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (quad.method_3360()) {
                int tintIndex = ((BakedQuadAccessor)quad).punchy$tintIndex();
                if (data.tintLayers != null && tintIndex >= 0 && tintIndex < data.tintLayers.length) {
                    int color = data.tintLayers[tintIndex];
                    r = (float)(color >> 16 & 0xFF) / 255.0f;
                    g = (float)(color >> 8 & 0xFF) / 255.0f;
                    b = (float)(color & 0xFF) / 255.0f;
                }
            }
            vertexConsumer.method_22919(matrices.method_23760(), quad, r, g, b, 1.0f, resolvedLight, packedOverlay);
        }
    }

    public void getExtents(Set<Vector3f> extents) {
    }

    @Nullable
    public LayerData extractArgument(class_1799 stack) {
        return null;
    }

    private static AxolotlPhysics stateFor(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return PHYSICS.computeIfAbsent(resolved, h -> new AxolotlPhysics());
    }

    public record LayerData(class_1268 hand, class_1921 renderType, class_10444.class_10445 foilType, int[] tintLayers, List<class_777> quads, boolean usesBlockLight) {
    }
}

