/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public interface GeoRenderer<T extends GeoAnimatable, O, R extends GeoRenderState> {
    public GeoModel<T> getGeoModel();

    default public List<GeoRenderLayer<T, O, R>> getRenderLayers() {
        return List.of();
    }

    @ApiStatus.Internal
    default public long getInstanceId(T animatable, O relatedObject) {
        return animatable.hashCode();
    }

    default public int getRenderColor(T animatable, O relatedObject, float partialTick) {
        return -1;
    }

    default public int getPackedOverlay(T animatable, O relatedObject, float u, float partialTick) {
        return class_4608.field_21444;
    }

    default public float getMotionAnimThreshold(T animatable) {
        return 0.015f;
    }

    default public class_2960 getTextureLocation(R renderState) {
        return this.getGeoModel().getTextureResource(renderState);
    }

    @Nullable
    default public class_1921 getRenderType(R renderState, class_2960 texture) {
        return this.getGeoModel().getRenderType(renderState, texture);
    }

    @ApiStatus.OverrideOnly
    default public void addRenderData(T animatable, O relatedObject, R renderState) {
    }

    @ApiStatus.Internal
    default public R captureDefaultRenderState(T animatable, O relatedObject, R renderState, float partialTick) {
        long instanceId = this.getInstanceId(animatable, relatedObject);
        renderState.addGeckolibData(DataTickets.TICK, (Object)animatable.getTick(relatedObject));
        renderState.addGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, (Object)instanceId);
        renderState.addGeckolibData(DataTickets.ANIMATABLE_MANAGER, (Object)animatable.getAnimatableInstanceCache().getManagerForId(instanceId));
        renderState.addGeckolibData(DataTickets.PARTIAL_TICK, (Object)Float.valueOf(partialTick));
        renderState.addGeckolibData(DataTickets.RENDER_COLOR, (Object)this.getRenderColor(animatable, relatedObject, partialTick));
        renderState.addGeckolibData(DataTickets.PACKED_OVERLAY, (Object)this.getPackedOverlay(animatable, relatedObject, 0.0f, partialTick));
        renderState.addGeckolibData(DataTickets.IS_MOVING, (Object)false);
        renderState.addGeckolibData(DataTickets.BONE_RESET_TIME, (Object)animatable.getBoneResetTime());
        renderState.addGeckolibData(DataTickets.ANIMATABLE_CLASS, (Object)animatable.getClass());
        renderState.addGeckolibData(DataTickets.PER_BONE_TASKS, (Object)new Reference2ObjectOpenHashMap(0));
        return renderState;
    }

    @ApiStatus.Internal
    default public R fillRenderState(T animatable, O relatedObject, R renderState, float partialTick) {
        this.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        this.addRenderData(animatable, relatedObject, renderState);
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.addRenderData(animatable, relatedObject, renderState);
        }
        this.fireCompileRenderStateEvent(animatable, relatedObject, renderState);
        this.getGeoModel().prepareForRenderPass(animatable, renderState);
        return renderState;
    }

    default public void defaultRender(R renderState, class_4587 poseStack, class_4597 bufferSource, @Nullable class_1921 renderType, @Nullable class_4588 buffer) {
        poseStack.method_22903();
        if (renderType == null) {
            renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
        }
        if (buffer == null && renderType != null) {
            buffer = bufferSource.getBuffer(renderType);
        }
        GeoModel<T> geoModel = this.getGeoModel();
        BakedGeoModel model = geoModel.getBakedModel(geoModel.getModelResource(renderState));
        int packedOverlay = (Integer)renderState.getGeckolibData(DataTickets.PACKED_OVERLAY);
        int packedLight = (Integer)renderState.getGeckolibData(DataTickets.PACKED_LIGHT);
        int renderColor = (Integer)renderState.getGeckolibData(DataTickets.RENDER_COLOR);
        this.preRender(renderState, poseStack, model, bufferSource, buffer, false, packedLight, packedOverlay, renderColor);
        this.adjustPositionForRender(renderState, poseStack, model, false);
        this.scaleModelForRender(renderState, 1.0f, 1.0f, poseStack, model, false);
        if (this.firePreRenderEvent(renderState, poseStack, model, bufferSource)) {
            this.preApplyRenderLayers(renderState, poseStack, model, renderType, bufferSource, buffer, packedLight, packedOverlay, renderColor);
            this.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, false, packedLight, packedOverlay, renderColor);
            this.applyRenderLayers(renderState, poseStack, model, renderType, bufferSource, buffer, packedLight, packedOverlay, renderColor);
            this.postRender(renderState, poseStack, model, bufferSource, buffer, false, packedLight, packedOverlay, renderColor);
            this.firePostRenderEvent(renderState, poseStack, model, bufferSource);
        }
        poseStack.method_22909();
        this.renderFinal(renderState, poseStack, model, bufferSource, buffer, packedLight, packedOverlay, renderColor);
        this.doPostRenderCleanup();
    }

    default public void reRender(R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, class_1921 renderType, class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        poseStack.method_22903();
        this.preRender(renderState, poseStack, model, bufferSource, buffer, true, packedLight, packedOverlay, renderColor);
        this.adjustPositionForRender(renderState, poseStack, model, true);
        this.scaleModelForRender(renderState, 1.0f, 1.0f, poseStack, model, true);
        this.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, true, packedLight, packedOverlay, renderColor);
        this.postRender(renderState, poseStack, model, bufferSource, buffer, true, packedLight, packedOverlay, renderColor);
        poseStack.method_22909();
    }

    default public void actuallyRender(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (renderType == null || buffer == null) {
            return;
        }
        for (GeoBone group : model.topLevelBones()) {
            this.renderRecursively(renderState, poseStack, group, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        }
    }

    default public void preApplyRenderLayers(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        Reference2ObjectMap perBoneTasks = this.getPerBoneTasks(renderState);
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.preRender(renderState, poseStack, model, renderType, bufferSource, buffer, packedLight, packedOverlay, renderColor);
            renderLayer.addPerBoneRender(renderState, model, (boneName, renderOp) -> perBoneTasks.put(boneName, (Object)Pair.of((Object)new MutableObject(), (Object)renderOp)));
        }
    }

    default public void applyRenderLayers(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_1921 renderType, class_4597 bufferSource, @Nullable class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        for (Reference2ObjectMap.Entry entry : this.getPerBoneTasks(renderState).reference2ObjectEntrySet()) {
            ((PerBoneRender)((Pair)entry.getValue()).right()).runTask(renderState, poseStack, (GeoBone)entry.getKey(), (class_4587.class_4665)((MutableObject)((Pair)entry.getValue()).left()).getValue(), renderType, bufferSource, packedLight, packedOverlay, renderColor);
        }
        for (GeoRenderLayer geoRenderLayer : this.getRenderLayers()) {
            geoRenderLayer.render(renderState, poseStack, model, renderType, bufferSource, buffer, packedLight, packedOverlay, renderColor);
        }
    }

    default public void preRender(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void postRender(R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void renderFinal(R renderState, class_4587 poseStack, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void doPostRenderCleanup() {
    }

    default public void renderRecursively(R renderState, class_4587 poseStack, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        Pair boneRenderTask;
        poseStack.method_22903();
        RenderUtil.prepMatrixForBone((class_4587)poseStack, (GeoBone)bone);
        if (!isReRender && (boneRenderTask = (Pair)this.getPerBoneTasks(renderState).get((Object)bone)) != null) {
            ((MutableObject)boneRenderTask.left()).setValue((Object)poseStack.method_23760().method_56822());
        }
        this.renderCubesOfBone(renderState, bone, poseStack, buffer, packedLight, packedOverlay, renderColor);
        this.renderChildBones(renderState, bone, poseStack, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        poseStack.method_22909();
    }

    default public void renderCubesOfBone(R renderState, GeoBone bone, class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isHidden()) {
            return;
        }
        for (GeoCube cube : bone.getCubes()) {
            poseStack.method_22903();
            this.renderCube(renderState, cube, poseStack, buffer, packedLight, packedOverlay, renderColor);
            poseStack.method_22909();
        }
    }

    default public void renderChildBones(R renderState, GeoBone bone, class_4587 poseStack, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, int packedLight, int packedColor, int renderColor) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (GeoBone childBone : bone.getChildBones()) {
            this.renderRecursively(renderState, poseStack, childBone, renderType, bufferSource, buffer, isReRender, packedLight, packedColor, renderColor);
        }
    }

    default public void renderCube(R renderState, GeoCube cube, class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        RenderUtil.translateToPivotPoint((class_4587)poseStack, (GeoCube)cube);
        RenderUtil.rotateMatrixAroundCube((class_4587)poseStack, (GeoCube)cube);
        RenderUtil.translateAwayFromPivotPoint((class_4587)poseStack, (GeoCube)cube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtil.fixInvertedFlatCube((GeoCube)cube, (Vector3f)normal);
            this.createVerticesOfQuad(renderState, quad, poseState, normal, buffer, packedOverlay, packedLight, renderColor);
        }
    }

    default public void createVerticesOfQuad(R renderState, GeoQuad quad, Matrix4f poseState, Vector3f normal, class_4588 buffer, int packedOverlay, int packedLight, int renderColor) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            buffer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), renderColor, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    default public void adjustPositionForRender(R renderState, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
    }

    default public void scaleModelForRender(R renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, boolean isReRender) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            poseStack.method_22905(widthScale, heightScale, widthScale);
        }
    }

    default public AnimationState<T> createAnimationState(R renderState) {
        return new AnimationState(renderState);
    }

    default public void setBonesVisible(boolean visible, String ... boneNames) {
        GeoModel<T> model = this.getGeoModel();
        for (String boneName : boneNames) {
            model.getBone(boneName).ifPresent(bone -> bone.setHidden(!visible));
        }
    }

    default public void setBonesVisible(boolean visible, GeoBone ... bones) {
        if (bones == null) {
            return;
        }
        for (GeoBone bone : bones) {
            if (bone == null) continue;
            bone.setHidden(!visible);
        }
    }

    public void fireCompileRenderLayersEvent();

    public void fireCompileRenderStateEvent(T var1, O var2, R var3);

    public boolean firePreRenderEvent(R var1, class_4587 var2, BakedGeoModel var3, class_4597 var4);

    public void firePostRenderEvent(R var1, class_4587 var2, BakedGeoModel var3, class_4597 var4);

    default public Reference2ObjectMap<GeoBone, Pair<MutableObject<class_4587.class_4665>, PerBoneRender<R>>> getPerBoneTasks(R renderState) {
        return (Reference2ObjectMap)renderState.getGeckolibData(DataTickets.PER_BONE_TASKS);
    }
}

