/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.ClientBridge;
import com.henrique.punchy.client.debug.AnchorDebugProbe;
import com.henrique.punchy.client.render.ArmAnimationOverrides;
import com.henrique.punchy.client.render.BoneAnimationController;
import com.henrique.punchy.client.render.HandItemOverrides;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.ToolAnimationOverrides;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.UseAnimationSuppressor;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.render.anim.BoneAnimationIds;
import com.henrique.punchy.client.tuning.TuningKeybinds;
import com.henrique.punchy.combat.ImpactClientHooks;
import com.henrique.punchy.config.PunchyConfig;
import com.henrique.punchy.config.PunchyTuningConfig;
import com.henrique.punchy.geo.renderer.LeftArmRenderer;
import com.henrique.punchy.geo.renderer.RightArmRenderer;
import com.henrique.punchy.item.AnimatedBoneProxy;
import com.henrique.punchy.item.AnimatedTool;
import com.henrique.punchy.item.AnimationRandomizer;
import com.henrique.punchy.mixin.accessor.LivingEntityAccessor;
import com.henrique.punchy.networking.ModMessages;
import com.henrique.punchy.networking.packet.BlockImpactPayload;
import com.henrique.punchy.platform.ClientPlatform;
import com.henrique.punchy.platform.ClientPlatformServices;
import com.henrique.punchy.util.HandHelper;
import com.henrique.punchy.util.ProxyItemHelper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1755;
import net.minecraft.class_1764;
import net.minecraft.class_1771;
import net.minecraft.class_1776;
import net.minecraft.class_1779;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1823;
import net.minecraft.class_1826;
import net.minecraft.class_1835;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3675;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4537;
import net.minecraft.class_5498;
import net.minecraft.class_5538;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9362;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class PunchyClient {
    private static final int USE_ANIMATION_TICKS = 6;
    private static final int BUCKET_USE_ANIMATION_TICKS = 40;
    private static final JumpSpringPivot SPRING_PIVOT = new JumpSpringPivot(-1.0f, 0.3f, 0.2f);
    private static final float LANTERN_RIGHT_DELTA_X = 0.16f;
    private static final float LANTERN_LEFT_DELTA_X = -0.16f;
    private static final float LANTERN_DELTA_Y = 0.14f;
    private static final float LANTERN_DELTA_Z = 0.08f;
    private static final String TRANSITION_PREFIX = "transition_to_idle_";
    private static final String FLINT_STEEL_CLIP = "flint_and_steel";
    private static final class_1799 FLINT_AND_STEEL_PROXY_STACK = new class_1799((class_1935)class_1802.field_8884);
    private static final String[] SWORD_ATTACK_VARIANTS = new String[]{"attack", "attack_2", "attack_3"};
    private static final String PUNCH_TRIGGER = "mining";
    private static final String PUNCH_ATTACK_TRIGGER = "punch_attack";
    private static final String CONTROLLER_ACTIVATION = "Activation";
    private static final float OFFHAND_LOWERED_ROT_X = -90.0f;
    private static Set<String> cachedTransitionAnimations = Set.of();
    private static boolean transitionAnimationsLoaded = false;
    private static final double FALL_CHARGE_MIN_DROP = 5.0;
    private static final double FALL_CHARGE_SPEED_THRESHOLD = -0.08;
    private static final String TRANSITION_TO_IDLE_PUNCH = "transition_to_idle_punch";
    private AttackTarget pendingAttackTarget;
    private long pendingAttackExpiryNanos;
    private static PunchyClient INSTANCE;
    private static class_304 inspectKey;
    public static boolean isMiningAnimationPlaying;
    public static long miningAnimationStartTime;
    public static class_2338 lastMiningTargetPos;
    private class_1799 lastMainhandStack = class_1799.field_8037;
    private class_1799 lastOffhandStack = class_1799.field_8037;
    private boolean offhandHoldActive = false;
    private boolean mainHandHiddenForSwap = false;
    private boolean needsOffhandLowerBootstrap = true;
    private final EnumMap<class_1268, Boolean> loweredHands = new EnumMap(class_1268.class);
    private final EnumSet<class_1268> idleHands = EnumSet.noneOf(class_1268.class);
    private final Map<class_1268, String> idleClips = new EnumMap<class_1268, String>(class_1268.class);
    private final Map<class_1268, LanternPhysicsState> lanternPhysics = new EnumMap<class_1268, LanternPhysicsState>(class_1268.class);
    private final Map<class_1268, LanternGripState> lanternGrips = new EnumMap<class_1268, LanternGripState>(class_1268.class);
    private final Map<class_1268, JumpSpringState> jumpSprings = new EnumMap<class_1268, JumpSpringState>(class_1268.class);
    private final Map<class_1268, SneakSpringState> sneakSprings = new EnumMap<class_1268, SneakSpringState>(class_1268.class);
    private final Map<class_1268, IdleSpringState> idleSprings = new EnumMap<class_1268, IdleSpringState>(class_1268.class);
    private final Map<class_1268, WalkSpringState> walkSprings = new EnumMap<class_1268, WalkSpringState>(class_1268.class);
    private final Map<class_1268, PunchLoopState> punchLoops = new EnumMap<class_1268, PunchLoopState>(class_1268.class);
    private final Map<class_1268, ArrayDeque<TransitionRequest>> idleTransitionQueues = new EnumMap<class_1268, ArrayDeque<TransitionRequest>>(class_1268.class);
    private final Map<class_1268, String> activeIdleTransitionClips = new EnumMap<class_1268, String>(class_1268.class);
    private final Map<class_1268, PendingTransition> pendingIdleTransitionSources = new EnumMap<class_1268, PendingTransition>(class_1268.class);
    private final Map<class_1268, Double> deferredWalkRequests = new EnumMap<class_1268, Double>(class_1268.class);
    private final Map<class_1268, String> lastQueuedIdleClip = new EnumMap<class_1268, String>(class_1268.class);
    private long lastLanternTickTime = System.nanoTime();
    private long lastSpringTickTime = System.nanoTime();
    private long lastIdleTickTime = System.nanoTime();
    private long lastWalkTickTime = System.nanoTime();
    private float lanternTimeRemainder = 0.0f;
    private float springTimeRemainder = 0.0f;
    private float idleTimeRemainder = 0.0f;
    private float walkTimeRemainder = 0.0f;
    private boolean consuming = false;
    private String consumingAnim = null;
    private class_1268 consumeHand = class_1268.field_5808;
    private boolean wasAttacking = false;
    private int attackHoldTicks = 0;
    private boolean attackLoopArmed = false;
    private boolean wasUsing = false;
    private class_1268 activationHand = class_1268.field_5808;
    private boolean transitionActive = false;
    private class_1268 transitionHand = class_1268.field_5808;
    private long transitionStopGameTime = -1L;
    private float lastCameraYaw = Float.NaN;
    private float lastCameraPitch = Float.NaN;
    private float lastCameraYawDelta = 0.0f;
    private float lastCameraPitchDelta = 0.0f;
    private float yawLag = 0.0f;
    private float pitchLag = 0.0f;
    private float cameraTiltMainDeg = 0.0f;
    private float cameraTiltOffDeg = 0.0f;
    private float cameraTiltMainSmoothDeg = 0.0f;
    private float cameraTiltOffSmoothDeg = 0.0f;
    private float cameraTiltMainOffsetX = 0.0f;
    private float cameraTiltMainOffsetY = 0.0f;
    private float cameraTiltMainOffsetZ = 0.0f;
    private float cameraTiltOffOffsetX = 0.0f;
    private float cameraTiltOffOffsetY = 0.0f;
    private float cameraTiltOffOffsetZ = 0.0f;
    private float cameraAnchorYawDeg = 0.0f;
    private float cameraAnchorPitchDeg = 0.0f;
    public static final ThreadLocal<Boolean> CAMERA_TILT_LOCK;
    private long lastCameraLogTick = Long.MIN_VALUE;
    private float lastLoggedCameraMain = Float.NaN;
    private float lastLoggedCameraOff = Float.NaN;
    private boolean rangedChargeActive = false;
    private class_1268 rangedChargeWeaponHand = class_1268.field_5808;
    private class_1268 rangedChargeArrowHand = null;
    private boolean rangedSpriteSuppressed = false;
    private class_1268 rangedSpriteHand = class_1268.field_5808;
    private int rangedSpriteHoldDepth = 0;
    private RangedChargeKind rangedChargeKind = RangedChargeKind.BOW;
    private final Map<class_1268, Long> rangedReleaseStopTimes = new EnumMap<class_1268, Long>(class_1268.class);
    private final Map<class_1268, ReleaseCleanup> rangedReleaseCleanup = new EnumMap<class_1268, ReleaseCleanup>(class_1268.class);
    private final EnumSet<class_1268> activeArrowOverrides = EnumSet.noneOf(class_1268.class);
    private final Map<class_1268, class_1799> savedArrowOverrides = new EnumMap<class_1268, class_1799>(class_1268.class);
    private final Map<class_1268, Boolean> savedArrowHidden = new EnumMap<class_1268, Boolean>(class_1268.class);
    private final Map<class_1268, Boolean> crossbowHiddenStates = new EnumMap<class_1268, Boolean>(class_1268.class);
    private boolean spyglassActive = false;
    private class_1268 spyglassHand = class_1268.field_5808;
    private boolean spyglassZoomAllowed = false;
    private boolean fallToWaterActive = false;
    private final EnumSet<class_1268> fallToWaterHands = EnumSet.noneOf(class_1268.class);
    private boolean swimmingActive = false;
    private double swimmingDirection = 1.0;
    private final EnumSet<class_1268> swimmingHands = EnumSet.noneOf(class_1268.class);
    private long swimmingStopDeadline = -1L;
    private boolean swimRightKeyDown = false;
    private boolean swimLeftKeyDown = false;
    private boolean swimRightPending = false;
    private boolean swimLeftPending = false;
    private boolean swimForwardHeldLast = false;
    private final Map<class_1268, String> swimmingStrafeClips = new EnumMap<class_1268, String>(class_1268.class);
    private static final int SWIM_STRAFE_BLEND_TICKS = 6;
    private final EnumSet<class_1268> fallingHands = EnumSet.noneOf(class_1268.class);
    private final Map<class_1268, String> fallingClips = new EnumMap<class_1268, String>(class_1268.class);
    private boolean fallChargeActive = false;
    private double fallChargeStartY = Double.NaN;
    private boolean fallChargeTracking = false;
    private int swimStrafeBlendTicks = 0;
    private boolean swimStrafeStopScheduled = false;
    private static final String HAND_IN_CLIP = "hand_in";
    private static final String HAND_OUT_CLIP = "hand_out";
    private static final Map<class_1268, Double> SELECT_ANIMATION_DURATION_MULTIPLIERS;
    private boolean shieldActive = false;
    private class_1268 shieldHand = class_1268.field_5808;
    private int shieldHurtTime = 0;
    private int shieldItemDamage = -1;
    private final EnumSet<class_1268> selectSuppressionHands = EnumSet.noneOf(class_1268.class);
    private final EnumSet<class_1268> walkingHands = EnumSet.noneOf(class_1268.class);
    private final EnumSet<class_1268> selectHands = EnumSet.noneOf(class_1268.class);
    private final EnumSet<class_1268> selectStopInProgress = EnumSet.noneOf(class_1268.class);
    private final Map<class_1268, Long> selectStopDeadlines = new EnumMap<class_1268, Long>(class_1268.class);
    private final Map<class_1268, String> activeSelectClips = new EnumMap<class_1268, String>(class_1268.class);
    private boolean pendingOffhandLowerSync = false;
    private boolean offhandRenderOverrideActive = false;
    private class_1799 offhandRenderOverrideBackup = class_1799.field_8037;
    private boolean offhandRenderHiddenBackup = false;
    private final MainHandSwapState mainHandSwapState = new MainHandSwapState();
    private final EnumSet<class_1268> jumpHands = EnumSet.noneOf(class_1268.class);
    private final EnumSet<class_1268> jumpHoldHands = EnumSet.noneOf(class_1268.class);
    private final Map<class_1268, Double> jumpHoldProgress = new EnumMap<class_1268, Double>(class_1268.class);
    private final Map<class_1268, Long> jumpStopTimes = new EnumMap<class_1268, Long>(class_1268.class);
    private final Map<class_1268, Double> jumpClipDurations = new EnumMap<class_1268, Double>(class_1268.class);
    private final Map<class_1268, Double> walkSpeedByHand = new EnumMap<class_1268, Double>(class_1268.class);
    private final Map<class_1268, String> walkingClips = new EnumMap<class_1268, String>(class_1268.class);
    private boolean walkActive = false;
    private double walkSpeedMultiplier = 1.0;
    private boolean jumpActive = false;
    private boolean wasOnGround = true;
    private boolean jumpInitialized = false;
    private boolean landingArmed = false;
    private long lastJumpSpringLogTick = Long.MIN_VALUE;
    private final Map<class_1268, JumpSpringPose> lastLoggedJumpSpringPoses = new EnumMap<class_1268, JumpSpringPose>(class_1268.class);
    private final Map<class_1268, Long> landingStopTimes = new EnumMap<class_1268, Long>(class_1268.class);
    private boolean idlePrimedThisSession = false;
    public static final ThreadLocal<Boolean> IN_MAP_RENDER;
    private static final int GECKOLIB_FPS = 60;
    private ActivationSource activationSource = ActivationSource.NONE;
    private boolean activationTargetIsEntity = false;
    private boolean inspectActive = false;
    private class_1799 inspectStack = class_1799.field_8037;
    private long inspectStopGameTime = -1L;
    private int inspectBlendTicks = 0;
    private static final int INSPECT_BLEND_TICKS = 8;
    private boolean pendingUseTrigger = false;
    private class_1268 pendingUseHand = class_1268.field_5808;
    private boolean pendingUseInteractsWithBlock = false;
    private int useAnimationTicks = 0;
    private class_1268 useAnimationHand = class_1268.field_5808;
    private String useAnimationClip = "";
    private boolean useInteractsWithBlock = false;
    private boolean usebrushHolding = false;
    private boolean useClickConsumed = false;
    private boolean useTargetWasEntity = false;
    private boolean flintAndSteelDualActive = false;
    private class_1268 flintAndSteelProxyHand = null;
    private class_1799 flintAndSteelSavedOverride = class_1799.field_8037;
    private boolean flintAndSteelSavedHidden = false;
    private boolean flintAndSteelCleanupPending = false;
    private class_1268 lockedUseHand = null;
    private class_1799 lockedUseStack = class_1799.field_8037;
    private final Map<class_1268, String> lastActivationClip = new EnumMap<class_1268, String>(class_1268.class);
    private final Map<AnimationRunKey, AnimationRunInfo> animationRuns = new HashMap<AnimationRunKey, AnimationRunInfo>();
    private boolean walkOnWaterActive = false;
    private final EnumSet<class_1268> walkOnWaterHands = EnumSet.noneOf(class_1268.class);
    private final EnumSet<class_1268> walkOnWaterPausedHands = EnumSet.noneOf(class_1268.class);
    private boolean walkOnWaterStopScheduled = false;
    private int walkOnWaterBlendTicks = 0;
    private double walkOnWaterAnimSpeed = 1.0;
    private int walkOnWaterExitGrace = 0;
    private static final int WALK_ON_WATER_BLEND_TICKS = 8;
    private static final int WALK_ON_WATER_EXIT_GRACE_TICKS = 6;
    private static final double SWAY_PRIMARY_WEIGHT = 0.85;
    private static final double SWAY_SECONDARY_WEIGHT = 0.15;

    public PunchyClient() {
        INSTANCE = this;
    }

    public static void initialize() {
        Punchy.applyCombatToggles(PunchyConfig.load());
        ClientBridge.setHooks(new ClientHooks());
        PunchyClient.registerInspectKey();
        PunchyClient client = new PunchyClient();
        ClientPlatformServices services = ClientPlatform.get();
        services.registerClientStarted(PunchyTuningConfig::loadAndApply);
        TuningKeybinds.register();
        services.registerClientTick(() -> client.onClientTick(class_310.method_1551()));
        services.registerRenderFrame(() -> client.onRenderFrame(class_310.method_1551()));
        client.handleResourceReload();
        ModMessages.registerS2CPackets();
    }

    private void handleResourceReload() {
        ToolAnimationOverrides.clearAll();
        ArmAnimationOverrides.clearAll();
        HandItemOverrides.clearAll();
        this.cancelPunchLoopForHand(class_1268.field_5808);
        this.cancelPunchLoopForHand(class_1268.field_5810);
        this.lastActivationClip.clear();
        this.pendingIdleTransitionSources.clear();
        this.punchLoops.clear();
        this.selectHands.clear();
        this.selectStopDeadlines.clear();
        this.activeSelectClips.clear();
        this.attackLoopArmed = false;
        class_310 client = class_310.method_1551();
        if (client != null) {
            this.ensureIdle(client);
        }
    }

    public static void queueUseAnimation(class_1268 hand) {
        PunchyClient.queueUseAnimation(hand, false);
    }

    public static void queueUseAnimation(class_1268 hand, boolean interactsWithBlock) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            class_1268 resolved;
            inst.lockedUseHand = resolved = hand == null ? class_1268.field_5808 : hand;
            class_1799 lockStack = inst.lastStackForHand(resolved);
            inst.lockedUseStack = lockStack == null ? class_1799.field_8037 : lockStack.method_7972();
            inst.pendingUseTrigger = true;
            inst.pendingUseHand = resolved;
            inst.pendingUseInteractsWithBlock = interactsWithBlock;
        }
    }

    public static void triggerImmediateUse(class_746 player, class_1268 hand, boolean interactsWithBlock) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        inst.lockedUseHand = hand == null ? class_1268.field_5808 : hand;
        class_1799 lockStack = inst.lastStackForHand(inst.lockedUseHand);
        inst.lockedUseStack = lockStack == null ? class_1799.field_8037 : lockStack.method_7972();
        inst.startUseAction(client, hand, interactsWithBlock);
    }

    private void onClientTick(class_310 client) {
        TuningKeybinds.handleClientTick(client);
        AnchorDebugProbe.tick(client);
        class_746 player = client.field_1724;
        if (player == null || client.field_1687 == null) {
            this.resetCameraLag();
            this.resetState(client);
            return;
        }
        if (!this.idlePrimedThisSession) {
            this.primeIdleState(player);
        }
        this.maintainFlintAndSteelVisibility();
        class_239 crosshair = client.field_1765;
        boolean hasBlockTarget = false;
        if (crosshair instanceof class_3965) {
            class_3965 blockHit = (class_3965)crosshair;
            if (crosshair.method_17783() == class_239.class_240.field_1332) {
                class_2680 state = client.field_1687.method_8320(blockHit.method_17777());
                hasBlockTarget = state != null && !state.method_26215();
            }
        }
        boolean attackKeyDown = client.field_1690.field_1886.method_1434();
        boolean attackBlocked = player.method_6039();
        boolean canStartAttack = attackKeyDown && !attackBlocked && this.activationSource == ActivationSource.NONE && (!this.wasAttacking || hasBlockTarget);
        int n = this.attackHoldTicks = attackKeyDown ? this.attackHoldTicks + 1 : 0;
        if (!attackKeyDown) {
            class_1268 loopHand;
            PunchLoopState state;
            this.attackLoopArmed = false;
            if (this.activationSource == ActivationSource.PUNCH && (state = this.punchLoops.get(loopHand = this.activationHand == null ? class_1268.field_5808 : this.activationHand)) != null) {
                state.requestStop(PunchLoopState.defaultTailTicks());
            }
        } else if (this.attackHoldTicks >= 6) {
            this.attackLoopArmed = true;
        }
        if (canStartAttack) {
            this.startPunch(client);
        } else if (!attackKeyDown && this.activationSource == ActivationSource.PUNCH) {
            this.attackLoopArmed = false;
        }
        this.wasAttacking = attackKeyDown;
        boolean useKeyDown = client.field_1690.field_1904.method_1434();
        if (!useKeyDown) {
            this.useClickConsumed = false;
        }
        this.wasUsing = useKeyDown;
        if (attackKeyDown) {
            this.updateMiningTarget(client);
        }
        if (this.pendingUseTrigger) {
            this.startUseAction(client, this.pendingUseHand, this.pendingUseInteractsWithBlock);
            this.pendingUseTrigger = false;
            this.pendingUseInteractsWithBlock = false;
        }
        if (this.transitionActive) {
            long now;
            boolean releasingHandActive;
            class_1268 transitionHandLocal = this.transitionHand;
            boolean bl = releasingHandActive = transitionHandLocal == this.consumeHand && this.consuming;
            if (!releasingHandActive && client.field_1724 != null && client.field_1687 != null && this.transitionStopGameTime > 0L && (now = client.field_1687.method_8510()) >= this.transitionStopGameTime) {
                this.handleTransitionStopped(this.transitionHand);
            }
        }
        if (this.activationSource == ActivationSource.USE && this.useAnimationTicks > 0) {
            --this.useAnimationTicks;
            if (this.useAnimationTicks <= 0) {
                this.handleUseCycleComplete(client);
            }
        }
        this.tickPunchLoops(client);
        this.handleSelectAnimation(client);
        this.handleConsume(client);
        this.handleSpyglassUse(client);
        this.handleWaterFall(client);
        this.handleSwimming(client);
        this.tickSwimStrafeBlend(client.field_1724);
        this.handleJumpAndLanding(client);
        this.handleWalk(client);
        this.handleRangedCharge(client);
        this.updateRangedReleaseStops(client.field_1724);
        this.handleShieldUse(client);
        this.tickInspect(client);
        this.handleInspect(client);
        this.ensureIdle(client);
    }

    private void onRenderFrame(class_310 client) {
        if (client == null) {
            return;
        }
        class_746 player = client.field_1724;
        this.updateIdleSprings(client);
        this.updateWalkSprings(client);
        if (player == null || client.field_1687 == null) {
            this.resetCameraLag();
            this.resetLanternPhysicsStates();
            this.resetJumpSpringStates();
            this.resetIdleSpringStates();
            this.resetWalkSpringStates();
            return;
        }
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            this.resetCameraLag();
            this.resetLanternPhysicsStates();
            this.resetJumpSpringStates();
            this.resetIdleSpringStates();
            this.resetWalkSpringStates();
            return;
        }
        float partial = client.method_1493() ? 0.0f : 1.0f;
        this.updateCameraLag(client, partial);
        this.updateLanternPhysics(client);
        this.updateJumpSprings(client);
        HandSwayPhysics.get().tick(client);
    }

    private void ensureHandsRaised(class_746 player) {
        if (this.offhandHoldActive) {
            this.stopOffhandHold(player);
        }
        this.loweredHands.clear();
    }

    private void startPunch(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        this.cancelSwimming(player);
        this.stopInspect(player);
        this.interruptSelectForMouseAction(player, null);
        this.stopTransition((class_1657)player);
        this.stopJump((class_1657)player);
        this.stopLanding((class_1657)player);
        class_1268 activeHand = this.findAttackHand(player);
        if (activeHand == null) {
            this.stopWalk((class_1657)player);
            this.stopFallingAnimations((class_1657)player);
            return;
        }
        this.stopWalkForHands((class_1657)player, EnumSet.of(activeHand));
        this.activationHand = activeHand;
        this.triggerPunchCycle(player, activeHand);
    }

    private void triggerPunchCycle(class_746 player, class_1268 hand) {
        String clip;
        if (player == null || hand == null) {
            return;
        }
        this.stopFallingAnimation((class_1657)player, hand);
        AnimatedTool.markNextActionHand(hand);
        AnimatedTool.markNextActionFromUse(false);
        class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, hand);
        class_1799 clipStack = this.stackForAttackResolution(held, hand);
        AttackTarget target = this.consumePendingAttackTarget();
        if (target == null) {
            target = PunchyClient.detectAttackTarget(player);
        }
        boolean entityTarget = target.entity();
        boolean blockTarget = target.block();
        String previousClip = this.lastActivationClip.get(hand);
        boolean loopClip = false;
        if (!entityTarget && blockTarget) {
            clip = PunchyClient.randomizeLoopClip(PunchyClient.resolveBlockLoopClip(clipStack), previousClip);
            loopClip = true;
        } else {
            clip = PunchyClient.resolveAttackClip(clipStack, true, previousClip);
        }
        if (clip == null || clip.isEmpty()) {
            if (!entityTarget && blockTarget) {
                clip = PunchyClient.randomizeLoopClip(PunchyClient.resolveBlockLoopClip(clipStack), previousClip);
                loopClip = true;
            } else {
                clip = PunchyClient.resolveAttackClip(clipStack, true, previousClip);
            }
        }
        BoneAnimationController.triggerActivation((class_1657)player, hand, clip);
        HandSwayPhysics.get().trigger(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808);
        this.lastActivationClip.put(hand, clip);
        this.activationSource = ActivationSource.PUNCH;
        this.activationTargetIsEntity = entityTarget;
        int durationTicks = Math.max(1, (int)Math.round(this.clipDurationSeconds((class_1657)player, hand, clip) * 20.0));
        if (loopClip) {
            this.punchLoops.put(hand, new PunchLoopState(durationTicks));
        } else {
            this.punchLoops.remove(hand);
        }
    }

    private void stopPunch(class_310 client) {
        if (this.activationSource != ActivationSource.PUNCH) {
            return;
        }
        class_746 player = client.field_1724;
        class_1268 cleanupHand = class_1268.field_5808;
        if (player != null) {
            class_1268 activeHand = this.findAttackHand(player);
            class_1268 handToUse = activeHand == null ? class_1268.field_5808 : activeHand;
            class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, handToUse);
            class_1799 clipStack = this.stackForAttackResolution(held, handToUse);
            boolean shouldTransition = ProxyItemHelper.requiresProxy(held);
            String clip = this.lastActivationClip.get(handToUse);
            if (clip == null || clip.isEmpty()) {
                AttackTarget target = PunchyClient.detectAttackTarget(player);
                boolean entityTarget = target.entity();
                boolean blockTarget = target.block();
                clip = blockTarget ? PunchyClient.randomizeLoopClip(PunchyClient.resolveBlockLoopClip(clipStack), null) : PunchyClient.resolveAttackClip(clipStack, entityTarget, null);
            }
            boolean playedTransition = false;
            boolean queuedIdleTransition = this.queueIdleTransitionAfterClip(handToUse, CONTROLLER_ACTIVATION, clip);
            if (!queuedIdleTransition && shouldTransition) {
                playedTransition = this.playReleaseTransition(player, handToUse);
            }
            if (!playedTransition) {
                AnimatedTool.markNextActivationSpeed(5.0);
                this.stopTransition((class_1657)player);
                this.stopActivationLoop((class_1657)player, handToUse, clip, false);
            }
            cleanupHand = handToUse;
            this.finalizePunch((class_1657)player, cleanupHand);
        } else {
            this.finalizePunch(null, cleanupHand);
        }
    }

    private void finalizePunch(class_1657 player, class_1268 cleanupHand) {
        class_746 lp;
        class_746 localPlayer;
        this.activationSource = ActivationSource.NONE;
        this.activationHand = class_1268.field_5808;
        class_1268 safeHand = cleanupHand == null ? class_1268.field_5808 : cleanupHand;
        this.lastActivationClip.remove(safeHand);
        this.punchLoops.remove(safeHand);
        this.activationTargetIsEntity = false;
        AnimatedTool.resetActivationSpeed();
        class_746 class_7462 = localPlayer = player instanceof class_746 ? (lp = (class_746)player) : class_310.method_1551().field_1724;
        if (!this.transitionActive && localPlayer != null && !this.hasIdleTransitionInFlight(safeHand)) {
            ToolAnimationOverrides.clear(safeHand);
            this.ensureIdleAfterAction(localPlayer, safeHand);
        }
        this.resumeWalkOnWaterForHands(localPlayer, EnumSet.of(safeHand));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateMiningTarget(class_310 client) {
        class_239 target = client.field_1765;
        if (target instanceof class_3965) {
            class_3965 blockHit = (class_3965)target;
            if (target.method_17783() == class_239.class_240.field_1332) {
                lastMiningTargetPos = blockHit.method_17777();
                return;
            }
        }
        lastMiningTargetPos = null;
    }

    private void resetState(class_310 client) {
        this.finalizeFlintAndSteelCleanup(true);
        this.wasAttacking = false;
        this.stopPunch(client);
        this.stopJump((class_1657)(client != null ? client.field_1724 : null));
        this.stopLanding((class_1657)(client != null ? client.field_1724 : null));
        this.stopWalk((class_1657)(client != null ? client.field_1724 : null));
        this.stopTransition((class_1657)(client != null ? client.field_1724 : null));
        this.stopUseAction(client);
        this.stopInspect(client != null ? client.field_1724 : null);
        this.stopConsume((class_1657)(client != null ? client.field_1724 : null));
        this.punchLoops.clear();
        this.stopRangedCharge((class_1657)(client != null ? client.field_1724 : null));
        this.stopSpyglassUse((class_1657)(client != null ? client.field_1724 : null));
        this.stopShieldUse((class_1657)(client != null ? client.field_1724 : null));
        this.stopOffhandHold(client != null ? client.field_1724 : null);
        this.stopIdle((class_1657)(client != null ? client.field_1724 : null));
        this.loweredHands.clear();
        this.needsOffhandLowerBootstrap = true;
        this.pendingUseTrigger = false;
        this.pendingUseHand = class_1268.field_5808;
        this.pendingUseInteractsWithBlock = false;
        this.useAnimationHand = class_1268.field_5808;
        this.useAnimationTicks = 0;
        this.wasUsing = false;
        this.attackHoldTicks = 0;
        this.attackLoopArmed = false;
        this.useInteractsWithBlock = false;
        ToolAnimationOverrides.clearAll();
        ArmAnimationOverrides.clearAll();
        this.lanternPhysics.clear();
        this.lastLanternTickTime = System.nanoTime();
        this.idlePrimedThisSession = false;
        HandItemOverrides.clearAll();
        this.mainHandHiddenForSwap = false;
        this.crossbowHiddenStates.clear();
        this.releaseBowSpriteSuppression();
        this.selectSuppressionHands.clear();
        this.selectHands.clear();
        this.selectStopDeadlines.clear();
        this.activeSelectClips.clear();
        this.resetCameraLag();
        this.resetLanternPhysicsStates();
        this.resetJumpSpringStates();
        this.resetIdleSpringStates();
        this.resetWalkSpringStates();
        this.resetIdleTransitionState();
        this.rangedReleaseStopTimes.clear();
        this.rangedReleaseCleanup.clear();
        this.lastActivationClip.clear();
    }

    private void resetLanternPhysicsStates() {
        for (LanternPhysicsState lanternPhysicsState : this.lanternPhysics.values()) {
            if (lanternPhysicsState == null) continue;
            lanternPhysicsState.reset();
        }
        for (LanternGripState lanternGripState : this.lanternGrips.values()) {
            if (lanternGripState == null) continue;
            lanternGripState.reset();
        }
        this.lanternTimeRemainder = 0.0f;
    }

    private void updateWalkSprings(class_310 client) {
        if (client == null) {
            this.resetWalkSpringStates();
            return;
        }
        long now = System.nanoTime();
        float rawDt = Math.max(0.0f, (float)(now - this.lastWalkTickTime) / 1.0E9f);
        this.lastWalkTickTime = now;
        if (client.method_1493()) {
            rawDt = 0.0f;
        }
        this.walkTimeRemainder = class_3532.method_15363((float)(this.walkTimeRemainder + rawDt), (float)0.0f, (float)0.5f);
        float targetStep = 0.016666668f;
        class_1268[] hands = class_1268.values();
        int guard = 0;
        while (this.walkTimeRemainder >= 0.016666668f && guard < 8) {
            this.walkTimeRemainder -= 0.016666668f;
            ++guard;
            for (class_1268 hand : hands) {
                WalkSpringState state = this.walkSpringState(hand);
                if (state == null) continue;
                boolean active = this.walkActive && this.walkingHands.contains(hand);
                double speed = active ? this.walkSpeedByHand.getOrDefault(hand, this.walkSpeedMultiplier) : this.walkSpeedMultiplier;
                state.tick(active, speed, 0.016666668f);
            }
        }
    }

    private void resetJumpSpringStates() {
        for (JumpSpringState jumpSpringState : this.jumpSprings.values()) {
            if (jumpSpringState == null) continue;
            jumpSpringState.reset();
        }
        for (SneakSpringState sneakSpringState : this.sneakSprings.values()) {
            if (sneakSpringState == null) continue;
            sneakSpringState.reset();
        }
        this.springTimeRemainder = 0.0f;
        this.lastLoggedJumpSpringPoses.clear();
        this.lastJumpSpringLogTick = Long.MIN_VALUE;
    }

    private void resetIdleSpringStates() {
        for (IdleSpringState state : this.idleSprings.values()) {
            if (state == null) continue;
            state.reset();
        }
        this.idleTimeRemainder = 0.0f;
    }

    private void resetWalkSpringStates() {
        for (WalkSpringState state : this.walkSprings.values()) {
            if (state == null) continue;
            state.reset();
        }
        this.walkTimeRemainder = 0.0f;
    }

    private class_1268 resolveVisualHand(class_746 player, class_1268 hand) {
        if (player.method_6068() == class_1306.field_6183) {
            return hand;
        }
        return hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
    }

    private class_1268 visualLockedUseHand(class_746 player) {
        if (this.lockedUseHand == null) {
            return null;
        }
        if (player == null) {
            return this.lockedUseHand;
        }
        return this.resolveVisualHand(player, this.lockedUseHand);
    }

    private void startUseAction(class_310 client, class_1268 hand, boolean interactsWithBlockHint) {
        boolean airClickEmptyMain;
        boolean specialEntityInsert;
        boolean interactingWithBlock;
        class_3965 blockHit;
        class_1268 rawHand;
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        this.cancelSwimming(player);
        this.stopInspect(player);
        class_1268 class_12682 = rawHand = hand == null ? PunchyClient.findProxyHand(player) : hand;
        if (rawHand == null) {
            return;
        }
        class_1268 targetHand = this.resolveVisualHand(player, rawHand);
        class_1268 lockedVisualHand = this.visualLockedUseHand(player);
        this.interruptSelectForMouseAction(player, targetHand);
        if (lockedVisualHand != null && targetHand != lockedVisualHand) {
            return;
        }
        class_1799 stack = HandHelper.getConfiguredHandItem((class_1657)player, targetHand);
        if (!ProxyItemHelper.requiresProxy(stack)) {
            return;
        }
        if (PunchyClient.isShield(stack)) {
            return;
        }
        if (stack.method_7909() instanceof class_1835) {
            return;
        }
        if (stack.method_7909() instanceof class_1753 || stack.method_7909() instanceof class_1764) {
            return;
        }
        boolean hasEntityTarget = client.field_1692 != null;
        boolean entityTarget = hasEntityTarget || client.field_1765 instanceof class_3966;
        class_239 class_2392 = client.field_1765;
        boolean blockTarget = class_2392 instanceof class_3965 && (blockHit = (class_3965)class_2392).method_17783() == class_239.class_240.field_1332 && client.field_1687 != null && !client.field_1687.method_8320(blockHit.method_17777()).method_26215();
        boolean bl = interactingWithBlock = interactsWithBlockHint || !entityTarget && blockTarget;
        if (PunchyClient.isConsumable(stack) && !interactingWithBlock) {
            return;
        }
        boolean bl2 = specialEntityInsert = entityTarget && targetHand == class_1268.field_5808 && PunchyClient.isEmptyHand(stack);
        if (specialEntityInsert) {
            interactingWithBlock = true;
        }
        boolean bl3 = airClickEmptyMain = targetHand == class_1268.field_5808 && PunchyClient.isEmptyHand(stack) && (client.field_1765 == null || client.field_1765.method_17783() == class_239.class_240.field_1333);
        if (airClickEmptyMain && !specialEntityInsert) {
            this.useClickConsumed = true;
            return;
        }
        if (interactingWithBlock && PunchyClient.isThrowableItem(stack)) {
            interactingWithBlock = false;
        }
        if (this.activationSource == ActivationSource.USE && this.useAnimationHand == targetHand && "insert".equals(this.useAnimationClip)) {
            this.stopActivationLoop((class_1657)player, targetHand, "insert", false);
            ToolAnimationOverrides.clear(targetHand);
            this.activationSource = ActivationSource.NONE;
            this.useAnimationTicks = 0;
            this.useAnimationClip = "";
            this.useInteractsWithBlock = interactingWithBlock;
        } else {
            this.useInteractsWithBlock = interactingWithBlock;
        }
        this.useTargetWasEntity = specialEntityInsert;
        this.stopWalkForHands((class_1657)player, EnumSet.of(targetHand));
        AnimatedTool.markNextActionHand(targetHand);
        AnimatedTool.markNextActionFromUse(true);
        this.triggerUseClip(player, targetHand, stack, interactingWithBlock);
        this.stopIdleForHand((class_1657)player, targetHand);
    }

    private void triggerUseClip(class_746 player, class_1268 hand, class_1799 sourceStack, boolean interactingWithBlock) {
        String clip;
        if (player == null || hand == null) {
            return;
        }
        class_1268 lockedVisualHand = this.visualLockedUseHand(player);
        if (lockedVisualHand != null && hand != lockedVisualHand) {
            return;
        }
        class_1799 clipStack = this.stackForClipResolution(sourceStack, hand);
        if (PunchyClient.isThrowableItem(clipStack)) {
            interactingWithBlock = false;
        }
        if ((clip = PunchyClient.randomizeLoopClip(PunchyClient.resolveRightClickClip(clipStack, interactingWithBlock))) == null || clip.isEmpty()) {
            clip = PunchyClient.resolveRightClickClip(clipStack, interactingWithBlock);
        }
        if (PunchyClient.isBucketClip(clip)) {
            this.suppressNextSelect(hand);
        }
        BoneAnimationController.triggerActivation((class_1657)player, hand, clip);
        HandSwayPhysics.get().trigger(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808);
        this.maybeTriggerFlintAndSteelDualAnimation(player, hand, clip);
        this.activationSource = ActivationSource.USE;
        this.useAnimationTicks = this.resolveUseAnimationTicks(player, hand, clip);
        this.useAnimationHand = hand;
        this.useAnimationClip = clip;
        this.usebrushHolding = "usebrush".equals(clip);
    }

    private void maybeTriggerFlintAndSteelDualAnimation(class_746 player, class_1268 hand, String clip) {
        class_1268 other;
        if (player == null || hand == null || !FLINT_STEEL_CLIP.equals(clip)) {
            return;
        }
        this.ensureHandsRaised(player);
        class_1268 class_12682 = other = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        if (!this.flintAndSteelDualActive || this.flintAndSteelProxyHand != other) {
            this.beginFlintAndSteelProxy(other);
        }
        AnimatedTool.markNextActionHand(other);
        AnimatedTool.markNextActionFromUse(true);
        this.stopIdleForHand((class_1657)player, other);
        BoneAnimationController.triggerActivation((class_1657)player, other, FLINT_STEEL_CLIP);
    }

    private void beginFlintAndSteelProxy(class_1268 other) {
        if (other == null) {
            return;
        }
        this.flintAndSteelProxyHand = other;
        class_1799 previous = HandItemOverrides.getOverride(other);
        this.flintAndSteelSavedOverride = previous == null ? class_1799.field_8037 : previous.method_7972();
        this.flintAndSteelSavedHidden = HandItemOverrides.isHidden(other);
        HandItemOverrides.setHidden(other, false);
        HandItemOverrides.setOverride(other, FLINT_AND_STEEL_PROXY_STACK);
        this.flintAndSteelDualActive = true;
        this.flintAndSteelCleanupPending = false;
        ArmAnimationOverrides.setForceRender(other, true);
    }

    private void maintainFlintAndSteelVisibility() {
        if (this.flintAndSteelDualActive && this.flintAndSteelProxyHand != null) {
            ArmAnimationOverrides.setForceRender(this.flintAndSteelProxyHand, true);
        }
    }

    private void requestFlintAndSteelCleanup(class_1657 player) {
        if (!this.flintAndSteelDualActive || this.flintAndSteelProxyHand == null || this.flintAndSteelCleanupPending) {
            return;
        }
        class_1268 other = this.flintAndSteelProxyHand;
        if (player != null) {
            this.stopActivationLoop(player, other, FLINT_STEEL_CLIP, false);
            ToolAnimationOverrides.clear(other);
        }
        this.flintAndSteelCleanupPending = true;
    }

    private void finalizeFlintAndSteelCleanup(boolean force) {
        if (!this.flintAndSteelDualActive || this.flintAndSteelProxyHand == null) {
            this.flintAndSteelCleanupPending = false;
            return;
        }
        if (!force && !this.flintAndSteelCleanupPending) {
            return;
        }
        class_1268 other = this.flintAndSteelProxyHand;
        HandItemOverrides.setOverride(other, this.flintAndSteelSavedOverride);
        HandItemOverrides.setHidden(other, this.flintAndSteelSavedHidden);
        ArmAnimationOverrides.clear(other);
        this.flintAndSteelDualActive = false;
        this.flintAndSteelProxyHand = null;
        this.flintAndSteelSavedOverride = class_1799.field_8037;
        this.flintAndSteelSavedHidden = false;
        this.flintAndSteelCleanupPending = false;
    }

    private void stopUseAction(class_310 client) {
        if (this.activationSource != ActivationSource.USE) {
            return;
        }
        class_746 player = client.field_1724;
        if (player != null) {
            class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, this.useAnimationHand);
            String clip = this.useAnimationClip == null || this.useAnimationClip.isEmpty() ? PunchyClient.resolveRightClickClip(held, this.useInteractsWithBlock) : this.useAnimationClip;
            boolean playedTransition = false;
            boolean queuedIdleTransition = this.queueIdleTransitionAfterClip(this.useAnimationHand, CONTROLLER_ACTIVATION, clip);
            if (!queuedIdleTransition && "insert".equals(clip)) {
                playedTransition = this.playReleaseTransition(player, this.useAnimationHand);
            }
            if (!playedTransition) {
                AnimatedTool.markNextActivationSpeed(2.0);
                this.stopActivationLoop((class_1657)player, this.useAnimationHand, clip, false);
            }
        }
        ToolAnimationOverrides.clear(this.useAnimationHand);
        this.requestFlintAndSteelCleanup((class_1657)player);
        this.finalizeFlintAndSteelCleanup(true);
        this.lockedUseHand = null;
        this.lockedUseStack = class_1799.field_8037;
        this.activationSource = ActivationSource.NONE;
        this.useAnimationTicks = 0;
        this.useAnimationHand = class_1268.field_5808;
        this.useAnimationClip = "";
        this.useInteractsWithBlock = false;
        this.usebrushHolding = false;
        this.useTargetWasEntity = false;
        AnimatedTool.resetActivationSpeed();
    }

    private void handleUseCycleComplete(class_310 client) {
        boolean interactingWithBlock;
        class_3965 blockHit;
        class_746 player;
        if (this.activationSource != ActivationSource.USE) {
            return;
        }
        class_746 class_7462 = player = client == null ? null : client.field_1724;
        if (player == null) {
            this.stopUseAction(client);
            return;
        }
        boolean hasEntityTarget = client.field_1692 != null;
        boolean entityTarget = hasEntityTarget || client.field_1765 instanceof class_3966;
        class_239 class_2392 = client.field_1765;
        boolean blockTarget = class_2392 instanceof class_3965 && (blockHit = (class_3965)class_2392).method_17783() == class_239.class_240.field_1332 && client.field_1687 != null && !client.field_1687.method_8320(blockHit.method_17777()).method_26215();
        boolean bl = interactingWithBlock = !entityTarget && blockTarget || this.useInteractsWithBlock;
        if (this.usebrushHolding) {
            this.useInteractsWithBlock = interactingWithBlock;
            return;
        }
        if (this.useClickConsumed) {
            this.useInteractsWithBlock = interactingWithBlock;
            return;
        }
        this.useClickConsumed = true;
        this.useInteractsWithBlock = interactingWithBlock;
        if (this.useTargetWasEntity) {
            this.useTargetWasEntity = false;
            this.stopUseAction(client);
            return;
        }
    }

    private void tickPunchLoops(class_310 client) {
        boolean canLoop;
        class_239 target;
        if (this.activationSource != ActivationSource.PUNCH) {
            this.punchLoops.clear();
            return;
        }
        class_1268 hand = this.activationHand == null ? class_1268.field_5808 : this.activationHand;
        PunchLoopState state = this.punchLoops.get(hand);
        if (state == null) {
            return;
        }
        class_746 player = client == null ? null : client.field_1724;
        boolean stillHolding = client != null && client.field_1690.field_1886.method_1434();
        String clip = this.lastActivationClip.get(hand);
        boolean hasBlockTarget = false;
        if (client != null && (target = client.field_1765) instanceof class_3965) {
            class_3965 blockHit = (class_3965)target;
            if (target.method_17783() == class_239.class_240.field_1332 && client.field_1687 != null) {
                hasBlockTarget = !client.field_1687.method_8320(blockHit.method_17777()).method_26215();
            }
        }
        boolean bl = canLoop = stillHolding && !state.stopRequested() && this.attackLoopArmed && player != null && ProxyItemHelper.requiresProxy(HandHelper.getConfiguredHandItem((class_1657)player, hand)) && hasBlockTarget && PunchyClient.isMiningLoopClip(clip);
        if (state.tick(canLoop)) {
            if (state.justLooped()) {
                HandSwayPhysics.get().trigger(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808);
            }
        } else {
            this.punchLoops.remove(hand);
            if (player != null) {
                if (clip == null || clip.isEmpty()) {
                    clip = "attack";
                }
                AnimatedTool.markNextActivationSpeed(2.0);
                this.stopActivationLoop((class_1657)player, hand, clip, true);
            } else {
                this.finalizePunch(null, hand);
            }
        }
    }

    private void cancelPunchLoopForHand(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        PunchLoopState state = this.punchLoops.remove(resolved);
        if (state != null) {
            state.requestStop(0);
        }
    }

    private void stopLoopedAnimation(class_1657 player, String controller, String clip, class_1268 hand) {
        this.requestStopForClip(player, hand, controller, clip);
        this.cancelPunchLoopForHand(hand);
    }

    private void stopActivationLoop(class_1657 player, class_1268 hand, String clip, boolean finalize) {
        this.stopLoopedAnimation(player, CONTROLLER_ACTIVATION, clip, hand);
        if (finalize && this.activationSource == ActivationSource.PUNCH) {
            this.finalizePunch(player, hand);
        }
    }

    private static boolean isMiningLoopClip(String clip) {
        String normalized = PunchyClient.normalizeClipKey(clip);
        if (normalized == null || normalized.isEmpty()) {
            return false;
        }
        return switch (normalized) {
            case "sway_forward", "sway_forward_2", "sway_forward_3", "sway_sideways", "sway_sideways_2", "sway_sideways_3", "sway_digging", "punch", PUNCH_TRIGGER -> true;
            default -> normalized.startsWith("walk_") || normalized.startsWith("mine");
        };
    }

    private void resetFallCharge(class_1657 player) {
        if (player != null) {
            this.stopFallingAnimation(player, class_1268.field_5808);
            this.stopFallingAnimation(player, class_1268.field_5810);
        }
        this.fallChargeActive = false;
        this.fallChargeStartY = Double.NaN;
        this.fallChargeTracking = false;
    }

    private void handleRangedCharge(class_310 client) {
        class_1268 arrowHand;
        class_1799 useStack;
        RangedChargeKind kind;
        boolean holdSuppressed;
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopRangedCharge(null);
            return;
        }
        boolean vanillaUsing = player.method_6115();
        boolean bl = holdSuppressed = UseAnimationSuppressor.isSuppressed() && this.rangedChargeActive;
        if (!vanillaUsing && !holdSuppressed) {
            this.stopRangedCharge((class_1657)player);
            return;
        }
        if (holdSuppressed) {
            this.clampBowUseTicks(player);
        }
        if ((kind = RangedChargeKind.fromStack(useStack = player.method_6030())) == null) {
            this.stopRangedCharge((class_1657)player);
            return;
        }
        class_1268 usedHand = this.resolveVisualHand(player, player.method_6058());
        if (usedHand == null && this.rangedChargeActive) {
            usedHand = this.rangedChargeWeaponHand;
        }
        if (usedHand == null || !ProxyItemHelper.requiresProxy(HandHelper.getConfiguredHandItem((class_1657)player, usedHand))) {
            this.stopRangedCharge((class_1657)player);
            return;
        }
        class_1268 class_12682 = kind.usesArrowHand() ? (usedHand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808) : (arrowHand = null);
        if (!this.rangedChargeActive || this.rangedChargeWeaponHand != usedHand || this.rangedChargeArrowHand != arrowHand || this.rangedChargeKind != kind) {
            this.startRangedCharge(player, kind, usedHand, arrowHand);
        }
    }

    private void startRangedCharge(class_746 player, RangedChargeKind kind, class_1268 weaponHand, class_1268 arrowHand) {
        this.ensureHandsRaised(player);
        this.stopRangedCharge((class_1657)player);
        EnumSet<class_1268> walkHandsToStop = EnumSet.noneOf(class_1268.class);
        walkHandsToStop.add(weaponHand);
        if (arrowHand != null) {
            walkHandsToStop.add(arrowHand);
        }
        this.stopWalkForHands((class_1657)player, walkHandsToStop);
        if (kind.suppressSprite()) {
            this.suppressBowSprite(weaponHand, true);
        }
        this.rangedReleaseStopTimes.remove(weaponHand);
        AnimatedTool.markNextActionHand(weaponHand);
        BoneAnimationController.trigger((class_1657)player, weaponHand, kind.controller(), kind.weaponClip());
        if (kind.usesArrowHand() && arrowHand != null && !kind.arrowClip().isEmpty()) {
            AnimatedTool.markNextActionHand(arrowHand);
            this.rangedReleaseStopTimes.remove(arrowHand);
            BoneAnimationController.trigger((class_1657)player, arrowHand, kind.controller(), kind.arrowClip());
            ArmAnimationOverrides.setForceRender(arrowHand, true);
        } else {
            arrowHand = null;
        }
        this.rangedChargeActive = true;
        this.rangedChargeKind = kind;
        this.rangedChargeWeaponHand = weaponHand;
        this.rangedChargeArrowHand = arrowHand;
        this.stopIdleForHand((class_1657)player, weaponHand);
        if (arrowHand != null) {
            this.stopIdleForHand((class_1657)player, arrowHand);
        }
    }

    private void stopRangedCharge(class_1657 player) {
        if (!this.rangedChargeActive) {
            return;
        }
        if (player != null) {
            if (!this.rangedChargeKind.releaseClip().isEmpty()) {
                this.playRangedReleaseClip(player, this.rangedChargeWeaponHand, this.rangedChargeKind);
                this.queueRangedReleaseCleanup(this.rangedChargeWeaponHand, this.rangedChargeArrowHand, this.rangedChargeKind);
            } else {
                this.queueIdleTransitionAfterClip(this.rangedChargeWeaponHand, this.rangedChargeKind.controller(), this.rangedChargeKind.weaponClip());
                BoneAnimationController.stop(player, this.rangedChargeWeaponHand, this.rangedChargeKind.controller(), this.rangedChargeKind.weaponClip());
                this.finalizeRangedReleaseCleanup(player, this.rangedChargeWeaponHand, this.rangedChargeArrowHand, this.rangedChargeKind.suppressSprite());
            }
            if (this.rangedChargeKind.usesArrowHand() && this.rangedChargeArrowHand != null && !this.rangedChargeKind.arrowClip().isEmpty()) {
                this.queueIdleTransitionAfterClip(this.rangedChargeArrowHand, this.rangedChargeKind.controller(), this.rangedChargeKind.arrowClip());
                BoneAnimationController.stop(player, this.rangedChargeArrowHand, this.rangedChargeKind.controller(), this.rangedChargeKind.arrowClip());
            }
        }
        if (this.rangedChargeKind.releaseClip().isEmpty()) {
            ArmAnimationOverrides.clear(this.rangedChargeWeaponHand);
            if (this.rangedChargeArrowHand != null) {
                ArmAnimationOverrides.clear(this.rangedChargeArrowHand);
                HandItemOverrides.clear(this.rangedChargeArrowHand);
                HandItemOverrides.setHidden(this.rangedChargeArrowHand, false);
            }
            ToolAnimationOverrides.clear(this.rangedChargeWeaponHand);
            if (this.rangedChargeArrowHand != null) {
                ToolAnimationOverrides.clear(this.rangedChargeArrowHand);
            }
            if (this.rangedChargeKind.suppressSprite()) {
                this.releaseBowSpriteSuppression();
            }
        }
        this.restoreAllCrossbowVisibility();
        this.rangedChargeActive = false;
        this.rangedChargeWeaponHand = class_1268.field_5808;
        this.rangedChargeArrowHand = null;
        this.rangedChargeKind = RangedChargeKind.BOW;
    }

    private void playRangedReleaseClip(class_1657 player, class_1268 hand, RangedChargeKind kind) {
        if (player == null || hand == null || kind == null || kind.releaseClip().isEmpty()) {
            return;
        }
        AnimatedTool.markNextActionHand(hand);
        BoneAnimationController.trigger(player, hand, kind.controller(), kind.releaseClip());
        double seconds = this.clipDurationSeconds(player, hand, kind.releaseClip());
        this.scheduleRangedReleaseStop(player, hand, seconds);
    }

    private void handleSpyglassUse(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopSpyglassUse(null);
            return;
        }
        if (!player.method_6115()) {
            this.stopSpyglassUse((class_1657)player);
            return;
        }
        class_1799 useStack = player.method_6030();
        if (useStack == null || !(useStack.method_7909() instanceof class_5538)) {
            this.stopSpyglassUse((class_1657)player);
            return;
        }
        class_1268 usedHand = this.resolveVisualHand(player, player.method_6058());
        if (usedHand == null) {
            if (!this.spyglassActive) {
                this.stopSpyglassUse((class_1657)player);
                return;
            }
            usedHand = this.spyglassHand;
        }
        if (!ProxyItemHelper.requiresProxy(HandHelper.getConfiguredHandItem((class_1657)player, usedHand))) {
            if (!this.spyglassActive) {
                this.stopSpyglassUse((class_1657)player);
                return;
            }
            usedHand = this.spyglassHand;
        }
        if (!this.spyglassActive || this.spyglassHand != usedHand) {
            this.startSpyglassUse(player, usedHand);
        }
    }

    private void startSpyglassUse(class_746 player, class_1268 hand) {
        this.ensureHandsRaised(player);
        this.stopSpyglassUse((class_1657)player);
        AnimatedTool.markNextActionHand(hand);
        BoneAnimationController.trigger((class_1657)player, hand, "Spyglass", "use_spyglass");
        this.suppressBowSprite(hand, false);
        this.spyglassActive = true;
        this.spyglassHand = hand;
        this.spyglassZoomAllowed = false;
        this.stopIdleForHand((class_1657)player, hand);
    }

    private void stopSpyglassUse(class_1657 player) {
        if (!this.spyglassActive) {
            return;
        }
        if (player != null) {
            BoneAnimationController.stop(player, this.spyglassHand, "Spyglass", "use_spyglass");
        }
        this.releaseBowSpriteSuppression();
        this.spyglassActive = false;
        this.spyglassZoomAllowed = false;
        this.spyglassHand = class_1268.field_5808;
    }

    private void handleWaterFall(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopWaterFall(null);
            return;
        }
        if (this.fallToWaterActive && (PunchyClient.isSupportedBySolid((class_1657)player) || player.method_5799() || player.method_18798().field_1351 > -0.05)) {
            this.stopWaterFall((class_1657)player);
            return;
        }
        if (this.fallToWaterActive) {
            return;
        }
        if (PunchyClient.isSupportedBySolid((class_1657)player) || player.method_5799()) {
            return;
        }
        if (player.method_18798().field_1351 > (double)-0.35f) {
            return;
        }
        class_3965 impact = this.clipWaterBelow(player, 64.0);
        if (impact == null) {
            return;
        }
        double drop = player.method_23318() - impact.method_17784().field_1351;
        if (drop < 7.0) {
            return;
        }
        class_1268 hand = this.findAttackHand(player);
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        this.startWaterFall(player, hand);
    }

    private void startWaterFall(class_746 player, class_1268 preferredHand) {
        this.stopWaterFall((class_1657)player);
        this.ensureHandsRaised(player);
        this.fallToWaterHands.clear();
        for (class_1268 hand : class_1268.values()) {
            AnimatedTool.markNextActionHand(hand);
            BoneAnimationController.trigger((class_1657)player, hand, "FallingWater", "falling_in_water");
            BoneAnimationController.trigger((class_1657)player, hand, "FallingWaterLoop", "falling_in_water_loop");
            ArmAnimationOverrides.setForceRender(hand, true);
            this.fallToWaterHands.add(hand);
        }
        this.fallToWaterActive = true;
    }

    private void stopWaterFall(class_1657 player) {
        if (!this.fallToWaterActive) {
            return;
        }
        if (player != null) {
            for (class_1268 hand : this.fallToWaterHands) {
                BoneAnimationController.stop(player, hand, "FallingWater", "falling_in_water");
                BoneAnimationController.stop(player, hand, "FallingWaterLoop", "falling_in_water_loop");
                ArmAnimationOverrides.clear(hand);
            }
        }
        this.fallToWaterHands.clear();
        this.fallToWaterActive = false;
    }

    private void handleSwimming(class_310 client) {
        boolean inFluid;
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopSwimming(null);
            this.updateSwimStrafeState(false, false, null, client);
            return;
        }
        boolean forwardKey = client.field_1690.field_1894.method_1434();
        boolean backwardKey = client.field_1690.field_1881.method_1434();
        boolean submerged = player.method_5869() || player.method_5777(class_3486.field_15517);
        boolean bl = inFluid = player.method_5799() || submerged;
        if (this.isSwimmingActionBlocked()) {
            this.cancelSwimming(player);
            this.updateSwimStrafeState(inFluid, forwardKey, player, client);
            return;
        }
        this.updateSwimStrafeState(inFluid, forwardKey, player, client);
        if (!inFluid) {
            this.stopSwimming((class_1657)player);
            this.stopWalkOnWater(player);
            return;
        }
        if (!submerged) {
            this.stopSwimming((class_1657)player);
            this.startWalkOnWater(player);
            return;
        }
        double impulse = player.field_6250;
        double epsilon = 0.001;
        boolean forwardInput = impulse > 0.001 || forwardKey;
        boolean backwardInput = impulse < -0.001 || backwardKey;
        double desiredDirection = 0.0;
        if (forwardInput && !backwardInput) {
            desiredDirection = 1.0;
        } else if (backwardInput && !forwardInput) {
            desiredDirection = -1.0;
        } else if (forwardInput && backwardInput && (desiredDirection = Math.signum(impulse)) == 0.0) {
            double d = forwardKey ? 1.0 : (desiredDirection = backwardKey ? -1.0 : 0.0);
        }
        if (desiredDirection == 0.0) {
            this.updateSwimStrafeState(inFluid, false, player, client);
            this.ensureSwimmingCompletion(player);
            return;
        }
        if (!this.swimmingActive) {
            this.startSwimming(player, desiredDirection);
            return;
        }
        this.swimmingStopDeadline = -1L;
        if (Math.signum(this.swimmingDirection) != Math.signum(desiredDirection)) {
            this.startSwimming(player, desiredDirection);
        }
    }

    private void updateSwimStrafeState(boolean inFluid, boolean forwardHeld, class_746 player, class_310 client) {
        boolean triggerLeft;
        if (client == null || client.field_1690 == null) {
            this.swimRightKeyDown = false;
            this.swimLeftKeyDown = false;
            this.swimRightPending = false;
            this.swimLeftPending = false;
            this.swimForwardHeldLast = false;
            this.stopSwimStrafe((class_1657)player);
            return;
        }
        boolean forwardTransition = this.swimForwardHeldLast && !forwardHeld;
        this.swimForwardHeldLast = forwardHeld;
        boolean rightDown = client.field_1690.field_1849.method_1434();
        boolean leftDown = client.field_1690.field_1913.method_1434();
        if (!inFluid) {
            this.stopSwimStrafe((class_1657)player);
            this.swimRightKeyDown = false;
            this.swimLeftKeyDown = false;
            this.swimRightPending = false;
            this.swimLeftPending = false;
            this.swimForwardHeldLast = false;
            return;
        }
        if (forwardHeld) {
            if (rightDown) {
                this.swimRightPending = true;
            }
            if (leftDown) {
                this.swimLeftPending = true;
            }
            this.stopSwimStrafe((class_1657)player);
            this.swimRightKeyDown = rightDown;
            this.swimLeftKeyDown = leftDown;
            return;
        }
        boolean triggerRight = rightDown && (forwardTransition || !this.swimRightKeyDown || this.swimRightPending);
        boolean bl = triggerLeft = leftDown && (forwardTransition || !this.swimLeftKeyDown || this.swimLeftPending);
        if (triggerRight) {
            this.triggerSwimStrafe(player, "swiming_right");
            this.swimRightPending = false;
        }
        if (triggerLeft) {
            this.triggerSwimStrafe(player, "swiming_left");
            this.swimLeftPending = false;
        }
        this.swimRightKeyDown = rightDown;
        this.swimLeftKeyDown = leftDown;
        if (!rightDown) {
            this.swimRightPending = false;
        }
        if (!leftDown) {
            this.swimLeftPending = false;
        }
        if (!rightDown && !leftDown) {
            this.scheduleSwimStrafeStopWithBlend();
        }
    }

    private void triggerSwimStrafe(class_746 player, String clip) {
        if (player == null || clip == null || clip.isEmpty()) {
            return;
        }
        this.ensureHandsRaised(player);
        this.swimStrafeBlendTicks = 0;
        this.swimStrafeStopScheduled = false;
        EnumSet<class_1268> hands = PunchyClient.collectProxyHands((class_1657)player);
        if (hands.isEmpty()) {
            return;
        }
        this.cancelSwimming(player);
        this.stopTransition((class_1657)player);
        this.stopWalk((class_1657)player);
        for (class_1268 hand : hands) {
            AnimatedTool.markNextActionHand(hand);
            AnimatedTool.markNextActionFromUse(false);
            BoneAnimationController.trigger((class_1657)player, hand, "SwimStrafe", clip);
            ArmAnimationOverrides.setForceRender(hand, true);
            this.swimmingStrafeClips.put(hand, clip);
        }
    }

    private void stopSwimStrafe(class_1657 player) {
        if (this.swimmingStrafeClips.isEmpty()) {
            this.swimStrafeBlendTicks = 0;
            this.swimStrafeStopScheduled = false;
            return;
        }
        if (player != null) {
            for (Map.Entry<class_1268, String> entry : this.swimmingStrafeClips.entrySet()) {
                String clip = entry.getValue();
                if (clip == null || clip.isEmpty()) continue;
                BoneAnimationController.stop(player, entry.getKey(), "SwimStrafe", clip);
            }
        }
        this.swimmingStrafeClips.clear();
        this.swimStrafeBlendTicks = 0;
        this.swimStrafeStopScheduled = false;
    }

    private void scheduleSwimStrafeStopWithBlend() {
        if (this.swimmingStrafeClips.isEmpty() || this.swimStrafeStopScheduled) {
            return;
        }
        this.swimStrafeBlendTicks = 6;
        this.swimStrafeStopScheduled = true;
    }

    private void tickSwimStrafeBlend(class_746 player) {
        if (!this.swimStrafeStopScheduled || this.swimStrafeBlendTicks <= 0) {
            return;
        }
        --this.swimStrafeBlendTicks;
        if (this.swimStrafeBlendTicks == 0) {
            this.stopSwimStrafe((class_1657)player);
        }
    }

    private void cancelSwimming(class_746 player) {
        if (player == null) {
            return;
        }
        this.stopSwimStrafe((class_1657)player);
        this.stopSwimming((class_1657)player);
        this.stopWalkOnWater(player);
    }

    private void startSwimming(class_746 player, double direction) {
        this.stopSwimming((class_1657)player);
        this.swimmingHands.clear();
        if (this.walkOnWaterActive) {
            this.scheduleWalkOnWaterStopWithBlend();
        }
        this.ensureHandsRaised(player);
        for (class_1268 hand : class_1268.values()) {
            AnimatedTool.markNextActionHand(hand);
            AnimatedTool.markNextActivationSpeed(direction);
            AnimatedTool.markNextActionFromUse(false);
            BoneAnimationController.trigger((class_1657)player, hand, "Swimming", "swiming");
            ArmAnimationOverrides.setForceRender(hand, true);
            this.swimmingHands.add(hand);
        }
        AnimatedTool.resetActivationSpeed();
        this.swimmingDirection = direction;
        this.swimmingActive = true;
        this.swimmingStopDeadline = -1L;
    }

    private void startWalkOnWater(class_746 player) {
        if (this.walkOnWaterActive) {
            this.walkOnWaterStopScheduled = false;
            this.walkOnWaterBlendTicks = 0;
            this.resetWalkOnWaterPose();
            this.walkOnWaterExitGrace = 6;
            return;
        }
        this.walkOnWaterHands.clear();
        this.walkOnWaterPausedHands.clear();
        this.stopWalk((class_1657)player);
        this.stopIdle((class_1657)player);
        this.ensureHandsRaised(player);
        for (class_1268 hand : class_1268.values()) {
            this.stopWalkAnimation((class_1657)player, hand);
            this.stopIdleForHand((class_1657)player, hand);
            this.triggerWalkOnWaterForHand(player, hand);
        }
        this.walkOnWaterBlendTicks = 0;
        this.walkOnWaterStopScheduled = false;
        this.walkOnWaterExitGrace = 6;
        this.resetWalkOnWaterPose();
    }

    private void stopWalkOnWater(class_746 player) {
        if (!this.walkOnWaterActive && this.walkOnWaterHands.isEmpty()) {
            this.resetWalkOnWaterPose();
            return;
        }
        if (player != null) {
            for (class_1268 hand : this.walkOnWaterHands) {
                BoneAnimationController.stop((class_1657)player, hand, "WalkOnWater", "walk_on_water");
            }
        }
        this.walkOnWaterHands.clear();
        this.walkOnWaterActive = false;
        this.walkOnWaterBlendTicks = 0;
        this.walkOnWaterStopScheduled = false;
        this.walkOnWaterExitGrace = 0;
        this.walkOnWaterPausedHands.clear();
        this.resetWalkOnWaterPose();
    }

    private void triggerWalkOnWaterForHand(class_746 player, class_1268 hand) {
        if (player == null || hand == null) {
            return;
        }
        this.ensureHandsRaised(player);
        AnimatedTool.markNextActionHand(hand);
        AnimatedTool.markNextActionFromUse(false);
        BoneAnimationController.trigger((class_1657)player, hand, "WalkOnWater", "walk_on_water");
        ArmAnimationOverrides.setForceRender(hand, true);
        this.walkOnWaterHands.add(hand);
        this.walkOnWaterActive = true;
    }

    private void stopWalkOnWaterForHand(class_1657 player, class_1268 hand) {
        if (hand == null) {
            return;
        }
        if (player != null && this.walkOnWaterHands.contains(hand)) {
            BoneAnimationController.stop(player, hand, "WalkOnWater", "walk_on_water");
        }
        this.walkOnWaterHands.remove(hand);
        if (this.walkOnWaterHands.isEmpty()) {
            this.walkOnWaterActive = false;
        }
    }

    private void resetWalkOnWaterPose() {
        this.walkOnWaterAnimSpeed = 1.0;
    }

    private void scheduleWalkOnWaterStopWithBlend() {
        if (!this.walkOnWaterActive) {
            return;
        }
        if (this.walkOnWaterStopScheduled) {
            return;
        }
        this.walkOnWaterExitGrace = 6;
        this.walkOnWaterBlendTicks = Math.max(this.walkOnWaterBlendTicks, 8);
        this.walkOnWaterStopScheduled = true;
    }

    private void stopSwimming(class_1657 player) {
        if (!this.swimmingActive && this.swimmingHands.isEmpty()) {
            this.swimmingDirection = 1.0;
            this.swimmingStopDeadline = -1L;
            return;
        }
        if (player != null) {
            for (class_1268 hand : this.swimmingHands) {
                BoneAnimationController.stop(player, hand, "Swimming", "swiming");
                ArmAnimationOverrides.clear(hand);
            }
            class_310 client = class_310.method_1551();
            if (client != null) {
                this.ensureIdle(client);
            }
        }
        this.swimmingHands.clear();
        this.swimmingActive = false;
        this.swimmingDirection = 1.0;
        AnimatedTool.resetActivationSpeed();
        this.swimmingStopDeadline = -1L;
    }

    private void ensureSwimmingCompletion(class_746 player) {
        if (!this.swimmingActive) {
            return;
        }
        if (player == null || player.method_37908() == null) {
            this.stopSwimming((class_1657)player);
            return;
        }
        long gameTime = player.method_37908().method_8510();
        if (this.swimmingStopDeadline < 0L) {
            class_1268 sampleHand = this.swimmingHands.isEmpty() ? class_1268.field_5808 : (class_1268)this.swimmingHands.iterator().next();
            long ticks = this.swimmingDurationTicks((class_1657)player, sampleHand);
            this.swimmingStopDeadline = gameTime + ticks;
            return;
        }
        if (gameTime >= this.swimmingStopDeadline) {
            this.stopSwimming((class_1657)player);
        }
    }

    private void startJump(class_746 player) {
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            return;
        }
        if (this.jumpActive) {
            return;
        }
        EnumSet<class_1268> hands = PunchyClient.collectProxyHands((class_1657)player);
        if (hands.isEmpty()) {
            return;
        }
        this.stopTransition((class_1657)player);
        this.stopWalk((class_1657)player);
        this.jumpActive = true;
        this.wasOnGround = false;
        this.landingArmed = true;
        for (class_1268 hand : hands) {
            this.jumpSpringState(hand).impulse(-3.2f);
        }
    }

    private void stopJump(class_1657 player) {
        if (!this.jumpActive && this.jumpHands.isEmpty() && this.jumpStopTimes.isEmpty()) {
            this.jumpHoldHands.clear();
            this.jumpHoldProgress.clear();
            this.jumpClipDurations.clear();
            return;
        }
        if (player != null) {
            EnumSet<class_1268> handsToStop = EnumSet.noneOf(class_1268.class);
            handsToStop.addAll(this.jumpHands);
            handsToStop.addAll(this.jumpStopTimes.keySet());
            if (handsToStop.isEmpty()) {
                handsToStop.add(class_1268.field_5808);
                handsToStop.add(class_1268.field_5810);
            }
            for (class_1268 hand : handsToStop) {
                BoneAnimationController.stop(player, hand, "Jump", "jump");
                ArmAnimationOverrides.clear(hand);
            }
        }
        this.jumpHands.clear();
        this.jumpStopTimes.clear();
        this.jumpHoldHands.clear();
        this.jumpHoldProgress.clear();
        this.jumpClipDurations.clear();
        this.stopFallingAnimations(player);
        this.jumpActive = false;
    }

    private void stopLanding(class_1657 player) {
        if (this.landingStopTimes.isEmpty()) {
            return;
        }
        if (player != null) {
            for (class_1268 hand : this.landingStopTimes.keySet()) {
                BoneAnimationController.stop(player, hand, "Landing", "landing");
                ArmAnimationOverrides.clear(hand);
            }
        }
        this.landingStopTimes.clear();
    }

    private void finishJumpAfterGround(class_746 player) {
        if (player == null) {
            return;
        }
        EnumSet<class_1268> handsToResume = EnumSet.noneOf(class_1268.class);
        handsToResume.addAll(this.jumpHands);
        handsToResume.addAll(this.jumpHoldHands);
        this.stopFallingAnimations((class_1657)player);
        if (handsToResume.isEmpty()) {
            this.jumpActive = false;
            return;
        }
        for (class_1268 hand : handsToResume) {
            this.resumeJumpHold((class_1657)player, hand);
        }
        this.jumpActive = false;
    }

    private void resumeJumpHold(class_1657 player, class_1268 hand) {
        double remaining;
        if (player == null || hand == null) {
            return;
        }
        boolean wasHolding = this.jumpHoldHands.remove(hand);
        double clipSeconds = this.jumpClipDurations.getOrDefault(hand, this.clipDurationSeconds(player, hand, "jump"));
        if (clipSeconds <= 0.0) {
            clipSeconds = 0.75;
        }
        if (wasHolding) {
            double pausedAt = this.jumpHoldProgress.getOrDefault(hand, clipSeconds);
            remaining = Math.max(0.01, clipSeconds - pausedAt);
        } else {
            remaining = 0.1;
        }
        this.jumpHoldProgress.remove(hand);
        this.scheduleJumpStop(player, hand, remaining);
    }

    private void triggerLanding(class_1657 player) {
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            return;
        }
        if (player == null) {
            return;
        }
        EnumSet<class_1268> hands = PunchyClient.collectProxyHands(player);
        if (hands.isEmpty()) {
            return;
        }
        for (class_1268 hand : hands) {
            this.jumpSpringState(hand).impulse(4.0f);
        }
    }

    private void scheduleLandingStop(class_1657 player, class_1268 hand) {
        if (player == null || hand == null || player.method_37908() == null) {
            return;
        }
        long ticks = this.landingDurationTicks(player, hand);
        long stopTime = player.method_37908().method_8510() + ticks;
        this.landingStopTimes.put(hand, stopTime);
    }

    private void scheduleJumpStop(class_1657 player, class_1268 hand, double seconds) {
        if (player == null || hand == null || player.method_37908() == null) {
            return;
        }
        long gameTime = player.method_37908().method_8510();
        this.scheduleJumpStop(player, hand, seconds, gameTime);
    }

    private void scheduleJumpStop(class_1657 player, class_1268 hand, double seconds, long currentGameTime) {
        if (player == null || hand == null || player.method_37908() == null) {
            return;
        }
        if (seconds <= 0.0) {
            seconds = 0.1;
        }
        double speed = 1.3;
        long ticks = Math.max(1L, Math.round(seconds / Math.max(0.001, speed) * 20.0));
        long stopTime = currentGameTime + ticks;
        this.jumpStopTimes.put(hand, stopTime);
    }

    private void startFallingAnimation(class_746 player, class_1268 hand) {
        if (player == null || hand == null) {
            return;
        }
        this.ensureHandsRaised(player);
        class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, hand);
        if (held == null || held.method_7960() || !(held.method_7909() instanceof class_9362)) {
            return;
        }
        if (this.fallingHands.contains(hand)) {
            return;
        }
        this.stopWalkOnWater(player);
        AnimatedTool.markNextActionHand(hand);
        this.stopWalkAnimation((class_1657)player, hand);
        this.stopIdleForHand((class_1657)player, hand);
        AnimatedTool.markNextActivationSpeed(1.0);
        String clip = "attack_mace_charge";
        BoneAnimationController.trigger((class_1657)player, hand, "FallCharge", clip);
        ArmAnimationOverrides.setForceRender(hand, true);
        this.fallingHands.add(hand);
        this.fallingClips.put(hand, clip);
    }

    private void stopFallingAnimations(class_1657 player) {
        if (this.fallingHands.isEmpty()) {
            return;
        }
        EnumSet<class_1268> active = EnumSet.copyOf(this.fallingHands);
        for (class_1268 hand : active) {
            this.stopFallingAnimation(player, hand);
        }
        this.resetFallCharge(player);
    }

    private void stopFallingAnimation(class_1657 player, class_1268 hand) {
        if (hand == null) {
            return;
        }
        String clip = this.fallingClips.remove(hand);
        this.fallingHands.remove(hand);
        if (clip == null || clip.isEmpty() || player == null) {
            return;
        }
        BoneAnimationController.stop(player, hand, "FallCharge", clip);
        ArmAnimationOverrides.clear(hand);
        this.fallChargeActive = false;
        this.fallChargeStartY = Double.NaN;
        AnimatedTool.resetActivationSpeed();
    }

    private void scheduleRangedReleaseStop(class_1657 player, class_1268 hand, double seconds) {
        if (player == null || hand == null || player.method_37908() == null) {
            return;
        }
        if (seconds <= 0.0) {
            seconds = 0.25;
        }
        long ticks = Math.max(1L, Math.round(seconds * 20.0));
        long stopTime = player.method_37908().method_8510() + ticks;
        this.rangedReleaseStopTimes.put(hand, stopTime);
    }

    private void queueRangedReleaseCleanup(class_1268 weaponHand, class_1268 arrowHand, RangedChargeKind kind) {
        boolean clearArrow = kind.usesArrowHand() && arrowHand != null && !kind.arrowClip().isEmpty();
        String releaseClip = kind.releaseClip();
        String controller = kind.controller();
        this.rangedReleaseCleanup.put(weaponHand, new ReleaseCleanup(arrowHand, clearArrow, kind.suppressSprite(), controller, releaseClip));
    }

    private void finalizeQueuedRelease(class_746 player, class_1268 weaponHand) {
        ReleaseCleanup cleanup = this.rangedReleaseCleanup.remove(weaponHand);
        if (player != null && cleanup != null && cleanup.releaseClip() != null && !cleanup.releaseClip().isEmpty()) {
            this.queueIdleTransitionAfterClip(weaponHand, cleanup.controller(), cleanup.releaseClip());
            BoneAnimationController.stop((class_1657)player, weaponHand, cleanup.controller(), cleanup.releaseClip());
        }
        if (cleanup == null) {
            this.finalizeRangedReleaseCleanup((class_1657)player, weaponHand, null, false);
            this.ensureIdleAfterAction(player, weaponHand);
            return;
        }
        this.finalizeRangedReleaseCleanup((class_1657)player, weaponHand, cleanup.clearArrow() ? cleanup.arrowHand() : null, cleanup.releaseSprite());
        this.ensureIdleAfterAction(player, weaponHand);
    }

    private void finalizeRangedReleaseCleanup(class_1657 player, class_1268 weaponHand, class_1268 arrowHand, boolean releaseSprite) {
        ArmAnimationOverrides.clear(weaponHand);
        ToolAnimationOverrides.clear(weaponHand);
        if (arrowHand != null) {
            ToolAnimationOverrides.clear(arrowHand);
            this.restoreArrowHandState(arrowHand);
        }
        if (releaseSprite) {
            this.releaseBowSpriteSuppression();
        }
    }

    private void updateLandingStops(class_1657 player) {
        if (this.landingStopTimes.isEmpty() || player == null) {
            return;
        }
        long gameTime = player.method_37908() != null ? player.method_37908().method_8510() : 0L;
        Iterator<Map.Entry<class_1268, Long>> iterator = this.landingStopTimes.entrySet().iterator();
        boolean stoppedAny = false;
        while (iterator.hasNext()) {
            Map.Entry<class_1268, Long> entry = iterator.next();
            if (gameTime < entry.getValue()) continue;
            class_1268 hand = entry.getKey();
            BoneAnimationController.stop(player, hand, "Landing", "landing");
            ArmAnimationOverrides.clear(hand);
            iterator.remove();
            stoppedAny = true;
        }
        if (stoppedAny) {
            this.handleWalk(class_310.method_1551());
        }
    }

    private void updateJumpStops(class_1657 player) {
        if (this.jumpStopTimes.isEmpty() || player == null || player.method_37908() == null) {
            return;
        }
        long gameTime = player.method_37908().method_8510();
        Iterator<Map.Entry<class_1268, Long>> iterator = this.jumpStopTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_1268, Long> entry = iterator.next();
            if (gameTime < entry.getValue()) continue;
            class_1268 hand = entry.getKey();
            BoneAnimationController.stop(player, hand, "Jump", "jump");
            ArmAnimationOverrides.clear(hand);
            iterator.remove();
            this.jumpHands.remove(hand);
            this.jumpHoldHands.remove(hand);
            this.jumpHoldProgress.remove(hand);
            this.jumpClipDurations.remove(hand);
        }
        if (this.jumpStopTimes.isEmpty() && this.jumpHands.isEmpty()) {
            this.jumpActive = false;
        }
    }

    private void handleWalk(class_310 client) {
        double speed;
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopWalk(null);
            return;
        }
        boolean surface = this.isOnWaterSurface(player);
        if (surface) {
            if (!this.walkOnWaterActive && this.walkOnWaterPausedHands.isEmpty() && !this.walkOnWaterStopScheduled) {
                this.stopWalkOnWater(player);
                this.startWalkOnWater(player);
            }
            this.walkOnWaterExitGrace = 6;
            return;
        }
        if (!this.walkOnWaterPausedHands.isEmpty()) {
            return;
        }
        if (this.walkOnWaterActive) {
            if (this.walkOnWaterExitGrace > 0) {
                --this.walkOnWaterExitGrace;
                return;
            }
            if (this.walkOnWaterStopScheduled) {
                return;
            }
            this.stopWalkOnWater(player);
        }
        if (this.jumpActive || this.swimmingActive || this.fallToWaterActive) {
            this.stopWalk((class_1657)player);
            return;
        }
        EnumSet<class_1268> proxyHands = PunchyClient.collectProxyHands((class_1657)player);
        if (proxyHands.isEmpty()) {
            this.stopWalk((class_1657)player);
            return;
        }
        if (!PunchyClient.isSupportedBySolid((class_1657)player) || player.method_5799() || player.method_5869() || player.method_6128()) {
            this.stopWalk((class_1657)player);
            return;
        }
        if (!PunchyClient.isMovingHorizontally((class_1657)player)) {
            this.stopWalk((class_1657)player);
            return;
        }
        EnumSet<class_1268> eligibleHands = EnumSet.copyOf(this.walkingHands);
        for (class_1268 hand : proxyHands) {
            if (eligibleHands.contains(hand) || this.isHandBusy(hand)) continue;
            eligibleHands.add(hand);
        }
        if (eligibleHands.isEmpty()) {
            this.stopWalk((class_1657)player);
            return;
        }
        double d = speed = player.method_5624() ? 1.3 : 1.0;
        if (!this.walkActive || Math.abs(speed - this.walkSpeedMultiplier) > 0.001 || !eligibleHands.equals(this.walkingHands)) {
            this.startWalk(player, eligibleHands, speed);
        }
    }

    private boolean isSwimmingActionBlocked() {
        if (this.activationSource != ActivationSource.NONE) {
            return true;
        }
        return this.consuming || this.shieldActive || this.spyglassActive || this.rangedChargeActive;
    }

    private void startWalk(class_746 player, EnumSet<class_1268> hands, double speed) {
        if (player == null || hands == null || hands.isEmpty()) {
            this.stopWalk((class_1657)player);
            return;
        }
        if (this.walkActive && hands.equals(this.walkingHands)) {
            this.walkSpeedMultiplier = speed;
            for (class_1268 hand : hands) {
                this.walkSpeedByHand.put(hand, speed);
                this.deferredWalkRequests.remove(hand);
                this.applyWalkSpringImpulse(hand, speed);
            }
            return;
        }
        Object previous = this.walkingHands.clone();
        if (!((AbstractCollection)previous).isEmpty() && player != null) {
            Iterator hand = ((AbstractCollection)previous).iterator();
            while (hand.hasNext()) {
                class_1268 hand2 = (class_1268)hand.next();
                if (hands.contains(hand2)) continue;
                this.stopWalkAnimation((class_1657)player, hand2);
            }
        }
        this.walkActive = true;
        this.walkSpeedMultiplier = speed;
        this.walkingHands.clear();
        this.walkingHands.addAll(hands);
        EnumSet<class_1268> toStart = EnumSet.copyOf(hands);
        toStart.removeAll((Collection<?>)previous);
        for (class_1268 hand : hands) {
            this.walkSpeedByHand.put(hand, speed);
            this.deferredWalkRequests.remove(hand);
            if (!toStart.contains(hand)) continue;
            if (this.hasIdleTransitionInFlight(hand)) {
                this.deferredWalkRequests.put(hand, speed);
                continue;
            }
            this.applyWalkSpringImpulse(hand, speed);
            this.playWalkAnimation(player, hand, speed);
        }
    }

    private void stopWalkForHands(class_1657 player, EnumSet<class_1268> hands) {
        if (hands == null || hands.isEmpty()) {
            return;
        }
        EnumSet<class_1268> waterHands = EnumSet.copyOf(hands);
        waterHands.retainAll(this.walkOnWaterHands);
        if (!waterHands.isEmpty()) {
            this.pauseWalkOnWaterForHands(player, waterHands);
        }
        EnumSet<class_1268> toStop = EnumSet.copyOf(hands);
        toStop.retainAll(this.walkingHands);
        if (toStop.isEmpty()) {
            return;
        }
        this.pauseWalkOnWaterForHands(player, EnumSet.copyOf(toStop));
        for (class_1268 hand : toStop) {
            this.stopWalkAnimation(player, hand);
        }
        this.walkingHands.removeAll(toStop);
        if (this.walkingHands.isEmpty()) {
            this.walkActive = false;
            this.walkSpeedMultiplier = 1.0;
        }
    }

    private void resumeWalkOnWaterForHands(class_746 player, EnumSet<class_1268> hands) {
        if (hands == null || hands.isEmpty()) {
            return;
        }
        EnumSet<class_1268> toResume = EnumSet.noneOf(class_1268.class);
        for (class_1268 hand : hands) {
            if (!this.walkOnWaterPausedHands.remove(hand)) continue;
            toResume.add(hand);
        }
        if (toResume.isEmpty()) {
            return;
        }
        if (player != null && this.isOnWaterSurface(player)) {
            this.walkOnWaterExitGrace = 6;
        }
        if (this.walkOnWaterPausedHands.isEmpty()) {
            this.handleWalk(class_310.method_1551());
        }
    }

    private void pauseWalkOnWaterForHands(class_1657 player, EnumSet<class_1268> hands) {
        if (!this.walkOnWaterActive || hands == null || hands.isEmpty()) {
            return;
        }
        EnumSet<class_1268> newlyPaused = EnumSet.noneOf(class_1268.class);
        for (class_1268 hand : hands) {
            if (!this.walkOnWaterHands.contains(hand)) continue;
            this.stopWalkOnWaterForHand(player, hand);
            newlyPaused.add(hand);
        }
        if (!newlyPaused.isEmpty()) {
            this.walkOnWaterPausedHands.addAll(newlyPaused);
        }
    }

    private void stopWalk(class_1657 player) {
        if (!this.walkActive && this.walkingHands.isEmpty() && this.deferredWalkRequests.isEmpty()) {
            return;
        }
        Object active = this.walkingHands.clone();
        if (player != null) {
            Iterator iterator = ((AbstractCollection)active).iterator();
            while (iterator.hasNext()) {
                class_1268 hand = (class_1268)iterator.next();
                this.stopWalkAnimation(player, hand);
            }
        } else {
            Iterator iterator = ((AbstractCollection)active).iterator();
            while (iterator.hasNext()) {
                class_1268 hand = (class_1268)iterator.next();
                this.stopWalkAnimation(null, hand);
            }
        }
        this.walkingHands.clear();
        this.walkingClips.clear();
        this.walkSpeedByHand.clear();
        this.deferredWalkRequests.clear();
        this.walkActive = false;
        this.walkSpeedMultiplier = 1.0;
    }

    private void playWalkAnimation(class_746 player, class_1268 hand, double speed) {
        if (player == null || hand == null) {
            return;
        }
        class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, hand);
        if (!ProxyItemHelper.requiresProxy(held)) {
            return;
        }
        AnimatedTool.markNextActionHand(hand);
        String clip = this.walkClipForHand(held);
        BoneAnimationController.trigger((class_1657)player, hand, "Walk", clip);
        this.walkingClips.put(hand, clip);
        this.walkSpeedByHand.put(hand, speed);
        this.deferredWalkRequests.remove(hand);
        this.stopIdleForHand((class_1657)player, hand);
        PunchyClient.applyMovementArmVisibility((class_1657)player, hand);
    }

    private void stopWalkAnimation(class_1657 player, class_1268 hand) {
        if (hand == null) {
            return;
        }
        String clip = this.walkingClips.get(hand);
        if ((clip == null || clip.isEmpty()) && player != null) {
            clip = this.walkClipForHand(HandHelper.getConfiguredHandItem(player, hand));
        }
        if (player != null && clip != null && !clip.isEmpty()) {
            BoneAnimationController.stop(player, hand, "Walk", clip);
        }
        ArmAnimationOverrides.clear(hand);
        this.walkingClips.remove(hand);
        this.walkSpeedByHand.remove(hand);
        this.deferredWalkRequests.remove(hand);
    }

    private boolean isOnWaterSurface(class_746 player) {
        if (player == null || player.method_37908() == null) {
            return false;
        }
        if (!player.method_5799() || player.method_5869()) {
            return false;
        }
        class_2338 feet = player.method_24515();
        class_3610 fluid = player.method_37908().method_8316(feet);
        if (!fluid.method_15767(class_3486.field_15517)) {
            return false;
        }
        return player.method_23320() > (double)((float)feet.method_10264() + fluid.method_15763((class_1922)player.method_37908(), feet));
    }

    private void updateRangedReleaseStops(class_746 player) {
        if (this.rangedReleaseStopTimes.isEmpty()) {
            return;
        }
        if (player == null || player.method_37908() == null) {
            this.rangedReleaseStopTimes.clear();
            this.rangedReleaseCleanup.clear();
            return;
        }
        long now = player.method_37908().method_8510();
        Iterator<Map.Entry<class_1268, Long>> iterator = this.rangedReleaseStopTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_1268, Long> entry = iterator.next();
            if (now < entry.getValue()) continue;
            class_1268 hand = entry.getKey();
            this.finalizeQueuedRelease(player, hand);
            iterator.remove();
        }
    }

    private void handleJumpAndLanding(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopJump(null);
            this.wasOnGround = true;
            this.landingArmed = false;
            this.jumpInitialized = false;
            this.landingStopTimes.clear();
            this.jumpStopTimes.clear();
            return;
        }
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            this.stopJump((class_1657)player);
            this.landingArmed = false;
            this.jumpInitialized = false;
            this.landingStopTimes.clear();
            this.jumpStopTimes.clear();
            return;
        }
        this.updateLandingStops((class_1657)player);
        this.updateJumpStops((class_1657)player);
        if (!this.jumpInitialized) {
            this.wasOnGround = PunchyClient.isTouchingGroundOrLiquid((class_1657)player);
            this.landingArmed = false;
            this.jumpInitialized = true;
            return;
        }
        boolean onGround = PunchyClient.isTouchingGroundOrLiquid((class_1657)player);
        this.checkFallCharge(player, onGround);
        if (!onGround) {
            if (this.wasOnGround) {
                this.landingArmed = true;
                if (this.shouldTriggerJump(player, client)) {
                    this.startJump(player);
                }
            }
        } else if (!this.wasOnGround) {
            if (this.jumpActive) {
                this.finishJumpAfterGround(player);
            }
            if (this.landingArmed) {
                this.triggerLanding((class_1657)player);
                this.landingArmed = false;
            }
        } else {
            if (this.jumpActive) {
                this.finishJumpAfterGround(player);
            }
            this.landingArmed = false;
        }
        if (!onGround && this.walkActive) {
            this.stopWalk((class_1657)player);
        }
        this.wasOnGround = onGround;
    }

    private void checkFallCharge(class_746 player, boolean onGround) {
        double drop;
        if (player == null) {
            this.resetFallCharge((class_1657)player);
            return;
        }
        if (onGround) {
            this.resetFallCharge((class_1657)player);
            return;
        }
        if (player.method_6115() || this.activationSource != ActivationSource.NONE) {
            this.resetFallCharge((class_1657)player);
            return;
        }
        if (player.method_5681()) {
            this.resetFallCharge((class_1657)player);
            return;
        }
        double motionY = player.method_18798().field_1351;
        if (motionY >= -0.08) {
            this.fallChargeTracking = false;
            this.fallChargeStartY = Double.NaN;
            return;
        }
        if (!this.fallChargeTracking || Double.isNaN(this.fallChargeStartY)) {
            this.fallChargeTracking = true;
            this.fallChargeStartY = player.method_23318();
        }
        if ((drop = this.fallChargeStartY - player.method_23318()) < 5.0) {
            return;
        }
        if (this.fallChargeActive) {
            return;
        }
        this.fallChargeActive = true;
        this.startFallingAnimation(player, class_1268.field_5808);
        this.startFallingAnimation(player, class_1268.field_5810);
    }

    private boolean isPriorityActionActive() {
        return this.activationSource != ActivationSource.NONE || this.shieldActive || this.rangedChargeActive || this.swimmingActive || this.fallToWaterActive || this.consuming || this.inspectActive || this.inspectBlendTicks > 0;
    }

    public static double walkExpressivenessMultiplier() {
        PunchyClient inst = INSTANCE;
        if (inst == null || !inst.walkActive) {
            return 1.0;
        }
        return 1.35;
    }

    public static double jumpSpeedForClip(String clip) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 1.3;
        }
        class_1268 hand = PunchyClient.inferHandFromClip(clip);
        return inst.jumpHoldHands.contains(hand == null ? class_1268.field_5808 : hand) ? 0.0 : 1.3;
    }

    public static void onJumpGoingToLand(class_1268 hand, double animationTick) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return;
        }
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        inst.jumpHoldHands.add(resolved);
        inst.jumpHoldProgress.put(resolved, Math.max(0.0, animationTick));
        inst.jumpStopTimes.remove(resolved);
    }

    private boolean shouldTriggerJump(class_746 player, class_310 client) {
        class_243 motion = player.method_18798();
        return client.field_1690.field_1903.method_1434() || motion.field_1351 > 0.08;
    }

    private long landingDurationTicks(class_1657 player, class_1268 hand) {
        double seconds = this.clipDurationSeconds(player, hand, "landing");
        double speed = 1.3;
        return Math.max(1L, Math.round(seconds / Math.max(0.001, speed) * 20.0));
    }

    private long swimmingDurationTicks(class_1657 player, class_1268 hand) {
        double seconds = this.clipDurationSeconds(player, hand, "swiming");
        return Math.max(1L, Math.round(seconds * 20.0));
    }

    private class_3965 clipWaterBelow(class_746 player, double maxDistance) {
        class_243 start = player.method_19538();
        class_243 end = start.method_1031(0.0, -maxDistance, 0.0);
        class_3959 ctx = new class_3959(start, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, (class_1297)player);
        class_3965 result = player.method_37908().method_17742(ctx);
        if (result.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_3965 blockHit = result;
        class_2680 state = player.method_37908().method_8320(blockHit.method_17777());
        if (!state.method_26227().method_15767(class_3486.field_15517)) {
            return null;
        }
        return blockHit;
    }

    private void handleArrowInstruction(boolean equip) {
        if (!this.rangedChargeActive || this.rangedChargeArrowHand == null) {
            return;
        }
        class_1268 arrowHand = this.rangedChargeArrowHand;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (equip) {
            if (!this.activeArrowOverrides.contains(arrowHand)) {
                this.savedArrowOverrides.put(arrowHand, HandItemOverrides.getOverride(arrowHand));
                this.savedArrowHidden.put(arrowHand, HandItemOverrides.isHidden(arrowHand));
            }
            class_1799 arrowStack = this.createVisualArrowStack(player);
            HandItemOverrides.setOverride(arrowHand, arrowStack);
            HandItemOverrides.setHidden(arrowHand, false);
            ArmAnimationOverrides.setForceRender(arrowHand, true);
            this.activeArrowOverrides.add(arrowHand);
        } else {
            if (!this.activeArrowOverrides.contains(arrowHand)) {
                return;
            }
            HandItemOverrides.setOverride(arrowHand, class_1799.field_8037);
            HandItemOverrides.setHidden(arrowHand, true);
        }
    }

    private void handleCrossbowItemVisibility(class_1268 hand, boolean hidden) {
        if (hand == null) {
            return;
        }
        class_1268 resolved = hand;
        if (hidden) {
            this.crossbowHiddenStates.putIfAbsent(resolved, HandItemOverrides.isHidden(resolved));
            HandItemOverrides.setHidden(resolved, true);
            return;
        }
        Boolean previous = this.crossbowHiddenStates.remove(resolved);
        HandItemOverrides.setHidden(resolved, previous != null ? previous : false);
    }

    private void restoreAllCrossbowVisibility() {
        if (this.crossbowHiddenStates.isEmpty()) {
            return;
        }
        EnumSet<class_1268> hands = EnumSet.copyOf(this.crossbowHiddenStates.keySet());
        for (class_1268 hand : hands) {
            this.handleCrossbowItemVisibility(hand, false);
        }
    }

    private void handleFlintAndSteelArmIn(class_1268 hand) {
        if (hand != class_1268.field_5810) {
            return;
        }
        if (!this.flintAndSteelDualActive || this.flintAndSteelProxyHand != hand) {
            this.beginFlintAndSteelProxy(hand);
        }
        this.flintAndSteelCleanupPending = false;
    }

    private void handleFlintAndSteelArmOut(class_1268 hand) {
        if (hand != class_1268.field_5810) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        this.requestFlintAndSteelCleanup((class_1657)player);
        this.finalizeFlintAndSteelCleanup(true);
    }

    private void handleFlintAndSteelSpark(class_1268 hand) {
        this.spawnFlintAndSteelSpark(hand);
    }

    private void spawnFlintAndSteelSpark(class_1268 hand) {
        class_243 up;
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null || player.method_37908() == null) {
            return;
        }
        class_243 look = player.method_5828(1.0f);
        class_243 sideVec = look.method_1036(up = new class_243(0.0, 1.0, 0.0));
        if (sideVec.method_1027() <= 1.0E-6) {
            sideVec = new class_243(1.0, 0.0, 0.0);
        }
        sideVec = sideVec.method_1029();
        double sideOffset = hand == class_1268.field_5810 ? -0.25 : 0.25;
        class_243 offset = look.method_1021(0.5).method_1019(sideVec.method_1021(sideOffset));
        class_243 base = player.method_5836(1.0f).method_1019(offset).method_1031(0.0, -0.3, 0.0);
        class_5819 random = player.method_59922();
        class_1937 level = player.method_37908();
        int tinyColor = 0x66CCFF;
        float r = (float)(tinyColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(tinyColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(tinyColor & 0xFF) / 255.0f;
        class_2390 tinySpark = new class_2390(new Vector3f(r, g, b), 0.1f);
        class_2390 tinySmoke = new class_2390(new Vector3f(0.33f, 0.33f, 0.33f), 0.3f);
        for (int i = 0; i < 4; ++i) {
            double dx = (random.method_43058() - 0.5) * 0.2;
            double dy = (random.method_43058() - 0.5) * 0.2;
            double dz = (random.method_43058() - 0.5) * 0.2;
            double vx = look.field_1352 * 0.2 + (random.method_43058() - 0.5) * 0.1;
            double vy = look.field_1351 * 0.2 + (random.method_43058() - 0.5) * 0.1;
            double vz = look.field_1350 * 0.2 + (random.method_43058() - 0.5) * 0.1;
            if (!(random.method_43058() < 0.33)) continue;
            double sx = base.field_1352 + dx * 0.6;
            double sy = base.field_1351 + dy * 0.6;
            double sz = base.field_1350 + dz * 0.6;
            level.method_8406((class_2394)class_2398.field_29644, sx, sy, sz, vx * 1.9, vy * 1.9, vz * 1.9);
            level.method_8406((class_2394)tinySpark, sx, sy, sz, vx * 1.9, vy * 1.9, vz * 1.9);
            for (int smoke = 0; smoke < 2; ++smoke) {
                double ox = sx + (random.method_43058() - 0.5) * 0.05;
                double oy = sy + (random.method_43058() - 0.5) * 0.05;
                double oz = sz + (random.method_43058() - 0.5) * 0.05;
                level.method_8406((class_2394)tinySmoke, ox, oy, oz, vx * 0.6, vy * 0.6, vz * 0.6);
            }
        }
    }

    private void handleSelectAnimation(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            this.lastMainhandStack = class_1799.field_8037;
            this.lastOffhandStack = class_1799.field_8037;
            this.loweredHands.clear();
            this.resetMainHandSwapState();
            this.needsOffhandLowerBootstrap = true;
            return;
        }
        this.tickMainHandSwap(player);
        this.handleSelectForHand(player, class_1268.field_5808);
        this.handleSelectForHand(player, class_1268.field_5810);
        this.processPendingOffhandSyncs(player);
        this.tickSelectDeadlines(player);
    }

    private void processPendingOffhandSyncs(class_746 player) {
        if (!this.pendingOffhandLowerSync) {
            return;
        }
        this.pendingOffhandLowerSync = false;
        this.syncOffhandLowering(player);
    }

    private void handleSelectForHand(class_746 player, class_1268 hand) {
        boolean changedItem;
        class_1799 last;
        boolean proxy;
        class_1799 stack = HandHelper.getConfiguredHandItem((class_1657)player, hand);
        if (this.shieldActive && hand == this.shieldHand && !PunchyClient.isShield(stack)) {
            this.stopShieldUse((class_1657)player);
        }
        this.updateLoweredState(player, hand, stack);
        if (hand == class_1268.field_5810) {
            if (stack.method_7960()) {
                class_1799 previous = this.lastOffhandStack;
                this.storeLastStack(hand, stack);
                boolean needsBootstrap = this.needsOffhandLowerBootstrap;
                if (!this.pendingOffhandLowerSync && (previous != null && !previous.method_7960() || needsBootstrap)) {
                    this.startOffhandHold(player);
                }
                return;
            }
            this.stopOffhandHold(player);
        }
        if (!(proxy = ProxyItemHelper.requiresProxy(stack))) {
            if (hand == class_1268.field_5808) {
                this.resetMainHandSwapState();
                this.lastMainhandStack = class_1799.field_8037;
            } else {
                this.lastOffhandStack = class_1799.field_8037;
            }
            return;
        }
        class_1799 class_17992 = last = hand == class_1268.field_5808 ? this.lastMainhandStack : this.lastOffhandStack;
        if (this.consumeSelectSuppression(hand)) {
            this.storeLastStack(hand, stack);
            return;
        }
        boolean bl = changedItem = stack.method_7960() != last.method_7960();
        if (!changedItem && !stack.method_7960()) {
            boolean bl2 = changedItem = stack.method_7909() != last.method_7909();
        }
        if (hand == class_1268.field_5808) {
            if (changedItem) {
                this.handleMainHandSwap(player, stack);
            }
            this.storeLastStack(hand, stack);
            return;
        }
        if (changedItem && (hand != class_1268.field_5810 || !this.pendingOffhandLowerSync)) {
            if (hand == class_1268.field_5810) {
                this.endOffhandRenderOverride();
                ArmAnimationOverrides.setForceRender(class_1268.field_5810, true);
            }
            this.prioritizeMovementAnimation((class_1657)player, hand);
            AnimatedTool.markNextActionHand(hand);
            BoneAnimationController.trigger((class_1657)player, hand, "Select", HAND_IN_CLIP);
            this.selectHands.add(hand);
            this.onSelectClipTriggered(player, hand, HAND_IN_CLIP, true);
        }
        this.storeLastStack(hand, stack);
    }

    private boolean isActionActive() {
        if (this.rangedChargeActive || this.shieldActive || this.spyglassActive) {
            return true;
        }
        if (this.flintAndSteelDualActive || this.fallToWaterActive || this.swimmingActive || this.walkOnWaterActive) {
            return true;
        }
        return !this.swimmingStrafeClips.isEmpty();
    }

    private void updateLoweredState(class_746 player, class_1268 hand, class_1799 stack) {
        boolean empty;
        boolean forceRaised = this.isActionActive();
        if (forceRaised) {
            if (this.loweredHands.getOrDefault(hand, false).booleanValue()) {
                if (hand == class_1268.field_5810) {
                    this.stopOffhandHold(player);
                    if (stack.method_7960()) {
                        ArmAnimationOverrides.setForceRender(class_1268.field_5810, true);
                        AnimatedTool.markNextActionHand(class_1268.field_5810);
                        BoneAnimationController.trigger((class_1657)player, class_1268.field_5810, "Select", HAND_IN_CLIP);
                    }
                }
                this.loweredHands.put(hand, false);
            }
            return;
        }
        class_1268 loweredTarget = this.loweredHandForPlayer(player);
        if (hand != loweredTarget) {
            return;
        }
        boolean bl = empty = stack == null || stack.method_7960();
        if (empty && !this.loweredHands.getOrDefault(hand, false).booleanValue() && !this.offhandHoldActive) {
            this.startOffhandHold(player);
            return;
        }
        if (this.offhandHoldActive) {
            this.loweredHands.put(hand, true);
            return;
        }
        this.loweredHands.put(hand, empty);
    }

    private class_1268 loweredHandForPlayer(class_746 player) {
        return class_1268.field_5810;
    }

    private void handleMainHandSwap(class_746 player, class_1799 stack) {
        class_1799 desired;
        class_1799 class_17992 = desired = stack == null ? class_1799.field_8037 : stack.method_7972();
        if (this.mainHandSwapState.stage == MainHandSwapStage.IDLE) {
            if (class_1799.method_31577((class_1799)desired, (class_1799)this.mainHandSwapState.displayed)) {
                this.mainHandSwapState.pending = class_1799.field_8037;
                return;
            }
            this.mainHandSwapState.displayed = this.lastMainhandStack == null ? class_1799.field_8037 : this.lastMainhandStack.method_7972();
        }
        this.mainHandSwapState.pending = desired;
        if (this.mainHandSwapState.stage == MainHandSwapStage.LOWERING) {
            return;
        }
        if (this.mainHandSwapState.stage == MainHandSwapStage.RAISING) {
            this.startMainHandLowering(player);
            return;
        }
        this.startMainHandLowering(player);
    }

    private void startMainHandLowering(class_746 player) {
        boolean offhandHadItem;
        if (player == null) {
            this.resetMainHandSwapState();
            return;
        }
        if (class_1799.method_31577((class_1799)this.mainHandSwapState.pending, (class_1799)this.mainHandSwapState.displayed)) {
            this.mainHandSwapState.pending = class_1799.field_8037;
            return;
        }
        class_1799 configuredMain = HandHelper.getConfiguredMainHandItem((class_1657)player);
        if (this.mainHandSwapState.pending.method_7960() && !configuredMain.method_7960()) {
            this.mainHandSwapState.pending = configuredMain.method_7972();
        }
        if (this.shieldActive && this.shieldHand == class_1268.field_5810) {
            this.stopShieldUse((class_1657)player);
        }
        boolean bl = offhandHadItem = this.lastOffhandStack != null && !this.lastOffhandStack.method_7960();
        if (offhandHadItem) {
            this.suppressNextSelect(class_1268.field_5810);
            this.pendingOffhandLowerSync = this.shouldSyncOffhandWithMain();
        } else {
            this.pendingOffhandLowerSync = false;
        }
        if (this.lastOffhandStack == null || this.lastOffhandStack.method_7960()) {
            this.pendingOffhandLowerSync = false;
        }
        if (this.pendingOffhandLowerSync && offhandHadItem) {
            this.beginOffhandRenderOverride(this.lastOffhandStack);
        }
        this.prioritizeMovementAnimation((class_1657)player, class_1268.field_5808);
        AnimatedTool.markNextActionHand(class_1268.field_5808);
        this.mainHandSwapState.stage = MainHandSwapStage.LOWERING;
        if ((this.mainHandSwapState.displayed == null || this.mainHandSwapState.displayed.method_7960()) && !this.mainHandHiddenForSwap) {
            HandItemOverrides.setHidden(class_1268.field_5808, true);
            this.mainHandHiddenForSwap = true;
        }
        this.mainHandSwapState.loweringDeadline = this.estimateSelectDeadline(player, class_1268.field_5808, HAND_OUT_CLIP);
        this.selectHands.add(class_1268.field_5808);
        BoneAnimationController.trigger((class_1657)player, class_1268.field_5808, "Select", HAND_OUT_CLIP);
        this.onSelectClipTriggered(player, class_1268.field_5808, HAND_OUT_CLIP, true);
    }

    private void handleMainHandLoweringFinished(class_746 player) {
        if (this.mainHandSwapState.stage != MainHandSwapStage.LOWERING) {
            return;
        }
        if (player == null) {
            this.resetMainHandSwapState();
            return;
        }
        this.mainHandSwapState.loweringDeadline = -1L;
        class_1799 next = this.mainHandSwapState.pending;
        if (next == null || next.method_7960()) {
            next = HandHelper.getConfiguredMainHandItem((class_1657)player);
        }
        this.mainHandSwapState.displayed = next == null ? class_1799.field_8037 : next.method_7972();
        this.mainHandSwapState.pending = class_1799.field_8037;
        this.clearMainHandSwapHide();
        this.mainHandSwapState.stage = MainHandSwapStage.RAISING;
        this.mainHandSwapState.raisingDeadline = this.estimateSelectDeadline(player, class_1268.field_5808, HAND_IN_CLIP);
        this.prioritizeMovementAnimation((class_1657)player, class_1268.field_5808);
        AnimatedTool.markNextActionHand(class_1268.field_5808);
        this.selectHands.add(class_1268.field_5808);
        BoneAnimationController.trigger((class_1657)player, class_1268.field_5808, "Select", HAND_IN_CLIP);
        this.onSelectClipTriggered(player, class_1268.field_5808, HAND_IN_CLIP, true);
        this.syncOffhandRaising(player);
    }

    private void handleMainHandRaiseFinished(class_746 player) {
        if (this.mainHandSwapState.stage != MainHandSwapStage.RAISING) {
            return;
        }
        this.mainHandSwapState.raisingDeadline = -1L;
        this.mainHandSwapState.stage = MainHandSwapStage.IDLE;
        this.endOffhandRenderOverride();
        boolean restart = this.mainHandSwapState.restartAfterRaise;
        this.mainHandSwapState.restartAfterRaise = false;
        if (restart) {
            if (player != null) {
                this.startMainHandLowering(player);
            } else {
                this.resetMainHandSwapState();
            }
        } else {
            this.mainHandSwapState.pending = class_1799.field_8037;
        }
    }

    private void prioritizeMovementAnimation(class_1657 player, class_1268 hand) {
        if (player != null && hand != null) {
            this.stopWalkForHands(player, EnumSet.of(hand));
        } else {
            this.stopWalk(player);
        }
        this.stopJump(player);
        this.stopLanding(player);
    }

    private void interruptSelectForMouseAction(class_746 player, class_1268 hand) {
        if (player == null) {
            return;
        }
        if (hand == null) {
            this.stopSelect((class_1657)player, class_1268.field_5808);
            return;
        }
        this.stopSelect((class_1657)player, hand);
    }

    private void stopSelect(class_1657 player, class_1268 hand) {
        this.stopSelect(player, hand, true, "manual");
    }

    private void stopSelect(class_1657 player, class_1268 hand, boolean stopAnimation) {
        this.stopSelect(player, hand, stopAnimation, "manual");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSelect(class_1657 player, class_1268 hand, boolean stopAnimation, String reason) {
        class_1268 resolved;
        class_1268 class_12682 = resolved = hand == null ? class_1268.field_5808 : hand;
        if (!this.selectHands.contains(resolved) || this.selectStopInProgress.contains(resolved)) {
            return;
        }
        this.selectStopInProgress.add(resolved);
        try {
            class_746 lp;
            String clip = this.activeSelectClips.get(resolved);
            if (clip == null || clip.isEmpty()) {
                clip = HAND_IN_CLIP;
            }
            this.logSelectClipEvent("Stopped", resolved, clip, stopAnimation, reason);
            if (stopAnimation && player != null) {
                BoneAnimationController.stop(player, resolved, "Select", clip);
            }
            if (player != null) {
                ArmAnimationOverrides.clear(resolved);
            }
            this.selectHands.remove(resolved);
            this.selectStopDeadlines.remove(resolved);
            this.activeSelectClips.remove(resolved);
            boolean isOutClip = PunchyClient.isSelectOutClipName(clip);
            if (resolved == class_1268.field_5810 && isOutClip) {
                this.endOffhandRenderOverride();
            }
            if (resolved == class_1268.field_5808 && this.mainHandSwapState.stage != MainHandSwapStage.IDLE && !isOutClip) {
                this.resetMainHandSwapState();
            }
            if (resolved == class_1268.field_5808) {
                this.clearMainHandSwapHide();
            }
            class_746 local = player instanceof class_746 ? (lp = (class_746)player) : class_310.method_1551().field_1724;
            this.ensureIdleAfterAction(local, resolved);
            class_310 client = class_310.method_1551();
            if (client != null) {
                this.handleWalk(client);
            }
        }
        finally {
            this.selectStopInProgress.remove(resolved);
        }
    }

    private void onSelectClipTriggered(class_746 player, class_1268 hand, String clip, boolean autoStop) {
        class_1268 resolved;
        class_1268 class_12682 = resolved = hand == null ? class_1268.field_5808 : hand;
        if (clip == null || clip.isEmpty()) {
            this.activeSelectClips.remove(resolved);
            this.selectStopDeadlines.remove(resolved);
            return;
        }
        this.activeSelectClips.put(resolved, clip);
        if (autoStop) {
            this.scheduleSelectStop(player, resolved, clip);
        } else {
            this.selectStopDeadlines.remove(resolved);
        }
        String note = autoStop ? "auto" : "hold";
        this.logSelectClipEvent("Triggered", resolved, clip, autoStop, note);
    }

    private void logSelectClipEvent(String stage, class_1268 hand, String clip, boolean autoStop, String note) {
    }

    private static String stackName(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return "empty";
        }
        class_1792 item = stack.method_7909();
        if (item == null) {
            return "unknown";
        }
        return item.toString();
    }

    private static String gameTimeStamp(class_1657 player) {
        if (player == null || player.method_37908() == null) {
            return "n/a";
        }
        return String.valueOf(player.method_37908().method_8510());
    }

    private boolean shouldAnimateOffhand(class_746 player) {
        if (player == null) {
            return false;
        }
        class_1799 off = HandHelper.getConfiguredHandItem((class_1657)player, class_1268.field_5810);
        return off != null && !off.method_7960() && ProxyItemHelper.requiresProxy(off);
    }

    private boolean shouldSyncOffhandWithMain() {
        class_1799 pending = this.mainHandSwapState.pending;
        class_1799 mirror = this.lastOffhandStack;
        if (pending == null) {
            pending = class_1799.field_8037;
        }
        if (mirror == null) {
            mirror = class_1799.field_8037;
        }
        if (mirror.method_7960()) {
            return false;
        }
        return class_1799.method_31577((class_1799)pending, (class_1799)mirror);
    }

    private void beginOffhandRenderOverride(class_1799 stack) {
        if (this.offhandRenderOverrideActive) {
            return;
        }
        class_1799 backup = HandItemOverrides.getOverride(class_1268.field_5810);
        this.offhandRenderOverrideBackup = backup == null ? class_1799.field_8037 : backup.method_7972();
        this.offhandRenderHiddenBackup = HandItemOverrides.isHidden(class_1268.field_5810);
        class_1799 safe = stack == null ? class_1799.field_8037 : stack.method_7972();
        HandItemOverrides.setOverride(class_1268.field_5810, safe);
        HandItemOverrides.setHidden(class_1268.field_5810, false);
        ArmAnimationOverrides.setForceRender(class_1268.field_5810, true);
        this.offhandRenderOverrideActive = true;
    }

    private void endOffhandRenderOverride() {
        if (!this.offhandRenderOverrideActive) {
            return;
        }
        if (this.offhandRenderOverrideBackup.method_7960()) {
            HandItemOverrides.clear(class_1268.field_5810);
            ArmAnimationOverrides.clear(class_1268.field_5810);
        } else {
            HandItemOverrides.setOverride(class_1268.field_5810, this.offhandRenderOverrideBackup);
        }
        HandItemOverrides.setHidden(class_1268.field_5810, this.offhandRenderHiddenBackup);
        this.offhandRenderOverrideActive = false;
        this.offhandRenderOverrideBackup = class_1799.field_8037;
        this.offhandRenderHiddenBackup = false;
    }

    private void scheduleSelectStop(class_746 player, class_1268 hand, String clip) {
        if (player == null || player.method_37908() == null || hand == null || clip == null || clip.isEmpty()) {
            return;
        }
        int baseTicks = this.clipDurationTicks((class_1657)player, hand, clip);
        double multiplier = PunchyClient.selectAnimationDurationMultiplier(hand);
        long adjusted = Math.max(1L, Math.round((double)baseTicks * multiplier));
        long stopTime = player.method_37908().method_8510() + adjusted;
        this.selectStopDeadlines.put(hand, stopTime);
    }

    private static double selectAnimationDurationMultiplier(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        double multiplier = SELECT_ANIMATION_DURATION_MULTIPLIERS.getOrDefault(resolved, 1.0);
        return multiplier <= 0.0 ? 1.0 : multiplier;
    }

    public static double selectAnimationSpeedScale(class_1268 hand) {
        return 1.0 / PunchyClient.selectAnimationDurationMultiplier(hand);
    }

    private void tickSelectDeadlines(class_746 player) {
        if (player == null || player.method_37908() == null || this.selectStopDeadlines.isEmpty()) {
            return;
        }
        long now = player.method_37908().method_8510();
        EnumSet<class_1268> expired = EnumSet.noneOf(class_1268.class);
        for (Map.Entry<class_1268, Long> entry : this.selectStopDeadlines.entrySet()) {
            if (entry.getValue() == null || entry.getValue() > now) continue;
            expired.add(entry.getKey());
        }
        for (class_1268 hand : expired) {
            this.stopSelect((class_1657)player, hand, true, "deadline");
            if (hand != class_1268.field_5810 || !this.offhandHoldActive) continue;
            this.stopOffhandHold(player);
        }
    }

    public static boolean isOffhandHoldActive() {
        PunchyClient inst = INSTANCE;
        return inst != null && inst.offhandHoldActive;
    }

    public static boolean isHandLowered(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null || hand == null) {
            return false;
        }
        return inst.loweredHands.getOrDefault(hand, false);
    }

    public static float loweredRotationDegrees(class_1268 hand) {
        if (hand == class_1268.field_5810) {
            return -90.0f;
        }
        return 0.0f;
    }

    public static class_1799 resolveMainHandRenderStack(class_1799 fallback) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return fallback == null ? class_1799.field_8037 : fallback;
        }
        return inst.currentMainHandOverride(fallback);
    }

    private void startOffhandHold(class_746 player) {
        if (this.offhandHoldActive || player == null) {
            return;
        }
        this.needsOffhandLowerBootstrap = false;
        class_1268 loweredTarget = this.loweredHandForPlayer(player);
        ArmAnimationOverrides.setForceRender(loweredTarget, true);
        class_1799 configured = HandHelper.getConfiguredHandItem((class_1657)player, loweredTarget);
        if (configured != null && !configured.method_7960()) {
            HandItemOverrides.setOverride(loweredTarget, configured);
        } else {
            HandItemOverrides.clear(loweredTarget);
        }
        HandItemOverrides.setHidden(loweredTarget, true);
        AnimatedTool.markNextActionHand(loweredTarget);
        BoneAnimationController.trigger((class_1657)player, loweredTarget, "Select", HAND_OUT_CLIP);
        this.offhandHoldActive = true;
        this.loweredHands.put(loweredTarget, true);
        this.selectHands.add(loweredTarget);
        this.onSelectClipTriggered(player, loweredTarget, HAND_OUT_CLIP, false);
    }

    private void syncOffhandLowering(class_746 player) {
        if (player == null || this.offhandHoldActive) {
            return;
        }
        if (!this.shouldAnimateOffhand(player) && !this.offhandRenderOverrideActive) {
            return;
        }
        class_1268 loweredTarget = this.loweredHandForPlayer(player);
        String currentClip = this.activeSelectClips.get(loweredTarget);
        if (HAND_OUT_CLIP.equals(currentClip)) {
            return;
        }
        AnimatedTool.markNextActionHand(loweredTarget);
        BoneAnimationController.trigger((class_1657)player, loweredTarget, "Select", HAND_OUT_CLIP);
        this.loweredHands.put(loweredTarget, true);
        this.selectHands.add(loweredTarget);
        this.onSelectClipTriggered(player, loweredTarget, HAND_OUT_CLIP, false);
    }

    private void syncOffhandRaising(class_746 player) {
        if (player == null || this.offhandHoldActive) {
            return;
        }
        class_1799 off = HandHelper.getConfiguredHandItem((class_1657)player, class_1268.field_5810);
        if (off == null || off.method_7960()) {
            return;
        }
        if (!this.shouldAnimateOffhand(player)) {
            return;
        }
        if (!this.activeSelectClips.containsKey(class_1268.field_5810)) {
            return;
        }
        String currentClip = this.activeSelectClips.get(class_1268.field_5810);
        if (HAND_IN_CLIP.equals(currentClip)) {
            return;
        }
        this.endOffhandRenderOverride();
        ArmAnimationOverrides.setForceRender(class_1268.field_5810, true);
        AnimatedTool.markNextActionHand(class_1268.field_5810);
        BoneAnimationController.trigger((class_1657)player, class_1268.field_5810, "Select", HAND_IN_CLIP);
        this.selectHands.add(class_1268.field_5810);
        this.onSelectClipTriggered(player, class_1268.field_5810, HAND_IN_CLIP, true);
    }

    private void stopOffhandHold(class_746 player) {
        if (!this.offhandHoldActive) {
            return;
        }
        this.offhandHoldActive = false;
        class_1268 loweredTarget = this.loweredHandForPlayer(player);
        this.loweredHands.put(loweredTarget, false);
        ArmAnimationOverrides.clear(loweredTarget);
        HandItemOverrides.setHidden(loweredTarget, false);
        this.selectHands.remove(loweredTarget);
        this.selectStopDeadlines.remove(loweredTarget);
        this.activeSelectClips.remove(loweredTarget);
        if (player != null) {
            BoneAnimationController.stop((class_1657)player, loweredTarget, "Select", HAND_OUT_CLIP);
            this.ensureIdleAfterAction(player, loweredTarget);
        }
    }

    private void handleConsume(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopConsume(null);
            return;
        }
        if (!ProxyItemHelper.requiresProxy(HandHelper.getConfiguredHandItem((class_1657)player, class_1268.field_5808)) && !ProxyItemHelper.requiresProxy(HandHelper.getConfiguredHandItem((class_1657)player, class_1268.field_5810))) {
            this.stopConsume((class_1657)player);
            return;
        }
        if (player.method_6115()) {
            String anim;
            class_1268 activeHand = this.resolveVisualHand(player, player.method_6058());
            class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, activeHand);
            if (!ProxyItemHelper.requiresProxy(held)) {
                return;
            }
            class_1799 useStack = player.method_6030();
            class_1839 action = useStack.method_7976();
            switch (action) {
                case field_8946: {
                    String string = "drink";
                    break;
                }
                case field_8950: {
                    String string = "eat";
                    break;
                }
                default: {
                    String string = anim = null;
                }
            }
            if (anim != null && !this.consuming) {
                this.prioritizeMovementAnimation((class_1657)player, activeHand);
                AnimatedTool.markNextActionHand(activeHand);
                BoneAnimationController.trigger((class_1657)player, activeHand, "Consume", anim);
                this.consuming = true;
                this.consumingAnim = anim;
                this.consumeHand = activeHand;
            }
        } else if (this.consuming) {
            class_1799 held;
            class_1268 finishedHand = this.stopConsume((class_1657)player);
            if (player != null && finishedHand != null && ProxyItemHelper.requiresProxy(held = HandHelper.getConfiguredHandItem((class_1657)player, finishedHand))) {
                this.playReleaseTransition(player, finishedHand);
            }
        }
    }

    private class_1268 stopConsume(class_1657 player) {
        if (!this.consuming) {
            return null;
        }
        class_1268 finishedHand = this.consumeHand;
        if (player != null && this.consumingAnim != null) {
            AnimatedTool.markNextActivationSpeed(5.0);
            BoneAnimationController.stop(player, finishedHand, "Consume", this.consumingAnim);
        }
        this.consuming = false;
        this.consumingAnim = null;
        this.consumeHand = class_1268.field_5808;
        AnimatedTool.resetActivationSpeed();
        return finishedHand;
    }

    private void handleInspect(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_1799 mainStack = HandHelper.getConfiguredHandItem((class_1657)player, class_1268.field_5808);
        if (!(!this.inspectActive || PunchyClient.isInspectEligible(mainStack) && PunchyClient.inspectStacksMatch(mainStack, this.inspectStack))) {
            this.stopInspect(player);
        }
        if (inspectKey == null || !inspectKey.method_1436()) {
            return;
        }
        if (!PunchyClient.isInspectEligible(mainStack)) {
            return;
        }
        this.stopInspect(player);
        this.stopWalkForHands((class_1657)player, EnumSet.of(class_1268.field_5808));
        AnimatedTool.markNextActionHand(class_1268.field_5808);
        this.inspectActive = true;
        this.inspectBlendTicks = 0;
        this.inspectStack = mainStack.method_7972();
        BoneAnimationController.trigger((class_1657)player, class_1268.field_5808, "Inspect", "inspect_my_item");
        if (player.method_37908() != null) {
            double duration = this.clipDurationSeconds((class_1657)player, class_1268.field_5808, "inspect_my_item");
            long ticks = Math.max(1L, Math.round(duration * 20.0));
            this.inspectStopGameTime = player.method_37908().method_8510() + ticks;
        } else {
            this.inspectStopGameTime = -1L;
        }
    }

    private void tickInspect(class_310 client) {
        class_746 local;
        if (client == null || client.field_1687 == null) {
            return;
        }
        if (this.inspectActive && this.inspectStopGameTime > 0L && client.field_1687.method_8510() >= this.inspectStopGameTime) {
            local = client.field_1724;
            this.completeInspect(local);
        }
        if (this.inspectBlendTicks > 0) {
            --this.inspectBlendTicks;
            if (this.inspectBlendTicks == 0 && (local = client.field_1724) != null) {
                this.ensureIdleAfterAction(local, class_1268.field_5808);
            }
        }
        if (this.walkOnWaterBlendTicks > 0) {
            --this.walkOnWaterBlendTicks;
            if (this.walkOnWaterBlendTicks == 0 && (local = client.field_1724) != null) {
                this.stopWalkOnWater(local);
                this.ensureIdleAfterAction(local, class_1268.field_5808);
            }
        }
    }

    private void handleShieldUse(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopShieldUse(null);
            return;
        }
        if (!player.method_6115()) {
            this.stopShieldUse((class_1657)player);
            return;
        }
        class_1799 useStack = player.method_6030();
        if (!PunchyClient.isShield(useStack)) {
            this.stopShieldUse((class_1657)player);
            return;
        }
        this.ensureHandsRaised(player);
        class_1268 usedHand = this.resolveVisualHand(player, player.method_6058());
        if (usedHand == null || !ProxyItemHelper.requiresProxy(HandHelper.getConfiguredHandItem((class_1657)player, usedHand))) {
            this.stopShieldUse((class_1657)player);
            return;
        }
        HandItemOverrides.setOverride(usedHand, HandHelper.getConfiguredHandItem((class_1657)player, usedHand));
        if (this.shieldActive && this.shieldHand != usedHand) {
            this.stopShieldUse((class_1657)player);
        }
        if (!this.shieldActive) {
            this.startShieldUse((class_1657)player, usedHand);
        }
        if (this.shieldActive && !player.method_6115()) {
            this.stopShieldUse((class_1657)player);
            return;
        }
        int currentHurt = player.field_6235;
        if (this.shieldActive && currentHurt > this.shieldHurtTime) {
            this.handleShieldImpact(player);
        }
        this.shieldHurtTime = currentHurt;
        this.monitorShieldDamage(player, usedHand);
    }

    private void monitorShieldDamage(class_746 player, class_1268 hand) {
        if (!this.shieldActive || player == null || hand == null) {
            return;
        }
        class_1799 stack = HandHelper.getConfiguredHandItem((class_1657)player, hand);
        if (!PunchyClient.isShield(stack)) {
            return;
        }
        int damage = stack.method_7919();
        if (damage > this.shieldItemDamage) {
            this.handleShieldImpact(player);
        }
        this.shieldItemDamage = damage;
    }

    private void startShieldUse(class_1657 player, class_1268 hand) {
        int n;
        class_1268 resolvedHand = hand == null ? class_1268.field_5808 : hand;
        this.prioritizeMovementAnimation(player, resolvedHand);
        AnimatedTool.markNextActionHand(resolvedHand);
        BoneAnimationController.trigger(player, resolvedHand, "Shield", "rise_shield");
        class_1799 stack = HandHelper.getConfiguredHandItem(player, resolvedHand);
        HandItemOverrides.setOverride(resolvedHand, stack);
        this.shieldActive = true;
        this.shieldHand = resolvedHand;
        if (player instanceof class_746) {
            class_746 local = (class_746)player;
            n = local.field_6235;
        } else {
            n = 0;
        }
        this.shieldHurtTime = n;
        this.shieldItemDamage = stack.method_7919();
        this.stopIdleForHand(player, resolvedHand);
    }

    private void stopShieldUse(class_1657 player) {
        if (!this.shieldActive) {
            return;
        }
        HandItemOverrides.clear(this.shieldHand);
        if (this.shieldHand == class_1268.field_5810 && this.offhandRenderOverrideActive) {
            this.endOffhandRenderOverride();
        }
        if (player != null) {
            BoneAnimationController.stop(player, this.shieldHand, "Shield", "rise_shield");
        }
        this.shieldActive = false;
        this.shieldHand = class_1268.field_5808;
        this.shieldHurtTime = 0;
        this.shieldItemDamage = -1;
    }

    private void handleShieldImpact(class_746 player) {
        if (!this.shieldActive || player == null) {
            return;
        }
        AnimatedTool.markNextActionHand(this.shieldHand);
        BoneAnimationController.trigger((class_1657)player, this.shieldHand, "ShieldImpact", "shield_hit");
        this.shieldHurtTime = player.field_6235;
    }

    private boolean playReleaseTransition(class_746 player, class_1268 hand) {
        if (player == null || hand == null) {
            return false;
        }
        class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, hand);
        if (!ProxyItemHelper.requiresProxy(held)) {
            this.stopTransition((class_1657)player);
            return false;
        }
        if (this.jumpActive || !this.landingStopTimes.isEmpty()) {
            return false;
        }
        if (this.transitionActive && this.transitionHand == hand) {
            return true;
        }
        this.stopTransition((class_1657)player);
        AnimatedTool.markNextActionHand(hand);
        BoneAnimationController.triggerActivation((class_1657)player, hand, TRANSITION_TO_IDLE_PUNCH);
        this.transitionActive = true;
        this.transitionHand = hand;
        if (player.method_37908() != null) {
            long durationTicks = Math.max(1L, Math.round(this.clipDurationSeconds((class_1657)player, hand, TRANSITION_TO_IDLE_PUNCH) * 20.0));
            this.transitionStopGameTime = player.method_37908().method_8510() + durationTicks;
        } else {
            this.transitionStopGameTime = -1L;
        }
        return true;
    }

    private void stopTransition(class_1657 player) {
        if (!this.transitionActive) {
            return;
        }
        if (player != null) {
            this.stopActivationLoop(player, this.transitionHand, TRANSITION_TO_IDLE_PUNCH, false);
            ToolAnimationOverrides.clear(this.transitionHand);
        }
        this.transitionActive = false;
        this.transitionHand = class_1268.field_5808;
        this.transitionStopGameTime = -1L;
    }

    private void handleTransitionStopped(class_1268 hand) {
        class_1268 effective;
        if (!this.transitionActive) {
            return;
        }
        class_1268 class_12682 = effective = hand == null ? this.transitionHand : hand;
        if (effective != this.transitionHand) {
            return;
        }
        this.transitionActive = false;
        this.transitionHand = class_1268.field_5808;
        this.transitionStopGameTime = -1L;
        ToolAnimationOverrides.clear(effective);
        this.ensureIdleAfterAction(class_310.method_1551().field_1724, effective);
    }

    private void ensureIdle(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null) {
            this.stopIdle(null);
            return;
        }
        for (class_1268 hand : class_1268.values()) {
            if (hand == class_1268.field_5810 && this.offhandHoldActive) continue;
            this.tryStartIdle(player, hand);
        }
    }

    private void primeIdleState(class_746 player) {
        if (player == null) {
            return;
        }
        this.idlePrimedThisSession = true;
        this.storeLastStack(class_1268.field_5808, HandHelper.getConfiguredMainHandItem((class_1657)player));
        this.storeLastStack(class_1268.field_5810, player.method_6079());
        this.tryStartIdle(player, class_1268.field_5808);
        this.tryStartIdle(player, class_1268.field_5810);
    }

    private void stopIdle(class_1657 player) {
        if (player != null) {
            for (class_1268 hand : this.idleHands) {
                BoneAnimationController.stop(player, hand, "Idle", this.idleClipName(hand));
            }
        }
        this.idleHands.clear();
        this.idleClips.clear();
    }

    private void stopIdleForHand(class_1657 player, class_1268 hand) {
        if (hand == null) {
            return;
        }
        String clip = this.idleClips.remove(hand);
        if (this.idleHands.remove(hand) && player != null) {
            BoneAnimationController.stop(player, hand, "Idle", clip == null ? "idle" : clip);
        }
    }

    private boolean isHandBusy(class_1268 hand) {
        if (hand == null) {
            return true;
        }
        if (this.flintAndSteelDualActive && hand == this.flintAndSteelProxyHand) {
            return true;
        }
        switch (this.activationSource.ordinal()) {
            case 1: 
            case 2: {
                if (hand != this.activationHand) break;
                return true;
            }
            case 3: {
                if (hand != this.useAnimationHand) break;
                return true;
            }
        }
        if (this.consuming && hand == this.consumeHand) {
            return true;
        }
        if (this.shieldActive && hand == this.shieldHand) {
            return true;
        }
        if (this.spyglassActive && hand == this.spyglassHand) {
            return true;
        }
        if (this.rangedChargeActive) {
            if (hand == this.rangedChargeWeaponHand) {
                return true;
            }
            if (this.rangedChargeArrowHand != null && hand == this.rangedChargeArrowHand) {
                return true;
            }
        }
        if (this.rangedReleaseStopTimes.containsKey(hand)) {
            return true;
        }
        if (this.fallingHands.contains(hand)) {
            return true;
        }
        if (this.walkOnWaterActive && this.walkOnWaterHands.contains(hand)) {
            return true;
        }
        if (this.walkActive && this.walkingHands.contains(hand)) {
            return true;
        }
        if (this.jumpHands.contains(hand) || this.jumpStopTimes.containsKey(hand)) {
            return true;
        }
        if (this.landingStopTimes.containsKey(hand)) {
            return true;
        }
        return this.swimmingHands.contains(hand) || this.fallToWaterHands.contains(hand);
    }

    private void ensureIdleAfterAction(class_746 player, class_1268 hand) {
        if (player == null) {
            return;
        }
        if (!(hand == null || hand == class_1268.field_5810 && this.offhandHoldActive)) {
            this.tryStartIdle(player, hand);
        }
        this.ensureIdle(class_310.method_1551());
    }

    private void applyIdleSpringImpulse(class_1268 hand) {
    }

    private void applyIdleSpringImpulse(class_1268 hand, float strength) {
        if (hand == null) {
            return;
        }
        IdleSpringState state = this.idleSpringState(hand);
        if (state != null) {
            state.impulse(strength);
        }
    }

    private void applyWalkSpringImpulse(class_1268 hand, double speed) {
        if (hand == null) {
            return;
        }
        WalkSpringState state = this.walkSpringState(hand);
        if (state != null) {
            state.impulse(speed);
        }
    }

    private void tryStartIdle(class_746 player, class_1268 hand) {
        if (player == null || hand == null) {
            return;
        }
        if (hand == class_1268.field_5810 && this.offhandHoldActive) {
            return;
        }
        if (this.hasIdleTransitionInFlight(hand)) {
            return;
        }
        class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, hand);
        if (held == null || !ProxyItemHelper.requiresProxy(held)) {
            this.stopIdleForHand((class_1657)player, hand);
            return;
        }
        if (this.isHandBusy(hand)) {
            this.stopIdleForHand((class_1657)player, hand);
            return;
        }
        String nextClip = this.idleClipForHand(held);
        if (this.idleHands.contains(hand)) {
            String currentClip = this.idleClips.get(hand);
            if (!nextClip.equals(currentClip)) {
                AnimatedTool.markNextActionHand(hand);
                BoneAnimationController.trigger((class_1657)player, hand, "Idle", nextClip);
                this.idleClips.put(hand, nextClip);
            }
            return;
        }
        AnimatedTool.markNextActionHand(hand);
        BoneAnimationController.trigger((class_1657)player, hand, "Idle", nextClip);
        this.idleHands.add(hand);
        this.idleClips.put(hand, nextClip);
    }

    private String idleClipName(class_1268 hand) {
        return this.idleClips.getOrDefault(hand == null ? class_1268.field_5808 : hand, "idle");
    }

    private String idleClipForHand(class_1799 stack) {
        if (PunchyClient.isLantern(stack)) {
            return "idle_lantern";
        }
        return "idle";
    }

    private String walkClipForHand(class_1799 stack) {
        if (PunchyClient.isLantern(stack)) {
            return "walk_lantern";
        }
        return "walk";
    }

    private static boolean isLantern(class_1799 stack) {
        if (stack == null) {
            return false;
        }
        if (stack.method_31574(class_1802.field_16539) || stack.method_31574(class_1802.field_22016)) {
            return true;
        }
        return ToolKindResolver.isPendulumFlower(stack);
    }

    private void updateCameraLag(class_310 client, float partialTicks) {
        class_746 player = client.field_1724;
        if (player == null) {
            this.resetCameraLag();
            return;
        }
        class_1937 level = player.method_37908();
        float yaw = player.method_5705(partialTicks);
        float pitch = player.method_5695(partialTicks);
        if (Float.isNaN(this.lastCameraYaw) || Float.isNaN(this.lastCameraPitch)) {
            this.lastCameraYaw = yaw;
            this.lastCameraPitch = pitch;
            this.yawLag = 0.0f;
            this.pitchLag = 0.0f;
            this.cameraTiltMainDeg = 0.0f;
            this.cameraTiltOffDeg = 0.0f;
            this.cameraAnchorYawDeg = 0.0f;
            this.cameraAnchorPitchDeg = 0.0f;
            return;
        }
        float prevYaw = this.lastCameraYaw;
        float prevPitch = this.lastCameraPitch;
        this.lastCameraYaw = yaw;
        this.lastCameraPitch = pitch;
        float yawDelta = class_3532.method_15393((float)(yaw - prevYaw));
        float pitchDelta = pitch - prevPitch;
        this.lastCameraYawDelta = yawDelta;
        this.lastCameraPitchDelta = pitchDelta;
        float yawContribution = class_3532.method_15363((float)(yawDelta * 1.55f), (float)-20.0f, (float)20.0f);
        this.yawLag = this.yawLag * 0.78f + yawContribution * 0.22f;
        float pitchContribution = class_3532.method_15363((float)(pitchDelta * 1.5f), (float)-26.0f, (float)26.0f);
        this.pitchLag = this.pitchLag * 0.78f + pitchContribution * 0.22f;
        float downward = -Math.max(0.0f, this.pitchLag * 1.85f);
        downward = class_3532.method_15363((float)downward, (float)-26.0f, (float)0.0f);
        float yawTilt = class_3532.method_15363((float)(this.yawLag * 1.3f), (float)-19.0f, (float)19.0f);
        this.cameraTiltMainDeg = class_3532.method_15363((float)(downward - yawTilt), (float)-24.0f, (float)24.0f);
        this.cameraTiltOffDeg = class_3532.method_15363((float)(downward + yawTilt), (float)-24.0f, (float)24.0f);
        this.cameraTiltMainSmoothDeg = class_3532.method_16439((float)0.4f, (float)this.cameraTiltMainSmoothDeg, (float)this.cameraTiltMainDeg);
        this.cameraTiltOffSmoothDeg = class_3532.method_16439((float)0.4f, (float)this.cameraTiltOffSmoothDeg, (float)this.cameraTiltOffDeg);
        float lateral = class_3532.method_15363((float)(this.yawLag * 0.004575f), (float)-0.12f, (float)0.12f);
        float vertical = class_3532.method_15363((float)(-this.pitchLag * 0.0061f), (float)-0.175f, (float)0.175f);
        float depth = class_3532.method_15363((float)(yawDelta * 0.002f + pitchDelta * 0.0034f), (float)-0.11f, (float)0.11f);
        float mainTargetX = -lateral;
        float mainTargetY = vertical;
        float mainTargetZ = depth;
        float offTargetX = lateral * 1.1f;
        float offTargetY = vertical * 0.9f;
        float offTargetZ = -depth * 0.8f;
        this.cameraTiltMainOffsetX = class_3532.method_16439((float)0.3f, (float)this.cameraTiltMainOffsetX, (float)mainTargetX);
        this.cameraTiltMainOffsetY = class_3532.method_16439((float)0.3f, (float)this.cameraTiltMainOffsetY, (float)mainTargetY);
        this.cameraTiltMainOffsetZ = class_3532.method_16439((float)0.3f, (float)this.cameraTiltMainOffsetZ, (float)mainTargetZ);
        this.cameraTiltOffOffsetX = class_3532.method_16439((float)0.3f, (float)this.cameraTiltOffOffsetX, (float)offTargetX);
        this.cameraTiltOffOffsetY = class_3532.method_16439((float)0.3f, (float)this.cameraTiltOffOffsetY, (float)offTargetY);
        this.cameraTiltOffOffsetZ = class_3532.method_16439((float)0.3f, (float)this.cameraTiltOffOffsetZ, (float)offTargetZ);
        float yawAnchorTargetDeg = class_3532.method_15363((float)(this.yawLag * 0.65f), (float)-14.0f, (float)14.0f);
        float pitchAnchorTargetDeg = class_3532.method_15363((float)(this.pitchLag * 0.65f), (float)-14.0f, (float)14.0f);
        this.cameraAnchorYawDeg = class_3532.method_16439((float)0.35f, (float)this.cameraAnchorYawDeg, (float)yawAnchorTargetDeg);
        this.cameraAnchorPitchDeg = class_3532.method_16439((float)0.35f, (float)this.cameraAnchorPitchDeg, (float)pitchAnchorTargetDeg);
    }

    private void resetCameraLag() {
        this.lastCameraYaw = Float.NaN;
        this.lastCameraPitch = Float.NaN;
        this.yawLag = 0.0f;
        this.pitchLag = 0.0f;
        this.cameraTiltMainDeg = 0.0f;
        this.cameraTiltOffDeg = 0.0f;
        this.cameraTiltMainSmoothDeg = 0.0f;
        this.cameraTiltOffSmoothDeg = 0.0f;
        this.cameraTiltMainOffsetX = 0.0f;
        this.cameraTiltMainOffsetY = 0.0f;
        this.cameraTiltMainOffsetZ = 0.0f;
        this.cameraTiltOffOffsetX = 0.0f;
        this.cameraTiltOffOffsetY = 0.0f;
        this.cameraTiltOffOffsetZ = 0.0f;
        this.cameraAnchorYawDeg = 0.0f;
        this.cameraAnchorPitchDeg = 0.0f;
        this.lastCameraYawDelta = 0.0f;
        this.lastCameraPitchDelta = 0.0f;
        this.lastCameraLogTick = Long.MIN_VALUE;
        this.lastLoggedCameraMain = Float.NaN;
        this.lastLoggedCameraOff = Float.NaN;
    }

    public static float cameraTiltRadians(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null || Boolean.TRUE.equals(CAMERA_TILT_LOCK.get())) {
            return 0.0f;
        }
        float deg = hand == class_1268.field_5810 ? inst.cameraTiltOffSmoothDeg : inst.cameraTiltMainSmoothDeg;
        return (float)Math.toRadians(deg);
    }

    public static class_243 cameraTiltOffset(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null || Boolean.TRUE.equals(CAMERA_TILT_LOCK.get())) {
            return class_243.field_1353;
        }
        if (hand == class_1268.field_5810) {
            return new class_243((double)inst.cameraTiltOffOffsetX, (double)inst.cameraTiltOffOffsetY, (double)inst.cameraTiltOffOffsetZ);
        }
        return new class_243((double)inst.cameraTiltMainOffsetX, (double)inst.cameraTiltMainOffsetY, (double)inst.cameraTiltMainOffsetZ);
    }

    public static float cameraAnchorYawRadians() {
        PunchyClient inst = INSTANCE;
        if (inst == null || Boolean.TRUE.equals(CAMERA_TILT_LOCK.get())) {
            return 0.0f;
        }
        return (float)Math.toRadians(inst.cameraAnchorYawDeg);
    }

    public static float cameraAnchorYawRadiansRaw() {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 0.0f;
        }
        return (float)Math.toRadians(inst.cameraAnchorYawDeg);
    }

    public static float cameraAnchorPitchRadians() {
        PunchyClient inst = INSTANCE;
        if (inst == null || Boolean.TRUE.equals(CAMERA_TILT_LOCK.get())) {
            return 0.0f;
        }
        return (float)Math.toRadians(inst.cameraAnchorPitchDeg);
    }

    public static float cameraAnchorPitchRadiansRaw() {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 0.0f;
        }
        return (float)Math.toRadians(inst.cameraAnchorPitchDeg);
    }

    public static AutoCloseable pushDisableCameraTilt() {
        Boolean previous = CAMERA_TILT_LOCK.get();
        CAMERA_TILT_LOCK.set(Boolean.TRUE);
        return () -> CAMERA_TILT_LOCK.set(previous);
    }

    private class_1268 findAttackHand(class_746 player) {
        if (player == null) {
            return null;
        }
        class_1268 hand = PunchyClient.findProxyHand(player);
        hand = PunchyClient.preferMainHandWhenProxyingFor(player, hand);
        if (!this.shieldActive || hand == null) {
            return PunchyClient.mapToPlayerMainHand(player, hand);
        }
        if (hand != this.shieldHand) {
            return PunchyClient.mapToPlayerMainHand(player, hand);
        }
        class_1268 other = this.shieldHand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        class_1799 otherStack = HandHelper.getConfiguredHandItem((class_1657)player, other);
        class_1268 result = ProxyItemHelper.requiresProxy(otherStack) ? other : null;
        return PunchyClient.mapToPlayerMainHand(player, result);
    }

    private static class_1268 mapToPlayerMainHand(class_746 player, class_1268 hand) {
        if (hand == null || player == null) {
            return hand;
        }
        if (hand == class_1268.field_5808) {
            return PunchyClient.mainHandFor(player);
        }
        if (hand == class_1268.field_5810) {
            return PunchyClient.offHandFor(player);
        }
        return hand;
    }

    private static class_1268 mainHandFor(class_746 player) {
        return player.method_6068() == class_1306.field_6182 ? class_1268.field_5810 : class_1268.field_5808;
    }

    private static class_1268 offHandFor(class_746 player) {
        return PunchyClient.mainHandFor(player) == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
    }

    private static class_1268 findProxyHand(class_746 player) {
        boolean offHasItem;
        if (player == null) {
            return null;
        }
        class_1799 main = HandHelper.getConfiguredMainHandItem((class_1657)player);
        class_1799 off = HandHelper.getConfiguredOffHandItem((class_1657)player);
        boolean mainHasItem = main != null && !main.method_7960();
        boolean bl = offHasItem = off != null && !off.method_7960();
        if (mainHasItem && ProxyItemHelper.requiresProxy(main)) {
            return class_1268.field_5808;
        }
        if (offHasItem && ProxyItemHelper.requiresProxy(off)) {
            return class_1268.field_5810;
        }
        if (ProxyItemHelper.requiresProxy(main)) {
            return class_1268.field_5808;
        }
        if (ProxyItemHelper.requiresProxy(off)) {
            return class_1268.field_5810;
        }
        return null;
    }

    private static class_1268 preferMainHandWhenProxyingFor(class_746 player, class_1268 candidate) {
        if (candidate != class_1268.field_5810 || player == null) {
            return candidate;
        }
        class_1799 main = HandHelper.getConfiguredMainHandItem((class_1657)player);
        class_1799 off = HandHelper.getConfiguredOffHandItem((class_1657)player);
        if ((main == null || main.method_7960()) && off != null && !off.method_7960()) {
            return class_1268.field_5808;
        }
        return candidate;
    }

    public static double walkSpeedForHand(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null || hand == null) {
            return 1.0;
        }
        return inst.walkSpeedByHand.getOrDefault(hand, 1.0);
    }

    public static double walkOnWaterAnimationSpeed() {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 1.0;
        }
        return inst.walkOnWaterAnimSpeed;
    }

    private static EnumSet<class_1268> collectProxyHands(class_1657 player) {
        EnumSet<class_1268> hands = EnumSet.noneOf(class_1268.class);
        if (player == null) {
            return hands;
        }
        for (class_1268 hand : class_1268.values()) {
            class_1799 held = HandHelper.getConfiguredHandItem(player, hand);
            if (!ProxyItemHelper.requiresProxy(held)) continue;
            hands.add(hand);
        }
        return hands;
    }

    private static boolean isMovingHorizontally(class_1657 player) {
        if (player == null) {
            return false;
        }
        class_243 motion = player.method_18798();
        if (motion.method_37268() > 1.0E-4) {
            return true;
        }
        if (player instanceof class_746) {
            class_746 local = (class_746)player;
            return (double)Math.abs(local.field_6250) > 0.001 || (double)Math.abs(local.field_6212) > 0.001;
        }
        return false;
    }

    private static boolean isBlockItem(class_1799 stack) {
        return stack != null && !stack.method_7960() && stack.method_7909() instanceof class_1747;
    }

    private static boolean isConsumable(class_1799 stack) {
        return stack != null && !stack.method_7960() && stack.method_57826(class_9334.field_50075);
    }

    private static boolean isEmptyHand(class_1799 stack) {
        return stack == null || stack.method_7960();
    }

    private static void applyMovementArmVisibility(class_1657 player, class_1268 hand) {
        class_1799 held;
        if (hand == null) {
            return;
        }
        class_1799 class_17992 = held = player == null ? class_1799.field_8037 : HandHelper.getConfiguredHandItem(player, hand);
        if (PunchyClient.isEmptyHand(held)) {
            ArmAnimationOverrides.clear(hand);
            return;
        }
        ArmAnimationOverrides.setForceRender(hand, true);
    }

    private static void registerInspectKey() {
        if (inspectKey != null) {
            return;
        }
        inspectKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.inspect", class_3675.class_307.field_1668, 73, "key.categories.misc"));
    }

    private static boolean isSupportedBySolid(class_1657 player) {
        if (player == null) {
            return false;
        }
        return player.method_24828() || player.field_36331;
    }

    private static boolean isTouchingGroundOrLiquid(class_1657 player) {
        if (player == null) {
            return false;
        }
        return player.method_24828() || player.field_36331 || player.method_5799() || player.method_5771();
    }

    private static boolean isProjectileWeapon(class_1799 stack) {
        return stack != null && !stack.method_7960() && (stack.method_7909() instanceof class_1753 || stack.method_7909() instanceof class_1764);
    }

    private static boolean isEmptyBucket(class_1799 stack) {
        return stack != null && stack.method_31574(class_1802.field_8550);
    }

    private static boolean isBucket(class_1799 stack) {
        return stack != null && !stack.method_7960() && stack.method_7909() instanceof class_1755;
    }

    private static boolean isFilledBucket(class_1799 stack) {
        return PunchyClient.isBucket(stack) && !PunchyClient.isEmptyBucket(stack);
    }

    private static boolean isShield(class_1799 stack) {
        return stack != null && stack.method_7909() instanceof class_1819;
    }

    private static boolean isFishingRod(class_1799 stack) {
        return stack != null && stack.method_7909() instanceof class_1787;
    }

    private static boolean isThrowableItem(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        return item instanceof class_1823 || item instanceof class_1771 || item instanceof class_1776 || item instanceof class_1779 || item instanceof class_4537 || item instanceof class_1835;
    }

    private static boolean isBrush(class_1799 stack) {
        return stack != null && stack.method_31574(class_1802.field_42716);
    }

    private static boolean isLead(class_1799 stack) {
        return stack != null && stack.method_31574(class_1802.field_8719);
    }

    private static String resolveRightClickClip(class_1799 stack, boolean interactingWithBlock) {
        if (PunchyClient.isEmptyHand(stack)) {
            return interactingWithBlock ? "insert" : PUNCH_TRIGGER;
        }
        if (interactingWithBlock) {
            if (stack.method_7909() instanceof class_1786) {
                return FLINT_STEEL_CLIP;
            }
            if (PunchyClient.isEmptyBucket(stack)) {
                return "bucket_fill";
            }
            if (PunchyClient.isFilledBucket(stack)) {
                return "bucket_throw";
            }
            if (PunchyClient.isBrush(stack)) {
                return "usebrush";
            }
            if (stack.method_7909() instanceof class_1826 || PunchyClient.isBlockItem(stack) || PunchyClient.isLead(stack)) {
                return "insert";
            }
            if (PunchyClient.isToolSwayItem(stack)) {
                return PunchyClient.resolveToolLoopClip(stack);
            }
            if (PunchyClient.isThrowableItem(stack)) {
                return "sway_throw";
            }
            return "insert";
        }
        if (PunchyClient.isShield(stack)) {
            return "rise_shield";
        }
        if (PunchyClient.isFishingRod(stack)) {
            return "fishing";
        }
        if (PunchyClient.isProjectileWeapon(stack)) {
            return "attack";
        }
        if (PunchyClient.isThrowableItem(stack)) {
            return "sway_throw";
        }
        if (PunchyClient.isBrush(stack)) {
            return "usebrush";
        }
        if (PunchyClient.isToolSwayItem(stack)) {
            return PunchyClient.resolveToolLoopClip(stack);
        }
        if (PunchyClient.isBlockItem(stack) || PunchyClient.isLead(stack)) {
            return "insert";
        }
        if (PunchyClient.isConsumable(stack)) {
            return PUNCH_TRIGGER;
        }
        return "insert";
    }

    public static LanternPose lanternPhysics(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return LanternPose.ZERO;
        }
        return inst.lanternPhysicsPose(hand);
    }

    public static float lanternGripBlend(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 0.0f;
        }
        LanternGripState state = inst.lanternGrips.get(hand == null ? class_1268.field_5808 : hand);
        return state == null ? 0.0f : state.blend();
    }

    public static float lanternGripDeltaX(boolean leftHand) {
        return leftHand ? -0.16f : 0.16f;
    }

    public static float lanternGripDeltaY() {
        return 0.14f;
    }

    public static float lanternGripDeltaZ() {
        return 0.08f;
    }

    public static void nudgeLantern(class_1268 hand, float forwardImpulse, float lateralImpulse) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return;
        }
        LanternPhysicsState state = inst.lanternPhysics.get(hand == null ? class_1268.field_5808 : hand);
        if (state != null) {
            state.impulse(forwardImpulse, lateralImpulse);
        }
    }

    private LanternPose lanternPhysicsPose(class_1268 hand) {
        LanternPhysicsState state = this.lanternPhysics.get(hand == null ? class_1268.field_5808 : hand);
        return state == null ? LanternPose.ZERO : state.snapshot();
    }

    private JumpSpringState jumpSpringState(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return this.jumpSprings.computeIfAbsent(resolved, h -> new JumpSpringState());
    }

    private IdleSpringState idleSpringState(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return this.idleSprings.computeIfAbsent(resolved, h -> new IdleSpringState());
    }

    public static IdleSpringPose idleSpringPose(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return IdleSpringPose.ZERO;
        }
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        IdleSpringState state = inst.idleSprings.get(resolved);
        return state == null ? IdleSpringPose.ZERO : state.snapshot();
    }

    private WalkSpringState walkSpringState(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return this.walkSprings.computeIfAbsent(resolved, h -> new WalkSpringState());
    }

    public static WalkSpringPose walkSpringPose(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return WalkSpringPose.ZERO;
        }
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        WalkSpringState state = inst.walkSprings.get(resolved);
        return state == null ? WalkSpringPose.ZERO : state.snapshot();
    }

    private SneakSpringState sneakSpringState(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return this.sneakSprings.computeIfAbsent(resolved, h -> new SneakSpringState());
    }

    public static JumpSpringPose jumpSpringPose(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return JumpSpringPose.ZERO;
        }
        JumpSpringState state = inst.jumpSprings.get(hand == null ? class_1268.field_5808 : hand);
        return state == null ? JumpSpringPose.ZERO : state.snapshot();
    }

    public static float sneakOffset(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 0.0f;
        }
        SneakSpringState state = inst.sneakSprings.get(hand == null ? class_1268.field_5808 : hand);
        return state == null ? 0.0f : state.offset();
    }

    public static JumpSpringPivot jumpSpringPivot() {
        return SPRING_PIVOT;
    }

    private static String randomizeLoopClip(String clip) {
        return PunchyClient.randomizeLoopClip(clip, null);
    }

    private static String randomizeLoopClip(String clip, String avoid) {
        if (clip == null || clip.isEmpty()) {
            return clip;
        }
        return switch (clip) {
            case "sway_forward" -> PunchyClient.rollWeightedVariant("sway_forward", "sway_forward_2", "sway_forward_3", 0.85, 0.15, avoid);
            case "sway_sideways" -> PunchyClient.rollWeightedVariant("sway_sideways", "sway_sideways_2", "sway_sideways_3", 0.85, 0.15, avoid);
            default -> clip;
        };
    }

    private static String resolveAttackClip(class_1799 stack, boolean entityTarget, String avoid) {
        LeftActionProfile profile = PunchyClient.resolveLeftActionProfile(stack);
        return switch (profile.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> "trident_attack";
            case 4 -> "attack_mace";
            case 2 -> PunchyClient.randomSwordClip(avoid);
            case 0 -> "attack";
            case 1 -> entityTarget ? PUNCH_ATTACK_TRIGGER : PUNCH_TRIGGER;
        };
    }

    private static String randomSwordClip(String avoid) {
        if (SWORD_ATTACK_VARIANTS.length == 0) {
            return "attack";
        }
        for (int attempt = 0; attempt < 4; ++attempt) {
            String pick = SWORD_ATTACK_VARIANTS[ThreadLocalRandom.current().nextInt(SWORD_ATTACK_VARIANTS.length)];
            if (avoid != null && avoid.equals(pick)) continue;
            return pick;
        }
        return avoid == null ? "attack" : avoid;
    }

    private static String rollWeightedVariant(String primary, String secondary, String tertiary) {
        return PunchyClient.rollWeightedVariant(primary, secondary, tertiary, 0.85, 0.15, null);
    }

    private static String rollWeightedVariant(String primary, String secondary, String tertiary, double primaryWeight, double secondaryWeight, String avoid) {
        double tertiaryWeight = 1.0 - (primaryWeight + secondaryWeight);
        for (int attempt = 0; attempt < 4; ++attempt) {
            double roll = ThreadLocalRandom.current().nextDouble();
            String pick = roll < primaryWeight ? primary : (roll < primaryWeight + secondaryWeight ? secondary : tertiary);
            if (avoid != null && Objects.equals(pick, avoid)) continue;
            return pick;
        }
        return avoid == null ? primary : avoid;
    }

    private static int resolveUseAnimationTicks(String clip) {
        if (PunchyClient.isBucketClip(clip)) {
            return 40;
        }
        return 6;
    }

    private int resolveUseAnimationTicks(class_746 player, class_1268 hand, String clip) {
        double seconds = this.clipDurationSeconds((class_1657)player, hand, clip);
        if (seconds <= 0.0) {
            seconds = 0.05;
        }
        int ticks = (int)Math.ceil(seconds * 20.0);
        return Math.max(1, ticks);
    }

    private static boolean isBucketClip(String clip) {
        return "bucket_fill".equals(clip) || "bucket_throw".equals(clip);
    }

    private void suppressNextSelect(class_1268 hand) {
        this.selectSuppressionHands.add(hand == null ? class_1268.field_5808 : hand);
    }

    private boolean consumeSelectSuppression(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return this.selectSuppressionHands.remove(resolved);
    }

    private void storeLastStack(class_1268 hand, class_1799 stack) {
        class_1799 snapshot;
        class_1799 class_17992 = snapshot = stack == null ? class_1799.field_8037 : stack.method_7972();
        if (hand == class_1268.field_5808) {
            this.lastMainhandStack = snapshot;
        } else {
            this.lastOffhandStack = snapshot;
        }
        if (hand == class_1268.field_5808 && this.mainHandSwapState.stage == MainHandSwapStage.IDLE) {
            this.mainHandSwapState.displayed = snapshot;
            this.mainHandSwapState.pending = class_1799.field_8037;
            this.mainHandSwapState.restartAfterRaise = false;
        }
    }

    private class_1799 lastStackForHand(class_1268 hand) {
        return hand == class_1268.field_5810 ? this.lastOffhandStack : this.lastMainhandStack;
    }

    private class_1799 stackForClipResolution(class_1799 currentStack, class_1268 hand) {
        boolean previousDiffers;
        class_1799 previous = this.lastStackForHand(hand);
        if (previous == null || previous.method_7960()) {
            return currentStack;
        }
        boolean bl = previousDiffers = currentStack == null || currentStack.method_7960() || previous.method_7909() != currentStack.method_7909();
        if (previousDiffers && PunchyClient.isBucket(previous)) {
            return previous;
        }
        return currentStack;
    }

    private void resetMainHandSwapState() {
        this.pendingOffhandLowerSync = false;
        this.endOffhandRenderOverride();
        class_1799 fallback = this.lastMainhandStack == null ? class_1799.field_8037 : this.lastMainhandStack;
        this.mainHandSwapState.reset(fallback);
        this.clearMainHandSwapHide();
    }

    private void clearMainHandSwapHide() {
        if (this.mainHandHiddenForSwap) {
            HandItemOverrides.setHidden(class_1268.field_5808, false);
            this.mainHandHiddenForSwap = false;
        }
    }

    private class_1799 currentMainHandOverride(class_1799 fallback) {
        class_1799 previous;
        class_1799 safeFallback = fallback == null ? class_1799.field_8037 : fallback;
        class_1799 class_17992 = previous = this.lastMainhandStack == null ? class_1799.field_8037 : this.lastMainhandStack;
        if (this.mainHandSwapState.stage == MainHandSwapStage.IDLE) {
            if (!class_1799.method_31577((class_1799)previous, (class_1799)safeFallback)) {
                return previous;
            }
            return safeFallback;
        }
        return this.mainHandSwapState.displayedOr(safeFallback);
    }

    private class_1799 stackForAttackResolution(class_1799 currentStack, class_1268 hand) {
        class_1799 previous;
        if (currentStack != null && currentStack.method_7909() == Punchy.boneProxy() && (previous = this.lastStackForHand(hand)) != null && !previous.method_7960()) {
            return previous;
        }
        return currentStack;
    }

    private static String resolveBlockLoopClip(class_1799 stack) {
        if (stack == null) {
            return PUNCH_TRIGGER;
        }
        return switch (PunchyClient.resolveLeftActionProfile(stack).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PunchyClient.resolveToolLoopClip(stack);
            case 1, 2, 3, 4 -> PUNCH_TRIGGER;
        };
    }

    private static boolean isToolSwayItem(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_7909() instanceof class_1835 || PunchyClient.isSwordItem(stack)) {
            return false;
        }
        return stack.method_31573(class_3489.field_42614) || stack.method_31573(class_3489.field_42613) || stack.method_31573(class_3489.field_42612) || stack.method_31573(class_3489.field_42615);
    }

    private static String resolveToolLoopClip(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return "sway_forward";
        }
        if (stack.method_31573(class_3489.field_42612)) {
            return "sway_sideways";
        }
        if (stack.method_31573(class_3489.field_42615)) {
            return "sway_digging";
        }
        return "sway_forward";
    }

    private static LeftActionProfile resolveLeftActionProfile(class_1799 stack) {
        if (stack == null) {
            return LeftActionProfile.PUNCH_ONLY;
        }
        if (stack.method_7909() instanceof class_1835) {
            return LeftActionProfile.TRIDENT;
        }
        if (stack.method_7909() instanceof class_9362) {
            return LeftActionProfile.MACE;
        }
        if (PunchyClient.isSwordItem(stack)) {
            return LeftActionProfile.SWORD;
        }
        if (stack.method_31573(class_3489.field_42614) || stack.method_31573(class_3489.field_42615) || stack.method_31573(class_3489.field_42612) || stack.method_31573(class_3489.field_42613)) {
            return LeftActionProfile.TOOL_SWAY;
        }
        return LeftActionProfile.PUNCH_ONLY;
    }

    private void updateLanternPhysics(class_310 client) {
        int i;
        class_746 player = client.field_1724;
        class_1268[] hands = class_1268.values();
        LanternPhysicsState[] states = new LanternPhysicsState[hands.length];
        LanternGripState[] gripStates = new LanternGripState[hands.length];
        boolean[] physicsFlags = new boolean[hands.length];
        boolean[] leftFlags = new boolean[hands.length];
        boolean[] gripTargets = new boolean[hands.length];
        long now = System.nanoTime();
        float rawDt = Math.max(0.0f, (float)(now - this.lastLanternTickTime) / 1.0E9f);
        this.lastLanternTickTime = now;
        if (client.method_1493()) {
            rawDt = 0.0f;
        }
        for (i = 0; i < hands.length; ++i) {
            boolean left;
            LanternGripState gripState;
            LanternPhysicsState state;
            class_1268 hand = hands[i];
            states[i] = state = this.lanternPhysics.computeIfAbsent(hand, h -> new LanternPhysicsState());
            gripStates[i] = gripState = this.lanternGrips.computeIfAbsent(hand, h -> new LanternGripState());
            boolean active = false;
            if (player != null) {
                class_1799 held = HandHelper.getConfiguredHandItem((class_1657)player, hand);
                active = held != null && !held.method_7960() && PunchyClient.isLantern(held) && ProxyItemHelper.requiresProxy(held);
            } else {
                state.reset();
                gripState.reset();
            }
            leftFlags[i] = left = hand == class_1268.field_5810;
            physicsFlags[i] = active && Punchy.JUMP_PHYSICS_ENABLED;
            gripTargets[i] = active;
            if (player == null) continue;
            state.setBasePose(player, hand);
        }
        for (i = 0; i < hands.length; ++i) {
            LanternGripState gripState = gripStates[i];
            if (gripState == null) continue;
            gripState.tick(gripTargets[i], rawDt);
        }
        if (!Punchy.JUMP_PHYSICS_ENABLED || player == null || player.method_37908() == null) {
            this.lanternTimeRemainder = 0.0f;
            return;
        }
        this.lanternTimeRemainder = class_3532.method_15363((float)(this.lanternTimeRemainder + rawDt), (float)0.0f, (float)0.5f);
        float targetStep = 0.016666668f;
        long gameTime = player.method_37908().method_8510();
        int guard = 0;
        while (this.lanternTimeRemainder >= 0.016666668f && guard < 8) {
            this.lanternTimeRemainder -= 0.016666668f;
            ++guard;
            for (int i2 = 0; i2 < hands.length; ++i2) {
                LanternPhysicsState state = states[i2];
                if (state == null) continue;
                state.tick(player, physicsFlags[i2], leftFlags[i2], this.lastCameraYawDelta, this.lastCameraPitchDelta, 0.016666668f, gameTime);
            }
        }
    }

    private void updateJumpSprings(class_310 client) {
        long tick;
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            this.resetJumpSpringStates();
            return;
        }
        long now = System.nanoTime();
        float rawDt = Math.max(0.0f, (float)(now - this.lastSpringTickTime) / 1.0E9f);
        this.lastSpringTickTime = now;
        if (client.method_1493()) {
            rawDt = 0.0f;
        }
        this.springTimeRemainder = class_3532.method_15363((float)(this.springTimeRemainder + rawDt), (float)0.0f, (float)0.5f);
        float targetStep = 0.016666668f;
        class_1268[] hands = class_1268.values();
        class_746 player = client.field_1724;
        JumpSpringState[] states = new JumpSpringState[hands.length];
        SneakSpringState[] sneakStates = new SneakSpringState[hands.length];
        boolean[] activeFlags = new boolean[hands.length];
        boolean[] leftFlags = new boolean[hands.length];
        boolean[] sneakFlags = new boolean[hands.length];
        boolean playerSneaking = player != null && player.method_18276();
        for (int i = 0; i < hands.length; ++i) {
            SneakSpringState sneakState;
            boolean active;
            class_1268 hand = hands[i];
            states[i] = this.jumpSpringState(hand);
            leftFlags[i] = hand == class_1268.field_5810;
            activeFlags[i] = active = player != null && ProxyItemHelper.requiresProxy(HandHelper.getConfiguredHandItem((class_1657)player, hand));
            sneakStates[i] = sneakState = this.sneakSpringState(hand);
            boolean sneakActive = playerSneaking && active;
            sneakState.setSneaking(sneakActive);
            sneakFlags[i] = sneakActive;
        }
        int guard = 0;
        class_638 level = client.field_1687;
        long l = tick = level != null ? level.method_8510() : Long.MIN_VALUE;
        while (this.springTimeRemainder >= 0.016666668f && guard < 8) {
            this.springTimeRemainder -= 0.016666668f;
            ++guard;
            for (int i = 0; i < hands.length; ++i) {
                JumpSpringState state = states[i];
                state.tick(activeFlags[i], leftFlags[i], 0.016666668f);
                long logTick = tick != Long.MIN_VALUE ? tick : -1L;
                this.logJumpSpringPose(hands[i], state.snapshot(), activeFlags[i], sneakFlags[i], leftFlags[i], logTick, guard);
                SneakSpringState sneakState = sneakStates[i];
                if (sneakState == null) continue;
                sneakState.tick(0.016666668f);
            }
        }
    }

    private void updateIdleSprings(class_310 client) {
        if (client == null) {
            this.resetIdleSpringStates();
            return;
        }
        long now = System.nanoTime();
        float rawDt = Math.max(0.0f, (float)(now - this.lastIdleTickTime) / 1.0E9f);
        this.lastIdleTickTime = now;
        if (client.method_1493()) {
            rawDt = 0.0f;
        }
        this.idleTimeRemainder = class_3532.method_15363((float)(this.idleTimeRemainder + rawDt), (float)0.0f, (float)0.5f);
        float targetStep = 0.016666668f;
        class_1268[] hands = class_1268.values();
        class_746 player = client.field_1724;
        boolean[] activeFlags = new boolean[hands.length];
        boolean[] leftFlags = new boolean[hands.length];
        for (int i = 0; i < hands.length; ++i) {
            class_1268 hand = hands[i];
            leftFlags[i] = hand == class_1268.field_5810;
            class_1799 held = player != null ? HandHelper.getConfiguredHandItem((class_1657)player, hand) : class_1799.field_8037;
            activeFlags[i] = held != null && !held.method_7960() && ProxyItemHelper.requiresProxy(held);
        }
        int guard = 0;
        while (this.idleTimeRemainder >= 0.016666668f && guard < 8) {
            this.idleTimeRemainder -= 0.016666668f;
            ++guard;
            for (int i = 0; i < hands.length; ++i) {
                IdleSpringState state = this.idleSpringState(hands[i]);
                if (state == null) continue;
                state.tick(activeFlags[i], leftFlags[i], 0.016666668f);
            }
        }
    }

    private void logJumpSpringPose(class_1268 hand, JumpSpringPose pose, boolean active, boolean sneaking, boolean leftHand, long tick, int iteration) {
        boolean changed;
        JumpSpringPose lastPose = this.lastLoggedJumpSpringPoses.get(hand);
        boolean bl = changed = lastPose == null || Math.abs(pose.rotX() - lastPose.rotX()) > 0.01f || Math.abs(pose.rotZ() - lastPose.rotZ()) > 0.01f || Math.abs(pose.offY() - lastPose.offY()) > 0.005f;
        if (!(changed || tick >= 0L && this.lastJumpSpringLogTick >= 0L && tick - this.lastJumpSpringLogTick >= 10L)) {
            return;
        }
        this.lastLoggedJumpSpringPoses.put(hand, pose);
        if (tick >= 0L) {
            this.lastJumpSpringLogTick = tick;
        }
    }

    public static void onPunchImpact() {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handlePunchImpact();
        }
    }

    public static void onAnimationTriggered(class_1657 player, class_1268 hand, String controller, String clip, long instanceId) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.recordAnimationStart(player, hand, controller, clip, instanceId);
        }
    }

    public static void onAnimationStopped(class_1657 player, class_1268 hand, String controller, String clip, long instanceId) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.recordAnimationStop(player, hand, controller, clip, instanceId);
        }
    }

    public static void onAnimationKeyframe(String controller, String clip, String label, double animationTick) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.recordAnimationKeyframe(controller, clip, label, animationTick);
        }
    }

    public static void onArrowInstruction(boolean equip) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleArrowInstruction(equip);
        }
    }

    private void stopInspect(class_746 player) {
        if (!this.inspectActive) {
            return;
        }
        this.inspectActive = false;
        this.inspectStack = class_1799.field_8037;
        this.inspectStopGameTime = -1L;
        this.inspectBlendTicks = 0;
        if (player != null) {
            BoneAnimationController.stop((class_1657)player, class_1268.field_5808, "Inspect", "inspect_my_item");
            this.ensureIdleAfterAction(player, class_1268.field_5808);
        }
    }

    private void completeInspect(class_746 player) {
        if (!this.inspectActive) {
            return;
        }
        this.inspectActive = false;
        this.inspectStack = class_1799.field_8037;
        this.inspectStopGameTime = -1L;
        this.inspectBlendTicks = Math.max(this.inspectBlendTicks, 8);
    }

    private static boolean isInspectEligible(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1753 || item instanceof class_1835 || item instanceof class_9362 || stack.method_31573(class_3489.field_42611)) {
            return true;
        }
        return stack.method_31573(class_3489.field_42614) || stack.method_31573(class_3489.field_42612) || stack.method_31573(class_3489.field_42613) || stack.method_31573(class_3489.field_42615);
    }

    private static boolean inspectStacksMatch(class_1799 a, class_1799 b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        return a.method_7909() == b.method_7909();
    }

    public static void onCrossbowItemVisibility(class_1268 hand, boolean hidden) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleCrossbowItemVisibility(hand, hidden);
        }
    }

    public static void onBowAnimationGate() {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.releaseBowSpriteSuppression();
        }
    }

    public static void onSpyglassInstruction() {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.allowSpyglassZoom();
        }
    }

    public static void onUseHandLocked(class_1268 hand, class_1799 stack) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.lockedUseHand = hand == null ? class_1268.field_5808 : hand;
            inst.lockedUseStack = stack == null ? class_1799.field_8037 : stack.method_7972();
        }
    }

    public static void onFlintAndSteelArmIn(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleFlintAndSteelArmIn(hand);
        }
    }

    public static void onFlintAndSteelArmOut(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleFlintAndSteelArmOut(hand);
        }
    }

    public static void onFlintAndSteelSpark(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleFlintAndSteelSpark(hand);
        }
    }

    public static void onShieldImpact(class_746 player) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleShieldImpact(player);
        }
    }

    private void allowSpyglassZoom() {
        if (this.spyglassActive) {
            this.spyglassZoomAllowed = true;
        }
    }

    public static boolean isBowHandSuppressed(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        return inst != null && inst.isSpriteSuppressedFor(hand);
    }

    public static boolean shouldHoldBowAnimation(class_1268 hand, class_1799 stack) {
        PunchyClient inst = INSTANCE;
        return inst != null && inst.shouldHoldBowAnimationFor(hand, stack);
    }

    public static boolean shouldBlockSpyglassZoom(class_746 player) {
        PunchyClient inst = INSTANCE;
        return inst != null && inst.isSpyglassZoomSuppressed(player);
    }

    private boolean shouldHoldBowAnimationFor(class_1268 hand, class_1799 stack) {
        if (!this.isSpriteSuppressedFor(hand)) {
            return false;
        }
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1839 animation = stack.method_7976();
        if (animation == class_1839.field_8953 || animation == class_1839.field_8947) {
            return true;
        }
        class_1792 item = stack.method_7909();
        return item instanceof class_1753 || item instanceof class_1764;
    }

    private boolean isSpyglassZoomSuppressed(class_746 player) {
        if (!this.spyglassActive || this.spyglassZoomAllowed) {
            return false;
        }
        if (player == null || !player.method_6115()) {
            return false;
        }
        class_1799 stack = player.method_6030();
        return stack != null && stack.method_7909() instanceof class_5538;
    }

    private void handlePunchImpact() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        if (this.activationSource != ActivationSource.PUNCH) {
            return;
        }
        boolean stillHolding = client.field_1690.field_1886.method_1434();
    }

    private void recordAnimationStart(class_1657 player, class_1268 hand, String controller, String clip, long instanceId) {
        if (player == null || player.method_37908() == null || clip == null || clip.isEmpty()) {
            return;
        }
        class_1268 safeHand = hand == null ? class_1268.field_5808 : hand;
        String normalizedClip = PunchyClient.normalizeClipKey(clip);
        boolean isIdleController = "Idle".equals(controller);
        if (!(PunchyClient.isIdleTransitionClip(normalizedClip) || isIdleController && this.pendingIdleTransitionSources.containsKey(safeHand))) {
            this.clearIdleTransitionState(safeHand);
        }
        long gameTime = player.method_37908().method_8510();
        String trackingClip = PunchyClient.clipKeyForTracking(clip);
        AnimationRunKey key = new AnimationRunKey(instanceId, controller, trackingClip);
        double clipSeconds = this.clipDurationSeconds(player, safeHand, clip);
        long expectedTicks = Math.max(1L, Math.round(clipSeconds * 20.0));
        AnimationRunInfo info = new AnimationRunInfo(gameTime, System.nanoTime(), safeHand, expectedTicks, clipSeconds);
        this.animationRuns.put(key, info);
    }

    private void recordAnimationStop(class_1657 player, class_1268 hand, String controller, String clip, long instanceId) {
        boolean isTransitionClip;
        long gameTime = player != null && player.method_37908() != null ? player.method_37908().method_8510() : 0L;
        String normalizedClip = PunchyClient.normalizeClipKey(clip);
        AnimationRunKey key = new AnimationRunKey(instanceId, controller, PunchyClient.clipKeyForTracking(clip));
        AnimationRunInfo info = this.animationRuns.remove(key);
        boolean bl = isTransitionClip = clip != null && clip.startsWith("transition");
        if (info == null) {
            class_1268 fallbackHand = hand == null ? class_1268.field_5808 : hand;
            this.onQueuedIdleClipStopped(fallbackHand, clip);
            this.onSourceClipStoppedForIdle(fallbackHand, clip);
            if (CONTROLLER_ACTIVATION.equals(controller) && isTransitionClip) {
                this.handleTransitionStopped(hand);
            }
            if (this.flintAndSteelCleanupPending && fallbackHand == this.flintAndSteelProxyHand && "transition_to_idle_insert".equals(normalizedClip)) {
                this.finalizeFlintAndSteelCleanup(false);
            }
            return;
        }
        class_1268 safeHand = hand == null ? info.hand() : hand;
        boolean queuedFromStop = this.queueIdleTransitionAfterClip(safeHand, controller, clip);
        this.onQueuedIdleClipStopped(safeHand, clip);
        this.onSourceClipStoppedForIdle(safeHand, clip);
        if (CONTROLLER_ACTIVATION.equals(controller)) {
            class_746 local;
            class_310 client = class_310.method_1551();
            class_746 class_7462 = local = client != null ? client.field_1724 : null;
            if (this.activationSource == ActivationSource.PUNCH && safeHand == this.activationHand) {
                this.finalizePunch((class_1657)local, safeHand);
            } else if (this.activationSource == ActivationSource.USE && safeHand == this.useAnimationHand) {
                boolean stillHoldingUse;
                boolean isUsebrushClip = "usebrush".equals(normalizedClip);
                boolean bl2 = stillHoldingUse = client != null && client.field_1690.field_1904.method_1434();
                if (isUsebrushClip && stillHoldingUse && this.usebrushHolding) {
                    if (local != null) {
                        class_1799 current = HandHelper.getConfiguredHandItem((class_1657)local, safeHand);
                        this.triggerUseClip(local, safeHand, current, this.useInteractsWithBlock);
                    }
                } else {
                    this.stopUseAction(client);
                }
            }
            if (isTransitionClip) {
                this.handleTransitionStopped(safeHand);
            }
            return;
        }
        if (isTransitionClip) {
            this.handleTransitionStopped(safeHand);
        }
        if (this.flintAndSteelCleanupPending && safeHand == this.flintAndSteelProxyHand && "transition_to_idle_insert".equals(normalizedClip)) {
            this.finalizeFlintAndSteelCleanup(false);
        }
        if ("Select".equals(controller) && (PunchyClient.isSelectClipName(normalizedClip) || PunchyClient.isSelectOutClipName(normalizedClip))) {
            class_746 lp;
            class_746 local;
            class_746 class_7463 = local = player instanceof class_746 ? (lp = (class_746)player) : class_310.method_1551().field_1724;
            if (safeHand == class_1268.field_5808) {
                if (PunchyClient.isSelectOutClipName(normalizedClip)) {
                    this.handleMainHandLoweringFinished(local);
                } else if (PunchyClient.isSelectClipName(normalizedClip)) {
                    this.handleMainHandRaiseFinished(local);
                }
            }
            if (PunchyClient.isSelectClipName(normalizedClip)) {
                this.stopSelect((class_1657)local, safeHand, false);
            }
            float impulseStrength = safeHand == class_1268.field_5808 ? 0.4f : 0.6f;
            this.applyIdleSpringImpulse(safeHand, impulseStrength);
        }
        if ("Inspect".equals(controller) && "inspect_my_item".equals(normalizedClip)) {
            class_746 lp;
            class_746 currentPlayer = player instanceof class_746 ? (lp = (class_746)player) : null;
            this.completeInspect(currentPlayer);
            return;
        }
    }

    private void recordAnimationKeyframe(String controller, String clip, String label, double animationTick) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || clip == null || clip.isEmpty()) {
            return;
        }
        String trackingClip = PunchyClient.clipKeyForTracking(clip);
        AnimationRunInfo info = this.findAnimationRunInfo((class_1657)player, controller, trackingClip);
        if (info == null) {
            return;
        }
        String entry = label == null || label.isEmpty() ? String.format(Locale.ROOT, "@%.2f", animationTick) : String.format(Locale.ROOT, "%s@%.2f", label, animationTick);
        info.keyframes().add(entry);
        if ("instr:end".equals(label)) {
            this.handleEndInstruction((class_1657)player, controller, clip, info);
        }
    }

    private void handleEndInstruction(class_1657 player, String controller, String clip, AnimationRunInfo info) {
        if (player == null || controller == null || clip == null || clip.isEmpty() || info == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        boolean mouseDown = client != null && (client.field_1690.field_1886.method_1434() || client.field_1690.field_1904.method_1434());
        class_1268 hand = info.hand() == null ? class_1268.field_5808 : info.hand();
        boolean activationController = CONTROLLER_ACTIVATION.equals(controller);
        boolean blockTarget = PunchyClient.hasViableBlockTarget(client);
        boolean consumeController = "Consume".equals(controller);
        String normalizedClip = PunchyClient.normalizeClipKey(clip);
        if ("Select".equals(controller) && (PunchyClient.isSelectClipName(normalizedClip) || PunchyClient.isSelectOutClipName(normalizedClip))) {
            class_746 lp;
            class_746 local;
            class_746 class_7462 = local = player instanceof class_746 ? (lp = (class_746)player) : class_310.method_1551().field_1724;
            if (hand == class_1268.field_5808) {
                if (PunchyClient.isSelectOutClipName(normalizedClip)) {
                    this.handleMainHandLoweringFinished(local);
                } else if (PunchyClient.isSelectClipName(normalizedClip)) {
                    this.handleMainHandRaiseFinished(local);
                }
            }
            if (PunchyClient.isSelectClipName(normalizedClip)) {
                this.stopSelect((class_1657)local, hand, false);
            }
            float impulseStrength = hand == class_1268.field_5808 ? 0.4f : 0.6f;
            return;
        }
        if ("Inspect".equals(controller) && "inspect_my_item".equals(normalizedClip)) {
            class_746 lp;
            class_746 localPlayer;
            class_746 class_7463 = localPlayer = player instanceof class_746 ? (lp = (class_746)player) : null;
            if (localPlayer != null) {
                this.stopInspect(localPlayer);
            }
            return;
        }
        if (!activationController && !consumeController || info.stopScheduled()) {
            return;
        }
        if (activationController) {
            boolean allowLoop;
            boolean bl = allowLoop = this.activationSource == ActivationSource.PUNCH && this.activationHand == hand && !this.activationTargetIsEntity;
            if (mouseDown && blockTarget && allowLoop && PunchyClient.isMiningLoopClip(clip)) {
                HandSwayPhysics.get().trigger(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808);
                String nextClip = AnimationRandomizer.nextMiningClip(HandHelper.getConfiguredHandItem(player, hand), clip);
                if (!nextClip.equals(clip)) {
                    BoneAnimationController.triggerActivation(player, hand, nextClip);
                    this.lastActivationClip.put(hand, nextClip);
                    PunchLoopState state = this.punchLoops.get(hand);
                    if (state != null) {
                        int newDuration = Math.max(1, (int)Math.round(this.clipDurationSeconds(player, hand, nextClip) * 20.0));
                        state.updateDuration(newDuration);
                    }
                }
                return;
            }
        } else if (consumeController) {
            boolean stillConsuming;
            boolean bl = stillConsuming = player.method_6115() && player.method_6058() == hand;
            if (mouseDown && stillConsuming) {
                return;
            }
        }
        info.markStopScheduled();
        if (consumeController) {
            String stopReason = !mouseDown ? "mouse released" : "consumption stopped";
        } else {
            String stopReason;
            String string = stopReason = !mouseDown ? "mouse released" : "lost block target";
        }
        if (activationController) {
            this.stopActivationLoop(player, hand, clip, true);
        } else {
            this.stopLoopedAnimation(player, controller, clip, hand);
        }
    }

    private void requestStopForClip(class_1657 player, class_1268 hand, String controller, String clip) {
        class_1268 resolvedHand;
        if (player == null || controller == null || clip == null || clip.isEmpty()) {
            return;
        }
        String baseClip = PunchyClient.normalizeClipKey(clip);
        if (baseClip.isEmpty()) {
            baseClip = clip;
        }
        if (baseClip.isEmpty()) {
            return;
        }
        class_1268 class_12682 = resolvedHand = hand == null ? class_1268.field_5808 : hand;
        if (CONTROLLER_ACTIVATION.equals(controller)) {
            BoneAnimationController.stopActivation(player, resolvedHand, baseClip);
        } else {
            BoneAnimationController.stop(player, resolvedHand, controller, baseClip);
        }
    }

    private void suppressBowSprite(class_1268 hand, boolean holdUse) {
        class_1268 target = hand == null ? class_1268.field_5808 : hand;
        this.rangedSpriteSuppressed = true;
        this.rangedSpriteHand = target;
        if (holdUse && PunchyClient.shouldSuppressUseAnimation()) {
            this.enterBowUseHold();
        }
    }

    private void releaseBowSpriteSuppression() {
        if (this.rangedSpriteSuppressed) {
            this.exitBowUseHold();
        }
        this.rangedSpriteSuppressed = false;
        this.rangedSpriteHand = class_1268.field_5808;
    }

    private void clampBowUseTicks(class_746 player) {
        if (player == null) {
            return;
        }
        class_1799 stack = player.method_6030();
        if (stack == null || stack.method_7960()) {
            return;
        }
        int duration = stack.method_7935((class_1309)player);
        if (duration <= 0) {
            duration = 72000;
        }
        ((LivingEntityAccessor)player).punchy$setUseItemRemainingTicks(duration);
    }

    private class_1799 createVisualArrowStack(class_746 player) {
        if (player == null) {
            return new class_1799((class_1935)class_1802.field_8107);
        }
        class_1799 projectile = player.method_18808(HandHelper.getConfiguredMainHandItem((class_1657)player));
        if ((projectile == null || projectile.method_7960()) && player != null) {
            projectile = player.method_18808(player.method_6079());
        }
        if (projectile == null || projectile.method_7960()) {
            projectile = new class_1799((class_1935)class_1802.field_8107);
        } else {
            projectile = projectile.method_7972();
            projectile.method_7939(1);
        }
        return projectile;
    }

    private void enterBowUseHold() {
        if (this.rangedSpriteHoldDepth++ == 0) {
            UseAnimationSuppressor.push();
        }
    }

    private void exitBowUseHold() {
        if (this.rangedSpriteHoldDepth <= 0) {
            this.rangedSpriteHoldDepth = 0;
            return;
        }
        --this.rangedSpriteHoldDepth;
        if (this.rangedSpriteHoldDepth == 0) {
            UseAnimationSuppressor.pop();
        }
    }

    private static boolean shouldSuppressUseAnimation() {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1690 == null) {
            return true;
        }
        return client.field_1690.method_31044() == class_5498.field_26664;
    }

    private void restoreArrowHandState(class_1268 hand) {
        if (hand == null) {
            return;
        }
        class_1799 previous = this.savedArrowOverrides.remove(hand);
        Boolean hidden = this.savedArrowHidden.remove(hand);
        if (previous != null) {
            HandItemOverrides.setOverride(hand, previous);
        } else {
            HandItemOverrides.clear(hand);
        }
        HandItemOverrides.setHidden(hand, hidden != null && hidden != false);
        ArmAnimationOverrides.clear(hand);
        this.activeArrowOverrides.remove(hand);
    }

    private boolean isSpriteSuppressedFor(class_1268 hand) {
        return this.rangedSpriteSuppressed && this.rangedSpriteHand == (hand == null ? class_1268.field_5808 : hand);
    }

    private static class_1268 inferHandFromClip(String clip) {
        if (clip != null && clip.endsWith("_left")) {
            return class_1268.field_5810;
        }
        return class_1268.field_5808;
    }

    private static String formatSeconds(double value) {
        return String.format(Locale.ROOT, "%.3f", value);
    }

    private double clipDurationSeconds(class_1657 player, class_1268 hand, String clip) {
        double seconds = 0.0;
        AnimatedBoneProxy proxy = Punchy.boneProxy();
        if (proxy != null) {
            seconds = proxy.getAnimationDurationSeconds(clip);
        }
        if (seconds <= 0.0) {
            seconds = 2.0;
        }
        double speedFactor = this.activationSpeedFactor(player, hand);
        return seconds / Math.max(0.001, speedFactor);
    }

    private double activationSpeedFactor(class_1657 player, class_1268 hand) {
        double factor;
        class_1792 class_17922;
        class_1799 held;
        double actionSpeed = AnimatedTool.currentActivationSpeedValue();
        double toolScale = 1.0;
        if (player != null && hand != null && (held = HandHelper.getConfiguredHandItem(player, hand)) != null && (class_17922 = held.method_7909()) instanceof AnimatedTool) {
            AnimatedTool tool = (AnimatedTool)class_17922;
            toolScale = tool.getToolSpeedScale();
        }
        return (factor = Punchy.ANIM_SPEED * toolScale * actionSpeed) <= 0.0 ? 1.0 : factor;
    }

    private static void playLocalSound(class_3414 event, float volume, float pitch) {
        class_310 client = class_310.method_1551();
        if (event == null || client == null || client.field_1724 == null) {
            return;
        }
        client.field_1724.method_5783(event, volume, pitch);
    }

    private static void handleImpactInstruction(AnimatedTool tool) {
        class_1268 resolvedActionHand;
        class_3965 blockHr;
        if (tool == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        PunchyClient inst = INSTANCE;
        if (client == null || client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (!Punchy.USE_IMPACT_TIMING) {
            return;
        }
        if (AnimatedTool.isCurrentActionUse()) {
            return;
        }
        boolean resetAttackCooldown = false;
        class_1268 actionHand = AnimatedTool.currentActionHand();
        class_239 hr = client.field_1765;
        class_3965 bhr = hr instanceof class_3965 ? (blockHr = (class_3965)hr) : null;
        boolean attackHeld = client.field_1690.field_1886.method_1434();
        if (bhr != null && !attackHeld) {
            return;
        }
        class_2338 fallbackPos = lastMiningTargetPos;
        if (bhr != null || fallbackPos != null) {
            class_239 ray;
            class_2338 pos;
            class_2338 class_23382 = pos = bhr != null ? bhr.method_17777() : fallbackPos;
            if (pos == null && (ray = client.field_1724.method_5745(5.0, 0.0f, false)) instanceof class_3965) {
                class_3965 extraHit = (class_3965)ray;
                pos = extraHit.method_17777();
            }
            if (pos == null) {
                return;
            }
            class_2680 state = client.field_1687.method_8320(pos);
            if (!state.method_26215() && Punchy.TAP_MINING_ENABLED) {
                class_3414 ev = state.method_26231().method_10596();
                float vol = Math.max(0.2f, Math.min(1.5f, state.method_26231().method_10597()));
                float pitch = (float)Math.max(0.25, Math.min(2.0, Punchy.SOUND_RATE));
                client.field_1724.method_5783(ev, vol, pitch);
                ClientPlatform.get().sendToServer(new BlockImpactPayload(pos));
                resetAttackCooldown = true;
            }
        } else if (hr instanceof class_3966) {
            class_1297 entity;
            class_3966 ehr = (class_3966)hr;
            if (tool instanceof AnimatedBoneProxy && (entity = ehr.method_17782()) != null) {
                ImpactClientHooks.fireAttackImpact(entity, actionHand);
                if (inst != null) {
                    inst.cancelPunchLoopForHand(actionHand);
                    inst.activationTargetIsEntity = true;
                }
                resetAttackCooldown = true;
            }
        }
        class_1268 class_12682 = resolvedActionHand = actionHand == null ? class_1268.field_5808 : actionHand;
        if (resetAttackCooldown) {
            try {
                client.field_1724.method_7350();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (inst != null) {
                inst.cancelPunchLoopForHand(resolvedActionHand);
                inst.attackLoopArmed = false;
                inst.finalizePunch((class_1657)client.field_1724, resolvedActionHand);
            }
        }
        AnimatedTool.markNextActionHand(resolvedActionHand);
        PunchyClient.onPunchImpact();
    }

    private static void createAnimatedBoneRenderer(Consumer<GeoRenderProvider> consumer) {
        if (consumer == null) {
            return;
        }
        consumer.accept(new GeoRenderProvider(){
            private final RightArmRenderer<AnimatedBoneProxy> rightRenderer = new RightArmRenderer();
            private final LeftArmRenderer<AnimatedBoneProxy> leftRenderer = new LeftArmRenderer();

            public GeoItemRenderer<AnimatedBoneProxy> getGeoItemRenderer() {
                class_1268 hand = VanillaProxyContext.getHand();
                return hand == class_1268.field_5810 ? this.leftRenderer : this.rightRenderer;
            }
        });
    }

    public static CameraDrift cameraDrift() {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return CameraDrift.ZERO;
        }
        return new CameraDrift(inst.lastCameraYawDelta, inst.lastCameraPitchDelta);
    }

    public static boolean isJumpActive() {
        PunchyClient inst = INSTANCE;
        return inst != null && inst.jumpActive;
    }

    public static boolean isLanding(class_1268 hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null || hand == null) {
            return false;
        }
        return inst.landingStopTimes.containsKey(hand);
    }

    private void resetIdleTransitionState() {
        this.idleTransitionQueues.clear();
        this.activeIdleTransitionClips.clear();
        this.pendingIdleTransitionSources.clear();
        this.deferredWalkRequests.clear();
        this.lastQueuedIdleClip.clear();
    }

    private boolean queueIdleTransitionAfterClip(class_1268 hand, String controller, String clip) {
        if (clip == null || clip.isEmpty()) {
            return false;
        }
        String normalized = PunchyClient.normalizeClipKey(clip);
        if (PunchyClient.isIdleTransitionClip(normalized)) {
            return false;
        }
        TransitionRequest request = this.buildTransitionRequest(controller, clip);
        if (request == null) {
            return false;
        }
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        PendingTransition pending = this.pendingIdleTransitionSources.get(resolved);
        if (pending != null && pending.normalizedClip.equals(normalized)) {
            return false;
        }
        String lastQueued = this.lastQueuedIdleClip.get(resolved);
        if (lastQueued != null && lastQueued.equals(normalized)) {
            return false;
        }
        this.pendingIdleTransitionSources.put(resolved, new PendingTransition(normalized, request));
        this.lastQueuedIdleClip.put(resolved, normalized);
        return true;
    }

    private void onSourceClipStoppedForIdle(class_1268 hand, String clip) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        String normalized = PunchyClient.normalizeClipKey(clip);
        PendingTransition pending = this.pendingIdleTransitionSources.get(resolved);
        if (pending == null || !pending.normalizedClip.equals(normalized)) {
            return;
        }
        this.pendingIdleTransitionSources.remove(resolved);
        TransitionRequest request = pending.request();
        if (request == null || request.clip() == null || request.clip().isEmpty()) {
            class_746 local = class_310.method_1551().field_1724;
            if (local != null) {
                ToolAnimationOverrides.clear(resolved);
                this.ensureIdleAfterAction(local, resolved);
            }
            return;
        }
        ArrayDeque queue = this.idleTransitionQueues.computeIfAbsent(resolved, h -> new ArrayDeque());
        queue.clear();
        queue.add(request);
        this.processIdleTransitionQueue(resolved);
    }

    private void onQueuedIdleClipStopped(class_1268 hand, String clip) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        String normalized = PunchyClient.normalizeClipKey(clip);
        String active = this.activeIdleTransitionClips.get(resolved);
        if (active == null || !active.equals(normalized)) {
            return;
        }
        this.activeIdleTransitionClips.remove(resolved);
        this.lastQueuedIdleClip.remove(resolved);
        this.processIdleTransitionQueue(resolved);
    }

    private void processIdleTransitionQueue(class_1268 hand) {
        class_1268 resolved;
        class_1268 class_12682 = resolved = hand == null ? class_1268.field_5808 : hand;
        if (this.activeIdleTransitionClips.containsKey(resolved)) {
            return;
        }
        ArrayDeque<TransitionRequest> queue = this.idleTransitionQueues.get(resolved);
        if (queue == null || queue.isEmpty()) {
            this.idleTransitionQueues.remove(resolved);
            Double deferredSpeed = this.deferredWalkRequests.remove(resolved);
            if (deferredSpeed != null) {
                class_746 local = class_310.method_1551().field_1724;
                if (local != null) {
                    if (!this.walkActive || this.walkingHands.isEmpty()) {
                        this.walkSpeedMultiplier = deferredSpeed;
                        this.walkActive = true;
                    }
                    this.playWalkAnimation(local, resolved, deferredSpeed);
                    this.walkingHands.add(resolved);
                }
            } else {
                ToolAnimationOverrides.clear(resolved);
                class_746 local = class_310.method_1551().field_1724;
                if (local != null) {
                    this.ensureIdleAfterAction(local, resolved);
                }
            }
            return;
        }
        class_746 local = class_310.method_1551().field_1724;
        if (local == null) {
            this.idleTransitionQueues.remove(resolved);
            ToolAnimationOverrides.clear(resolved);
            return;
        }
        TransitionRequest next = queue.poll();
        if (next == null || next.clip() == null || next.clip().isEmpty()) {
            this.processIdleTransitionQueue(resolved);
            return;
        }
        AnimatedTool.markNextActionHand(resolved);
        BoneAnimationController.trigger((class_1657)local, resolved, next.controller(), next.clip());
        this.activeIdleTransitionClips.put(resolved, next.clip());
    }

    private boolean hasIdleTransitionInFlight(class_1268 hand) {
        class_1268 resolved;
        class_1268 class_12682 = resolved = hand == null ? class_1268.field_5808 : hand;
        if (this.pendingIdleTransitionSources.containsKey(resolved)) {
            return true;
        }
        if (this.activeIdleTransitionClips.containsKey(resolved)) {
            return true;
        }
        ArrayDeque<TransitionRequest> queue = this.idleTransitionQueues.get(resolved);
        return queue != null && !queue.isEmpty();
    }

    private void clearIdleTransitionState(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        this.pendingIdleTransitionSources.remove(resolved);
        this.activeIdleTransitionClips.remove(resolved);
        this.idleTransitionQueues.remove(resolved);
        this.deferredWalkRequests.remove(resolved);
    }

    private static boolean isSelectClipName(String normalizedClip) {
        if (normalizedClip == null || normalizedClip.isEmpty()) {
            return false;
        }
        if (normalizedClip.equals(HAND_IN_CLIP)) {
            return true;
        }
        return normalizedClip.startsWith("hand_in_");
    }

    private static boolean isSelectOutClipName(String normalizedClip) {
        if (normalizedClip == null || normalizedClip.isEmpty()) {
            return false;
        }
        if (normalizedClip.equals(HAND_OUT_CLIP)) {
            return true;
        }
        return normalizedClip.startsWith("hand_out_");
    }

    private void tickMainHandSwap(class_746 player) {
        if (player == null || player.method_37908() == null) {
            return;
        }
        long gameTime = player.method_37908().method_8510();
        if (this.mainHandSwapState.stage == MainHandSwapStage.LOWERING && this.mainHandSwapState.loweringDeadline >= 0L && gameTime >= this.mainHandSwapState.loweringDeadline) {
            this.forceLoweringComplete(player);
        }
        if (this.mainHandSwapState.stage == MainHandSwapStage.RAISING && this.mainHandSwapState.raisingDeadline >= 0L && gameTime >= this.mainHandSwapState.raisingDeadline) {
            this.forceRaisingComplete(player);
        }
    }

    private void forceLoweringComplete(class_746 player) {
        class_746 local = player;
        if (local == null) {
            local = class_310.method_1551().field_1724;
        }
        if (local == null) {
            this.resetMainHandSwapState();
            return;
        }
        this.mainHandSwapState.loweringDeadline = -1L;
        this.handleMainHandLoweringFinished(local);
    }

    private void forceRaisingComplete(class_746 player) {
        class_746 local = player;
        if (local == null) {
            local = class_310.method_1551().field_1724;
        }
        if (local == null) {
            this.resetMainHandSwapState();
            return;
        }
        this.mainHandSwapState.raisingDeadline = -1L;
        this.handleMainHandRaiseFinished(local);
        this.stopSelect((class_1657)local, class_1268.field_5808, false);
    }

    private long estimateSelectDeadline(class_746 player, class_1268 hand, String clip) {
        if (player == null || player.method_37908() == null) {
            return -1L;
        }
        int ticks = this.clipDurationTicks((class_1657)player, hand, clip);
        double multiplier = PunchyClient.selectAnimationDurationMultiplier(hand);
        long adjusted = Math.max(1L, Math.round((double)ticks * multiplier));
        return player.method_37908().method_8510() + adjusted;
    }

    private int clipDurationTicks(class_1657 player, class_1268 hand, String clip) {
        double seconds = this.clipDurationSeconds(player, hand, clip);
        int ticks = (int)Math.ceil(seconds * 20.0);
        return Math.max(1, ticks);
    }

    private static String normalizeClipKey(String clip) {
        if (clip == null || clip.isEmpty()) {
            return "";
        }
        String normalized = clip;
        if (normalized.startsWith("animation.bone.")) {
            normalized = normalized.substring("animation.bone.".length());
        }
        if (normalized.endsWith("_left")) {
            normalized = normalized.substring(0, normalized.length() - "_left".length());
        } else if (normalized.endsWith("_right")) {
            normalized = normalized.substring(0, normalized.length() - "_right".length());
        }
        return normalized;
    }

    private static String clipKeyWithoutNamespace(String clip) {
        if (clip == null || clip.isEmpty()) {
            return "";
        }
        if (clip.startsWith("animation.bone.")) {
            return clip.substring("animation.bone.".length());
        }
        return clip;
    }

    private static boolean isIdleTransitionClip(String normalizedClip) {
        if (normalizedClip == null || normalizedClip.isEmpty()) {
            return false;
        }
        return normalizedClip.startsWith(TRANSITION_PREFIX);
    }

    private TransitionRequest buildTransitionRequest(String controller, String clip) {
        String transitionClip = PunchyClient.findTransitionClipFor(clip);
        if (transitionClip == null || transitionClip.isEmpty()) {
            return null;
        }
        return new TransitionRequest(controller, transitionClip);
    }

    private static String findTransitionClipFor(String clip) {
        String candidate;
        String candidate2;
        if (clip == null || clip.isEmpty()) {
            return "";
        }
        Set<String> transitions = PunchyClient.transitionAnimations();
        String sourceKey = PunchyClient.clipKeyWithoutNamespace(clip);
        if (!sourceKey.isEmpty() && transitions.contains(candidate2 = TRANSITION_PREFIX + sourceKey)) {
            return candidate2;
        }
        String normalized = PunchyClient.normalizeClipKey(clip);
        if (!normalized.isEmpty() && !normalized.equals(sourceKey) && transitions.contains(candidate = TRANSITION_PREFIX + normalized)) {
            return candidate;
        }
        return "";
    }

    private static String clipKeyForTracking(String clip) {
        if (clip == null || clip.isEmpty()) {
            return "";
        }
        String normalized = PunchyClient.normalizeClipKey(clip);
        return normalized.isEmpty() ? clip : normalized;
    }

    private static String normalizeTransitionAnimationName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (name.startsWith("animation.bone.")) {
            return name.substring("animation.bone.".length());
        }
        return name;
    }

    private static Set<String> transitionAnimations() {
        if (transitionAnimationsLoaded) {
            return cachedTransitionAnimations;
        }
        transitionAnimationsLoaded = true;
        if (class_310.method_1551() == null) {
            cachedTransitionAnimations = Set.of();
            return cachedTransitionAnimations;
        }
        class_3300 manager = class_310.method_1551().method_1478();
        class_2960 location = class_2960.method_60655((String)"punchy", (String)"geckolib/animations/bone_anchor.animation.json");
        try {
            Optional optional = manager.method_14486(location);
            if (optional.isEmpty()) {
                cachedTransitionAnimations = Set.of();
                return cachedTransitionAnimations;
            }
            class_3298 resource = (class_3298)optional.get();
            try (InputStreamReader reader = new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8);){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject animations = class_3518.method_15281((JsonObject)root, (String)"animations", (JsonObject)new JsonObject());
                HashSet<String> names = new HashSet<String>();
                for (Map.Entry entry : animations.entrySet()) {
                    String name = (String)entry.getKey();
                    String normalizedName = PunchyClient.normalizeTransitionAnimationName(name);
                    if (name != null && name.startsWith(TRANSITION_PREFIX)) {
                        names.add(name);
                    }
                    if (!normalizedName.startsWith(TRANSITION_PREFIX)) continue;
                    names.add(normalizedName);
                }
                cachedTransitionAnimations = Set.copyOf(names);
            }
        }
        catch (Exception ignored) {
            cachedTransitionAnimations = Set.of();
        }
        return cachedTransitionAnimations;
    }

    private AnimationRunInfo findAnimationRunInfo(class_1657 player, String controller, String clip) {
        if (player == null || controller == null || clip == null || clip.isEmpty()) {
            return null;
        }
        long mainId = BoneAnimationIds.compute(player, class_1268.field_5808);
        AnimationRunInfo info = this.animationRuns.get(new AnimationRunKey(mainId, controller, clip));
        if (info != null) {
            return info;
        }
        long offId = BoneAnimationIds.compute(player, class_1268.field_5810);
        info = this.animationRuns.get(new AnimationRunKey(offId, controller, clip));
        if (info != null) {
            return info;
        }
        for (Map.Entry<AnimationRunKey, AnimationRunInfo> entry : this.animationRuns.entrySet()) {
            AnimationRunKey key = entry.getKey();
            if (!controller.equals(key.controller()) || !clip.equals(key.clip())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static boolean hasViableBlockTarget(class_310 client) {
        if (client == null || client.field_1765 == null || client.field_1687 == null) {
            return false;
        }
        if (client.field_1765.method_17783() != class_239.class_240.field_1332) {
            return false;
        }
        class_3965 blockHit = (class_3965)client.field_1765;
        return blockHit != null && !client.field_1687.method_8320(blockHit.method_17777()).method_26215();
    }

    public static void markNextAttackTarget(boolean entity, boolean block) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.setPendingAttackTarget(entity, block);
        }
    }

    private void setPendingAttackTarget(boolean entity, boolean block) {
        this.pendingAttackTarget = new AttackTarget(entity, block);
        this.pendingAttackExpiryNanos = System.nanoTime() + 200000000L;
    }

    private AttackTarget consumePendingAttackTarget() {
        if (this.pendingAttackTarget == null) {
            return null;
        }
        long now = System.nanoTime();
        if (now <= this.pendingAttackExpiryNanos) {
            AttackTarget result = this.pendingAttackTarget;
            this.pendingAttackTarget = null;
            return result;
        }
        this.pendingAttackTarget = null;
        return null;
    }

    private static AttackTarget detectAttackTarget(class_746 player) {
        class_310 client = class_310.method_1551();
        if (client != null) {
            class_1297 crosshairEntity = client.field_1692;
            if (crosshairEntity != null && crosshairEntity.method_5863() && !crosshairEntity.method_7325()) {
                return new AttackTarget(true, false);
            }
            class_239 clientHit = client.field_1765;
            if (clientHit != null) {
                if (clientHit.method_17783() == class_239.class_240.field_1331) {
                    return new AttackTarget(true, false);
                }
                if (clientHit instanceof class_3965) {
                    class_3965 blockHit = (class_3965)clientHit;
                    boolean solid = client.field_1687 != null && !client.field_1687.method_8320(blockHit.method_17777()).method_26215();
                    return new AttackTarget(false, solid);
                }
            }
        }
        if (player == null || player.method_37908() == null) {
            return new AttackTarget(false, false);
        }
        double reach = player.method_7337() ? 6.0 : 4.5;
        class_239 hit = player.method_5745(reach, 0.0f, false);
        if (hit == null) {
            return new AttackTarget(false, false);
        }
        if (hit.method_17783() == class_239.class_240.field_1331) {
            return new AttackTarget(true, false);
        }
        if (hit instanceof class_3965) {
            class_3965 blockHit = (class_3965)hit;
            boolean solid = !player.method_37908().method_8320(blockHit.method_17777()).method_26215();
            return new AttackTarget(false, solid);
        }
        return new AttackTarget(false, false);
    }

    private static boolean isSwordItem(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (stack.method_31573(class_3489.field_42611)) {
            return true;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1835 || item instanceof class_9362) {
            return true;
        }
        class_2960 key = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return key != null && key.method_12832().contains("sword");
    }

    static {
        isMiningAnimationPlaying = false;
        miningAnimationStartTime = -1L;
        lastMiningTargetPos = null;
        CAMERA_TILT_LOCK = ThreadLocal.withInitial(() -> Boolean.FALSE);
        SELECT_ANIMATION_DURATION_MULTIPLIERS = Map.of(class_1268.field_5808, 0.6, class_1268.field_5810, 0.4);
        IN_MAP_RENDER = ThreadLocal.withInitial(() -> Boolean.FALSE);
    }

    private static enum RangedChargeKind {
        BOW("BowLoad", "bow_load_bow_hand", "bow_load_arrow_hand", true, true, ""),
        CROSSBOW("CrossbowLoad", "crossbow_load_crossbow_hand", "crossbow_load_arrow_hand", true, false, ""),
        TRIDENT("Trident", "trident_throw", "", false, false, "trident_throw_release");

        private final String controller;
        private final String weaponClip;
        private final String arrowClip;
        private final boolean usesArrowHand;
        private final boolean suppressSprite;
        private final String releaseClip;

        private RangedChargeKind(String controller, String weaponClip, String arrowClip, boolean usesArrowHand, boolean suppressSprite, String releaseClip) {
            this.controller = controller;
            this.weaponClip = weaponClip;
            this.arrowClip = arrowClip;
            this.usesArrowHand = usesArrowHand;
            this.suppressSprite = suppressSprite;
            this.releaseClip = releaseClip;
        }

        public String controller() {
            return this.controller;
        }

        public String weaponClip() {
            return this.weaponClip;
        }

        public String arrowClip() {
            return this.arrowClip;
        }

        public boolean usesArrowHand() {
            return this.usesArrowHand;
        }

        public boolean suppressSprite() {
            return this.suppressSprite;
        }

        public String releaseClip() {
            return this.releaseClip;
        }

        public static RangedChargeKind fromStack(class_1799 stack) {
            if (stack == null || stack.method_7960()) {
                return null;
            }
            class_1792 item = stack.method_7909();
            if (item instanceof class_1753) {
                return BOW;
            }
            if (item instanceof class_1764) {
                return CROSSBOW;
            }
            if (item instanceof class_1835) {
                return TRIDENT;
            }
            return null;
        }
    }

    private static final class MainHandSwapState {
        private class_1799 displayed = class_1799.field_8037;
        private class_1799 pending = class_1799.field_8037;
        private MainHandSwapStage stage = MainHandSwapStage.IDLE;
        private boolean restartAfterRaise = false;
        private long loweringDeadline = -1L;
        private long raisingDeadline = -1L;

        private MainHandSwapState() {
        }

        void reset() {
            this.reset(class_1799.field_8037);
        }

        void reset(class_1799 fallback) {
            this.displayed = fallback == null ? class_1799.field_8037 : fallback.method_7972();
            this.pending = class_1799.field_8037;
            this.stage = MainHandSwapStage.IDLE;
            this.restartAfterRaise = false;
            this.loweringDeadline = -1L;
            this.raisingDeadline = -1L;
        }

        class_1799 displayedOr(class_1799 fallback) {
            if (this.stage == MainHandSwapStage.IDLE) {
                return fallback;
            }
            if (this.stage == MainHandSwapStage.LOWERING) {
                return this.displayed == null ? class_1799.field_8037 : this.displayed;
            }
            if (this.displayed.method_7960()) {
                return fallback;
            }
            return this.displayed;
        }
    }

    private static enum ActivationSource {
        NONE,
        PUNCH,
        LOOP,
        USE;

    }

    private static final class ClientHooks
    implements ClientBridge.Hooks {
        private ClientHooks() {
        }

        @Override
        public double walkSpeedForHand(class_1268 hand) {
            return PunchyClient.walkSpeedForHand(hand);
        }

        @Override
        public double walkOnWaterAnimationSpeed() {
            return PunchyClient.walkOnWaterAnimationSpeed();
        }

        @Override
        public double jumpSpeedForClip(String name) {
            return PunchyClient.jumpSpeedForClip(name);
        }

        @Override
        public void onArrowInstruction(boolean equip) {
            PunchyClient.onArrowInstruction(equip);
        }

        @Override
        public void onCrossbowItemVisibility(class_1268 hand, boolean hidden) {
            PunchyClient.onCrossbowItemVisibility(hand, hidden);
        }

        @Override
        public void onBowAnimationGate() {
            PunchyClient.onBowAnimationGate();
        }

        @Override
        public void onSpyglassInstruction() {
            PunchyClient.onSpyglassInstruction();
        }

        @Override
        public void onJumpGoingToLand(class_1268 hand, double tick) {
            PunchyClient.onJumpGoingToLand(hand, tick);
        }

        @Override
        public void onPunchImpact() {
            PunchyClient.onPunchImpact();
        }

        @Override
        public void onAnimationKeyframe(String controller, String clip, String label, double tick) {
            PunchyClient.onAnimationKeyframe(controller, clip, label, tick);
        }

        @Override
        public void onFlintAndSteelArmIn(class_1268 hand) {
            PunchyClient.onFlintAndSteelArmIn(hand);
        }

        @Override
        public void onFlintAndSteelArmOut(class_1268 hand) {
            PunchyClient.onFlintAndSteelArmOut(hand);
        }

        @Override
        public void onFlintAndSteelSpark(class_1268 hand) {
            PunchyClient.onFlintAndSteelSpark(hand);
        }

        @Override
        public void playLocalSound(class_3414 event, float volume, float pitch) {
            PunchyClient.playLocalSound(event, volume, pitch);
        }

        @Override
        public void handleImpactInstruction(AnimatedTool tool) {
            PunchyClient.handleImpactInstruction(tool);
        }

        @Override
        public void createAnimatedBoneRenderer(Consumer<GeoRenderProvider> consumer) {
            PunchyClient.createAnimatedBoneRenderer(consumer);
        }
    }

    private static final class PunchLoopState {
        private static final int MIN_TAIL_TICKS = 4;
        private int durationTicks;
        private int remainingTicks;
        private boolean stopRequested = false;
        private boolean justLooped = false;

        PunchLoopState(int durationTicks) {
            this.remainingTicks = this.durationTicks = Math.max(1, durationTicks);
        }

        static int defaultTailTicks() {
            return 4;
        }

        void requestStop(int minTailTicks) {
            this.stopRequested = true;
            int tail = Math.max(0, minTailTicks);
            this.remainingTicks = Math.min(this.remainingTicks, tail);
        }

        boolean stopRequested() {
            return this.stopRequested;
        }

        boolean justLooped() {
            return this.justLooped;
        }

        void updateDuration(int newDuration) {
            this.remainingTicks = this.durationTicks = Math.max(1, newDuration);
        }

        boolean tick(boolean canLoop) {
            this.justLooped = false;
            if (--this.remainingTicks > 0) {
                return true;
            }
            if (!this.stopRequested && canLoop) {
                this.remainingTicks = this.durationTicks;
                this.justLooped = true;
                return true;
            }
            this.stopRequested = true;
            return false;
        }
    }

    private record AttackTarget(boolean entity, boolean block) {
    }

    private static final class LanternPhysicsState {
        private static final float GRAVITY = 45.0f;
        private static final float DRAG = 3.0f;
        private static final float INERTIA_GAIN = 50.0f;
        private float pitch;
        private float pitchVel;
        private float roll;
        private float rollVel;
        private LanternPose pose = LanternPose.ZERO;

        private LanternPhysicsState() {
        }

        void tick(class_746 player, boolean active, boolean leftHand, float yawDeltaDeg, float pitchDeltaDeg, float dt, long gameTime) {
            float playerPitchRad;
            if (!active) {
                this.rollVel = 0.0f;
                this.roll = 0.0f;
                this.pitchVel = 0.0f;
                this.pitch = 0.0f;
                this.pose = LanternPose.ZERO;
                return;
            }
            float targetPitch = playerPitchRad = (float)Math.toRadians(player.method_36455());
            float yawRad = (float)Math.toRadians(yawDeltaDeg);
            float pitchRad = (float)Math.toRadians(pitchDeltaDeg);
            float rollKick = -yawRad * 100.0f;
            float pitchKick = pitchRad * 50.0f;
            float pitchForce = (targetPitch - this.pitch) * 45.0f;
            pitchForce += pitchKick;
            this.pitchVel += (pitchForce -= this.pitchVel * 3.0f) * dt;
            this.pitch += this.pitchVel * dt;
            float rollForce = (0.0f - this.roll) * 27.000002f;
            rollForce += rollKick;
            float bob = (float)Math.sin((float)gameTime * 0.15f) * 0.05f * (player.field_42108.method_48566() > 0.1f ? 1.0f : 0.0f);
            rollForce += bob * 40.0f;
            this.rollVel += (rollForce -= this.rollVel * 3.0f) * dt;
            this.roll += this.rollVel * dt;
            this.pitch = class_3532.method_15363((float)this.pitch, (float)-1.0f, (float)1.5f);
            this.roll = class_3532.method_15363((float)this.roll, (float)-1.5f, (float)1.5f);
            float pivotLen = 0.25f;
            float offZ = (float)Math.sin(this.pitch - targetPitch) * pivotLen;
            float offX = -((float)Math.sin(this.roll)) * pivotLen;
            this.pose = new LanternPose(this.pitch, 0.0f, this.roll, offX, 0.0f, offZ);
        }

        void setBasePose(class_746 player, class_1268 hand) {
        }

        void impulse(float forwardKick, float lateralKick) {
            this.pitchVel += forwardKick * 5.0f;
            this.rollVel += lateralKick * 5.0f;
        }

        void reset() {
            this.rollVel = 0.0f;
            this.roll = 0.0f;
            this.pitchVel = 0.0f;
            this.pitch = 0.0f;
            this.pose = LanternPose.ZERO;
        }

        LanternPose snapshot() {
            return this.pose;
        }
    }

    private static final class LanternGripState {
        private static final float SPEED = 8.0f;
        private float blend;

        private LanternGripState() {
        }

        void tick(boolean active, float dt) {
            float target = active ? 1.0f : 0.0f;
            float alpha = class_3532.method_15363((float)(dt * 8.0f), (float)0.0f, (float)1.0f);
            this.blend = class_3532.method_16439((float)alpha, (float)this.blend, (float)target);
        }

        void reset() {
            this.blend = 0.0f;
        }

        float blend() {
            return this.blend;
        }
    }

    private static final class WalkSpringState {
        private static final float SPEED = 6.0f;
        private static final float WALK_OFFSET = 0.1f;
        private static final float ROT_AMP = 0.2f;
        private float time;
        private WalkSpringPose pose = WalkSpringPose.ZERO;

        private WalkSpringState() {
        }

        void tick(boolean active, double speed, float dt) {
            if (!active || speed <= 0.0) {
                this.pose = WalkSpringPose.ZERO;
                this.time = 0.0f;
                return;
            }
            this.time += dt * (float)speed;
            float phase = this.time * 2.0f;
            float rotX = (float)Math.sin(phase) * 0.2f;
            float rotZ = (float)Math.cos(phase) * 0.2f * 0.5f;
            float offY = (float)Math.sin(phase * 0.75f) * 0.1f;
            this.pose = new WalkSpringPose(rotX, rotZ, offY);
        }

        void impulse(double speed) {
            this.time = 0.0f;
            if (speed > 0.0) {
                this.pose = new WalkSpringPose((float)((double)0.2f * speed * 0.5), 0.0f, 0.1f * (float)speed * 0.5f);
            }
        }

        void reset() {
            this.time = 0.0f;
            this.pose = WalkSpringPose.ZERO;
        }

        WalkSpringPose snapshot() {
            return this.pose;
        }
    }

    private static final class JumpSpringState {
        private static final float DRIVE_UP = 10.0f;
        private static final float DRIVE_DOWN = 10.0f;
        private static final float RETURN_RATE = 10.0f;
        private static final float MAX_OFFSET = 10.0f;
        private float value;
        private float target;
        private JumpSpringPose pose = JumpSpringPose.ZERO;

        private JumpSpringState() {
        }

        void tick(boolean active, boolean leftHand, float dt) {
            float drive = this.value < this.target ? 10.0f : 10.0f;
            this.value = JumpSpringState.approach(this.value, this.target, drive * dt);
            float settleRate = active ? 3.5f : 10.0f;
            this.target = JumpSpringState.approach(this.target, 0.0f, settleRate * dt);
            float normalized = class_3532.method_15363((float)this.value, (float)-10.0f, (float)10.0f);
            float eased = (float)Math.sin(normalized * 0.65f);
            float pitch = eased * 0.2f;
            float roll = eased * -0.2f;
            if (leftHand) {
                roll = -roll;
            }
            float offY = eased * -0.22f;
            this.pose = new JumpSpringPose(pitch, roll, offY);
        }

        void impulse(float value) {
            this.target = class_3532.method_15363((float)(this.target + value * 0.22f), (float)-10.0f, (float)10.0f);
        }

        void reset() {
            this.value = 0.0f;
            this.target = 0.0f;
            this.pose = JumpSpringPose.ZERO;
        }

        JumpSpringPose snapshot() {
            return this.pose;
        }

        private static float approach(float current, float goal, float delta) {
            if (current < goal) {
                return Math.min(goal, current + delta);
            }
            if (current > goal) {
                return Math.max(goal, current - delta);
            }
            return current;
        }
    }

    private static final class SneakSpringState {
        private static final float TARGET_DEPTH = -0.095f;
        private static final float DOWN_STIFFNESS = 42.0f;
        private static final float UP_STIFFNESS = 32.0f;
        private static final float DAMPING = 14.0f;
        private static final float DOWN_IMPULSE = -2.4f;
        private static final float UP_IMPULSE = 2.0f;
        private float value;
        private float velocity;
        private boolean sneaking;

        private SneakSpringState() {
        }

        void setSneaking(boolean sneaking) {
            if (this.sneaking == sneaking) {
                return;
            }
            this.sneaking = sneaking;
            this.velocity += sneaking ? -2.4f : 2.0f;
        }

        void tick(float dt) {
            float target = this.sneaking ? -0.095f : 0.0f;
            float stiffness = this.sneaking ? 42.0f : 32.0f;
            float accel = stiffness * (target - this.value) - 14.0f * this.velocity;
            this.velocity += accel * dt;
            this.value += this.velocity * dt;
            if (!this.sneaking && Math.abs(this.value) < 1.0E-4f && Math.abs(this.velocity) < 1.0E-4f) {
                this.value = 0.0f;
                this.velocity = 0.0f;
            }
        }

        float offset() {
            return this.value;
        }

        void reset() {
            this.value = 0.0f;
            this.velocity = 0.0f;
            this.sneaking = false;
        }
    }

    private static final class IdleSpringState {
        private static final float SPEED = 4.5f;
        private static final float OFF_AMPLITUDE = 0.02f;
        private static final float BURST_DECAY = 2.5f;
        private static final float BURST_MULT = 1.0f;
        private float time;
        private float burst;
        private IdleSpringPose pose = IdleSpringPose.ZERO;

        private IdleSpringState() {
        }

        void tick(boolean active, boolean leftHand, float dt) {
            if (!active) {
                this.burst = Math.max(0.0f, this.burst - 2.5f * dt);
                this.pose = IdleSpringPose.ZERO;
                this.time = 0.0f;
                return;
            }
            this.time += dt;
            float phase = this.time * 1.2f + (leftHand ? 0.9f : 0.0f);
            float targetRotX = (float)Math.sin(phase * 0.65f) * 0.035f;
            float targetRotY = (float)Math.sin(phase * 0.43f) * 0.018f;
            float targetRotZ = (float)Math.sin(phase * 0.92f) * 0.03f * (leftHand ? -1.0f : 1.0f);
            float targetOffY = (float)Math.sin(phase * 1.1f) * 0.02f;
            float burstGain = this.burst * this.burst * 1.0f;
            float f = leftHand ? -0.2f : 0.2f;
            float targetOffYBurst = targetOffY + burstGain * 0.05f;
            float rotX = IdleSpringState.approach(this.pose.rotX(), targetRotX += burstGain * 0.2f, 4.5f * dt);
            float rotY = IdleSpringState.approach(this.pose.rotY(), targetRotY += burstGain * 0.1f, 4.5f * dt);
            float rotZ = IdleSpringState.approach(this.pose.rotZ(), targetRotZ += burstGain * f, 4.5f * dt);
            this.pose = new IdleSpringPose(rotX, rotY, rotZ, targetOffYBurst);
            this.burst = Math.max(0.0f, this.burst - 2.5f * dt);
        }

        void impulse(float strength) {
            float clamped = Math.max(0.0f, Math.min(1.0f, strength));
            this.burst = Math.min(1.0f, this.burst + clamped);
        }

        void reset() {
            this.time = 0.0f;
            this.burst = 0.0f;
            this.pose = IdleSpringPose.ZERO;
        }

        IdleSpringPose snapshot() {
            return this.pose;
        }

        private static float approach(float current, float goal, float delta) {
            if (current < goal) {
                return Math.min(goal, current + delta);
            }
            if (current > goal) {
                return Math.max(goal, current - delta);
            }
            return current;
        }
    }

    private record ReleaseCleanup(class_1268 arrowHand, boolean clearArrow, boolean releaseSprite, String controller, String releaseClip) {
    }

    private static enum MainHandSwapStage {
        IDLE,
        LOWERING,
        RAISING;

    }

    public record LanternPose(float rotX, float rotY, float rotZ, float offX, float offY, float offZ) {
        public static final LanternPose ZERO = new LanternPose(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public record IdleSpringPose(float rotX, float rotY, float rotZ, float offY) {
        public static final IdleSpringPose ZERO = new IdleSpringPose(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public record WalkSpringPose(float rotX, float rotZ, float offY) {
        public static final WalkSpringPose ZERO = new WalkSpringPose(0.0f, 0.0f, 0.0f);
    }

    public record JumpSpringPose(float rotX, float rotZ, float offY) {
        public static final JumpSpringPose ZERO = new JumpSpringPose(0.0f, 0.0f, 0.0f);
    }

    public record JumpSpringPivot(float x, float y, float z) {
        public static final JumpSpringPivot ZERO = new JumpSpringPivot(0.0f, 0.0f, 0.0f);

        public boolean isZero() {
            return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
        }
    }

    private static enum LeftActionProfile {
        TOOL_SWAY,
        PUNCH_ONLY,
        SWORD,
        TRIDENT,
        MACE;

    }

    private record AnimationRunKey(long instanceId, String controller, String clip) {
    }

    private static final class AnimationRunInfo {
        private final long startGameTime;
        private final long startNanoTime;
        private final class_1268 hand;
        private final long expectedTicks;
        private final double expectedSeconds;
        private final List<String> keyframes = new ArrayList<String>();
        private boolean stopScheduled = false;

        AnimationRunInfo(long startGameTime, long startNanoTime, class_1268 hand, long expectedTicks, double expectedSeconds) {
            this.startGameTime = startGameTime;
            this.startNanoTime = startNanoTime;
            this.hand = hand;
            this.expectedTicks = expectedTicks;
            this.expectedSeconds = expectedSeconds;
        }

        long startGameTime() {
            return this.startGameTime;
        }

        long startNanoTime() {
            return this.startNanoTime;
        }

        class_1268 hand() {
            return this.hand;
        }

        List<String> keyframes() {
            return this.keyframes;
        }

        long expectedTicks() {
            return this.expectedTicks;
        }

        double expectedSeconds() {
            return this.expectedSeconds;
        }

        boolean stopScheduled() {
            return this.stopScheduled;
        }

        void markStopScheduled() {
            this.stopScheduled = true;
        }
    }

    public record CameraDrift(float yawDeg, float pitchDeg) {
        public static final CameraDrift ZERO = new CameraDrift(0.0f, 0.0f);
    }

    private static final class TransitionRequest {
        private final String controller;
        private final String clip;

        private TransitionRequest(String controller, String clip) {
            this.controller = controller;
            this.clip = clip;
        }

        public String controller() {
            return this.controller;
        }

        public String clip() {
            return this.clip;
        }
    }

    private static final class PendingTransition {
        private final String normalizedClip;
        private final TransitionRequest request;

        private PendingTransition(String normalizedClip, TransitionRequest request) {
            this.normalizedClip = normalizedClip;
            this.request = request;
        }

        public TransitionRequest request() {
            return this.request;
        }
    }
}

