/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import java.util.Set;
import net.minecraft.class_1747;
import net.minecraft.class_1749;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1808;
import net.minecraft.class_1819;
import net.minecraft.class_1835;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2440;
import net.minecraft.class_2527;
import net.minecraft.class_2533;
import net.minecraft.class_2577;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5538;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9362;

public final class ToolKindResolver {
    private static final Set<class_1792> REDSTONE_COMPONENTS = Set.of(class_1802.field_8725, class_1802.field_8793, class_1802.field_8530, class_1802.field_8619, class_1802.field_8857, class_1802.field_8230, class_1802.field_8537, class_1802.field_8865, class_1802.field_8357, class_1802.field_8878, class_1802.field_8643, class_1802.field_8566, class_1802.field_8366, class_1802.field_22420, class_1802.field_8239, class_1802.field_8249, class_1802.field_8105, class_1802.field_27051, class_1802.field_8848, class_1802.field_8211, class_1802.field_8655, class_1802.field_28101, class_1802.field_43194);

    private ToolKindResolver() {
    }

    private static boolean isRedstoneComponent(class_1792 item) {
        return REDSTONE_COMPONENTS.contains(item);
    }

    private static boolean isPendulumFlower(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        if (id == null) {
            return false;
        }
        String path = id.method_12832();
        return "pink_petals".equals(path) || "wildflowers".equals(path) || "leaf_litter".equals(path);
    }

    public static boolean isPendulumFlower(class_1799 stack) {
        if (stack == null) {
            return false;
        }
        return ToolKindResolver.isPendulumFlower(stack.method_7909());
    }

    private static boolean isCreatureBucket(class_1792 item) {
        return item == class_1802.field_28354 || item == class_1802.field_8478 || item == class_1802.field_8108 || item == class_1802.field_8666 || item == class_1802.field_8714 || item == class_1802.field_37533;
    }

    private static boolean isMinecart(class_1792 item) {
        return item instanceof class_1808;
    }

    private static boolean isBoat(class_1792 item) {
        return item instanceof class_1749;
    }

    private static boolean isButtonOrPlate(class_1747 blockItem) {
        class_2248 block = blockItem.method_7711();
        return block instanceof class_2269 || block instanceof class_2440;
    }

    private static boolean isTrapdoor(class_1747 blockItem) {
        return blockItem.method_7711() instanceof class_2533;
    }

    private static boolean isCarpet(class_1747 blockItem) {
        return blockItem.method_7711() instanceof class_2577;
    }

    private static boolean isBed(class_1747 blockItem) {
        return blockItem.method_7711() instanceof class_2244;
    }

    public static VanillaFirstPersonItemLayer.ToolKind resolveItemKind(class_1799 stack, VanillaFirstPersonItemLayer.ToolKind fallback) {
        class_1792 item;
        class_1792 class_17922 = item = stack == null ? null : stack.method_7909();
        if (item == null) {
            return fallback;
        }
        if (stack.method_31573(class_3489.field_42611)) {
            return VanillaFirstPersonItemLayer.ToolKind.SWORD;
        }
        if (stack.method_31573(class_3489.field_42612)) {
            return VanillaFirstPersonItemLayer.ToolKind.AXE;
        }
        if (stack.method_31573(class_3489.field_42614)) {
            return VanillaFirstPersonItemLayer.ToolKind.PICKAXE;
        }
        if (stack.method_31573(class_3489.field_42615)) {
            return VanillaFirstPersonItemLayer.ToolKind.SHOVEL;
        }
        if (stack.method_31573(class_3489.field_42613)) {
            return VanillaFirstPersonItemLayer.ToolKind.HOE;
        }
        if (stack.method_57826(class_9334.field_50075)) {
            return VanillaFirstPersonItemLayer.ToolKind.FOOD;
        }
        if (item == class_1802.field_16539 || item == class_1802.field_22016) {
            return VanillaFirstPersonItemLayer.ToolKind.LANTERN;
        }
        if (ToolKindResolver.isPendulumFlower(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.FLOWER_PENDULUM;
        }
        if (ToolKindResolver.isCreatureBucket(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.CREATURE_BUCKET;
        }
        if (ToolKindResolver.isMinecart(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.MINECART;
        }
        if (ToolKindResolver.isBoat(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.BOAT;
        }
        if (item instanceof class_1753) {
            return VanillaFirstPersonItemLayer.ToolKind.BOW;
        }
        if (item == class_1802.field_8107) {
            return VanillaFirstPersonItemLayer.ToolKind.ARROW;
        }
        if (item instanceof class_1787) {
            return VanillaFirstPersonItemLayer.ToolKind.FISHING_ROD;
        }
        if (item instanceof class_1764) {
            return VanillaFirstPersonItemLayer.ToolKind.CROSSBOW;
        }
        if (item instanceof class_1835) {
            return VanillaFirstPersonItemLayer.ToolKind.TRIDENT;
        }
        if (item instanceof class_1819) {
            return VanillaFirstPersonItemLayer.ToolKind.SHIELD;
        }
        if (item instanceof class_5538) {
            return VanillaFirstPersonItemLayer.ToolKind.SPYGLASS;
        }
        if (item instanceof class_1786) {
            return VanillaFirstPersonItemLayer.ToolKind.FLINT;
        }
        if (item instanceof class_9362) {
            return VanillaFirstPersonItemLayer.ToolKind.MACE;
        }
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            if (blockItem.method_7711() instanceof class_2527) {
                return VanillaFirstPersonItemLayer.ToolKind.TORCH;
            }
            if (ToolKindResolver.isButtonOrPlate(blockItem)) {
                return VanillaFirstPersonItemLayer.ToolKind.BUTTON_PLATE;
            }
            if (ToolKindResolver.isTrapdoor(blockItem)) {
                return VanillaFirstPersonItemLayer.ToolKind.TRAPDOOR;
            }
            if (ToolKindResolver.isCarpet(blockItem)) {
                return VanillaFirstPersonItemLayer.ToolKind.CARPET;
            }
            if (ToolKindResolver.isBed(blockItem)) {
                return VanillaFirstPersonItemLayer.ToolKind.BED;
            }
            return VanillaFirstPersonItemLayer.ToolKind.BLOCK;
        }
        if (ToolKindResolver.isRedstoneComponent(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.REDSTONE;
        }
        return VanillaFirstPersonItemLayer.ToolKind.INGREDIENT;
    }

    public static PlayerArmModelLayer.ToolKind resolveArmKind(class_1799 stack, PlayerArmModelLayer.ToolKind fallback) {
        class_1792 item;
        class_1792 class_17922 = item = stack == null ? null : stack.method_7909();
        if (item == null) {
            return fallback;
        }
        if (stack.method_31573(class_3489.field_42611)) {
            return PlayerArmModelLayer.ToolKind.SWORD;
        }
        if (stack.method_31573(class_3489.field_42612)) {
            return PlayerArmModelLayer.ToolKind.AXE;
        }
        if (stack.method_31573(class_3489.field_42614)) {
            return PlayerArmModelLayer.ToolKind.PICKAXE;
        }
        if (stack.method_31573(class_3489.field_42615)) {
            return PlayerArmModelLayer.ToolKind.SHOVEL;
        }
        if (stack.method_31573(class_3489.field_42613)) {
            return PlayerArmModelLayer.ToolKind.HOE;
        }
        if (stack.method_57826(class_9334.field_50075)) {
            return PlayerArmModelLayer.ToolKind.FOOD;
        }
        if (item instanceof class_1753) {
            return PlayerArmModelLayer.ToolKind.BOW;
        }
        if (item instanceof class_1764) {
            return PlayerArmModelLayer.ToolKind.CROSSBOW;
        }
        if (item instanceof class_1835) {
            return PlayerArmModelLayer.ToolKind.TRIDENT;
        }
        if (item instanceof class_1819) {
            return PlayerArmModelLayer.ToolKind.SHIELD;
        }
        if (item instanceof class_9362) {
            return PlayerArmModelLayer.ToolKind.MACE;
        }
        if (item instanceof class_1747) {
            return PlayerArmModelLayer.ToolKind.BLOCK;
        }
        if (ToolKindResolver.isPendulumFlower(item)) {
            return PlayerArmModelLayer.ToolKind.BLOCK;
        }
        return fallback;
    }
}

