/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.renderer.layer;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.render.ArmAnimationOverrides;
import com.henrique.punchy.client.render.HandItemOverrides;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.LightingHelper;
import com.henrique.punchy.client.render.RenderSneakSuppressor;
import com.henrique.punchy.client.render.ToolAnimationOverrides;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.render.UseAnimationSuppressor;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.client.renderer.layer.PunchyBoneTaskProvider;
import com.henrique.punchy.geo.compat.PunchyPerBoneRender;
import com.henrique.punchy.geo.compat.PunchyPerBoneRenderRegistry;
import com.henrique.punchy.util.HandHelper;
import com.henrique.punchy.util.ProxyItemHelper;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class VanillaFirstPersonItemLayer<T extends class_1792>
extends GeoRenderLayer<T>
implements PunchyBoneTaskProvider {
    private static final class_1799 DEBUG_PIVOT_MARKER = new class_1799((class_1935)class_1802.field_8197);
    private static final class_1799 SPRING_PIVOT_MARKER = new class_1799((class_1935)class_1802.field_8737);
    private final String anchorBoneName;
    private final String infoBoneName;
    private final ToolKind kind;
    private final Boolean leftHandGate;
    private final Predicate<class_1799> stackFilter;
    private static boolean loggedEmptyItemMain = false;
    private static boolean loggedEmptyItemOff = false;
    private static boolean loggedNonEmptyItemMain = false;
    private static boolean loggedNonEmptyItemOff = false;
    private static class_2960 lastLoggedItemMainId = null;
    private static class_2960 lastLoggedItemOffId = null;
    private static final IdentityHashMap<GeoBone, Baseline> BASELINES = new IdentityHashMap();

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName) {
        this(renderer, boneName, boneName, ToolKind.AXE, null, null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind) {
        this(renderer, boneName, boneName, kind, null, null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind, boolean leftArm) {
        this(renderer, boneName, boneName, kind, (Boolean)leftArm, (Predicate<class_1799>)null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind, boolean leftArm, Predicate<class_1799> filter) {
        this(renderer, boneName, boneName, kind, (Boolean)leftArm, filter);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String anchorBoneName, String infoBoneName, ToolKind kind, boolean leftArm, Predicate<class_1799> filter) {
        this(renderer, anchorBoneName, infoBoneName, kind, (Boolean)leftArm, filter);
    }

    private VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String anchorBoneName, String infoBoneName, ToolKind kind, Boolean leftHandGate, Predicate<class_1799> filter) {
        super(renderer);
        this.anchorBoneName = anchorBoneName;
        this.infoBoneName = infoBoneName == null ? anchorBoneName : infoBoneName;
        this.kind = kind;
        this.leftHandGate = leftHandGate;
        this.stackFilter = filter == null ? stack -> true : filter;
    }

    public void render(class_4587 matrices, T animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
    }

    @Override
    public void registerTasks(GeoRenderer<?> renderer, BakedGeoModel model) {
        Optional anchorOpt = model.getBone(this.anchorBoneName);
        if (anchorOpt.isEmpty()) {
            return;
        }
        Optional infoOpt = this.infoBoneName.equals(this.anchorBoneName) ? anchorOpt : model.getBone(this.infoBoneName);
        GeoBone anchor = (GeoBone)anchorOpt.get();
        PunchyPerBoneRenderRegistry.register(renderer, anchor, this.createVanillaItemRenderTask(infoOpt, anchor));
    }

    private PunchyPerBoneRender createVanillaItemRenderTask(Optional<GeoBone> infoOpt, GeoBone anchorBone) {
        return (matrices, bone, queue, cameraState, light, overlay, renderColor) -> {
            class_746 player;
            class_1268 hand = VanillaProxyContext.getHand();
            if (this.leftHandGate != null) {
                if (this.leftHandGate.booleanValue() && hand != class_1268.field_5810) {
                    return;
                }
                if (!this.leftHandGate.booleanValue() && hand != class_1268.field_5808) {
                    return;
                }
            }
            class_1268 effectiveHand = hand == null ? class_1268.field_5808 : hand;
            boolean left = effectiveHand == class_1268.field_5810;
            class_310 client = class_310.method_1551();
            class_1799 original = VanillaProxyContext.getOriginal();
            if (original == null || original.method_7960()) {
                class_746 fallbackPlayer = client != null ? client.field_1724 : null;
                original = fallbackPlayer != null ? HandHelper.getConfiguredHandItem((class_1657)fallbackPlayer, effectiveHand) : class_1799.field_8037;
            }
            boolean proxyActive = VanillaProxyContext.isProxyActive(effectiveHand);
            boolean forceRender = ArmAnimationOverrides.isForceRender(effectiveHand);
            boolean proxyRequired = ProxyItemHelper.requiresProxy(original);
            if (client != null) {
                boolean shouldRender;
                if (HandItemOverrides.isHidden(effectiveHand)) {
                    return;
                }
                boolean bl = shouldRender = forceRender || proxyActive || proxyRequired;
                if (!shouldRender) {
                    return;
                }
            }
            if (original.method_7960()) {
                VanillaFirstPersonItemLayer.resetNonEmptyItemLog(effectiveHand);
            } else {
                VanillaFirstPersonItemLayer.clearEmptyItemLog(effectiveHand);
            }
            if (!this.stackFilter.test(original)) {
                return;
            }
            if (client == null || client.field_1724 == null) {
                return;
            }
            matrices.method_22903();
            class_811 ctx = left ? class_811.field_4321 : class_811.field_4322;
            class_4597 buffers = queue.bufferSource();
            class_638 world = client.field_1687;
            class_746 held = player = client.field_1724;
            int resolvedLight = VanillaFirstPersonItemLayer.resolveLight((class_1937)world, (class_1309)player, light);
            GeoBone infoBone = infoOpt.orElse(anchorBone);
            Baseline baseline = BASELINES.computeIfAbsent(infoBone, b -> new Baseline(b.getRotX(), b.getRotY(), b.getRotZ(), b.getPivotX() - bone.getPivotX(), b.getPivotY() - bone.getPivotY(), b.getPivotZ() - bone.getPivotZ(), b.getPosX(), b.getPosY(), b.getPosZ()));
            RenderSneakSuppressor.push();
            try {
                boolean freezeVanillaUse;
                boolean showPivotDebug;
                float sneakOffset;
                PunchyClient.IdleSpringPose idlePose;
                boolean hasSpringPivot;
                boolean hasInfoPivot;
                PunchyClient.LanternPose pose;
                boolean lanternLike;
                class_243 cameraOffset;
                float tiltRad = PunchyClient.cameraTiltRadians(effectiveHand);
                if (tiltRad != 0.0f) {
                    matrices.method_22907(class_7833.field_40714.rotation(tiltRad));
                }
                if ((cameraOffset = PunchyClient.cameraTiltOffset(effectiveHand)).method_1027() > 1.0E-6) {
                    matrices.method_22904(cameraOffset.method_10216(), cameraOffset.method_10214(), cameraOffset.method_10215());
                }
                ToolKind resolvedKind = ToolKindResolver.resolveItemKind(original, this.kind);
                ToolTuning.Profile tuning = ToolTuning.resolveProfile(original, resolvedKind, left);
                ToolAnimationOverrides.RotationOffset overrides = ToolAnimationOverrides.rotationOffset(effectiveHand);
                float basePivotDiffX = baseline.diffX() / 16.0f;
                float basePivotDiffY = baseline.diffY() / 16.0f;
                float basePivotDiffZ = baseline.diffZ() / 16.0f;
                float currPivotDiffX = (infoBone.getPivotX() - bone.getPivotX()) / 16.0f;
                float currPivotDiffY = (infoBone.getPivotY() - bone.getPivotY()) / 16.0f;
                float currPivotDiffZ = (infoBone.getPivotZ() - bone.getPivotZ()) / 16.0f;
                float pivotDeltaX = currPivotDiffX - basePivotDiffX;
                float pivotDeltaY = currPivotDiffY - basePivotDiffY;
                float pivotDeltaZ = currPivotDiffZ - basePivotDiffZ;
                float animOffX = (infoBone.getPosX() - baseline.posX()) / 16.0f;
                float animOffY = (infoBone.getPosY() - baseline.posY()) / 16.0f;
                float animOffZ = (infoBone.getPosZ() - baseline.posZ()) / 16.0f;
                float animRotXRad = infoBone.getRotX() - baseline.rotX();
                float animRotYRad = infoBone.getRotY() - baseline.rotY();
                float animRotZRad = infoBone.getRotZ() - baseline.rotZ();
                float rotXRad = animRotXRad + tuning.rotXRad() + overrides.rotXRad();
                float rotYRad = animRotYRad + tuning.rotYRad() + overrides.rotYRad();
                float rotZRad = animRotZRad + tuning.rotZRad() + overrides.rotZRad();
                float offX = tuning.offX;
                float offY = tuning.offY;
                float offZ = tuning.offZ;
                float baseOffX = offX;
                float baseOffY = offY;
                float baseOffZ = offZ;
                float boneExtraZ = PlayerArmModelLayer.springExtraZ(effectiveHand);
                boolean bl = lanternLike = resolvedKind == ToolKind.LANTERN || resolvedKind == ToolKind.FLOWER_PENDULUM;
                if (lanternLike && (pose = PunchyClient.lanternPhysics(effectiveHand)) != null) {
                    rotXRad += pose.rotX();
                    rotYRad += pose.rotY();
                    rotZRad += pose.rotZ();
                    offX = baseOffX;
                    offY = baseOffY;
                    offZ = baseOffZ;
                }
                float pivotX = tuning.pivotX;
                float pivotY = tuning.pivotY;
                float pivotZ = tuning.pivotZ;
                boolean hasPivot = Math.abs(pivotX) > 1.0E-4f || Math.abs(pivotY) > 1.0E-4f || Math.abs(pivotZ) > 1.0E-4f;
                boolean bl2 = hasInfoPivot = Math.abs(pivotDeltaX) > 1.0E-4f || Math.abs(pivotDeltaY) > 1.0E-4f || Math.abs(pivotDeltaZ) > 1.0E-4f;
                if (hasInfoPivot || hasPivot) {
                    float totalPivotX = (hasInfoPivot ? pivotDeltaX : 0.0f) + (hasPivot ? pivotX : 0.0f);
                    float totalPivotY = (hasInfoPivot ? pivotDeltaY : 0.0f) + (hasPivot ? pivotY : 0.0f);
                    float totalPivotZ = (hasInfoPivot ? pivotDeltaZ : 0.0f) + (hasPivot ? pivotZ : 0.0f);
                    VanillaProxyContext.setItemPivot(effectiveHand, totalPivotX, totalPivotY, totalPivotZ);
                } else {
                    VanillaProxyContext.clearItemPivot(effectiveHand);
                }
                PunchyClient.JumpSpringPose springPose = PunchyClient.jumpSpringPose(effectiveHand);
                PunchyClient.JumpSpringPivot springPivot = PunchyClient.jumpSpringPivot();
                float springPivotRawX = springPivot.x();
                float springPivotX = left ? -springPivotRawX : springPivotRawX;
                float springPivotY = springPivot.y();
                float springPivotZ = springPivot.z();
                boolean bl3 = hasSpringPivot = springPivotX != 0.0f || springPivotY != 0.0f || springPivotZ != 0.0f;
                if (hasSpringPivot) {
                    matrices.method_46416(springPivotX, springPivotY, springPivotZ);
                }
                if (Punchy.DEBUG_POSITION && hasSpringPivot && buffers != null) {
                    matrices.method_22903();
                    matrices.method_22905(0.12f, 0.12f, 0.12f);
                    VanillaFirstPersonItemLayer.renderItemWithNeutralTransforms(client, SPRING_PIVOT_MARKER, ctx, left, matrices, buffers, resolvedLight, overlay, (class_1937)world, (class_1309)held);
                    matrices.method_22909();
                }
                float springPitch = springPose.rotX();
                float springRoll = springPose.rotZ();
                float springOffY = springPose.offY();
                if (springPitch != 0.0f) {
                    matrices.method_22907(class_7833.field_40714.rotation(springPitch));
                }
                if (springRoll + boneExtraZ != 0.0f) {
                    matrices.method_22907(class_7833.field_40718.rotation(springRoll + boneExtraZ));
                }
                if (hasSpringPivot) {
                    matrices.method_46416(-springPivotX, -springPivotY, -springPivotZ);
                }
                if (springOffY != 0.0f) {
                    matrices.method_46416(0.0f, springOffY, 0.0f);
                }
                if ((idlePose = PunchyClient.idleSpringPose(effectiveHand)).rotX() != 0.0f) {
                    matrices.method_22907(class_7833.field_40714.rotation(idlePose.rotX()));
                }
                if (idlePose.rotY() != 0.0f) {
                    matrices.method_22907(class_7833.field_40716.rotation(idlePose.rotY()));
                }
                if (idlePose.rotZ() != 0.0f) {
                    matrices.method_22907(class_7833.field_40718.rotation(idlePose.rotZ()));
                }
                if (idlePose.offY() != 0.0f) {
                    matrices.method_46416(0.0f, idlePose.offY(), 0.0f);
                }
                if ((sneakOffset = PunchyClient.sneakOffset(effectiveHand)) != 0.0f) {
                    matrices.method_46416(0.0f, sneakOffset, 0.0f);
                }
                HandSwayPhysics sway = HandSwayPhysics.get();
                float swayX = sway.getX(effectiveHand);
                float swayY = sway.getY(effectiveHand);
                float swayRoll = sway.getRoll(effectiveHand);
                if (swayX != 0.0f || swayY != 0.0f || swayRoll != 0.0f) {
                    matrices.method_46416(0.0f, swayY, swayX);
                    if (swayRoll != 0.0f) {
                        matrices.method_22907(class_7833.field_40718.rotationDegrees(swayRoll));
                    }
                }
                sway.applyElasticity(matrices, original);
                sway.applyMotionInertia(matrices);
                ArmToolTuning.Profile armProfile = ArmToolTuning.resolveProfile(original, this.resolveArmKind(original), left);
                if (armProfile != null) {
                    float armShiftX = armProfile.offX;
                    float armShiftY = armProfile.offY;
                    float armShiftZ = armProfile.offZ;
                    float armProfileRotX = armProfile.rotX;
                    float armProfileRotY = armProfile.rotY;
                    float armProfileRotZ = armProfile.rotZ;
                    float armProfileScale = armProfile.scale;
                    if (armShiftX != 0.0f || armShiftY != 0.0f || armShiftZ != 0.0f) {
                        matrices.method_46416(armShiftX, armShiftY, armShiftZ);
                    }
                    if (armProfileRotX != 0.0f) {
                        matrices.method_22907(class_7833.field_40714.rotationDegrees(armProfileRotX));
                    }
                    if (armProfileRotY != 0.0f) {
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(armProfileRotY));
                    }
                    if (armProfileRotZ != 0.0f) {
                        matrices.method_22907(class_7833.field_40718.rotationDegrees(armProfileRotZ));
                    }
                    if (armProfileScale != 1.0f) {
                        matrices.method_22905(armProfileScale, armProfileScale, armProfileScale);
                    }
                }
                if (hasInfoPivot) {
                    matrices.method_46416(pivotDeltaX, pivotDeltaY, pivotDeltaZ);
                }
                if (hasPivot) {
                    matrices.method_46416(pivotX, pivotY, pivotZ);
                }
                boolean bl4 = showPivotDebug = Punchy.DEBUG_POSITION && buffers != null;
                if (showPivotDebug) {
                    matrices.method_22903();
                    matrices.method_22905(0.12f, 0.12f, 0.12f);
                    VanillaFirstPersonItemLayer.renderItemWithNeutralTransforms(client, DEBUG_PIVOT_MARKER, ctx, left, matrices, buffers, resolvedLight, overlay, (class_1937)world, (class_1309)held);
                    matrices.method_22909();
                }
                if (rotZRad != 0.0f) {
                    matrices.method_22907(class_7833.field_40718.rotation(rotZRad));
                }
                if (rotXRad != 0.0f) {
                    matrices.method_22907(class_7833.field_40714.rotation(rotXRad));
                }
                if (rotYRad != 0.0f) {
                    matrices.method_22907(class_7833.field_40716.rotation(rotYRad));
                }
                float anchorOffX = animOffX;
                float anchorOffY = animOffY;
                float anchorOffZ = animOffZ;
                if (hasPivot) {
                    matrices.method_46416(-pivotX, -pivotY, -pivotZ);
                    anchorOffX += pivotX;
                    anchorOffY += pivotY;
                    anchorOffZ += pivotZ;
                }
                if (hasInfoPivot) {
                    matrices.method_46416(-pivotDeltaX, -pivotDeltaY, -pivotDeltaZ);
                    anchorOffX += pivotDeltaX;
                    anchorOffY += pivotDeltaY;
                    anchorOffZ += pivotDeltaZ;
                }
                float finalOffX = anchorOffX + offX;
                float finalOffY = anchorOffY + offY;
                float finalOffZ = anchorOffZ + offZ;
                if (finalOffX != 0.0f || finalOffY != 0.0f || finalOffZ != 0.0f) {
                    matrices.method_46416(finalOffX, finalOffY, finalOffZ);
                }
                if (tuning.scale != 1.0f) {
                    matrices.method_22905(tuning.scale, tuning.scale, tuning.scale);
                }
                if (freezeVanillaUse = VanillaFirstPersonItemLayer.shouldFreezeVanillaUse(original, effectiveHand)) {
                    UseAnimationSuppressor.push();
                }
                try {
                    if (buffers != null) {
                        VanillaFirstPersonItemLayer.renderItemWithNeutralTransforms(client, original, ctx, left, matrices, buffers, resolvedLight, overlay, (class_1937)world, (class_1309)held);
                    }
                }
                finally {
                    if (freezeVanillaUse) {
                        UseAnimationSuppressor.pop();
                    }
                }
            }
            finally {
                RenderSneakSuppressor.pop();
            }
            matrices.method_22909();
        };
    }

    private static void renderItemWithNeutralTransforms(class_310 client, class_1799 stack, class_811 ctx, boolean left, class_4587 matrices, class_4597 buffers, int light, int overlay, class_1937 world, class_1309 entity) {
        if (client == null || stack == null || stack.method_7960() || buffers == null) {
            return;
        }
        class_918 renderer = client.method_1480();
        int entityId = entity != null ? entity.method_5628() : 0;
        class_1087 model = renderer.method_4019(stack, world, entity, entityId);
        renderer.method_23179(stack, ctx, left, matrices, buffers, light, overlay, (class_1087)new NeutralizedBakedModel(model));
    }

    private static int resolveLight(class_1937 world, class_1309 player, int fallback) {
        return LightingHelper.resolveLight(world, player, fallback);
    }

    private static boolean shouldFreezeVanillaUse(class_1799 stack, class_1268 hand) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (!PunchyClient.isBowHandSuppressed(hand)) {
            return false;
        }
        if (stack.method_7976() == class_1839.field_8953) {
            return true;
        }
        class_1792 item = stack.method_7909();
        return item instanceof class_1753 || item instanceof class_1764;
    }

    private static void resetNonEmptyItemLog(class_1268 hand) {
        if (hand == class_1268.field_5810) {
            loggedNonEmptyItemOff = false;
            lastLoggedItemOffId = null;
        } else {
            loggedNonEmptyItemMain = false;
            lastLoggedItemMainId = null;
        }
    }

    private static void clearEmptyItemLog(class_1268 hand) {
        if (hand == class_1268.field_5810) {
            loggedEmptyItemOff = false;
        } else {
            loggedEmptyItemMain = false;
        }
    }

    private static boolean shouldLogEmptyItem(class_1268 hand) {
        boolean already;
        boolean left = hand == class_1268.field_5810;
        boolean bl = already = left ? loggedEmptyItemOff : loggedEmptyItemMain;
        if (!already) {
            if (left) {
                loggedEmptyItemOff = true;
            } else {
                loggedEmptyItemMain = true;
            }
            return true;
        }
        return false;
    }

    private static boolean shouldLogItemSample(class_1268 hand, class_2960 itemId) {
        boolean needsLog;
        boolean left = hand == class_1268.field_5810;
        class_2960 lastId = left ? lastLoggedItemOffId : lastLoggedItemMainId;
        boolean alreadyLogged = left ? loggedNonEmptyItemOff : loggedNonEmptyItemMain;
        boolean bl = needsLog = !alreadyLogged || !Objects.equals(lastId, itemId);
        if (needsLog) {
            if (left) {
                loggedNonEmptyItemOff = true;
                lastLoggedItemOffId = itemId;
            } else {
                loggedNonEmptyItemMain = true;
                lastLoggedItemMainId = itemId;
            }
        }
        return needsLog;
    }

    private PlayerArmModelLayer.ToolKind resolveArmKind(class_1799 stack) {
        ToolKind itemKind = ToolKindResolver.resolveItemKind(stack, this.kind);
        if (itemKind != null) {
            try {
                return PlayerArmModelLayer.ToolKind.valueOf(itemKind.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return PlayerArmModelLayer.ToolKind.AXE;
    }

    public static enum ToolKind {
        AXE,
        PICKAXE,
        HOE,
        SWORD,
        SHOVEL,
        SHIELD,
        BLOCK,
        TORCH,
        LANTERN,
        FLOWER_PENDULUM,
        CREATURE_BUCKET,
        MINECART,
        BOAT,
        BUTTON_PLATE,
        TRAPDOOR,
        CARPET,
        BED,
        BOW,
        ARROW,
        CROSSBOW,
        SPYGLASS,
        FLINT,
        FOOD,
        SHUBBA_DUCK,
        MACE,
        TRIDENT,
        FISHING_ROD,
        REDSTONE,
        INGREDIENT;

    }

    private static final class NeutralizedBakedModel
    implements class_1087 {
        private final class_1087 delegate;

        private NeutralizedBakedModel(class_1087 delegate) {
            this.delegate = delegate;
        }

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, class_5819 random) {
            return this.delegate.method_4707(state, face, random);
        }

        public boolean method_4708() {
            return this.delegate.method_4708();
        }

        public boolean method_4712() {
            return this.delegate.method_4712();
        }

        public boolean method_24304() {
            return this.delegate.method_24304();
        }

        public boolean method_4713() {
            return this.delegate.method_4713();
        }

        public class_1058 method_4711() {
            return this.delegate.method_4711();
        }

        public class_809 method_4709() {
            return class_809.field_4301;
        }

        public class_806 method_4710() {
            return this.delegate.method_4710();
        }
    }

    private record Baseline(float rotX, float rotY, float rotZ, float diffX, float diffY, float diffZ, float posX, float posY, float posZ) {
    }
}

