/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.geo.compat;

import com.henrique.punchy.geo.compat.PunchyPerBoneRender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;

public class PunchyPerBoneRenderTasks {
    private static final ThreadLocal<Map<GeoRenderer<?>, ForRenderer>> TASKS = ThreadLocal.withInitial(WeakHashMap::new);

    public static ForRenderer get(GeoRenderer<?> renderer) {
        return TASKS.get().computeIfAbsent(renderer, k -> new ForRenderer());
    }

    public static class ForRenderer {
        private final Map<GeoBone, List<PunchyPerBoneRender>> tasks = new HashMap<GeoBone, List<PunchyPerBoneRender>>();

        public void addTask(GeoBone bone, PunchyPerBoneRender task) {
            this.tasks.computeIfAbsent(bone, k -> new ArrayList()).add(task);
        }

        public Map<GeoBone, List<PunchyPerBoneRender>> getTasks() {
            return this.tasks;
        }

        public void clear() {
            this.tasks.clear();
        }

        public boolean isEmpty() {
            return this.tasks.isEmpty();
        }
    }
}

