/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.renderer.layer.PunchyBoneTaskProvider;
import com.henrique.punchy.geo.compat.PunchyCameraRenderState;
import com.henrique.punchy.geo.compat.PunchyPerBoneRender;
import com.henrique.punchy.geo.compat.PunchyPerBoneRenderTasks;
import com.henrique.punchy.geo.compat.PunchySubmitNodeCollector;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

@Mixin(value={GeoRenderer.class})
public interface PunchyGeoRendererMixin<T extends GeoAnimatable> {
    @Inject(method={"actuallyRender"}, at={@At(value="HEAD")})
    private void punchy$populateBoneTasks(class_4587 poseStack, T animatable, BakedGeoModel model, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour, CallbackInfo ci) {
        if (!(animatable instanceof class_1792)) {
            return;
        }
        GeoRenderer renderer = (GeoRenderer)this;
        PunchyPerBoneRenderTasks.ForRenderer taskBucket = PunchyPerBoneRenderTasks.get(renderer);
        taskBucket.clear();
        List layers = renderer.getRenderLayers();
        if (layers != null) {
            for (GeoRenderLayer layer : layers) {
                if (!(layer instanceof PunchyBoneTaskProvider)) continue;
                PunchyBoneTaskProvider provider = (PunchyBoneTaskProvider)layer;
                provider.registerTasks(renderer, model);
            }
        }
        System.out.println("Punchy: Populated tasks for renderer " + String.valueOf(renderer) + ". Task count: " + taskBucket.getTasks().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"renderRecursively"}, at={@At(value="HEAD")})
    private void punchy$runPerBoneTasks(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour, CallbackInfo ci) {
        if (!(animatable instanceof class_1792)) {
            return;
        }
        GeoRenderer renderer = (GeoRenderer)this;
        PunchyPerBoneRenderTasks.ForRenderer taskBucket = PunchyPerBoneRenderTasks.get(renderer);
        if (taskBucket == null || taskBucket.isEmpty()) {
            return;
        }
        List<PunchyPerBoneRender> tasks = taskBucket.getTasks().get(bone);
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        System.out.println("Punchy: Running tasks for bone " + bone.getName());
        PunchySubmitNodeCollector queue = new PunchySubmitNodeCollector(bufferSource);
        PunchyCameraRenderState cameraState = PunchyCameraRenderState.capture();
        AutoCloseable tiltGuard = PunchyClient.pushDisableCameraTilt();
        try {
            poseStack.method_22903();
            PunchyGeoRendererMixin.applyBoneTransform(poseStack, bone);
            PunchyGeoRendererMixin.applyBoneAnchorRotation(poseStack, bone);
            for (PunchyPerBoneRender task : tasks) {
                task.submitRenderTask(poseStack, bone, queue, cameraState, packedLight, packedOverlay, colour);
            }
            poseStack.method_22909();
        }
        finally {
            try {
                tiltGuard.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Inject(method={"renderRecursively"}, at={@At(value="INVOKE", target="Lsoftware/bernie/geckolib/util/RenderUtil;prepMatrixForBone(Lcom/mojang/blaze3d/vertex/PoseStack;Lsoftware/bernie/geckolib/cache/object/GeoBone;)V", shift=At.Shift.AFTER)})
    private void punchy$applyAnchorRotation(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour, CallbackInfo ci) {
        if (animatable instanceof class_1792) {
            PunchyGeoRendererMixin.applyBoneAnchorRotation(poseStack, bone);
        }
    }

    private static void applyBoneTransform(class_4587 poseStack, GeoBone bone) {
        RenderUtil.prepMatrixForBone((class_4587)poseStack, (GeoBone)bone);
    }

    private static void applyBoneAnchorRotation(class_4587 poseStack, GeoBone bone) {
        float pitchRotation;
        String name = bone.getName();
        if (name == null) {
            return;
        }
        boolean isRight = "bone_anchor_right".equals(name);
        boolean isLeft = "bone_anchor_left".equals(name);
        if (!isRight && !isLeft) {
            return;
        }
        float yawRotation = PunchyClient.cameraAnchorYawRadiansRaw();
        if (yawRotation != 0.0f) {
            if (isRight) {
                yawRotation = -yawRotation;
            }
            poseStack.method_22907(class_7833.field_40714.rotation(yawRotation));
        }
        if ((pitchRotation = PunchyClient.cameraAnchorPitchRadiansRaw()) != 0.0f) {
            poseStack.method_22907(class_7833.field_40718.rotation(pitchRotation));
        }
    }
}

