/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.networking;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.combat.ImpactServer;
import com.henrique.punchy.networking.packet.AxeStripPayload;
import com.henrique.punchy.networking.packet.BlockImpactPayload;
import com.henrique.punchy.networking.packet.HoeTillPayload;
import com.henrique.punchy.networking.packet.ImpactAttackPayload;
import com.henrique.punchy.networking.packet.ShovelPathPayload;
import com.henrique.punchy.platform.PlatformServices;
import com.henrique.punchy.server.TapMiningManager;
import com.henrique.punchy.util.AxeStripHelper;
import com.henrique.punchy.util.HandHelper;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ServerPacketHandlers {
    public static void handleBlockImpact(BlockImpactPayload payload, PlatformServices.ServerPacketContext context) {
        class_2338 pos = payload.pos();
        class_3222 player = context.player();
        context.queue(() -> {
            if (!Punchy.TAP_MINING_ENABLED) {
                return;
            }
            class_3218 world = (class_3218)player.method_37908();
            TapMiningManager.onClick(player, world, pos);
        });
    }

    public static void handleHoeTill(HoeTillPayload payload, PlatformServices.ServerPacketContext context) {
        class_2338 pos = payload.pos();
        class_3222 player = context.player();
        context.queue(() -> {
            class_3218 world = (class_3218)player.method_37908();
            if (world == null) {
                return;
            }
            class_2338 above = pos.method_10084();
            if (!world.method_8320(above).method_26215()) {
                return;
            }
            class_2680 state = world.method_8320(pos);
            if (state.method_27852(class_2246.field_10253)) {
                world.method_8501(pos, class_2246.field_10566.method_9564());
                world.method_8396(null, pos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                HandHelper.getConfiguredMainHandItem((class_1657)player).method_7970(1, (class_1309)player, class_1304.field_6173);
            } else if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_28685)) {
                world.method_8501(pos, class_2246.field_10362.method_9564());
                world.method_8396(null, pos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                HandHelper.getConfiguredMainHandItem((class_1657)player).method_7970(1, (class_1309)player, class_1304.field_6173);
            }
        });
    }

    public static void handleAxeStrip(AxeStripPayload payload, PlatformServices.ServerPacketContext context) {
        class_2338 pos = payload.pos();
        class_3222 player = context.player();
        context.queue(() -> {
            class_3218 world = (class_3218)player.method_37908();
            if (world == null) {
                return;
            }
            class_2680 state = world.method_8320(pos);
            AxeStripHelper.CopperResult copper = AxeStripHelper.tryCopper(state);
            if (copper != null) {
                world.method_8501(pos, copper.state());
                world.method_8396(null, pos, copper.sound(), class_3419.field_15245, 1.0f, 1.0f);
                HandHelper.getConfiguredMainHandItem((class_1657)player).method_7970(1, (class_1309)player, class_1304.field_6173);
                return;
            }
            class_2680 stripped = AxeStripHelper.getStrippedState(state);
            if (stripped != null) {
                world.method_8501(pos, stripped);
                world.method_8396(null, pos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
                HandHelper.getConfiguredMainHandItem((class_1657)player).method_7970(1, (class_1309)player, class_1304.field_6173);
            }
        });
    }

    public static void handleShovelPath(ShovelPathPayload payload, PlatformServices.ServerPacketContext context) {
        class_2338 pos = payload.pos();
        class_3222 player = context.player();
        context.queue(() -> {
            class_3218 world = (class_3218)player.method_37908();
            if (world == null) {
                return;
            }
            class_2338 above = pos.method_10084();
            if (!world.method_8320(above).method_26215()) {
                return;
            }
            class_2680 state = world.method_8320(pos);
            if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10253) || state.method_27852(class_2246.field_28685)) {
                world.method_8501(pos, class_2246.field_10194.method_9564());
                world.method_8396(null, pos, class_3417.field_14616, class_3419.field_15245, 1.0f, 1.0f);
                try {
                    HandHelper.getConfiguredMainHandItem((class_1657)player).method_7970(1, (class_1309)player, class_1304.field_6173);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static void handleImpactAttack(ImpactAttackPayload payload, PlatformServices.ServerPacketContext context) {
        class_3222 player = context.player();
        context.queue(() -> ImpactServer.handleImpact(player, payload));
    }
}

