/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.render.anim.BoneAnimationIds;
import com.henrique.punchy.item.AnimatedBoneProxy;
import com.henrique.punchy.item.AnimatedTool;
import com.henrique.punchy.util.HandHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;

public final class BoneAnimationController {
    private static final String ACTIVATION = "Activation";

    private BoneAnimationController() {
    }

    private static AnimatedBoneProxy boneProxy() {
        return Punchy.boneProxy();
    }

    private static long instanceId(class_1657 player, class_1268 hand) {
        return BoneAnimationIds.compute(player, hand);
    }

    public static void triggerActivation(class_1657 player, class_1268 hand, String animation) {
        BoneAnimationController.trigger(player, hand, ACTIVATION, animation);
    }

    public static void stopActivation(class_1657 player, class_1268 hand, String animation) {
        BoneAnimationController.stop(player, hand, ACTIVATION, animation);
    }

    public static void trigger(class_1657 player, class_1268 hand, String controller, String animation) {
        AnimatedBoneProxy proxy = BoneAnimationController.boneProxy();
        if (proxy == null || player == null || animation == null || animation.isEmpty()) {
            return;
        }
        AnimationVariant variant = BoneAnimationController.resolveVariant(player, hand);
        String triggerKeyBase = BoneAnimationController.selectTriggerBase(proxy, animation, variant, hand);
        if (triggerKeyBase == null || triggerKeyBase.isEmpty()) {
            return;
        }
        long id = BoneAnimationController.instanceId(player, hand);
        String resolved = BoneAnimationController.resolvedAnimation(triggerKeyBase, hand);
        proxy.triggerAnim((class_1297)player, id, controller, resolved);
        PunchyClient.onAnimationTriggered(player, hand, controller, resolved, id);
    }

    public static void stop(class_1657 player, class_1268 hand, String controller, String animation) {
        AnimatedBoneProxy proxy = BoneAnimationController.boneProxy();
        if (proxy == null || player == null || animation == null || animation.isEmpty()) {
            return;
        }
        AnimationVariant variant = BoneAnimationController.resolveVariant(player, hand);
        String triggerKeyBase = BoneAnimationController.selectTriggerBase(proxy, animation, variant, hand);
        if (triggerKeyBase == null || triggerKeyBase.isEmpty()) {
            return;
        }
        long id = BoneAnimationController.instanceId(player, hand);
        String resolved = BoneAnimationController.resolvedAnimation(triggerKeyBase, hand);
        proxy.stopTriggeredAnim((class_1297)player, id, controller, resolved);
        PunchyClient.onAnimationStopped(player, hand, controller, resolved, id);
    }

    private static String resolvedAnimation(String animation, class_1268 hand) {
        return AnimatedTool.triggerName(animation, hand);
    }

    private static AnimationVariant resolveVariant(class_1657 player, class_1268 hand) {
        if (player == null) {
            return AnimationVariant.DEFAULT;
        }
        class_1799 stack = HandHelper.getConfiguredHandItem(player, hand == null ? class_1268.field_5808 : hand);
        if (stack == null || stack.method_7960()) {
            return AnimationVariant.DEFAULT;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            return AnimationVariant.BLOCK;
        }
        if (item instanceof class_1764) {
            return AnimationVariant.CROSSBOW;
        }
        if (item instanceof class_1753) {
            return AnimationVariant.BOW;
        }
        class_1839 useAnim = stack.method_7976();
        if (useAnim == class_1839.field_8950 || useAnim == class_1839.field_8946) {
            return AnimationVariant.FOOD;
        }
        return AnimationVariant.DEFAULT;
    }

    private static String applyVariant(String animation, AnimationVariant variant) {
        if (variant == AnimationVariant.DEFAULT) {
            return animation;
        }
        return animation + "_" + variant.suffix();
    }

    private static String selectTriggerBase(AnimatedBoneProxy proxy, String animation, AnimationVariant variant, class_1268 hand) {
        if (animation == null || animation.isEmpty()) {
            return "";
        }
        if (variant != AnimationVariant.DEFAULT && proxy != null && proxy.hasVariantClip(animation, variant.suffix(), hand)) {
            return BoneAnimationController.applyVariant(animation, variant);
        }
        return animation;
    }

    private static enum AnimationVariant {
        DEFAULT("default"),
        BLOCK("block"),
        FOOD("food"),
        BOW("bow"),
        CROSSBOW("crossbow");

        private final String suffix;

        private AnimationVariant(String suffix) {
            this.suffix = suffix;
        }

        public String suffix() {
            return this.suffix;
        }
    }
}

