/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.renderer.layer;

import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class ArmToolTuning {
    private static Profile RIGHT_GLOBAL;
    private static Profile LEFT_GLOBAL;
    private static final EnumMap<PlayerArmModelLayer.ToolKind, Profile> PROFILES_RIGHT;
    private static final EnumMap<PlayerArmModelLayer.ToolKind, Profile> PROFILES_LEFT;
    private static final EnumMap<PlayerArmModelLayer.ToolKind, TransformOverride> OVERRIDES_RIGHT;
    private static final EnumMap<PlayerArmModelLayer.ToolKind, TransformOverride> OVERRIDES_LEFT;
    private static final Map<class_2960, SpecificEntry> ITEM_SPECIFICS;
    private static final EnumMap<PlayerArmModelLayer.ToolKind, Boolean> ATTACHED_RIGHT;
    private static final EnumMap<PlayerArmModelLayer.ToolKind, Boolean> ATTACHED_LEFT;

    private ArmToolTuning() {
    }

    public static void resetDefaults() {
        RIGHT_GLOBAL = new Profile(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        LEFT_GLOBAL = RIGHT_GLOBAL.mirror();
        PROFILES_RIGHT.clear();
        PROFILES_LEFT.clear();
        OVERRIDES_RIGHT.clear();
        OVERRIDES_LEFT.clear();
        ATTACHED_RIGHT.clear();
        ATTACHED_LEFT.clear();
        for (PlayerArmModelLayer.ToolKind kind : PlayerArmModelLayer.ToolKind.values()) {
            PROFILES_RIGHT.put(kind, ArmToolTuning.copyProfile(RIGHT_GLOBAL));
            PROFILES_LEFT.put(kind, ArmToolTuning.copyProfile(LEFT_GLOBAL));
            OVERRIDES_RIGHT.put(kind, new TransformOverride());
            OVERRIDES_LEFT.put(kind, new TransformOverride());
            ATTACHED_RIGHT.put(kind, true);
            ATTACHED_LEFT.put(kind, true);
        }
        ITEM_SPECIFICS.clear();
    }

    public static boolean isKindAttached(PlayerArmModelLayer.ToolKind kind, boolean left) {
        if (kind == null) {
            return true;
        }
        return (left ? ATTACHED_LEFT : ATTACHED_RIGHT).getOrDefault((Object)kind, true);
    }

    public static void markKindDetached(PlayerArmModelLayer.ToolKind kind, boolean left) {
        if (kind == null) {
            return;
        }
        (left ? ATTACHED_LEFT : ATTACHED_RIGHT).put(kind, false);
    }

    public static void markKindAttached(PlayerArmModelLayer.ToolKind kind, boolean left) {
        if (kind == null) {
            return;
        }
        (left ? ATTACHED_LEFT : ATTACHED_RIGHT).put(kind, true);
        ArmToolTuning.refreshKind(kind, left);
    }

    public static Profile get(PlayerArmModelLayer.ToolKind kind, boolean left) {
        if (kind == null) {
            return ArmToolTuning.getGlobal(left);
        }
        return (left ? PROFILES_LEFT : PROFILES_RIGHT).get((Object)kind);
    }

    public static Profile getGlobal(boolean left) {
        return left ? LEFT_GLOBAL : RIGHT_GLOBAL;
    }

    public static void apply(PlayerArmModelLayer.ToolKind kind, boolean left, Profile p) {
        if (p == null) {
            return;
        }
        if (kind == null) {
            ArmToolTuning.applyGlobal(left, p);
            return;
        }
        Profile dst = ArmToolTuning.get(kind, left);
        if (dst != null) {
            dst.copyFrom(p);
            ArmToolTuning.commitKind(kind, left);
        }
    }

    public static void applyGlobal(boolean left, Profile p) {
        if (p == null) {
            return;
        }
        ArmToolTuning.getGlobal(left).copyFrom(p);
        ArmToolTuning.refresh(left);
    }

    public static void commitGlobal(boolean left) {
        ArmToolTuning.refresh(left);
    }

    public static Profile snapshot(PlayerArmModelLayer.ToolKind kind, boolean left) {
        Profile s = ArmToolTuning.get(kind, left);
        return ArmToolTuning.copyProfile(s);
    }

    public static Profile snapshotGlobal(boolean left) {
        return ArmToolTuning.snapshot(null, left);
    }

    private static Profile copyProfile(Profile src) {
        return new Profile(src.scale, src.offX, src.offY, src.offZ, src.rotX, src.rotY, src.rotZ);
    }

    public static void commitKind(PlayerArmModelLayer.ToolKind kind, boolean left) {
        Profile base = ArmToolTuning.getGlobal(left);
        Profile dst = ArmToolTuning.get(kind, left);
        TransformOverride override = ArmToolTuning.getOverride(kind, left);
        override.set(base, dst);
    }

    private static TransformOverride getOverride(PlayerArmModelLayer.ToolKind kind, boolean left) {
        return (left ? OVERRIDES_LEFT : OVERRIDES_RIGHT).get((Object)kind);
    }

    private static void refresh(boolean left) {
        for (PlayerArmModelLayer.ToolKind kind : PlayerArmModelLayer.ToolKind.values()) {
            ArmToolTuning.refreshKind(kind, left);
        }
    }

    private static void refreshKind(PlayerArmModelLayer.ToolKind kind, boolean left) {
        Profile dst = ArmToolTuning.get(kind, left);
        Profile base = ArmToolTuning.getGlobal(left);
        if (dst == null || base == null) {
            return;
        }
        if (ArmToolTuning.isKindAttached(kind, left)) {
            dst.copyFrom(base);
            return;
        }
        TransformOverride override = ArmToolTuning.getOverride(kind, left);
        if (override == null) {
            return;
        }
        dst.scale = base.scale + override.scale;
        dst.offX = base.offX + override.offX;
        dst.offY = base.offY + override.offY;
        dst.offZ = base.offZ + override.offZ;
        dst.rotX = base.rotX + override.rotX;
        dst.rotY = base.rotY + override.rotY;
        dst.rotZ = base.rotZ + override.rotZ;
    }

    private static class_2960 idFor(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return null;
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909());
    }

    public static Profile resolveProfile(class_1799 stack, PlayerArmModelLayer.ToolKind kind, boolean left) {
        Profile profile;
        SpecificEntry entry;
        class_2960 id = ArmToolTuning.idFor(stack);
        if (id != null && (entry = ITEM_SPECIFICS.get(id)) != null && (profile = entry.get(left)) != null) {
            return profile;
        }
        return ArmToolTuning.get(kind, left);
    }

    public static void applySpecific(class_2960 id, PlayerArmModelLayer.ToolKind kind, Profile right, Profile left) {
        if (id == null || kind == null) {
            return;
        }
        SpecificEntry entry = new SpecificEntry(kind);
        entry.right = right != null ? ArmToolTuning.copyProfile(right) : null;
        entry.left = left != null ? ArmToolTuning.copyProfile(left) : null;
        ITEM_SPECIFICS.put(id, entry);
    }

    public static Profile getSpecificProfile(class_2960 id, PlayerArmModelLayer.ToolKind kind, boolean left) {
        Profile profile;
        if (id == null) {
            return null;
        }
        SpecificEntry entry = ITEM_SPECIFICS.computeIfAbsent(id, key -> new SpecificEntry(kind));
        if (entry.kind == null) {
            entry.kind = kind;
        }
        if ((profile = entry.get(left)) == null) {
            profile = ArmToolTuning.copyProfile(ArmToolTuning.snapshot(kind, left));
            entry.set(left, profile);
        }
        return profile;
    }

    public static Map<class_2960, SpecificSnapshot> snapshotSpecifics() {
        HashMap<class_2960, SpecificSnapshot> copy = new HashMap<class_2960, SpecificSnapshot>();
        ITEM_SPECIFICS.forEach((id, entry) -> copy.put((class_2960)id, new SpecificSnapshot(entry.kind, entry.right != null ? ArmToolTuning.copyProfile(entry.right) : null, entry.left != null ? ArmToolTuning.copyProfile(entry.left) : null)));
        return copy;
    }

    public static void clearSpecifics() {
        ITEM_SPECIFICS.clear();
    }

    static {
        PROFILES_RIGHT = new EnumMap(PlayerArmModelLayer.ToolKind.class);
        PROFILES_LEFT = new EnumMap(PlayerArmModelLayer.ToolKind.class);
        OVERRIDES_RIGHT = new EnumMap(PlayerArmModelLayer.ToolKind.class);
        OVERRIDES_LEFT = new EnumMap(PlayerArmModelLayer.ToolKind.class);
        ITEM_SPECIFICS = new HashMap<class_2960, SpecificEntry>();
        ATTACHED_RIGHT = new EnumMap(PlayerArmModelLayer.ToolKind.class);
        ATTACHED_LEFT = new EnumMap(PlayerArmModelLayer.ToolKind.class);
        ArmToolTuning.resetDefaults();
    }

    public static final class Profile {
        public float scale;
        public float offX;
        public float offY;
        public float offZ;
        public float rotX;
        public float rotY;
        public float rotZ;

        public Profile(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.offZ = offZ;
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
        }

        public Profile mirror() {
            return new Profile(this.scale, -this.offX, this.offY, this.offZ, this.rotX, -this.rotY, -this.rotZ);
        }

        public void copyFrom(Profile other) {
            this.scale = other.scale;
            this.offX = other.offX;
            this.offY = other.offY;
            this.offZ = other.offZ;
            this.rotX = other.rotX;
            this.rotY = other.rotY;
            this.rotZ = other.rotZ;
        }
    }

    private static final class TransformOverride {
        float scale;
        float offX;
        float offY;
        float offZ;
        float rotX;
        float rotY;
        float rotZ;

        private TransformOverride() {
        }

        void set(Profile base, Profile target) {
            this.scale = target.scale - base.scale;
            this.offX = target.offX - base.offX;
            this.offY = target.offY - base.offY;
            this.offZ = target.offZ - base.offZ;
            this.rotX = target.rotX - base.rotX;
            this.rotY = target.rotY - base.rotY;
            this.rotZ = target.rotZ - base.rotZ;
        }
    }

    public static final class SpecificEntry {
        PlayerArmModelLayer.ToolKind kind;
        Profile right;
        Profile left;

        SpecificEntry(PlayerArmModelLayer.ToolKind kind) {
            this.kind = kind;
        }

        Profile get(boolean leftHand) {
            return leftHand ? this.left : this.right;
        }

        void set(boolean leftHand, Profile profile) {
            if (leftHand) {
                this.left = profile;
            } else {
                this.right = profile;
            }
        }

        public PlayerArmModelLayer.ToolKind kind() {
            return this.kind;
        }

        public Profile right() {
            return this.right;
        }

        public Profile left() {
            return this.left;
        }
    }

    public static final class SpecificSnapshot {
        private final PlayerArmModelLayer.ToolKind kind;
        private final Profile right;
        private final Profile left;

        public SpecificSnapshot(PlayerArmModelLayer.ToolKind kind, Profile right, Profile left) {
            this.kind = kind;
            this.right = right;
            this.left = left;
        }

        public PlayerArmModelLayer.ToolKind kind() {
            return this.kind;
        }

        public Profile right() {
            return this.right;
        }

        public Profile left() {
            return this.left;
        }
    }
}

