/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.renderer.layer;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.debug.AnchorDebugProbe;
import com.henrique.punchy.client.render.ArmAnimationOverrides;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.PunchyArmMeshes;
import com.henrique.punchy.client.render.RenderSneakSuppressor;
import com.henrique.punchy.client.render.ToolAnimationOverrides;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.renderer.layer.ArmMeshTuning;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PunchyBoneTaskProvider;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import com.henrique.punchy.geo.compat.PunchyPerBoneRender;
import com.henrique.punchy.geo.compat.PunchyPerBoneRenderRegistry;
import com.henrique.punchy.util.HandHelper;
import com.henrique.punchy.util.ProxyItemHelper;
import java.util.EnumMap;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1068;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class PlayerArmModelLayer<T extends class_1792>
extends GeoRenderLayer<T>
implements PunchyBoneTaskProvider {
    private final String boneName;
    private final boolean leftArm;
    private final ToolKind kind;
    private final boolean matchContextHand;
    private final boolean requireOffhandItem;
    private final Predicate<class_1799> originalFilter;
    private static long lastLogTick = -9999L;
    private static class_5498 lastPerspective = null;
    private static long rearmAtTick = -1L;
    private static final EnumMap<class_1268, Float> extraZCache = new EnumMap(class_1268.class);

    static float springExtraZ(class_1268 hand) {
        return extraZCache.getOrDefault(hand == null ? class_1268.field_5808 : hand, Float.valueOf(0.0f)).floatValue();
    }

    private ToolKind resolveArmKind(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return this.kind;
        }
        VanillaFirstPersonItemLayer.ToolKind itemKind = ToolKindResolver.resolveItemKind(stack, null);
        if (itemKind != null) {
            try {
                return ToolKind.valueOf(itemKind.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.kind;
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName) {
        this(renderer, boneName, false, ToolKind.AXE, true, true, stack -> true);
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName, boolean leftArm) {
        this(renderer, boneName, leftArm, ToolKind.AXE, true, true, stack -> true);
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind) {
        this(renderer, boneName, false, kind, true, true, stack -> true);
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName, boolean leftArm, ToolKind kind) {
        this(renderer, boneName, leftArm, kind, true, true, stack -> true);
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName, boolean leftArm, ToolKind kind, boolean matchContextHand, boolean requireOffhandItem, Predicate<class_1799> originalFilter) {
        super(renderer);
        this.boneName = boneName;
        this.leftArm = leftArm;
        this.kind = kind;
        this.matchContextHand = matchContextHand;
        this.requireOffhandItem = requireOffhandItem;
        this.originalFilter = originalFilter == null ? stack -> true : originalFilter;
    }

    public void render(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
    }

    @Override
    public void registerTasks(GeoRenderer<?> renderer, BakedGeoModel model) {
        Optional opt = model.getBone(this.boneName);
        if (opt.isEmpty()) {
            return;
        }
        GeoBone target = (GeoBone)opt.get();
        PunchyPerBoneRenderRegistry.register(renderer, target, this.createArmRenderTask());
    }

    private PunchyPerBoneRender createArmRenderTask() {
        return (matrices, bone, queue, cameraState, light, overlay, renderColor) -> {
            class_243 cameraOffset;
            boolean loweredPose;
            class_1799 original;
            class_1799 filterStack;
            class_1268 renderHand;
            class_1268 expectedHand;
            class_310 client = class_310.method_1551();
            if (client == null || client.field_1724 == null) {
                return;
            }
            class_746 player = client.field_1724;
            class_1268 contextHand = VanillaProxyContext.getHand();
            class_1268 class_12682 = expectedHand = this.leftArm ? class_1268.field_5810 : class_1268.field_5808;
            if (this.matchContextHand && contextHand != expectedHand) {
                return;
            }
            class_1268 class_12683 = renderHand = this.matchContextHand ? contextHand : expectedHand;
            if (renderHand == null) {
                renderHand = expectedHand;
            }
            class_1799 class_17992 = filterStack = (original = VanillaProxyContext.getOriginal()) == null ? class_1799.field_8037 : original;
            if (client.field_1724 != null && !ProxyItemHelper.requiresProxy(filterStack)) {
                return;
            }
            boolean forceRender = ArmAnimationOverrides.isForceRender(renderHand);
            class_1268 logicalContext = VanillaProxyContext.getLogicalHand();
            class_1268 loweredRender = logicalContext != null ? logicalContext : renderHand;
            class_1268 loweredTarget = class_1268.field_5810;
            boolean bl = loweredPose = loweredRender == loweredTarget && PunchyClient.isHandLowered(loweredTarget);
            if (renderHand == class_1268.field_5810 && !forceRender && filterStack.method_7960() && !loweredPose) {
                return;
            }
            if (!forceRender && !this.originalFilter.test(filterStack)) {
                return;
            }
            boolean pendulumFlower = ToolKindResolver.isPendulumFlower(filterStack);
            boolean baseLantern = !filterStack.method_7960() && (filterStack.method_31574(class_1802.field_16539) || filterStack.method_31574(class_1802.field_22016));
            boolean lanternLike = pendulumFlower || baseLantern;
            class_5498 perspective = client.field_1690.method_31044();
            if (perspective != class_5498.field_26664) {
                lastPerspective = perspective;
                rearmAtTick = -1L;
                return;
            }
            lastPerspective = perspective;
            class_2960 skinTex = null;
            boolean slim = false;
            if (!Punchy.ARM_USE_PLAYER_SKIN && Punchy.ARM_SKIN_OVERRIDE != null) {
                skinTex = Punchy.ARM_SKIN_OVERRIDE;
            } else {
                slim = "slim".equals(player.method_3121());
                class_2960 playerSkin = player.method_3117();
                if (playerSkin != null) {
                    skinTex = playerSkin;
                }
            }
            if (skinTex == null) {
                class_2960 def = class_1068.method_4649();
                if (def != null) {
                    skinTex = def;
                }
                if (skinTex == null) {
                    skinTex = new class_2960("minecraft", slim ? "textures/entity/player/slim/alex.png" : "textures/entity/player/wide/steve.png");
                }
            }
            if (skinTex == null) {
                return;
            }
            matrices.method_22903();
            Matrix4f boneTransform = new Matrix4f((Matrix4fc)matrices.method_23760().method_23761());
            matrices.method_23760().method_23761().identity();
            float tiltRad = PunchyClient.cameraTiltRadians(renderHand);
            if (tiltRad != 0.0f) {
                matrices.method_22907(class_7833.field_40714.rotation(tiltRad));
            }
            if ((cameraOffset = PunchyClient.cameraTiltOffset(renderHand)).method_1027() > 1.0E-6) {
                matrices.method_22904(cameraOffset.method_10216(), cameraOffset.method_10214(), cameraOffset.method_10215());
            }
            matrices.method_34425(boneTransform);
            RenderSneakSuppressor.push();
            try {
                float armScale;
                float sneakOffset;
                PunchyClient.IdleSpringPose idlePose;
                boolean hasSpringPivot;
                class_1268 curHand = renderHand;
                boolean useLeft = curHand == class_1268.field_5810;
                class_630 arm = PunchyArmMeshes.arm(slim, useLeft);
                float savedPitch = arm.field_3654;
                float savedYaw = arm.field_3675;
                float savedRoll = arm.field_3674;
                arm.field_3654 = 0.0f;
                arm.field_3675 = 0.0f;
                arm.field_3674 = 0.0f;
                PunchyClient.LanternPose lanternPose = lanternLike ? PunchyClient.lanternPhysics(renderHand) : null;
                class_1799 currentStack = player != null ? HandHelper.getConfiguredHandItem((class_1657)player, curHand) : class_1799.field_8037;
                ToolKind effectiveKind = this.resolveArmKind(currentStack);
                ArmToolTuning.Profile toolProf = ArmToolTuning.resolveProfile(currentStack, effectiveKind, this.leftArm);
                ArmMeshTuning.Profile meshProf = ArmMeshTuning.getGlobal(this.leftArm);
                float offX = toolProf.offX + meshProf.offX;
                float offY = toolProf.offY + meshProf.offY;
                float offZ = toolProf.offZ + meshProf.offZ;
                float rotX = toolProf.rotX + meshProf.rotX;
                if (loweredPose) {
                    rotX += PunchyClient.loweredRotationDegrees(renderHand);
                }
                float rotY = toolProf.rotY + meshProf.rotY;
                float rotZ = toolProf.rotZ + meshProf.rotZ;
                PunchyClient.JumpSpringPose springPose = PunchyClient.jumpSpringPose(curHand);
                PunchyClient.JumpSpringPivot springPivot = PunchyClient.jumpSpringPivot();
                float springPivotX = springPivot.x();
                if (this.leftArm) {
                    springPivotX = -springPivotX;
                }
                float springPivotY = springPivot.y();
                float springPivotZ = springPivot.z();
                boolean bl2 = hasSpringPivot = springPivotX != 0.0f || springPivotY != 0.0f || springPivotZ != 0.0f;
                if (hasSpringPivot) {
                    matrices.method_46416(springPivotX, springPivotY, springPivotZ);
                }
                float springPitch = springPose.rotX();
                float springRoll = springPose.rotZ();
                float springOffY = springPose.offY();
                float targetExtraZ = springPitch * 0.1f;
                if (springOffY > 0.02f) {
                    targetExtraZ += 0.1f;
                } else if (springOffY < -0.02f) {
                    targetExtraZ -= 0.1f;
                }
                float prevExtra = extraZCache.getOrDefault(curHand, Float.valueOf(0.0f)).floatValue();
                float extraZ = class_3532.method_16439((float)0.15f, (float)prevExtra, (float)targetExtraZ);
                extraZCache.put(curHand, Float.valueOf(extraZ));
                VanillaProxyContext.setBoneExtraZ(curHand, extraZ);
                if (springPitch != 0.0f) {
                    matrices.method_22907(class_7833.field_40714.rotation(springPitch));
                }
                if (springRoll + extraZ != 0.0f) {
                    matrices.method_22907(class_7833.field_40718.rotation(springRoll + extraZ));
                }
                if (hasSpringPivot) {
                    matrices.method_46416(-springPivotX, -springPivotY, -springPivotZ);
                }
                if (springOffY != 0.0f) {
                    matrices.method_46416(0.0f, springOffY, 0.0f);
                }
                if ((idlePose = PunchyClient.idleSpringPose(curHand)).rotX() != 0.0f) {
                    matrices.method_22907(class_7833.field_40714.rotation(idlePose.rotX()));
                }
                if (idlePose.rotY() != 0.0f) {
                    matrices.method_22907(class_7833.field_40716.rotation(idlePose.rotY()));
                }
                if (idlePose.rotZ() != 0.0f) {
                    matrices.method_22907(class_7833.field_40718.rotation(idlePose.rotZ()));
                }
                if (idlePose.offY() != 0.0f) {
                    matrices.method_46416(0.0f, idlePose.offY(), 0.0f);
                }
                if ((sneakOffset = PunchyClient.sneakOffset(curHand)) != 0.0f) {
                    matrices.method_46416(0.0f, sneakOffset, 0.0f);
                }
                HandSwayPhysics sway = HandSwayPhysics.get();
                float swayX = sway.getX(curHand);
                float swayY = sway.getY(curHand);
                float swayRoll = sway.getRoll(curHand);
                if (swayX != 0.0f || swayY != 0.0f || swayRoll != 0.0f) {
                    matrices.method_46416(0.0f, swayY, swayX);
                    if (swayRoll != 0.0f) {
                        matrices.method_22907(class_7833.field_40718.rotationDegrees(swayRoll));
                    }
                }
                sway.applyElasticity(matrices, original);
                sway.applyMotionInertia(matrices);
                if (offX != 0.0f || offY != 0.0f || offZ != 0.0f) {
                    matrices.method_46416(offX, offY, offZ);
                }
                if (rotX != 0.0f) {
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(rotX));
                }
                ToolAnimationOverrides.RotationOffset rotOffset = ToolAnimationOverrides.rotationOffset(curHand);
                float overrideRotX = (float)Math.toDegrees(rotOffset.rotXRad());
                float overrideRotY = (float)Math.toDegrees(rotOffset.rotYRad());
                float overrideRotZ = (float)Math.toDegrees(rotOffset.rotZRad());
                if (overrideRotX != 0.0f) {
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(overrideRotX));
                }
                if (overrideRotY != 0.0f) {
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(overrideRotY));
                }
                if (overrideRotZ != 0.0f) {
                    matrices.method_22907(class_7833.field_40718.rotationDegrees(overrideRotZ));
                }
                if (rotY != 0.0f) {
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(rotY));
                }
                if (rotZ != 0.0f) {
                    matrices.method_22907(class_7833.field_40718.rotationDegrees(rotZ));
                }
                if ((armScale = toolProf.scale + (meshProf.scale - 1.0f)) != 1.0f) {
                    matrices.method_22905(armScale, armScale, armScale);
                }
                try {
                    int resolvedLight = PlayerArmModelLayer.resolveArmLight(client, (class_1309)player, light);
                    queue.submitModelPart(arm, matrices, class_1921.method_23578((class_2960)skinTex), resolvedLight, overlay, null);
                    if (client.field_1687 != null) {
                        AnchorDebugProbe.sampleArm(renderHand, matrices.method_23760(), client.field_1687.method_8510());
                    }
                }
                finally {
                    arm.field_3654 = savedPitch;
                    arm.field_3675 = savedYaw;
                    arm.field_3674 = savedRoll;
                }
            }
            finally {
                RenderSneakSuppressor.pop();
                matrices.method_22909();
            }
        };
    }

    private static int resolveArmLight(class_310 client, class_1309 entity, int fallback) {
        if (fallback > 0 && fallback != 0xF000F0) {
            return fallback;
        }
        if (entity == null) {
            return 0xF000F0;
        }
        class_1937 level = entity.method_37908();
        if (level == null) {
            return 0xF000F0;
        }
        class_243 eye = entity.method_33571();
        class_2338 pos = class_2338.method_49637((double)eye.field_1352, (double)eye.field_1351, (double)eye.field_1350);
        int block = level.method_8314(class_1944.field_9282, pos);
        block = class_3532.method_15340((int)block, (int)0, (int)15);
        int sky = level.method_8314(class_1944.field_9284, pos) - level.method_8594();
        sky = class_3532.method_15340((int)sky, (int)0, (int)15);
        return class_765.method_23687((int)block, (int)sky);
    }

    static {
        extraZCache.put(class_1268.field_5808, Float.valueOf(0.0f));
        extraZCache.put(class_1268.field_5810, Float.valueOf(0.0f));
    }

    public static enum ToolKind {
        AXE,
        PICKAXE,
        HOE,
        SWORD,
        SHOVEL,
        SHIELD,
        BLOCK,
        BLOCK_DOUBLE,
        FOOD,
        BOW,
        BOW_DOUBLE,
        CROSSBOW,
        CROSSBOW_DOUBLE,
        SHUBBA_DUCK,
        MACE,
        TRIDENT,
        TORCH,
        LANTERN,
        BOAT,
        BUTTON_PLATE,
        TRAPDOOR,
        CARPET,
        BED,
        ARROW,
        SPYGLASS,
        FLINT,
        FISHING_ROD,
        REDSTONE,
        INGREDIENT,
        MINECART,
        CREATURE_BUCKET,
        FLOWER_PENDULUM;

    }
}

