/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.tuning;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.renderer.layer.ArmMeshTuning;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import com.henrique.punchy.config.PunchyTuningConfig;
import com.henrique.punchy.platform.ClientPlatform;
import com.henrique.punchy.util.HandHelper;
import java.util.Locale;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_7923;

public final class TuningKeybinds {
    private static final String CATEGORY = "key.categories.punchy.tuning";
    private static final VanillaFirstPersonItemLayer.ToolKind[] ITEM_KINDS = VanillaFirstPersonItemLayer.ToolKind.values();
    private static class_304 toggleContextKey;
    private static class_304 cycleKindKey;
    private static class_304 toggleSpecificityKey;
    private static class_304 toggleHandKey;
    private static class_304 cycleModeKey;
    private static class_304 cycleAxisKey;
    private static class_304 setAxisXKey;
    private static class_304 setAxisYKey;
    private static class_304 setAxisZKey;
    private static class_304 increaseKey;
    private static class_304 decreaseKey;
    private static class_304 saveKey;
    private static class_304 resetKey;
    private static boolean registered;
    private static Target target;
    private static Axis axis;
    private static Mode mode;
    private static class_1268 hand;
    private static VanillaFirstPersonItemLayer.ToolKind currentKind;
    private static class_2960 currentItemId;

    private TuningKeybinds() {
    }

    public static void register() {
        if (registered) {
            return;
        }
        toggleContextKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.toggle_context", class_3675.class_307.field_1668, 260, CATEGORY));
        cycleKindKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.cycle_kind", class_3675.class_307.field_1668, 268, CATEGORY));
        toggleSpecificityKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.toggle_specificity", class_3675.class_307.field_1668, 266, CATEGORY));
        toggleHandKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.toggle_hand", class_3675.class_307.field_1668, 267, CATEGORY));
        cycleModeKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.cycle_mode", class_3675.class_307.field_1668, 261, CATEGORY));
        cycleAxisKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.cycle_axis", class_3675.class_307.field_1668, 269, CATEGORY));
        setAxisXKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.axis_x", class_3675.class_307.field_1668, 324, CATEGORY));
        setAxisYKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.axis_y", class_3675.class_307.field_1668, 325, CATEGORY));
        setAxisZKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.axis_z", class_3675.class_307.field_1668, 326, CATEGORY));
        increaseKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.increase", class_3675.class_307.field_1668, 265, CATEGORY));
        decreaseKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.decrease", class_3675.class_307.field_1668, 264, CATEGORY));
        saveKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.save", class_3675.class_307.field_1668, 295, CATEGORY));
        resetKey = ClientPlatform.get().registerKeyBinding(new class_304("key.punchy.tuning.reset", class_3675.class_307.field_1668, 82, CATEGORY));
        registered = true;
    }

    public static void handleClientTick(class_310 client) {
        boolean decreased;
        if (!registered || client == null || client.field_1724 == null) {
            return;
        }
        if (!Punchy.DEBUG_POSITION) {
            return;
        }
        TuningKeybinds.autoSelectCurrentItem(client);
        while (toggleContextKey.method_1436()) {
            TuningKeybinds.toggleContext(client);
        }
        while (cycleKindKey.method_1436()) {
            TuningKeybinds.cycleKind(client);
        }
        while (toggleSpecificityKey.method_1436()) {
            TuningKeybinds.toggleSpecificity(client);
        }
        while (toggleHandKey.method_1436()) {
            hand = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
            TuningKeybinds.autoSelectCurrentItem(client);
            TuningKeybinds.toast(client, TuningKeybinds.describeState());
        }
        while (cycleModeKey.method_1436()) {
            mode = Mode.values()[(mode.ordinal() + 1) % Mode.values().length];
            TuningKeybinds.toast(client, TuningKeybinds.describeState());
        }
        while (cycleAxisKey.method_1436()) {
            TuningKeybinds.cycleAxis(client);
        }
        if (setAxisXKey.method_1436()) {
            TuningKeybinds.setAxis(client, Axis.X);
        }
        if (setAxisYKey.method_1436()) {
            TuningKeybinds.setAxis(client, Axis.Y);
        }
        if (setAxisZKey.method_1436()) {
            TuningKeybinds.setAxis(client, Axis.Z);
        }
        while (saveKey.method_1436()) {
            PunchyTuningConfig.saveCurrent();
            TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Saved Punchy tuning to config"));
        }
        while (resetKey.method_1436()) {
            TuningKeybinds.resetCurrentTarget(client);
        }
        boolean increased = increaseKey.method_1434() && !decreaseKey.method_1434();
        boolean bl = decreased = decreaseKey.method_1434() && !increaseKey.method_1434();
        if (increased) {
            TuningKeybinds.applyDelta(client, true);
        } else if (decreased) {
            TuningKeybinds.applyDelta(client, false);
        }
    }

    private static void toggleContext(class_310 client) {
        target = switch (target.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Target.ARM_KIND;
            case 1 -> Target.ARM_SPECIFIC;
            case 2 -> Target.ARM_GLOBAL;
            case 3 -> Target.ITEM_KIND;
            case 4 -> Target.ITEM_SPECIFIC;
            case 5 -> Target.ITEM_GLOBAL;
            case 6 -> Target.ITEM_GLOBAL;
        };
        TuningKeybinds.toast(client, TuningKeybinds.describeState());
    }

    private static void toggleSpecificity(class_310 client) {
        target = switch (target.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Target.ITEM_SPECIFIC;
            case 1 -> Target.ITEM_GLOBAL;
            case 2 -> Target.ITEM_KIND;
            case 3 -> Target.ARM_SPECIFIC;
            case 4 -> Target.ARM_GLOBAL;
            case 5 -> Target.ARM_MESH;
            case 6 -> Target.ARM_KIND;
        };
        TuningKeybinds.toast(client, TuningKeybinds.describeState());
    }

    private static void cycleKind(class_310 client) {
        if (target == Target.ARM_SPECIFIC) {
            PlayerArmModelLayer.ToolKind newKind;
            VanillaFirstPersonItemLayer.ToolKind newItemKind;
            int idx;
            if (currentItemId == null) {
                TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Segure o item para alterar seu tipo de braco."));
                return;
            }
            PlayerArmModelLayer.ToolKind[] kinds = PlayerArmModelLayer.ToolKind.values();
            PlayerArmModelLayer.ToolKind currentArmKind = TuningKeybinds.toArmKind(currentKind);
            if (currentArmKind == null) {
                currentArmKind = PlayerArmModelLayer.ToolKind.AXE;
            }
            if ((idx = currentArmKind.ordinal() + 1) >= kinds.length) {
                idx = 0;
            }
            if ((newItemKind = TuningKeybinds.findMatchingItemKind(newKind = kinds[idx])) != null) {
                currentKind = newItemKind;
            }
            boolean leftHand = hand == class_1268.field_5810;
            ArmToolTuning.Profile profile = ArmToolTuning.getSpecificProfile(currentItemId, newKind, leftHand);
            ArmToolTuning.applySpecific(currentItemId, newKind, leftHand ? null : profile, leftHand ? profile : null);
            ArmToolTuning.SpecificSnapshot fullSpec = ArmToolTuning.snapshotSpecifics().get(currentItemId);
            if (fullSpec != null) {
                ArmToolTuning.Profile right = fullSpec.right();
                ArmToolTuning.Profile left = fullSpec.left();
                ArmToolTuning.applySpecific(currentItemId, newKind, right, left);
            }
            TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)("Arm Kind set to: " + newKind.name())));
            return;
        }
        int idx = currentKind.ordinal() + 1;
        if (idx >= ITEM_KINDS.length) {
            idx = 0;
        }
        currentKind = ITEM_KINDS[idx];
        if (target == Target.ITEM_KIND || target == Target.ARM_KIND) {
            TuningKeybinds.toast(client, TuningKeybinds.describeState());
        } else {
            TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)("Kind selected: " + currentKind.name() + " (Switch to Group mode to edit)")));
        }
    }

    private static VanillaFirstPersonItemLayer.ToolKind findMatchingItemKind(PlayerArmModelLayer.ToolKind armKind) {
        try {
            return VanillaFirstPersonItemLayer.ToolKind.valueOf(armKind.name());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void cycleAxis(class_310 client) {
        if (!TuningKeybinds.mode.usesAxis) {
            TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)("Axis not used in " + TuningKeybinds.mode.label + " mode")));
            return;
        }
        axis = Axis.values()[(axis.ordinal() + 1) % Axis.values().length];
        TuningKeybinds.toast(client, TuningKeybinds.describeState());
    }

    private static void setAxis(class_310 client, Axis desired) {
        if (!TuningKeybinds.mode.usesAxis) {
            TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)("Axis not used in " + TuningKeybinds.mode.label + " mode")));
            return;
        }
        axis = desired;
        TuningKeybinds.toast(client, TuningKeybinds.describeState());
    }

    private static void applyDelta(class_310 client, boolean positive) {
        if (mode == Mode.PIVOT && (target == Target.ARM_GLOBAL || target == Target.ARM_MESH || target == Target.ARM_KIND || target == Target.ARM_SPECIFIC)) {
            TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Pivot edits only apply to item bones"));
            return;
        }
        float delta = TuningKeybinds.computeStep(client);
        if (!positive) {
            delta *= -1.0f;
        }
        boolean leftHand = hand == class_1268.field_5810;
        switch (target.ordinal()) {
            case 0: {
                ToolTuning.Profile profile = ToolTuning.get(currentKind, leftHand);
                AdjustmentResult result = TuningKeybinds.adjustToolProfile(profile, delta);
                if (result == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Falha ao aplicar ajuste no item selecionado."));
                    return;
                }
                ToolTuning.commitKind(currentKind, leftHand);
                ToolTuning.markKindDetached(currentKind, leftHand);
                TuningKeybinds.report(client, result);
                break;
            }
            case 1: {
                if (currentItemId == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Segure o item que deseja editar especificamente."));
                    return;
                }
                ToolTuning.Profile profile = ToolTuning.getSpecificProfile(currentItemId, currentKind, leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Nao foi possivel preparar o perfil especifico desse item."));
                    return;
                }
                AdjustmentResult result = TuningKeybinds.adjustToolProfile(profile, delta);
                if (result == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Falha ao aplicar ajuste no item especifico."));
                    return;
                }
                TuningKeybinds.report(client, result);
                break;
            }
            case 2: {
                ToolTuning.Profile profile = ToolTuning.getGlobal(leftHand);
                AdjustmentResult result = TuningKeybinds.adjustToolProfile(profile, delta);
                if (result == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Nao foi possivel aplicar o ajuste global de item."));
                    return;
                }
                ToolTuning.commitGlobal(leftHand);
                TuningKeybinds.report(client, result);
                break;
            }
            case 3: {
                PlayerArmModelLayer.ToolKind armKind = TuningKeybinds.toArmKind(currentKind);
                if (armKind == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Tipo de item sem correspondente de braco."));
                    return;
                }
                ArmToolTuning.Profile profile = ArmToolTuning.get(armKind, leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Perfil de braco (Kind) nao encontrado."));
                    return;
                }
                AdjustmentResult result = TuningKeybinds.adjustArmProfile(profile, delta);
                ArmToolTuning.commitKind(armKind, leftHand);
                ArmToolTuning.markKindDetached(armKind, leftHand);
                TuningKeybinds.report(client, result);
                break;
            }
            case 4: {
                if (currentItemId == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Segure o item para editar o braco especifico."));
                    return;
                }
                PlayerArmModelLayer.ToolKind armKind = TuningKeybinds.toArmKind(currentKind);
                if (armKind == null) {
                    armKind = PlayerArmModelLayer.ToolKind.AXE;
                }
                ArmToolTuning.Profile profile = ArmToolTuning.getSpecificProfile(currentItemId, armKind, leftHand);
                TuningKeybinds.report(client, TuningKeybinds.adjustArmProfile(profile, delta));
                break;
            }
            case 5: {
                ArmToolTuning.Profile profile = ArmToolTuning.getGlobal(leftHand);
                TuningKeybinds.report(client, TuningKeybinds.adjustArmProfile(profile, delta));
                ArmToolTuning.commitGlobal(leftHand);
                break;
            }
            case 6: {
                ArmMeshTuning.Profile profile = ArmMeshTuning.getGlobal(leftHand);
                TuningKeybinds.report(client, TuningKeybinds.adjustArmMeshProfile(profile, delta));
            }
        }
    }

    private static PlayerArmModelLayer.ToolKind toArmKind(VanillaFirstPersonItemLayer.ToolKind vk) {
        try {
            return PlayerArmModelLayer.ToolKind.valueOf(vk.name());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void resetCurrentTarget(class_310 client) {
        boolean leftHand = hand == class_1268.field_5810;
        switch (target.ordinal()) {
            case 0: {
                ToolTuning.Profile profile = ToolTuning.get(currentKind, leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Nenhum perfil de item carregado."));
                    return;
                }
                TuningKeybinds.resetToolProfile(profile);
                ToolTuning.commitKind(currentKind, leftHand);
                ToolTuning.markKindAttached(currentKind, leftHand);
                TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Offsets e rotacoes resetados para o tipo selecionado."));
                break;
            }
            case 2: {
                ToolTuning.Profile profile = ToolTuning.getGlobal(leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Nenhum perfil global de item carregado."));
                    return;
                }
                TuningKeybinds.resetToolProfile(profile);
                ToolTuning.commitGlobal(leftHand);
                TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Offsets e rotacoes globais resetados."));
                break;
            }
            case 1: {
                if (currentItemId == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Segure o item especifico para resetar."));
                    return;
                }
                ToolTuning.Profile profile = ToolTuning.getSpecificProfile(currentItemId, currentKind, leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Nao foi possivel localizar o perfil especifico."));
                    return;
                }
                TuningKeybinds.resetToolProfile(profile);
                TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Offsets e rotacoes do item especifico resetados."));
                break;
            }
            case 3: {
                ArmToolTuning.Profile profile;
                PlayerArmModelLayer.ToolKind armKind = TuningKeybinds.toArmKind(currentKind);
                if (armKind == null || (profile = ArmToolTuning.get(armKind, leftHand)) == null) break;
                TuningKeybinds.resetArmProfile(profile);
                ArmToolTuning.commitKind(armKind, leftHand);
                ArmToolTuning.markKindAttached(armKind, leftHand);
                TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)("Braco resetado para o tipo " + armKind.name())));
                break;
            }
            case 4: {
                ArmToolTuning.Profile profile;
                if (currentItemId == null) break;
                PlayerArmModelLayer.ToolKind armKind = TuningKeybinds.toArmKind(currentKind);
                if (armKind == null) {
                    armKind = PlayerArmModelLayer.ToolKind.AXE;
                }
                if ((profile = ArmToolTuning.getSpecificProfile(currentItemId, armKind, leftHand)) == null) break;
                TuningKeybinds.resetArmProfile(profile);
                TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Braco especifico resetado."));
                break;
            }
            case 5: {
                ArmToolTuning.Profile profile = ArmToolTuning.getGlobal(leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Perfil de braco indisponivel."));
                    return;
                }
                TuningKeybinds.resetArmProfile(profile);
                ArmToolTuning.commitGlobal(leftHand);
                TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Offsets e rotacoes do braco resetados."));
                break;
            }
            case 6: {
                ArmMeshTuning.Profile profile = ArmMeshTuning.getGlobal(leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Perfil de braco indisponivel."));
                    return;
                }
                TuningKeybinds.resetArmMeshProfile(profile);
                TuningKeybinds.toast(client, (class_2561)class_2561.method_43470((String)"Offsets e rotacoes do braco apenas resetados."));
            }
        }
    }

    private static void resetToolProfile(ToolTuning.Profile profile) {
        profile.offZ = 0.0f;
        profile.offY = 0.0f;
        profile.offX = 0.0f;
        profile.rotZ = 0.0f;
        profile.rotY = 0.0f;
        profile.rotX = 0.0f;
        profile.recomputeRadians();
    }

    private static void resetArmProfile(ArmToolTuning.Profile profile) {
        profile.offZ = 0.0f;
        profile.offY = 0.0f;
        profile.offX = 0.0f;
        profile.rotZ = 0.0f;
        profile.rotY = 0.0f;
        profile.rotX = 0.0f;
    }

    private static void resetArmMeshProfile(ArmMeshTuning.Profile profile) {
        profile.offZ = 0.0f;
        profile.offY = 0.0f;
        profile.offX = 0.0f;
        profile.rotZ = 0.0f;
        profile.rotY = 0.0f;
        profile.rotX = 0.0f;
    }

    private static AdjustmentResult adjustToolProfile(ToolTuning.Profile profile, float delta) {
        AdjustmentResult result = switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("offX", profile.offX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("offY", profile.offY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("offZ", profile.offZ += delta);
            }
            case 1 -> {
                AdjustmentResult v1 = switch (axis.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> new AdjustmentResult("rotX", profile.rotX += delta);
                    case 1 -> new AdjustmentResult("rotY", profile.rotY += delta);
                    case 2 -> new AdjustmentResult("rotZ", profile.rotZ += delta);
                };
                AdjustmentResult res = v1;
                profile.recomputeRadians();
                yield res;
            }
            case 2 -> {
                profile.scale = Math.max(0.01f, profile.scale + delta);
                AdjustmentResult v2 = new AdjustmentResult("scale", profile.scale);
                yield v2;
            }
            case 3 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("pivotX", profile.pivotX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("pivotY", profile.pivotY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("pivotZ", profile.pivotZ += delta);
            }
        };
        return result;
    }

    private static AdjustmentResult adjustArmProfile(ArmToolTuning.Profile profile, float delta) {
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("offX", profile.offX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("offY", profile.offY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("offZ", profile.offZ += delta);
            }
            case 1 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("rotX", profile.rotX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("rotY", profile.rotY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("rotZ", profile.rotZ += delta);
            }
            case 2 -> {
                profile.scale = Math.max(0.25f, profile.scale + delta);
                AdjustmentResult v1 = new AdjustmentResult("scale", profile.scale);
                yield v1;
            }
            case 3 -> throw new IllegalStateException("Pivot editing should be gated for arms");
        };
    }

    private static AdjustmentResult adjustArmMeshProfile(ArmMeshTuning.Profile profile, float delta) {
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("offX", profile.offX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("offY", profile.offY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("offZ", profile.offZ += delta);
            }
            case 1 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("rotX", profile.rotX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("rotY", profile.rotY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("rotZ", profile.rotZ += delta);
            }
            case 2 -> {
                profile.scale = Math.max(0.25f, profile.scale + delta);
                AdjustmentResult v1 = new AdjustmentResult("scale", profile.scale);
                yield v1;
            }
            case 3 -> throw new IllegalStateException("Pivot editing should be gated for arms");
        };
    }

    private static float computeStep(class_310 client) {
        float base;
        switch (mode.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 3: {
                float f = 0.01f;
                break;
            }
            case 1: {
                float f = 1.0f;
                break;
            }
            case 2: {
                float f = base = 0.01f;
            }
        }
        if (client.field_1690 == null) {
            return base;
        }
        if (client.field_1690.field_1867.method_1434()) {
            base *= 5.0f;
        }
        if (client.field_1690.field_1832.method_1434()) {
            base *= 0.2f;
        }
        return base;
    }

    private static void report(class_310 client, AdjustmentResult result) {
        if (result == null) {
            return;
        }
        TuningKeybinds.toast(client, TuningKeybinds.describeState(result));
    }

    private static class_2561 describeState() {
        return TuningKeybinds.describeState(null);
    }

    private static class_2561 describeState(AdjustmentResult change) {
        String selection = switch (target.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 3 -> TuningKeybinds.friendlyName(currentKind.name());
            case 1, 4 -> {
                if (currentItemId != null) {
                    yield currentItemId.toString();
                }
                yield "Nenhum item";
            }
            case 2 -> "Global item";
            case 5 -> "Global arm";
            case 6 -> "Arm mesh";
        };
        StringBuilder stringBuilder = new StringBuilder("Tuning ");
        StringBuilder sb = stringBuilder.append(switch (target.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "item";
            case 1 -> "item-specific";
            case 2 -> "item-global";
            case 3 -> "arm-kind";
            case 4 -> "arm-specific";
            case 5 -> "arm-global";
            case 6 -> "arm mesh";
        }).append(" [").append(selection).append(" | ").append(hand == class_1268.field_5808 ? "MAIN" : "OFF").append("] ").append(TuningKeybinds.mode.label);
        if (TuningKeybinds.mode.usesAxis) {
            sb.append(" (").append(axis.name()).append(")");
        }
        if (change != null) {
            sb.append(" -> ").append(change.property).append("=").append(String.format(Locale.ROOT, "%.4f", Float.valueOf(change.value)));
        }
        return class_2561.method_43470((String)sb.toString());
    }

    private static void toast(class_310 client, class_2561 message) {
        if (client == null || client.field_1724 == null) {
            return;
        }
        client.field_1705.method_1758(message, false);
    }

    private static void autoSelectCurrentItem(class_310 client) {
        if (target == Target.ITEM_GLOBAL || target == Target.ARM_GLOBAL || target == Target.ARM_MESH || client == null || client.field_1724 == null) {
            return;
        }
        class_1799 stack = HandHelper.getConfiguredHandItem((class_1657)client.field_1724, hand);
        VanillaFirstPersonItemLayer.ToolKind resolved = ToolKindResolver.resolveItemKind(stack, currentKind);
        boolean changed = resolved != currentKind;
        currentKind = resolved;
        if (stack == null || stack.method_7960()) {
            if (currentItemId != null) {
                currentItemId = null;
                changed = true;
            }
        } else {
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (!id.equals((Object)currentItemId)) {
                currentItemId = id;
                changed = true;
            }
        }
        if (changed) {
            TuningKeybinds.toast(client, TuningKeybinds.describeState());
        }
    }

    private static String friendlyName(String raw) {
        String lower = raw.toLowerCase(Locale.ROOT).replace('_', ' ');
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    static {
        registered = false;
        target = Target.ITEM_KIND;
        axis = Axis.X;
        mode = Mode.TRANSLATE;
        hand = class_1268.field_5808;
        currentKind = ITEM_KINDS[0];
        currentItemId = null;
    }

    private static enum Mode {
        TRANSLATE("offsets", true),
        ROTATE("rotation", true),
        SCALE("scale", false),
        PIVOT("pivot", true);

        final String label;
        final boolean usesAxis;

        private Mode(String label, boolean usesAxis) {
            this.label = label;
            this.usesAxis = usesAxis;
        }
    }

    private static enum Axis {
        X,
        Y,
        Z;

    }

    private static enum Target {
        ITEM_KIND,
        ITEM_SPECIFIC,
        ITEM_GLOBAL,
        ARM_KIND,
        ARM_SPECIFIC,
        ARM_GLOBAL,
        ARM_MESH;

    }

    private record AdjustmentResult(String property, float value) {
    }
}

