/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.config;

import com.henrique.punchy.config.PunchyConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class FallbackRenderConfig {
    private static final Set<String> modBypass = new HashSet<String>();
    private static final Set<class_2960> itemBypass = new HashSet<class_2960>();
    private static final List<Pattern> wildcardItems = new ArrayList<Pattern>();
    private static double offsetX;
    private static double offsetY;
    private static double offsetZ;
    private static boolean compatMode;

    private FallbackRenderConfig() {
    }

    public static void reload(PunchyConfig config) {
        modBypass.clear();
        itemBypass.clear();
        wildcardItems.clear();
        offsetX = config.getFallbackViewOffsetX();
        offsetY = config.getFallbackViewOffsetY();
        offsetZ = config.getFallbackViewOffsetZ();
        compatMode = config.isFallbackCompatMode();
        for (String modId : config.getRenderBypassMods()) {
            if (modId.isEmpty()) continue;
            modBypass.add(modId.toLowerCase(Locale.ROOT));
        }
        for (String entry : config.getRenderBypassItems()) {
            if (entry.isEmpty()) continue;
            if (entry.contains("*") || entry.contains("?")) {
                String pattern = entry.replace(".", "\\.").replace("*", ".*").replace("?", ".");
                try {
                    wildcardItems.add(Pattern.compile(pattern));
                }
                catch (Exception exception) {}
                continue;
            }
            class_2960 id = class_2960.method_12829((String)entry);
            if (id == null) continue;
            itemBypass.add(id);
        }
    }

    public static boolean shouldBypass(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        if (id == null) {
            return false;
        }
        if (modBypass.contains(id.method_12836().toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (itemBypass.contains(id)) {
            return true;
        }
        String full = id.toString();
        for (Pattern pattern : wildcardItems) {
            if (!pattern.matcher(full).matches()) continue;
            return true;
        }
        return false;
    }

    public static double offsetX() {
        return offsetX;
    }

    public static double offsetY() {
        return offsetY;
    }

    public static double offsetZ() {
        return offsetZ;
    }

    public static boolean compatModeEnabled() {
        return compatMode;
    }

    public static List<String> snapshotBypassMods() {
        return Collections.unmodifiableList(new ArrayList<String>(modBypass));
    }
}

