/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchymcflop.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.henrique.punchy.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "punchy.json";
    private static Config CONFIG = new Config();

    private ConfigManager() {
    }

    public static void load() {
        Path path = Platform.get().getConfigDirectory().resolve(FILE_NAME);
        if (Files.notExists(path, new LinkOption[0])) {
            ConfigManager.saveDefault(path);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Config loaded = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (loaded != null) {
                CONFIG = loaded;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveDefault(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Config get() {
        return CONFIG;
    }

    public static final class Config {
        public boolean tapMiningEnabled = true;
    }
}

