/*
 * Decompiled with CFR 0.152.
 */
package com.simplequarries.block.entity;

import com.simplequarries.QuarryUpgrades;
import com.simplequarries.SimpleQuarries;
import com.simplequarries.screen.QuarryScreenHandler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

public class QuarryBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<QuarryScreenHandler.QuarryScreenData>,
class_1263,
class_1278 {
    public static final int PICKAXE_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int OUTPUT_START = 2;
    public static final int OUTPUT_SLOTS = 24;
    public static final int INVENTORY_SIZE = 26;
    private static final int[] TOP_SLOTS = new int[]{1};
    private static final int[] BOTTOM_SLOTS = QuarryBlockEntity.createBottomSlots();
    private static final int[] SIDE_SLOTS = new int[]{0};
    private static final Set<class_1792> VALID_PICKAXES = Set.of(class_1802.field_8647, class_1802.field_8387, class_1802.field_8403, class_1802.field_8335, class_1802.field_8377, class_1802.field_22024);
    private static final Map<class_1792, Integer> FUEL_VALUES = Map.ofEntries(Map.entry(class_1802.field_8713, 8), Map.entry(class_1802.field_8665, 8), Map.entry(class_1802.field_8894, 12), Map.entry(class_1802.field_17533, 20), Map.entry(class_1802.field_8797, 80), Map.entry(class_1802.field_8187, 100), Map.entry(class_1802.field_8600, 1), Map.entry(class_1802.field_8648, 1), Map.entry(class_1802.field_8583, 2), Map.entry(class_1802.field_8684, 2), Map.entry(class_1802.field_8170, 2), Map.entry(class_1802.field_8125, 2), Map.entry(class_1802.field_8820, 2), Map.entry(class_1802.field_8652, 2), Map.entry(class_1802.field_37512, 2), Map.entry(class_1802.field_42692, 2), Map.entry(class_1802.field_8118, 2), Map.entry(class_1802.field_8113, 2), Map.entry(class_1802.field_8191, 2), Map.entry(class_1802.field_8842, 2), Map.entry(class_1802.field_8651, 2), Map.entry(class_1802.field_8404, 2), Map.entry(class_1802.field_37507, 2), Map.entry(class_1802.field_42687, 2), Map.entry(class_1802.field_40213, 2));
    private final class_2371<class_1799> items = class_2371.method_10213((int)26, (Object)class_1799.field_8037);
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> QuarryBlockEntity.this.burnTime;
                case 1 -> QuarryBlockEntity.this.lastFuelTime;
                case 2 -> QuarryBlockEntity.this.miningProgress;
                case 3 -> QuarryBlockEntity.this.ticksPerBlock;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    QuarryBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    QuarryBlockEntity.this.lastFuelTime = value;
                    break;
                }
                case 2: {
                    QuarryBlockEntity.this.miningProgress = value;
                    break;
                }
                case 3: {
                    QuarryBlockEntity.this.ticksPerBlock = value;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    private int burnTime = 0;
    private int lastFuelTime = 0;
    private int miningProgress = 0;
    private int ticksPerBlock = 0;
    private int currentDepth = 1;
    private int areaIndex = 0;
    private int upgradeCount = 0;

    public QuarryBlockEntity(class_2338 pos, class_2680 state) {
        super(SimpleQuarries.QUARRY_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, QuarryBlockEntity quarry) {
        if (world.method_8608()) {
            return;
        }
        boolean dirty = false;
        class_1799 pickaxe = quarry.method_5438(0);
        if (!quarry.isValidPickaxe(pickaxe)) {
            quarry.resetProgress();
            quarry.ticksPerBlock = 0;
            return;
        }
        quarry.ticksPerBlock = quarry.getTicksPerBlockFor(pickaxe);
        if (quarry.burnTime <= 0) {
            if (!quarry.tryConsumeFuel()) {
                quarry.resetProgress();
                return;
            }
            dirty = true;
        }
        if (quarry.ticksPerBlock <= 0) {
            quarry.resetProgress();
            return;
        }
        ++quarry.miningProgress;
        if (quarry.miningProgress >= quarry.ticksPerBlock) {
            quarry.miningProgress = 0;
            class_2338 target = quarry.findNextTarget((class_3218)world);
            if (target != null && quarry.breakBlock((class_3218)world, target, pickaxe)) {
                quarry.burnTime = Math.max(0, quarry.burnTime - 1);
                dirty = true;
            }
        }
        if (dirty) {
            quarry.method_5431();
        }
    }

    private void resetProgress() {
        this.miningProgress = 0;
    }

    private boolean tryConsumeFuel() {
        class_1799 remainder;
        class_1799 fuel = this.method_5438(1);
        int gainedBlocks = this.getFuelValue(fuel);
        if (gainedBlocks <= 0) {
            this.lastFuelTime = 0;
            return false;
        }
        class_1792 fuelItem = fuel.method_7909();
        fuel.method_7934(1);
        if (fuel.method_7960() && !(remainder = fuelItem.getRecipeRemainder(fuel)).method_7960()) {
            this.method_5447(1, remainder.method_7972());
        }
        this.burnTime += gainedBlocks;
        this.lastFuelTime = gainedBlocks;
        this.method_5431();
        return true;
    }

    public int getFuelValue(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        Integer value = FUEL_VALUES.get(fuel.method_7909());
        if (value != null) {
            return value;
        }
        return 0;
    }

    private boolean breakBlock(class_3218 world, class_2338 target, class_1799 pickaxe) {
        class_2680 targetState = world.method_8320(target);
        if (targetState.method_26215() || targetState.method_26214((class_1922)world, target) < 0.0f) {
            return false;
        }
        List drops = class_2248.method_9609((class_2680)targetState, (class_3218)world, (class_2338)target, (class_2586)world.method_8321(target), null, (class_1799)pickaxe);
        boolean removed = world.method_22352(target, false);
        if (!removed) {
            return false;
        }
        for (class_1799 drop : drops) {
            class_1799 remainder = this.insertIntoOutputs(drop.method_7972());
            if (remainder.method_7960()) continue;
            class_2248.method_9577((class_1937)world, (class_2338)this.field_11867.method_10084(), (class_1799)remainder);
        }
        this.damagePickaxe(pickaxe);
        return true;
    }

    private void damagePickaxe(class_1799 pickaxe) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (pickaxe.method_7963()) {
                int unbreaking = this.getEnchantmentLevel((class_5321<class_1887>)class_1893.field_9119, pickaxe);
                boolean damage = true;
                if (unbreaking > 0 && serverWorld.method_8409().method_43048(unbreaking + 1) != 0) {
                    damage = false;
                }
                if (damage) {
                    int maxDamage;
                    int currentDamage = pickaxe.method_7919();
                    if (currentDamage + 1 >= (maxDamage = pickaxe.method_7936())) {
                        this.method_5447(0, class_1799.field_8037);
                    } else {
                        pickaxe.method_7974(currentDamage + 1);
                        this.method_5447(0, pickaxe);
                    }
                }
            }
        }
    }

    @Nullable
    private class_2338 findNextTarget(class_3218 world) {
        int maxAttempts = Math.max(512, this.getTotalAreaSlots() * 2);
        for (int attempts = 0; this.field_11867.method_10264() - this.currentDepth >= world.method_31607() && attempts < maxAttempts; ++attempts) {
            class_2338 offset = this.getOffsetForIndex(this.areaIndex);
            class_2338 target = this.field_11867.method_10069(offset.method_10263(), -this.currentDepth, offset.method_10260());
            this.advancePointer();
            class_2680 state = world.method_8320(target);
            if (state.method_26215() || state.method_26214((class_1922)world, target) < 0.0f || state.method_26204() == SimpleQuarries.QUARRY_BLOCK) continue;
            return target;
        }
        return null;
    }

    private void advancePointer() {
        ++this.areaIndex;
        if (this.areaIndex >= this.getTotalAreaSlots()) {
            this.areaIndex = 0;
            ++this.currentDepth;
        }
    }

    private class_1799 insertIntoOutputs(class_1799 stack) {
        class_1799 existing;
        int i;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        for (i = 2; i < 26; ++i) {
            int transferable;
            existing = (class_1799)this.items.get(i);
            if (existing.method_7960() || !class_1799.method_31577((class_1799)existing, (class_1799)stack) || (transferable = Math.min(stack.method_7947(), Math.min(this.method_5444(), existing.method_7914()) - existing.method_7947())) <= 0) continue;
            existing.method_7933(transferable);
            stack.method_7934(transferable);
            if (!stack.method_7960()) continue;
            this.method_5431();
            return class_1799.field_8037;
        }
        for (i = 2; i < 26; ++i) {
            existing = (class_1799)this.items.get(i);
            if (!existing.method_7960()) continue;
            this.items.set(i, (Object)stack.method_7972());
            this.method_5431();
            return class_1799.field_8037;
        }
        return stack;
    }

    public boolean isValidPickaxe(class_1799 stack) {
        return VALID_PICKAXES.contains(stack.method_7909());
    }

    public int getUpgradeCount() {
        return this.upgradeCount;
    }

    public void setUpgradeCount(int count) {
        this.upgradeCount = QuarryUpgrades.clampUpgradeCount(count);
        this.clampAreaIndex();
        this.method_5431();
    }

    private void clampAreaIndex() {
        int maxIndex = Math.max(0, this.getTotalAreaSlots() - 1);
        this.areaIndex = class_3532.method_15340((int)this.areaIndex, (int)0, (int)maxIndex);
    }

    private int getEnchantmentLevel(class_5321<class_1887> enchantmentKey, class_1799 stack) {
        class_9304 enchantments = class_1890.method_57532((class_1799)stack);
        for (class_6880 entry : enchantments.method_57534()) {
            if (!entry.method_40225(enchantmentKey)) continue;
            return enchantments.method_57536(entry);
        }
        return 0;
    }

    private int getTicksPerBlockFor(class_1799 pickaxe) {
        if (!this.isValidPickaxe(pickaxe)) {
            return 0;
        }
        class_1792 item = pickaxe.method_7909();
        int baseTicks = 0;
        if (item == class_1802.field_8647) {
            baseTicks = 200;
        } else if (item == class_1802.field_8387) {
            baseTicks = 160;
        } else if (item == class_1802.field_8403) {
            baseTicks = 120;
        } else if (item == class_1802.field_8335) {
            baseTicks = 20;
        } else if (item == class_1802.field_8377) {
            baseTicks = 80;
        } else if (item == class_1802.field_22024) {
            baseTicks = 40;
        } else {
            return 0;
        }
        int efficiency = this.getEnchantmentLevel((class_5321<class_1887>)class_1893.field_9131, pickaxe);
        if (efficiency > 0) {
            double speedMultiplier = 1.0 + 0.25 * (double)(efficiency * efficiency + 1);
            baseTicks = (int)Math.round((double)baseTicks / speedMultiplier);
        }
        return Math.max(1, baseTicks);
    }

    public class_3913 getPropertyDelegate() {
        return this.propertyDelegate;
    }

    protected void method_11007(class_11372 data) {
        class_11372.class_11374 itemsList = data.method_71476("Items");
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            if (stack.method_7960()) continue;
            class_11372 slotData = itemsList.method_71480();
            slotData.method_71462("Slot", (byte)i);
            slotData.method_71468("Item", class_1799.field_24671, (Object)stack);
        }
        data.method_71465("BurnTime", this.burnTime);
        data.method_71465("LastFuelTime", this.lastFuelTime);
        data.method_71465("MiningProgress", this.miningProgress);
        data.method_71465("TicksPerBlock", this.ticksPerBlock);
        data.method_71465("Depth", this.currentDepth);
        data.method_71465("AreaIndex", this.areaIndex);
        data.method_71465("UpgradeCount", this.upgradeCount);
    }

    protected void method_11014(class_11368 data) {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)class_1799.field_8037);
        }
        class_11368.class_11370 itemsList = data.method_71438("Items");
        for (class_11368 slotData : itemsList) {
            int slot = slotData.method_71421("Slot", (byte)0) & 0xFF;
            if (slot >= this.items.size()) continue;
            slotData.method_71426("Item", class_1799.field_24671).ifPresent(stack -> this.items.set(slot, stack));
        }
        this.burnTime = data.method_71424("BurnTime", 0);
        this.lastFuelTime = data.method_71424("LastFuelTime", 0);
        this.miningProgress = data.method_71424("MiningProgress", 0);
        this.ticksPerBlock = data.method_71424("TicksPerBlock", 0);
        this.currentDepth = Math.max(1, data.method_71424("Depth", 1));
        this.upgradeCount = QuarryUpgrades.clampUpgradeCount(data.method_71424("UpgradeCount", 0));
        this.clampAreaIndex();
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.items, (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.method_5431();
        }
        return result;
    }

    public class_1799 method_5441(int slot) {
        class_1799 result = class_1262.method_5428(this.items, (int)slot);
        if (!result.method_7960()) {
            this.method_5431();
        }
        return result;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5707(class_243.method_24953((class_2382)this.field_11867)) <= 64.0;
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new QuarryScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.simplequarries.quarry");
    }

    public QuarryScreenHandler.QuarryScreenData getScreenOpeningData(class_3222 player) {
        return new QuarryScreenHandler.QuarryScreenData(this.field_11867);
    }

    private int getMiningAreaSize() {
        return QuarryUpgrades.areaForCount(this.upgradeCount);
    }

    private int getTotalAreaSlots() {
        int size = this.getMiningAreaSize();
        return size * size;
    }

    private class_2338 getOffsetForIndex(int index) {
        int size = this.getMiningAreaSize();
        int radius = size / 2;
        int xIndex = index % size;
        int zIndex = index / size;
        return new class_2338(xIndex - radius, 0, zIndex - radius);
    }

    private static int[] createBottomSlots() {
        int[] slots = new int[25];
        slots[0] = 1;
        for (int i = 0; i < 24; ++i) {
            slots[i + 1] = 2 + i;
        }
        return slots;
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        if (side == class_2350.field_11036) {
            return TOP_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (slot == 0) {
            return this.isValidPickaxe(stack);
        }
        if (slot == 1) {
            return this.getFuelValue(stack) > 0;
        }
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (slot >= 2) {
            return true;
        }
        return slot == 1 && stack.method_31574(class_1802.field_8550);
    }
}

