/*
 * Decompiled with CFR 0.152.
 */
package com.simplequarries.screen;

import com.simplequarries.SimpleQuarries;
import com.simplequarries.block.entity.QuarryBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class QuarryScreenHandler
extends class_1703 {
    private final class_1263 inventory;
    private final QuarryBlockEntity blockEntity;
    private final class_3913 propertyDelegate;
    private static final int QUARRY_SLOT_COUNT = 26;

    public QuarryScreenHandler(int syncId, class_1661 playerInventory, QuarryScreenData data) {
        this(syncId, playerInventory, QuarryScreenHandler.getBlockEntity(playerInventory, data.pos()), (class_3913)new class_3919(4));
    }

    public QuarryScreenHandler(int syncId, class_1661 playerInventory, QuarryBlockEntity blockEntity, class_3913 propertyDelegate) {
        super(SimpleQuarries.QUARRY_SCREEN_HANDLER, syncId);
        int col;
        this.blockEntity = blockEntity;
        this.inventory = blockEntity;
        this.propertyDelegate = propertyDelegate;
        QuarryScreenHandler.method_17359((class_1263)this.inventory, (int)26);
        this.inventory.method_5435(playerInventory.field_7546);
        this.method_7621(new PickaxeSlot(blockEntity, 0, 8, 17));
        this.method_7621(new FuelSlot(blockEntity, 1, 8, 53));
        int outputStartX = 62;
        int outputStartY = 8;
        for (int row = 0; row < 4; ++row) {
            for (int col2 = 0; col2 < 6; ++col2) {
                int slotIndex = 2 + row * 6 + col2;
                int x = outputStartX + col2 * 18;
                int y = outputStartY + row * 18;
                this.method_7621(new OutputSlot(blockEntity, slotIndex, x, y));
            }
        }
        int playerInvY = 84;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, playerInvY + row * 18));
            }
        }
        int hotbarY = 142;
        for (col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, 8 + col * 18, hotbarY));
        }
        this.method_17360(propertyDelegate);
    }

    private static QuarryBlockEntity getBlockEntity(class_1661 playerInventory, class_2338 pos) {
        class_2586 class_25862;
        if (playerInventory.field_7546.method_37908() != null && (class_25862 = playerInventory.field_7546.method_37908().method_8321(pos)) instanceof QuarryBlockEntity) {
            QuarryBlockEntity quarry = (QuarryBlockEntity)class_25862;
            return quarry;
        }
        return new QuarryBlockEntity(pos, null);
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot != null && slot.method_7681()) {
            class_1799 original = slot.method_7677();
            newStack = original.method_7972();
            int playerSlotStart = 26;
            int playerSlotEnd = playerSlotStart + 36;
            if (slotIndex < 26) {
                if (!this.method_7616(original, playerSlotStart, playerSlotEnd, true)) {
                    return class_1799.field_8037;
                }
            } else if (this.blockEntity.isValidPickaxe(original)) {
                if (!this.method_7616(original, 0, 1, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.blockEntity.getFuelValue(original) > 0) {
                if (!this.method_7616(original, 1, 2, false)) {
                    return class_1799.field_8037;
                }
            } else {
                return class_1799.field_8037;
            }
            if (original.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432(player);
    }

    public int getBurnTime() {
        return this.propertyDelegate.method_17390(0);
    }

    public int getLastFuelTime() {
        return this.propertyDelegate.method_17390(1);
    }

    public int getMiningProgress() {
        return this.propertyDelegate.method_17390(2);
    }

    public int getTicksPerBlock() {
        return this.propertyDelegate.method_17390(3);
    }

    public int getScaledFuelProgress() {
        int burnTime = this.getBurnTime();
        int lastFuel = this.getLastFuelTime();
        if (burnTime <= 0 || lastFuel <= 0) {
            return 0;
        }
        return burnTime * 13 / lastFuel;
    }

    public int getScaledMiningProgress() {
        int progress = this.getMiningProgress();
        int total = this.getTicksPerBlock();
        if (total <= 0 || progress <= 0) {
            return 0;
        }
        return progress * 22 / total;
    }

    public boolean isBurning() {
        return this.getBurnTime() > 0;
    }

    public boolean hasPickaxe() {
        return !this.inventory.method_5438(0).method_7960();
    }

    public boolean hasFuel() {
        return !this.inventory.method_5438(1).method_7960();
    }

    public record QuarryScreenData(class_2338 pos) {
        public static final class_9139<class_9129, QuarryScreenData> PACKET_CODEC = class_9139.method_56438((data, buf) -> buf.method_10807(data.pos), buf -> new QuarryScreenData(buf.method_10811()));
    }

    private static class PickaxeSlot
    extends class_1735 {
        private final QuarryBlockEntity quarry;

        PickaxeSlot(QuarryBlockEntity quarry, int index, int x, int y) {
            super((class_1263)quarry, index, x, y);
            this.quarry = quarry;
        }

        public boolean method_7680(class_1799 stack) {
            return this.quarry.isValidPickaxe(stack);
        }

        public int method_7675() {
            return 1;
        }
    }

    private static class FuelSlot
    extends class_1735 {
        private final QuarryBlockEntity quarry;

        FuelSlot(QuarryBlockEntity quarry, int index, int x, int y) {
            super((class_1263)quarry, index, x, y);
            this.quarry = quarry;
        }

        public boolean method_7680(class_1799 stack) {
            return this.quarry.getFuelValue(stack) > 0;
        }
    }

    private static class OutputSlot
    extends class_1735 {
        OutputSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }
    }
}

