/*
 * Decompiled with CFR 0.152.
 */
package dev.xef2.visualkeymap;

import dev.xef2.visualkeymap.api.KeyBinding;
import dev.xef2.visualkeymap.api.MinecraftImpl;
import dev.xef2.visualkeymap.api.VisualKeymapApi;
import dev.xef2.visualkeymap.integration.CommandKeysIntegration;
import dev.xef2.visualkeymap.integration.MaLiLibIntegration;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;

public class VisualKeymap
implements ClientModInitializer {
    private static final String MOD_ID = "visualkeymap";
    private static final List<VisualKeymapApi<?>> apiImpl = new ArrayList<MinecraftImpl>(List.of(new MinecraftImpl()));

    public void onInitializeClient() {
        FabricLoader.getInstance().getEntrypointContainers(MOD_ID, VisualKeymapApi.class).forEach(entrypoint -> {
            try {
                VisualKeymapApi api = (VisualKeymapApi)entrypoint.getEntrypoint();
                apiImpl.add(api);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        if (FabricLoader.getInstance().isModLoaded("malilib")) {
            apiImpl.add(new MaLiLibIntegration());
        }
        if (FabricLoader.getInstance().isModLoaded("commandkeys")) {
            apiImpl.add(new CommandKeysIntegration());
        }
    }

    public static List<? extends KeyBinding> getKeyBindings() {
        return apiImpl.stream().flatMap(api -> api.getKeyBindings().stream()).toList();
    }

    public static void saveKeyBindings() {
        apiImpl.forEach(VisualKeymapApi::save);
    }

    public static String getTranslationKey(String key) {
        return "visualkeymap." + key;
    }
}

