/*
 * Decompiled with CFR 0.152.
 */
package dev.xef2.visualkeymap.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3675;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public abstract class KeyBinding {
    private final class_2561 category;
    private final class_2561 name;
    private final int maxBoundKeys;

    public KeyBinding(class_2561 category, class_2561 name, int maxBoundKeys) {
        this.category = category;
        this.name = name;
        this.maxBoundKeys = maxBoundKeys;
    }

    public class_5250 getDisplayName() {
        return this.category.method_27661().method_10852(class_2561.method_30163((String)" - ")).method_10852(this.name);
    }

    public int getMaxBoundKeys() {
        return this.maxBoundKeys;
    }

    public abstract List<Integer> getKeyCodes();

    public List<Integer> getModifierKeyCodes() {
        return List.of();
    }

    public final List<Integer> getFullKeyCodes() {
        ArrayList<Integer> fullKeyCodes = new ArrayList<Integer>(this.getModifierKeyCodes());
        fullKeyCodes.addAll(this.getKeyCodes());
        return fullKeyCodes;
    }

    public int getOrder() {
        return 0;
    }

    public static List<List<KeyBinding>> getConflictBindings(List<? extends KeyBinding> bindings) {
        if (bindings.size() <= 1) {
            return List.of();
        }
        HashMap<ConflictKey, List> conflictMap = new HashMap<ConflictKey, List>();
        for (KeyBinding keyBinding : bindings) {
            ConflictKey key = new ConflictKey(keyBinding.getFullKeyCodes(), keyBinding.getOrder());
            conflictMap.computeIfAbsent(key, k -> new ArrayList()).add(keyBinding);
        }
        return conflictMap.values().stream().filter(list -> list.size() > 1).toList();
    }

    private static class_2561 getLocalizedTextFromCode(int code) {
        class_3675.class_307 inputType = code >= 0 && code <= 7 ? class_3675.class_307.field_1672 : class_3675.class_307.field_1668;
        return inputType.method_1447(code).method_27445();
    }

    public class_2561 getBoundKeysLocalizedText() {
        List<Integer> keyCodes = this.getKeyCodes();
        if (keyCodes.isEmpty()) {
            return class_2561.method_43471((String)"key.keyboard.unknown");
        }
        class_5250 text = class_2561.method_43473();
        List<Integer> modifierKeyCodes = this.getModifierKeyCodes();
        if (!modifierKeyCodes.isEmpty()) {
            class_5250 modifierText = class_2561.method_30163((String)"[ ").method_27661().method_27692(class_124.field_1056);
            for (int modifierKeyCode : modifierKeyCodes) {
                modifierText.method_10852(KeyBinding.getLocalizedTextFromCode(modifierKeyCode));
                modifierText.method_27693(" + ");
            }
            modifierText.method_27693("] ");
            text.method_10852((class_2561)modifierText);
        }
        for (int i = 0; i < keyCodes.size(); ++i) {
            if (i > 0) {
                text.method_10852(class_2561.method_30163((String)" + "));
            }
            text.method_10852(KeyBinding.getLocalizedTextFromCode(keyCodes.get(i)));
        }
        return text;
    }

    protected List<String> getSearchableStrings() {
        return Stream.concat(Stream.of(this.category, this.name), this.getFullKeyCodes().stream().map(KeyBinding::getLocalizedTextFromCode)).map(class_2561::getString).toList();
    }

    public final boolean containsSearchText(String searchText) {
        List<String> searchTerms = Arrays.stream(searchText.toLowerCase().split(" ")).filter(s -> !s.isBlank()).toList();
        if (searchTerms.isEmpty()) {
            return false;
        }
        String targetString = String.join((CharSequence)" ", this.getSearchableStrings()).toLowerCase();
        return searchTerms.stream().allMatch(targetString::contains);
    }

    public abstract void setBoundKeys(List<class_3675.class_306> var1);

    public abstract boolean isDefault();

    public abstract void resetToDefault();

    private record ConflictKey(List<Integer> fullKeyCodes, int order) {
    }
}

