/*
 * Decompiled with CFR 0.152.
 */
package dev.xef2.visualkeymap.gui.screen;

import dev.xef2.visualkeymap.VisualKeymap;
import dev.xef2.visualkeymap.api.KeyBinding;
import dev.xef2.visualkeymap.gui.widget.KeybindsListWidget;
import dev.xef2.visualkeymap.gui.widget.KeyboardWidget;
import dev.xef2.visualkeymap.mixin.ThreePartsLayoutWidgetAccessor;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

@Environment(value=EnvType.CLIENT)
public class VisualKeymapScreen
extends class_4667 {
    private List<? extends KeyBinding> keyBindings = List.of();
    private final SharedData sharedData = new SharedData();
    private final List<class_3675.class_306> pressedKeys = new ArrayList<class_3675.class_306>();
    private KeyboardWidget keyboardWidget;
    private KeybindsListWidget keybindsListWidget;

    public VisualKeymapScreen(class_437 parent, class_315 gameOptions) {
        super(parent, gameOptions, (class_2561)class_2561.method_43471((String)VisualKeymap.getTranslationKey("gui.title")));
    }

    protected void method_60325() {
    }

    protected void method_57732() {
        class_8667 directionalLayoutWidget = (class_8667)this.field_49503.method_48992((class_8021)class_8667.method_52741().method_52735(4));
        directionalLayoutWidget.method_52740().method_46467();
        directionalLayoutWidget.method_52736((class_8021)new class_7842(this.field_22785, this.field_22793));
        class_342 searchBox = (class_342)directionalLayoutWidget.method_52736((class_8021)new class_342(this.field_22793, 0, 0, 200, 15, (class_2561)class_2561.method_43473()));
        searchBox.method_47404((class_2561)class_2561.method_43471((String)VisualKeymap.getTranslationKey("gui.search_hint")).method_27696(class_342.field_62466));
        searchBox.method_1863(search -> {
            this.sharedData.searchText = search;
            this.keybindsListWidget.createEntries();
        });
        this.field_49503.method_48995(36);
    }

    protected void method_60329() {
        this.keyBindings = VisualKeymap.getKeyBindings();
        this.keyboardWidget = (KeyboardWidget)this.field_49503.method_49000((class_8021)new KeyboardWidget(0, 0, 0, 0, true, this.sharedData, this::getBindingsForKey, this::setSelectedKey), class_7847::method_46472);
        this.keybindsListWidget = (KeybindsListWidget)this.field_49503.method_49000((class_8021)new KeybindsListWidget(this.field_22787, 0, 0, 0, this.sharedData, k -> {
            k.resetToDefault();
            this.keyboardWidget.updateKeyBindings();
        }), class_7847::method_46476);
        this.keybindsListWidget.setKeyBindings(this.getUnboundBindings());
    }

    private List<? extends KeyBinding> getUnboundBindings() {
        return this.keyBindings.stream().filter(binding -> binding.getKeyCodes().isEmpty()).toList();
    }

    private List<? extends KeyBinding> getBindingsForKey(class_3675.class_306 key) {
        return this.keyBindings.stream().filter(binding -> binding.getFullKeyCodes().contains(key.method_1444())).toList();
    }

    private void setSelectedKey(class_3675.class_306 key) {
        int keyCode = key.method_1444();
        if (this.sharedData.selectedKeyCode != null && this.sharedData.selectedKeyCode == keyCode) {
            this.sharedData.selectedKeyCode = null;
            this.keybindsListWidget.setKeyBindings(this.getUnboundBindings());
        } else {
            this.sharedData.selectedKeyCode = keyCode;
            this.keybindsListWidget.setKeyBindings(this.getBindingsForKey(key));
        }
        this.sharedData.selectedKeyBinding = null;
    }

    protected void method_48640() {
        int cHeight = this.field_49503.method_57727();
        int keyboardPadding = 5;
        ((ThreePartsLayoutWidgetAccessor)this.field_49503).getBody().method_46447(cHeight);
        this.keyboardWidget.setSize(this.field_22789 - keyboardPadding * 2, cHeight / 2);
        this.keybindsListWidget.method_57714(this.field_22789, cHeight / 2 - keyboardPadding, this.field_49503.method_48998() + cHeight / 2 + keyboardPadding);
        super.method_48640();
    }

    private void setKeyBinding(boolean ended) {
        this.sharedData.selectedKeyBinding.setBoundKeys(this.pressedKeys);
        if (ended || this.pressedKeys.size() == this.sharedData.selectedKeyBinding.getMaxBoundKeys()) {
            this.sharedData.selectedKeyBinding = null;
            this.pressedKeys.clear();
        }
        this.keyboardWidget.updateKeyBindings();
        this.keybindsListWidget.updateAllEntries();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.sharedData.selectedKeyBinding != null) {
            this.pressedKeys.add(class_3675.class_307.field_1672.method_1447(click.method_74245()));
            this.setKeyBinding(true);
            return true;
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25404(class_11908 input) {
        class_3675.class_306 key = class_3675.method_15985((class_11908)input);
        if (this.sharedData.selectedKeyBinding != null && !this.pressedKeys.contains(key)) {
            if (!input.method_74231()) {
                this.pressedKeys.add(key);
            }
            this.setKeyBinding(input.method_74231());
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_16803(class_11908 input) {
        if (this.sharedData.selectedKeyBinding != null) {
            this.setKeyBinding(true);
            return true;
        }
        return super.method_16803(input);
    }

    public void method_25432() {
        VisualKeymap.saveKeyBindings();
        super.method_25432();
    }

    public static class SharedData {
        public String searchText = "";
        public Integer selectedKeyCode = null;
        public KeyBinding selectedKeyBinding = null;
    }
}

