/*
 * Decompiled with CFR 0.152.
 */
package dev.xef2.visualkeymap.gui.widget;

import dev.xef2.visualkeymap.VisualKeymap;
import dev.xef2.visualkeymap.api.KeyBinding;
import dev.xef2.visualkeymap.gui.screen.VisualKeymapScreen;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11907;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4264;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class KeyWidget
extends class_4264 {
    private static final int KEY_BACKGROUND_COLOR = -12303292;
    private static final int KEY_SINGLE_BOUNDED_COLOR = -16751616;
    private static final int KEY_MULTI_UNIQUE_COLOR = -4684277;
    private static final int KEY_MULTI_CONFLICT_COLOR = -7667712;
    private static final int BORDER_THICKNESS = 1;
    private static final int MAX_DISPLAYED_BINDINGS = 5;
    private final class_3675.class_306 key;
    private final VisualKeymapScreen.SharedData sharedData;
    private final Supplier<List<? extends KeyBinding>> bindingSupplier;
    private final Runnable keySelector;
    private List<? extends KeyBinding> bindings;
    private List<List<KeyBinding>> conflictBindings;

    public KeyWidget(class_3675.class_306 key, class_2561 text, VisualKeymapScreen.SharedData sharedData, Supplier<List<? extends KeyBinding>> bindingSupplier, Runnable keySelector) {
        super(0, 0, 0, 0, text);
        this.key = key;
        this.sharedData = sharedData;
        this.bindingSupplier = bindingSupplier;
        this.keySelector = keySelector;
        this.updateBindings();
    }

    public void updateBindings() {
        this.bindings = this.bindingSupplier.get();
        this.conflictBindings = KeyBinding.getConflictBindings(this.bindings);
        class_5250 tooltipText = class_2561.method_43473();
        tooltipText.method_10852((class_2561)this.key.method_27445().method_27661().method_27695(new class_124[]{class_124.field_1067, class_124.field_1065}));
        for (int i = 0; i < this.bindings.size(); ++i) {
            tooltipText.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            if (i >= 5) {
                tooltipText.method_10852((class_2561)class_2561.method_43469((String)VisualKeymap.getTranslationKey("gui.bindings_more"), (Object[])new Object[]{this.bindings.size() - 5}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
                break;
            }
            tooltipText.method_10852((class_2561)this.bindings.get(i).getDisplayName());
        }
        this.method_47400(class_7919.method_47407((class_2561)tooltipText));
    }

    public void method_25306(class_11907 input) {
        this.keySelector.run();
    }

    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int bindCount = this.bindings.size();
        int color = !this.conflictBindings.isEmpty() ? -7667712 : (bindCount == 1 ? -16751616 : (bindCount >= 2 ? -4684277 : -12303292));
        int borderColor = this.sharedData.selectedKeyCode != null && this.sharedData.selectedKeyCode.intValue() == this.key.method_1444() ? -1 : (this.bindings.stream().anyMatch(binding -> binding.containsSearchText(this.sharedData.searchText)) ? -256 : -16777216);
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), borderColor);
        int innerX = this.method_46426() + 1;
        int innerY = this.method_46427() + 1;
        int innerWidth = this.method_25368() - 2;
        int innerHeight = this.method_25364() - 2;
        context.method_25294(innerX, innerY, innerX + innerWidth, innerY + innerHeight, color);
        this.method_48589(context, class_310.method_1551().field_1772, -1);
    }
}

