/*
 * Decompiled with CFR 0.152.
 */
package dev.xef2.visualkeymap.gui.widget;

import dev.xef2.visualkeymap.api.KeyBinding;
import dev.xef2.visualkeymap.gui.screen.VisualKeymapScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class KeybindsListWidget
extends class_4265<Entry> {
    private static final int ROW_HEIGHT = 20;
    private final VisualKeymapScreen.SharedData sharedData;
    private final Consumer<KeyBinding> resetCallback;
    private List<? extends KeyBinding> keyBindings;

    public KeybindsListWidget(class_310 client, int width, int height, int y, VisualKeymapScreen.SharedData sharedData, Consumer<KeyBinding> resetCallback) {
        super(client, width, height, y, 20);
        this.sharedData = sharedData;
        this.resetCallback = resetCallback;
    }

    public void setKeyBindings(List<? extends KeyBinding> keyBindings) {
        this.keyBindings = new ArrayList<KeyBinding>(keyBindings);
        this.createEntries();
    }

    public void createEntries() {
        List sortedKeyBindings = this.keyBindings.stream().sorted((a, b) -> {
            boolean aContains = a.containsSearchText(this.sharedData.searchText);
            boolean bContains = b.containsSearchText(this.sharedData.searchText);
            if (aContains && !bContains) {
                return -1;
            }
            if (!aContains && bContains) {
                return 1;
            }
            return 0;
        }).toList();
        this.method_25339();
        for (KeyBinding keyBinding : sortedKeyBindings) {
            this.method_25321((class_350.class_351)new Entry(keyBinding));
        }
        this.method_44382(0.0);
        this.updateAllEntries();
    }

    public int method_25322() {
        return 340;
    }

    public void updateAllEntries() {
        List<List<KeyBinding>> conflictKeyBindings = KeyBinding.getConflictBindings(this.keyBindings);
        this.method_25396().forEach(entry -> entry.update(conflictKeyBindings));
    }

    @Environment(value=EnvType.CLIENT)
    public class Entry
    extends class_4265.class_4266<Entry> {
        private static final class_2561 RESET_TEXT = class_2561.method_43471((String)"controls.reset");
        private final KeyBinding binding;
        private final class_7842 nameWidget;
        private final class_4185 editButton;
        private final class_4185 resetButton;

        public Entry(KeyBinding binding) {
            this.binding = binding;
            class_327 textRenderer = ((KeybindsListWidget)KeybindsListWidget.this).field_22740.field_1772;
            this.nameWidget = new class_7842(0, 20, (class_2561)binding.getDisplayName(), textRenderer);
            this.nameWidget.method_47400(class_7919.method_47407((class_2561)binding.getDisplayName()));
            this.editButton = class_4185.method_46430((class_2561)binding.getBoundKeysLocalizedText(), button -> {
                KeybindsListWidget.this.sharedData.selectedKeyBinding = binding;
                KeybindsListWidget.this.updateAllEntries();
            }).method_46434(0, 0, 100, 20).method_46431();
            this.resetButton = class_4185.method_46430((class_2561)RESET_TEXT, button -> {
                KeybindsListWidget.this.resetCallback.accept(binding);
                KeybindsListWidget.this.updateAllEntries();
            }).method_46434(0, 0, 50, 20).method_46431();
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            int y = this.method_73382() - 2;
            int resetX = KeybindsListWidget.this.method_65507() - this.resetButton.method_25368() - 10;
            this.resetButton.method_48229(resetX, y);
            this.resetButton.method_25394(context, mouseX, mouseY, deltaTicks);
            int editX = resetX - 5 - this.editButton.method_25368();
            this.editButton.method_48229(editX, y);
            this.editButton.method_25394(context, mouseX, mouseY, deltaTicks);
            int textX = this.method_73380();
            this.nameWidget.method_48229(textX, y);
            this.nameWidget.method_73396(editX - textX - 5);
            this.nameWidget.method_25394(context, mouseX, mouseY, deltaTicks);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.nameWidget, this.editButton, this.resetButton);
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.editButton, this.resetButton);
        }

        protected void update(List<List<KeyBinding>> conflictKeyBindings) {
            List conflictedBindings;
            if (this.binding.containsSearchText(KeybindsListWidget.this.sharedData.searchText)) {
                this.nameWidget.method_25355((class_2561)this.binding.getDisplayName().method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
            } else {
                this.nameWidget.method_25355((class_2561)this.binding.getDisplayName());
            }
            List list2 = conflictedBindings = this.binding.getKeyCodes().isEmpty() ? null : (List)conflictKeyBindings.stream().filter(list -> list.contains(this.binding)).findFirst().orElse(null);
            if (conflictedBindings != null) {
                class_5250 tooltipText = class_2561.method_43473();
                tooltipText.method_10852((class_2561)class_2561.method_43471((String)"visualkeymap.gui.conflict_title").method_27695(new class_124[]{class_124.field_1067, class_124.field_1065}));
                for (KeyBinding binding : conflictedBindings) {
                    if (binding == this.binding) continue;
                    tooltipText.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)binding.getDisplayName());
                }
                this.editButton.method_47400(class_7919.method_47407((class_2561)tooltipText));
            } else {
                this.editButton.method_47400(null);
            }
            class_5250 keyText = this.binding.getBoundKeysLocalizedText().method_27661();
            if (KeybindsListWidget.this.sharedData.selectedKeyBinding == this.binding) {
                this.editButton.method_25355((class_2561)class_2561.method_43470((String)"> ").method_10852((class_2561)keyText.method_27692(class_124.field_1068)).method_27693(" <").method_27692(class_124.field_1054));
            } else if (conflictedBindings != null) {
                this.editButton.method_25355((class_2561)keyText.method_27692(class_124.field_1065));
            } else {
                this.editButton.method_25355((class_2561)keyText);
            }
            this.resetButton.field_22763 = !this.binding.isDefault();
        }
    }
}

