/*
 * Decompiled with CFR 0.152.
 */
package dev.xef2.visualkeymap.gui.widget;

import dev.xef2.visualkeymap.VisualKeymap;
import dev.xef2.visualkeymap.api.KeyBinding;
import dev.xef2.visualkeymap.gui.screen.VisualKeymapScreen;
import dev.xef2.visualkeymap.gui.widget.KeyLayoutHelper;
import dev.xef2.visualkeymap.gui.widget.KeyWidget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_7838;
import net.minecraft.class_8021;

@Environment(value=EnvType.CLIENT)
public class KeyboardWidget
extends class_7838 {
    private static final int KEY_SPACING = 1;
    private int maxHeight;
    private int keySize;
    private final KeyLayoutHelper.KeyboardLayout keyboardLayout;
    private final Map<KeyLayoutHelper.KeyLayout, KeyWidget> keyWidgetMap = new HashMap<KeyLayoutHelper.KeyLayout, KeyWidget>();

    public KeyboardWidget(int x, int y, int width, int maxHeight, boolean isFull, VisualKeymapScreen.SharedData sharedData, Function<class_3675.class_306, List<? extends KeyBinding>> bindingGetter, Consumer<class_3675.class_306> keySelector) {
        super(x, y, width, 0);
        this.maxHeight = maxHeight;
        this.keyboardLayout = KeyLayoutHelper.getLayout(isFull);
        for (KeyLayoutHelper.KeyLayout keyLayout : this.keyboardLayout.keys()) {
            String translationKey = VisualKeymap.getTranslationKey("key." + keyLayout.translationKey());
            class_3675.class_306 key = keyLayout.getKey();
            class_5250 text = class_1074.method_4663((String)translationKey) ? class_2561.method_43471((String)translationKey) : key.method_27445();
            this.keyWidgetMap.put(keyLayout, new KeyWidget(key, (class_2561)text, sharedData, () -> (List)bindingGetter.apply(key), () -> keySelector.accept(key)));
        }
        this.updateSizeAndHeight();
    }

    public void updateKeyBindings() {
        this.keyWidgetMap.values().forEach(KeyWidget::updateBindings);
    }

    public void setSize(int width, int maxHeight) {
        this.field_41813 = width;
        this.maxHeight = maxHeight;
        this.updateSizeAndHeight();
    }

    public void method_48227(Consumer<class_8021> consumer) {
        this.keyWidgetMap.values().forEach(consumer);
    }

    private int getSizeWithSpacing(double mult) {
        return (int)(mult * (double)this.keySize + (mult - 1.0) * 1.0);
    }

    private void updateSizeAndHeight() {
        double totalCols = this.keyboardLayout.columns();
        double totalRows = this.keyboardLayout.rows();
        this.keySize = class_3532.method_15357((double)Math.min(((double)this.field_41813 - (totalCols - 1.0) * 1.0) / totalCols, ((double)this.maxHeight - (totalRows - 1.0) * 1.0) / totalRows));
        this.field_41814 = this.getSizeWithSpacing(totalRows);
    }

    public void method_48222() {
        int totalWidth = this.getSizeWithSpacing(this.keyboardLayout.columns());
        int startX = this.method_46426() + (this.field_41813 - totalWidth) / 2;
        int startY = this.method_46427();
        for (KeyLayoutHelper.KeyLayout keyLayout : this.keyboardLayout.keys()) {
            int width = this.getSizeWithSpacing(keyLayout.widthMult());
            int height = this.getSizeWithSpacing(keyLayout.heightMult());
            int x = startX + (int)(keyLayout.col() * (double)(this.keySize + 1));
            int y = startY + (int)(keyLayout.row() * (double)(this.keySize + 1));
            this.keyWidgetMap.get(keyLayout).method_55444(width, height, x, y);
        }
    }
}

