/*
 * Decompiled with CFR 0.152.
 */
package dev.xef2.visualkeymap.integration;

import dev.terminalmc.commandkeys.CommandKeys;
import dev.terminalmc.commandkeys.config.Config;
import dev.terminalmc.commandkeys.config.Keybind;
import dev.terminalmc.commandkeys.config.Macro;
import dev.terminalmc.commandkeys.config.Profile;
import dev.xef2.visualkeymap.api.KeyBinding;
import dev.xef2.visualkeymap.api.VisualKeymapApi;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class CommandKeysIntegration
implements VisualKeymapApi<CommandKeysKeyBinding> {
    @Override
    public List<CommandKeysKeyBinding> getKeyBindings() {
        Profile currProfile = CommandKeys.profile();
        return currProfile.macroMap.entries().stream().map(entry -> new CommandKeysKeyBinding(currProfile, (Macro)entry.getValue(), (Keybind)entry.getKey())).toList();
    }

    @Override
    public void save() {
        Config.save();
    }

    public static class CommandKeysKeyBinding
    extends KeyBinding {
        private final Profile profile;
        private final Macro macro;
        private final Keybind keybind;

        public CommandKeysKeyBinding(Profile profile, Macro macro, Keybind keybind) {
            super((class_2561)class_2561.method_43471((String)"key.category.commandkeys.main"), (class_2561)class_2561.method_43469((String)"option.commandkeys.profile", (Object[])new Object[]{profile.name}), 2);
            this.profile = profile;
            this.macro = macro;
            this.keybind = keybind;
        }

        @Override
        public List<Integer> getKeyCodes() {
            return Stream.of(this.keybind.getLimitKey(), this.keybind.getKey()).filter(key -> !key.equals((Object)class_3675.field_16237)).map(class_3675.class_306::method_1444).toList();
        }

        @Override
        protected List<String> getSearchableStrings() {
            ArrayList<String> strings = new ArrayList<String>(super.getSearchableStrings());
            strings.addAll(this.macro.getMessages().stream().map(m -> m.string).toList());
            return strings;
        }

        @Override
        public void setBoundKeys(List<class_3675.class_306> keys) {
            class_3675.class_306 key = class_3675.field_16237;
            class_3675.class_306 limitKey = class_3675.field_16237;
            if (keys.size() == 1) {
                key = keys.getFirst();
            } else if (keys.size() > 1) {
                limitKey = keys.getFirst();
                key = keys.get(1);
            }
            this.profile.setKey(this.macro, this.keybind, key);
            this.profile.setLimitKey(this.macro, this.keybind, limitKey);
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public void resetToDefault() {
        }
    }
}

