/*
 * Decompiled with CFR 0.152.
 */
package dev.xef2.visualkeymap.integration;

import dev.xef2.visualkeymap.api.KeyBinding;
import dev.xef2.visualkeymap.api.VisualKeymapApi;
import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindCategory;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class MaLiLibIntegration
implements VisualKeymapApi<MaLiLibKeyBinding> {
    @Override
    public List<MaLiLibKeyBinding> getKeyBindings() {
        return InputEventHandler.getKeybindManager().getKeybindCategories().stream().flatMap(category -> category.getHotkeys().stream().map(hotkey -> new MaLiLibKeyBinding((KeybindCategory)category, (IHotkey)hotkey))).toList();
    }

    @Override
    public void save() {
        ((ConfigManager)ConfigManager.getInstance()).saveAllConfigs();
        InputEventHandler.getKeybindManager().updateUsedKeys();
    }

    public static class MaLiLibKeyBinding
    extends KeyBinding {
        private final IHotkey hotkey;

        public MaLiLibKeyBinding(KeybindCategory category, IHotkey hotkey) {
            super(class_2561.method_30163((String)category.getModName()), class_2561.method_30163((String)hotkey.getConfigGuiDisplayName()), 4);
            this.hotkey = hotkey;
        }

        @Override
        public List<Integer> getKeyCodes() {
            return this.hotkey.getKeybind().getKeys().stream().map(key -> key < -1 ? key + 100 : key).toList();
        }

        @Override
        protected List<String> getSearchableStrings() {
            ArrayList<String> strings = new ArrayList<String>(super.getSearchableStrings());
            strings.add(this.hotkey.getName());
            return strings;
        }

        @Override
        public void setBoundKeys(List<class_3675.class_306> keys) {
            IKeybind keybind = this.hotkey.getKeybind();
            keybind.clearKeys();
            keys.stream().map(class_3675.class_306::method_1444).map(code -> code >= 0 && code <= 7 ? code - 100 : code).forEach(arg_0 -> ((IKeybind)keybind).addKey(arg_0));
        }

        @Override
        public boolean isDefault() {
            return !this.hotkey.getKeybind().isModified();
        }

        @Override
        public void resetToDefault() {
            this.hotkey.getKeybind().resetToDefault();
        }
    }
}

