/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public final class DisplayOverrides {
    private static final Map<String, Map<HandSide, Entry>> CACHE = new ConcurrentHashMap<String, Map<HandSide, Entry>>();

    private DisplayOverrides() {
    }

    public static Entry get(String resourcePath, HandSide side) {
        try {
            Map m = CACHE.computeIfAbsent(resourcePath, DisplayOverrides::load);
            return (Entry)m.get((Object)side);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static Map<HandSide, Entry> load(String resourcePath) {
        ConcurrentHashMap<HandSide, Entry> map = new ConcurrentHashMap<HandSide, Entry>();
        try {
            class_310 mc = class_310.method_1551();
            if (mc == null) {
                return map;
            }
            class_2960 id = new class_2960("punchy", resourcePath);
            class_3298 res = mc.method_1478().method_14486(id).orElse(null);
            if (res == null) {
                return map;
            }
            try (InputStream in = res.method_14482();
                 InputStreamReader rdr = new InputStreamReader(in, StandardCharsets.UTF_8);){
                JsonObject root = JsonParser.parseReader((Reader)rdr).getAsJsonObject();
                Entry right = DisplayOverrides.parse(root.get("firstperson_righthand"));
                Entry left = DisplayOverrides.parse(root.get("firstperson_lefthand"));
                if (right != null) {
                    map.put(HandSide.RIGHT, right);
                }
                if (left != null) {
                    map.put(HandSide.LEFT, left);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private static Entry parse(JsonElement el) {
        if (el == null || !el.isJsonObject()) {
            return null;
        }
        JsonObject o = el.getAsJsonObject();
        float[] rot = DisplayOverrides.arr3(o.get("rotation"), 0.0f, 0.0f, 0.0f);
        float[] tr = DisplayOverrides.arr3(o.get("translation"), 0.0f, 0.0f, 0.0f);
        float[] sc = DisplayOverrides.arr3(o.get("scale"), 1.0f, 1.0f, 1.0f);
        return new Entry(rot[0], rot[1], rot[2], tr[0], tr[1], tr[2], sc[0], sc[1], sc[2]);
    }

    private static float[] arr3(JsonElement el, float dx, float dy, float dz) {
        float[] out = new float[]{dx, dy, dz};
        if (el == null || !el.isJsonArray()) {
            return out;
        }
        JsonArray a = el.getAsJsonArray();
        for (int i = 0; i < Math.min(3, a.size()); ++i) {
            try {
                out[i] = a.get(i).getAsFloat();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return out;
    }

    public static final class Entry {
        public final float rotX;
        public final float rotY;
        public final float rotZ;
        public final float offX;
        public final float offY;
        public final float offZ;
        public final float scaleX;
        public final float scaleY;
        public final float scaleZ;

        public Entry(float rx, float ry, float rz, float tx, float ty, float tz, float sx, float sy, float sz) {
            this.rotX = rx;
            this.rotY = ry;
            this.rotZ = rz;
            this.offX = tx;
            this.offY = ty;
            this.offZ = tz;
            this.scaleX = sx;
            this.scaleY = sy;
            this.scaleZ = sz;
        }
    }

    public static enum HandSide {
        LEFT,
        RIGHT;

    }
}

