/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import net.minecraft.class_1268;

public final class ToolAnimationOverrides {
    private static final RotationOffset MAIN = new RotationOffset();
    private static final RotationOffset OFF = new RotationOffset();

    private ToolAnimationOverrides() {
    }

    public static RotationOffset rotationOffset(class_1268 hand) {
        return hand == class_1268.field_5810 ? OFF : MAIN;
    }

    public static void setRotationOffset(class_1268 hand, float rotXDeg, float rotYDeg, float rotZDeg) {
        ToolAnimationOverrides.rotationOffset(hand).setDegrees(rotXDeg, rotYDeg, rotZDeg);
    }

    public static void addRotationOffset(class_1268 hand, float rotXDeg, float rotYDeg, float rotZDeg) {
        ToolAnimationOverrides.rotationOffset(hand).addDegrees(rotXDeg, rotYDeg, rotZDeg);
    }

    public static void clear(class_1268 hand) {
        ToolAnimationOverrides.rotationOffset(hand).clear();
    }

    public static void clearAll() {
        MAIN.clear();
        OFF.clear();
    }

    public static boolean hasOverride(class_1268 hand) {
        return !ToolAnimationOverrides.rotationOffset(hand).isZero();
    }

    public static final class RotationOffset {
        private float rotXRad;
        private float rotYRad;
        private float rotZRad;

        private RotationOffset() {
        }

        private void setDegrees(float rotXDeg, float rotYDeg, float rotZDeg) {
            this.rotXRad = (float)Math.toRadians(rotXDeg);
            this.rotYRad = (float)Math.toRadians(rotYDeg);
            this.rotZRad = (float)Math.toRadians(rotZDeg);
        }

        private void addDegrees(float rotXDeg, float rotYDeg, float rotZDeg) {
            this.rotXRad += (float)Math.toRadians(rotXDeg);
            this.rotYRad += (float)Math.toRadians(rotYDeg);
            this.rotZRad += (float)Math.toRadians(rotZDeg);
        }

        public float rotXRad() {
            return this.rotXRad;
        }

        public float rotYRad() {
            return this.rotYRad;
        }

        public float rotZRad() {
            return this.rotZRad;
        }

        private boolean isZero() {
            return this.rotXRad == 0.0f && this.rotYRad == 0.0f && this.rotZRad == 0.0f;
        }

        private void clear() {
            this.rotXRad = 0.0f;
            this.rotYRad = 0.0f;
            this.rotZRad = 0.0f;
        }
    }
}

