/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.legendofthedwerden.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.legendofthedwerden.LegendOfTheDwerdenMod;
import net.mcreator.legendofthedwerden.procedures.Achiv1Procedure;
import net.mcreator.legendofthedwerden.procedures.Achiv2Procedure;
import net.mcreator.legendofthedwerden.procedures.Bar2Procedure;
import net.mcreator.legendofthedwerden.procedures.BarProcedure;
import net.mcreator.legendofthedwerden.procedures.Break1Procedure;
import net.mcreator.legendofthedwerden.procedures.Break2Procedure;
import net.mcreator.legendofthedwerden.procedures.DeleteProcedure;
import net.mcreator.legendofthedwerden.procedures.DoneProcedure;
import net.mcreator.legendofthedwerden.procedures.NormalProcedure;
import net.mcreator.legendofthedwerden.procedures.Rab1Procedure;
import net.mcreator.legendofthedwerden.procedures.Rab2Procedure;
import net.mcreator.legendofthedwerden.procedures.SlowProcedure;
import net.mcreator.legendofthedwerden.procedures.UnDeleteProcedure;
import net.mcreator.legendofthedwerden.world.inventory.SpawnMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpawnButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SpawnButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SpawnButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SpawnButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SpawnButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SpawnButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SpawnMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            DoneProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SlowProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            NormalProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            DeleteProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            UnDeleteProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 5) {
            Break1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            Break2Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            Bar2Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 8) {
            BarProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 9) {
            Rab2Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 10) {
            Rab1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 11) {
            Achiv2Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 12) {
            Achiv1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        LegendOfTheDwerdenMod.addNetworkMessage(SpawnButtonMessage.class, SpawnButtonMessage::buffer, SpawnButtonMessage::new, SpawnButtonMessage::handler);
    }
}

