/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity;

import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.layers.BeeBodyLayer;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;

public class DyeBeeRenderer
extends ProductiveBeeRenderer {
    public DyeBeeRenderer(EntityRendererProvider.Context context) {
        super(context, new ProductiveBeeModel<ProductiveBee>(context.bakeLayer(PB_MAIN_LAYER), "default"));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_DEFAULT_LAYER), "default", this.isChristmas));
    }

    @Override
    @Nonnull
    public ResourceLocation getTextureLocation(ProductiveBee bee) {
        int num = bee.getRenderStatic() ? 1 : this.sum(bee.getId(), 3);
        String beeLocation = "productivebees:textures/entity/bee/" + bee.getBeeName() + "/" + num + "/bee";
        if (bee.isAngry()) {
            beeLocation = beeLocation + "_angry";
        }
        if (bee.hasNectar()) {
            beeLocation = beeLocation + "_nectar";
        }
        return ProductiveBeeRenderer.resLoc(beeLocation + ".png");
    }

    private int sum(int num, int max) {
        double sum = 0.0;
        while (num > 0) {
            sum += (double)(num % 10);
            num /= 10;
        }
        return sum > 9.0 ? this.sum((int)sum, max) : (int)Math.ceil(sum / (double)max);
    }
}

