/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.client.render.entity.layers.BeeBodyLayer;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BumbleBee;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ProductiveBeeRenderer
extends MobRenderer<ProductiveBee, ProductiveBeeModel<ProductiveBee>> {
    private static Map<String, ResourceLocation> resLocCache = new HashMap<String, ResourceLocation>();
    public static final ModelLayerLocation PB_MAIN_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"main"), "main");
    public static final ModelLayerLocation PB_HOARDER_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"hoarder"), "main");
    public static final ModelLayerLocation PB_RANCHER_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"rancher"), "main");
    public static final ModelLayerLocation PB_THICC_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"thicc"), "main");
    public static final ModelLayerLocation PB_DEFAULT_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"default"), "main");
    public static final ModelLayerLocation PB_DEFAULT_CRYSTAL_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"default_crystal"), "main");
    public static final ModelLayerLocation PB_DEFAULT_SHELL_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"default_shell"), "main");
    public static final ModelLayerLocation PB_DEFAULT_FOLIAGE_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"default_foliage"), "main");
    public static final ModelLayerLocation PB_ELVIS_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"elvis"), "main");
    public static final ModelLayerLocation PB_SMALL_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"small"), "main");
    public static final ModelLayerLocation PB_SLIM_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"slim"), "main");
    public static final ModelLayerLocation PB_TINY_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"tiny"), "main");
    public static final ModelLayerLocation PB_SLIMY_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"translucent_with_center"), "main");
    protected boolean isChristmas;
    protected boolean isAprilFool;

    public ProductiveBeeRenderer(EntityRendererProvider.Context context) {
        this(context, new ProductiveBeeModel<ProductiveBee>(context.bakeLayer(PB_MAIN_LAYER)));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_THICC_LAYER), "thicc", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_DEFAULT_LAYER), "default", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_DEFAULT_CRYSTAL_LAYER), "default_crystal", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_DEFAULT_SHELL_LAYER), "default_shell", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_DEFAULT_FOLIAGE_LAYER), "default_foliage", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_ELVIS_LAYER), "elvis", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_SMALL_LAYER), "small", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_SLIM_LAYER), "slim", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_TINY_LAYER), "tiny", this.isChristmas));
        this.addLayer(new BeeBodyLayer((RenderLayerParent<ProductiveBee, ProductiveBeeModel<ProductiveBee>>)this, context.bakeLayer(PB_SLIMY_LAYER), "translucent_with_center", this.isChristmas));
    }

    public ProductiveBeeRenderer(EntityRendererProvider.Context context, ProductiveBeeModel<ProductiveBee> model) {
        super(context, model, 0.4f);
        Calendar calendar = Calendar.getInstance();
        if (((Boolean)ProductiveBeesConfig.CLIENT.alwaysChristmas.get()).booleanValue() || calendar.get(2) + 1 == 12 && calendar.get(5) >= 21 && calendar.get(5) <= 26) {
            boolean bl = this.isChristmas = (Boolean)ProductiveBeesConfig.CLIENT.neverChristmas.get() == false;
        }
        if (calendar.get(2) + 1 == 4 && calendar.get(5) <= 1) {
            this.isAprilFool = (Boolean)ProductiveBeesConfig.GENERAL.enableJokes.get();
        }
    }

    protected void setupRotations(ProductiveBee pEntity, PoseStack pPoseStack, float pBob, float pYBodyRot, float pPartialTick, float pScale) {
        ConfigurableBee configurableBee;
        super.setupRotations((LivingEntity)pEntity, pPoseStack, pBob, pYBodyRot, pPartialTick, pScale);
        if (this.isAprilFool || pEntity instanceof ConfigurableBee && (configurableBee = (ConfigurableBee)pEntity).getRenderTransform().equals("flipped")) {
            pPoseStack.translate(0.0, (double)(pEntity.getBbHeight() + 0.1f), 0.0);
            pPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    @Nullable
    protected RenderType getRenderType(ProductiveBee bee, boolean b1, boolean b2, boolean b3) {
        if (bee instanceof ConfigurableBee && ((ConfigurableBee)bee).isTranslucent()) {
            return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(bee));
        }
        return super.getRenderType((LivingEntity)bee, b1, b2, b3);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(ProductiveBee bee) {
        Object textureLocation = "productivebees:textures/entity/bee/" + bee.getBeeName() + "/bee";
        if (bee instanceof BumbleBee && bee.hasCustomName() && bee.getCustomName().getString().equals("Bleh")) {
            textureLocation = "productivebees:textures/entity/bee/" + bee.getBeeName() + "_bleh/bee";
        }
        if (bee.isColored()) {
            String modelType = bee.getRenderer();
            textureLocation = "productivebees:textures/entity/bee/base/" + modelType + "/bee";
        }
        if (bee instanceof ConfigurableBee && ((ConfigurableBee)bee).hasBeeTexture()) {
            textureLocation = ((ConfigurableBee)bee).getBeeTexture();
        }
        if (bee.isAngry()) {
            textureLocation = (String)textureLocation + "_angry";
        }
        if (bee.hasNectar()) {
            textureLocation = (String)textureLocation + "_nectar";
        }
        return ProductiveBeeRenderer.resLoc((String)textureLocation + ".png");
    }

    public static ResourceLocation resLoc(String key) {
        if (!resLocCache.containsKey(key)) {
            resLocCache.put(key, ResourceLocation.parse((String)key));
        }
        return resLocCache.get(key);
    }
}

