/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumCrystalBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumElvisBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumFoliageBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumShellBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.PartialBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimyBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SmallBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ThiccBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.TinyBeeModel;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ModelUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ProductiveBeeModel<T extends ProductiveBee>
extends AgeableListModel<T> {
    protected float FAKE_PI = (float)Math.PI;
    public static final String BONE = "bone";
    public static final String BODY = "body";
    public static final String STINGER = "stinger";
    public static final String LEFT_ANTENNA = "left_antenna";
    public static final String RIGHT_ANTENNA = "right_antenna";
    public static final String RIGHT_WING = "right_wing";
    public static final String LEFT_WING = "left_wing";
    public static final String FRONT_LEGS = "front_legs";
    public static final String MIDDLE_LEGS = "middle_legs";
    public static final String BACK_LEGS = "back_legs";
    public static final String EXTERNALS = "externals";
    public static final String INNARDS = "innards";
    public static final String SANTA_HAT = "santa_hat";
    protected ModelPart bone;
    protected ModelPart body;
    protected ModelPart rightWing;
    protected ModelPart leftWing;
    protected ModelPart frontLegs;
    protected ModelPart middleLegs;
    protected ModelPart backLegs;
    protected ModelPart stinger;
    protected ModelPart leftAntenna;
    protected ModelPart rightAntenna;
    protected ModelPart externals;
    protected ModelPart innards;
    protected ModelPart santaHat;
    protected PartialBeeModel partialModel;
    protected float rollAmount;
    public float beeSize = 1.0f;

    public ProductiveBeeModel(ModelPart modelPart) {
        this(modelPart, false, 24.0f, 0.0f);
    }

    public ProductiveBeeModel(ModelPart modelPart, boolean isChildHeadScaled, float childHeadOffsetY, float childHeadOffsetZ) {
        super(isChildHeadScaled, childHeadOffsetY, childHeadOffsetZ);
        this.bone = modelPart.getChild(BONE);
        this.body = this.bone.getChild(BODY);
        this.stinger = this.body.getChild(STINGER);
        this.leftAntenna = this.body.getChild(LEFT_ANTENNA);
        this.rightAntenna = this.body.getChild(RIGHT_ANTENNA);
        this.rightWing = this.bone.getChild(RIGHT_WING);
        this.leftWing = this.bone.getChild(LEFT_WING);
        this.frontLegs = this.bone.getChild(FRONT_LEGS);
        this.middleLegs = this.bone.getChild(MIDDLE_LEGS);
        this.backLegs = this.bone.getChild(BACK_LEGS);
        this.externals = this.body.getChild(EXTERNALS);
        this.innards = this.body.getChild(INNARDS);
        this.santaHat = this.body.getChild(SANTA_HAT);
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.create((MeshDefinition)ProductiveBeeModel.createMeshDefinition(), (int)64, (int)64);
    }

    protected static MeshDefinition createMeshDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.getRoot();
        PartDefinition bone = root.addOrReplaceChild(BONE, CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition body = bone.addOrReplaceChild(BODY, CubeListBuilder.create(), PartPose.ZERO);
        body.addOrReplaceChild(STINGER, CubeListBuilder.create(), PartPose.ZERO);
        body.addOrReplaceChild(LEFT_ANTENNA, CubeListBuilder.create(), PartPose.ZERO);
        body.addOrReplaceChild(RIGHT_ANTENNA, CubeListBuilder.create(), PartPose.ZERO);
        bone.addOrReplaceChild(RIGHT_WING, CubeListBuilder.create(), PartPose.ZERO);
        bone.addOrReplaceChild(LEFT_WING, CubeListBuilder.create(), PartPose.ZERO);
        bone.addOrReplaceChild(FRONT_LEGS, CubeListBuilder.create(), PartPose.ZERO);
        bone.addOrReplaceChild(MIDDLE_LEGS, CubeListBuilder.create(), PartPose.ZERO);
        bone.addOrReplaceChild(BACK_LEGS, CubeListBuilder.create(), PartPose.ZERO);
        body.addOrReplaceChild(INNARDS, CubeListBuilder.create(), PartPose.ZERO);
        body.addOrReplaceChild(EXTERNALS, CubeListBuilder.create(), PartPose.ZERO);
        body.addOrReplaceChild(SANTA_HAT, CubeListBuilder.create(), PartPose.ZERO);
        return meshDefinition;
    }

    public ProductiveBeeModel(ModelPart modelPart, String modelType) {
        this(modelPart, false, 24.0f, 0.0f);
        this.partialModel = switch (modelType) {
            case "thicc" -> new ThiccBeeModel(modelPart);
            case "small" -> new SmallBeeModel(modelPart);
            case "slim" -> new SlimBeeModel(modelPart);
            case "tiny" -> new TinyBeeModel(modelPart);
            case "elvis" -> new MediumElvisBeeModel(modelPart);
            case "default_shell" -> new MediumShellBeeModel(modelPart);
            case "default_foliage" -> new MediumFoliageBeeModel(modelPart);
            case "default_crystal" -> new MediumCrystalBeeModel(modelPart);
            case "translucent_with_center" -> new SlimyBeeModel(modelPart);
            default -> new MediumBeeModel(modelPart);
        };
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        this.rollAmount = entity.getRollAmount(partialTicks);
        boolean bl = this.stinger.visible = !entity.hasStung();
        if (this.stinger.visible && entity instanceof ConfigurableBee && ((ConfigurableBee)entity).isStingless()) {
            this.stinger.visible = false;
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean grounded;
        this.leftAntenna.xRot = 0.0f;
        this.rightAntenna.xRot = 0.0f;
        this.bone.xRot = 0.0f;
        this.bone.y = 19.0f;
        boolean bl = grounded = entity.onGround() && entity.getDeltaMovement().lengthSqr() < 1.0E-7;
        if (grounded) {
            this.setRotationAngle(this.rightWing, 0.0f, -0.2618f, 0.0f);
            this.setRotationAngle(this.leftWing, 0.0f, 0.2618f, 0.0f);
            this.frontLegs.xRot = 0.0f;
            this.middleLegs.xRot = 0.0f;
            this.backLegs.xRot = 0.0f;
        } else {
            this.setRotationAngle(this.rightWing, 0.0f, 0.0f, Mth.cos((float)(ageInTicks % 98000.0f * 2.1f)) * this.FAKE_PI * 0.15f);
            this.setRotationAngle(this.leftWing, this.rightWing.xRot, this.rightWing.yRot, -this.rightWing.zRot);
            this.frontLegs.xRot = 0.7853982f;
            this.middleLegs.xRot = 0.7853982f;
            this.backLegs.xRot = 0.7853982f;
            this.setRotationAngle(this.bone, 0.0f, 0.0f, 0.0f);
        }
        if (!((ProductiveBee)entity).isAngry()) {
            this.bone.xRot = 0.0f;
            this.bone.yRot = 0.0f;
            this.bone.zRot = 0.0f;
            if (!grounded) {
                float angle = Mth.cos((float)(ageInTicks * 0.18f));
                this.bone.xRot = 0.1f + angle * this.FAKE_PI * 0.025f;
                this.leftAntenna.xRot = angle * this.FAKE_PI * 0.03f;
                this.rightAntenna.xRot = angle * this.FAKE_PI * 0.03f;
                this.frontLegs.xRot = -angle * this.FAKE_PI * 0.1f + 0.3926991f;
                if (!entity.getRenderer().equals("thicc")) {
                    this.backLegs.xRot = -angle * this.FAKE_PI * 0.05f + 0.7853982f;
                }
                this.bone.y = 19.0f - angle * 0.9f;
            }
        }
        if (this.rollAmount > 0.0f) {
            this.bone.xRot = ModelUtils.rotlerpRad((float)this.bone.xRot, (float)3.0915928f, (float)this.rollAmount);
        }
        this.beeSize = entity.getSizeModifier();
        if (this.young) {
            this.beeSize /= 2.0f;
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.bone);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer renderBuffer, int packedLightIn, int packedOverlayIn, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0, 1.5 - (double)this.beeSize * 1.5, 0.0);
        poseStack.scale(this.beeSize, this.beeSize, this.beeSize);
        super.renderToBuffer(poseStack, renderBuffer, packedLightIn, packedOverlayIn, color);
        poseStack.popPose();
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

