/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Amber
extends BaseEntityBlock {
    public static final MapCodec<Amber> CODEC = Amber.simpleCodec(Amber::new);

    public Amber(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : Amber.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.AMBER.get()), AmberBlockEntity::serverTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AmberBlockEntity(pos, state);
    }

    public void setPlacedBy(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity player, @Nonnull ItemStack stack) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (!level.isClientSide() && tileEntity instanceof AmberBlockEntity) {
            AmberBlockEntity amberBlockEntity = (AmberBlockEntity)tileEntity;
            if (stack.has(DataComponents.ENTITY_DATA)) {
                CompoundTag tag = ((CustomData)stack.get(DataComponents.ENTITY_DATA)).copyTag();
                amberBlockEntity.loadPacketNBT(tag, (HolderLookup.Provider)level.registryAccess());
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.AMBER.get());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AmberBlockEntity) {
            try {
                blockEntity.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stack;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState below = level.getBlockState(pos.below());
        if (below.is(BlockTags.CAMPFIRES)) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                this.trySpawnDripParticles(level, pos, state);
            }
        }
    }

    private void trySpawnDripParticles(Level level, BlockPos pos, BlockState state) {
        VoxelShape voxelshape;
        double d0;
        if (state.getFluidState().isEmpty() && !(level.random.nextFloat() < 0.3f) && (d0 = (voxelshape = state.getCollisionShape((BlockGetter)level, pos)).max(Direction.Axis.Y)) >= 1.0 && !state.is(BlockTags.IMPERMEABLE)) {
            double d1 = voxelshape.min(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.spawnParticle(level, pos, voxelshape, (double)pos.getY() + d1 - 0.05);
            } else {
                BlockPos blockpos = pos.below();
                BlockState blockstate = level.getBlockState(blockpos);
                VoxelShape voxelshape1 = blockstate.getCollisionShape((BlockGetter)level, blockpos);
                double d2 = voxelshape1.max(Direction.Axis.Y);
                if ((d2 < 1.0 || !blockstate.isCollisionShapeFullBlock((BlockGetter)level, blockpos)) && blockstate.getFluidState().isEmpty()) {
                    this.spawnParticle(level, pos, voxelshape, (double)pos.getY() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(Level level, BlockPos pos, VoxelShape voxelShape, double y) {
        this.spawnFluidParticle(level, (double)pos.getX() + voxelShape.min(Direction.Axis.X), (double)pos.getX() + voxelShape.max(Direction.Axis.X), (double)pos.getZ() + voxelShape.min(Direction.Axis.Z), (double)pos.getZ() + voxelShape.max(Direction.Axis.Z), y);
    }

    private void spawnFluidParticle(Level level, double xMin, double xMax, double zMin, double zMax, double y) {
        level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, Mth.lerp((double)level.random.nextDouble(), (double)xMin, (double)xMax), y, Mth.lerp((double)level.random.nextDouble(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }
}

