/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivelib.common.block.entity.AbstractBlockEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class AmberBlockEntity
extends AbstractBlockEntity {
    private int tickCounter = 0;
    private int meltCounter = 0;
    private static final Map<Integer, Entity> cachedEntities = new HashMap<Integer, Entity>();
    public CompoundTag entityTag = null;

    public AmberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.AMBER.get(), pos, state);
    }

    @Nullable
    public Entity getCachedEntity() {
        if (this.entityTag != null) {
            int key = this.entityTag.hashCode();
            if (!cachedEntities.containsKey(key)) {
                Entity cachedEntity = AmberBlockEntity.createEntity(this.level, this.entityTag);
                cachedEntities.put(key, cachedEntity);
            }
            return cachedEntities.getOrDefault(key, null);
        }
        return null;
    }

    @Nullable
    public static Entity createEntity(Level world, CompoundTag tag) {
        EntityType type;
        if (tag != null && (type = (EntityType)EntityType.byString((String)tag.getString("id")).orElse(null)) != null) {
            try {
                Entity loadedEntity = type.create(world);
                if (loadedEntity != null) {
                    loadedEntity.load(tag);
                    return loadedEntity;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.entityTag != null) {
            tag.put("EntityData", (Tag)this.entityTag);
        }
        tag.putInt("meltCounter", this.meltCounter);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("EntityData")) {
            this.entityTag = tag.getCompound("EntityData");
        }
        this.meltCounter = tag.contains("meltCounter") ? tag.getInt("meltCounter") : 0;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        this.entityTag = ((CustomData)pComponentInput.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()))).copyTag();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)this.entityTag));
    }

    public void setEntity(Mob target) {
        CompoundTag entityDataTag = target.saveWithoutId(new CompoundTag());
        entityDataTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()).toString());
        entityDataTag.putString("lootTable", target.getLootTable().toString());
        if (target.hasCustomName()) {
            entityDataTag.putString("name", target.getCustomName().getString());
        } else {
            entityDataTag.putString("name", target.getName().getString());
        }
        this.entityTag = entityDataTag;
        AdvancedBeehiveBlockEntityAbstract.removeIgnoredTags(this.entityTag);
        if (this.entityTag.contains("ActiveEffects")) {
            this.entityTag.remove("ActiveEffects");
        }
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, AmberBlockEntity amberBlockEntity) {
        BlockState below = level.getBlockState(blockPos.below());
        if (level instanceof ServerLevel && ++amberBlockEntity.tickCounter % 21 == 0 && below.is(BlockTags.CAMPFIRES)) {
            int meltingTime;
            amberBlockEntity.meltCounter += 21;
            int n = meltingTime = below.is(Blocks.SOUL_CAMPFIRE) ? 400 : 800;
            if (amberBlockEntity.meltCounter > meltingTime) {
                amberBlockEntity.meltCounter = -100000;
                Entity mob = AmberBlockEntity.createEntity(level, amberBlockEntity.entityTag);
                if (mob != null) {
                    mob.setPos((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                    List players = level.getEntitiesOfClass(Player.class, new AABB(blockPos).inflate(10.0, 5.0, 10.0));
                    if (players.size() > 0 && mob instanceof PathfinderMob) {
                        PathfinderMob pathfinderMob = (PathfinderMob)mob;
                        pathfinderMob.setLastHurtByMob((LivingEntity)players.iterator().next());
                    }
                    level.addFreshEntity(mob);
                    level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                }
            }
        }
    }
}

