/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.solitary;

import cy.jdkdigital.productivebees.common.advancements.criterion.SaddleBeeTrigger;
import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBee;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BumbleBee
extends SolitaryBee
implements ItemSteerable,
Saddleable {
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.defineId(BumbleBee.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.defineId(BumbleBee.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ItemBasedSteering steering;

    public BumbleBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.steering = new ItemBasedSteering(this.entityData, BOOST_TIME, SADDLED);
        this.beehiveInterests = poi -> poi.value() == ModPointOfInterestTypes.BUMBLE_BEE_NEST.get();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TREAT_ON_A_STICK.get()}), false));
    }

    @Override
    public String getRenderer() {
        return "thicc";
    }

    @Override
    public TagKey<Block> getNestingTag() {
        return ModTags.BUMBLE_BEE_NESTS;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Player player;
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player && ((player = (Player)entity).getMainHandItem().is((Item)ModItems.TREAT_ON_A_STICK.get()) || player.getOffhandItem().is((Item)ModItems.TREAT_ON_A_STICK.get()))) {
            return player;
        }
        return null;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (BOOST_TIME.equals(key) && this.level().isClientSide) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(key);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SADDLED, (Object)false);
        pBuilder.define(BOOST_TIME, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.steering.addAdditionalSaveData(compound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.steering.readAdditionalSaveData(compound);
    }

    public boolean isSaddled() {
        return this.steering.hasSaddle();
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby();
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.isSaddled()) {
            this.spawnAtLocation((ItemLike)Items.SADDLE);
        }
    }

    public void equipSaddle(ItemStack stack, @Nullable SoundSource soundSource) {
        this.steering.setSaddle(true);
        if (soundSource != null) {
            this.level().playSound(null, (Entity)this, SoundEvents.PIG_SADDLE, soundSource, 0.5f, 1.0f);
        }
    }

    protected void tickRidden(Player rider, Vec3 direction) {
        super.tickRidden(rider, direction);
        this.setRot(rider.getYRot(), rider.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
    }

    @NotNull
    public Vec3 getRiddenInput(Player rider, Vec3 travelVec) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float getRiddenSpeed(Player rider) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.steering.boostFactor();
    }

    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    public float getSizeModifier() {
        return 1.25f + (this.hasCustomName() && this.getCustomName().getString().equals("Bleh") ? 1.0f : 0.0f);
    }

    @Nonnull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean flag = this.isFood(player.getItemInHand(hand));
        if (!flag && this.isSaddled() && !this.isVehicle() && !player.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                if (player instanceof ServerPlayer) {
                    ((SaddleBeeTrigger)((Object)ModAdvancements.SADDLE_BEE.get())).trigger((ServerPlayer)player, this);
                }
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public void travel(Vec3 vec3) {
        super.travel(vec3);
        if (this.hasPlayerPassenger()) {
            double dy;
            double d = !this.level().isEmptyBlock(this.blockPosition().below(3)) ? 0.1 : (dy = this.level().isEmptyBlock(this.blockPosition().below(1)) ? -0.05 : 0.0);
            if (dy != 0.0) {
                Vec3 vec = this.getDeltaMovement();
                this.setDeltaMovement(vec.x(), vec.y() + dy, vec.z());
            }
        }
    }

    private boolean hasPlayerPassenger() {
        Entity entity;
        return this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player;
    }
}

