/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;

public class BlockConversionRecipe
implements Recipe<RecipeInput> {
    public final List<Supplier<BeeIngredient>> bees;
    public Ingredient input;
    public final BlockState stateFrom;
    public final BlockState stateTo;
    public final float chance;
    public Optional<Ingredient> fromDisplay;
    public Optional<Ingredient> toDisplay;
    public boolean pollinates;

    public BlockConversionRecipe(List<Supplier<BeeIngredient>> bees, Ingredient input, BlockState from, BlockState to, float chance, Optional<Ingredient> fromDisplay, Optional<Ingredient> toDisplay, boolean pollinates) {
        this.bees = bees;
        this.input = input;
        this.stateFrom = from;
        this.stateTo = to;
        this.chance = chance;
        this.fromDisplay = fromDisplay;
        this.toDisplay = toDisplay;
        this.pollinates = pollinates;
    }

    public boolean matches(RecipeInput inv, Level level) {
        if (inv instanceof BeeHelper.BlockStateInventory && this.bees.size() > 0) {
            String beeName = ((BeeHelper.BlockStateInventory)inv).getIdentifier(0);
            BlockState blockState = ((BeeHelper.BlockStateInventory)inv).getState();
            boolean matchesBlock = !this.input.isEmpty() ? !blockState.getBlock().equals(this.stateTo.getBlock()) && this.input.test(new ItemStack((ItemLike)blockState.getBlock())) : blockState.equals(this.stateFrom) || blockState.getBlock().defaultBlockState().equals(this.stateFrom);
            boolean matchesBee = false;
            for (Supplier<BeeIngredient> bee : this.bees) {
                matchesBee = matchesBee || bee.get().getBeeType().toString().equals(beeName);
            }
            return matchesBee && matchesBlock;
        }
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public List<BeeIngredient> getBees() {
        ArrayList<BeeIngredient> list = new ArrayList<BeeIngredient>();
        this.bees.forEach(bee -> list.add((BeeIngredient)bee.get()));
        return list;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BLOCK_CONVERSION.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.BLOCK_CONVERSION_TYPE.get();
    }

    private static BlockState readBlockState(@Nullable CompoundTag tag) {
        if (tag == null) {
            return Blocks.AIR.defaultBlockState();
        }
        ResourceLocation resourcelocation = ResourceLocation.parse((String)tag.getString("Name"));
        Block block = (Block)BuiltInRegistries.BLOCK.get(resourcelocation);
        BlockState blockstate = block.defaultBlockState();
        if (tag.contains("Properties", 10)) {
            CompoundTag compoundtag = tag.getCompound("Properties");
            StateDefinition statedefinition = block.getStateDefinition();
            for (String propertyName : compoundtag.getAllKeys()) {
                Property property = statedefinition.getProperty(propertyName);
                if (property == null) continue;
                blockstate = BlockConversionRecipe.setValueHelper(blockstate, property, propertyName, compoundtag, tag);
            }
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState setValueHelper(BlockState blockState, Property<T> property, String propertyName, CompoundTag tag, CompoundTag stateTag) {
        Optional optional = property.getValue(tag.getString(propertyName));
        if (optional.isPresent()) {
            return (BlockState)blockState.setValue(property, (Comparable)optional.get());
        }
        ProductiveBees.LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)propertyName, (Object)tag.getString(propertyName), (Object)stateTag.toString());
        return blockState;
    }

    public static class Serializer
    implements RecipeSerializer<BlockConversionRecipe> {
        private static final MapCodec<BlockConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BeeIngredient.LIST_CODEC.fieldOf("bees").forGetter(recipe -> recipe.bees), (App)Ingredient.CODEC.fieldOf("input").orElse((Object)Ingredient.EMPTY).forGetter(recipe -> recipe.input), (App)BlockState.CODEC.fieldOf("from").orElse((Object)Blocks.AIR.defaultBlockState()).forGetter(recipe -> recipe.stateFrom), (App)BlockState.CODEC.fieldOf("to").forGetter(recipe -> recipe.stateTo), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.chance)), (App)Ingredient.CODEC.optionalFieldOf("from_display").forGetter(recipe -> recipe.fromDisplay), (App)Ingredient.CODEC.optionalFieldOf("to_display").forGetter(recipe -> recipe.toDisplay), (App)Codec.BOOL.fieldOf("pollinates").orElse((Object)false).forGetter(recipe -> recipe.pollinates)).apply((Applicative)builder, BlockConversionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockConversionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BlockConversionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BlockConversionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BlockConversionRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                int beeCount = buffer.readInt();
                ArrayList<Supplier<BeeIngredient>> bees = new ArrayList<Supplier<BeeIngredient>>();
                for (int i = 0; i < beeCount; ++i) {
                    BeeIngredient source = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                    bees.add((Supplier<BeeIngredient>)Lazy.of(() -> source));
                }
                Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
                BlockState from = BlockConversionRecipe.readBlockState(buffer.readNbt());
                BlockState to = BlockConversionRecipe.readBlockState(buffer.readNbt());
                return new BlockConversionRecipe(bees, input, from, to, buffer.readFloat(), Optional.of((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)), Optional.of((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)), buffer.readBoolean());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading block conversion recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BlockConversionRecipe recipe) {
            try {
                buffer.writeInt(recipe.bees.size());
                recipe.bees.forEach(bee -> ((BeeIngredient)bee.get()).toNetwork((FriendlyByteBuf)buffer));
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
                buffer.writeNbt((Tag)NbtUtils.writeBlockState((BlockState)recipe.stateFrom));
                buffer.writeNbt((Tag)NbtUtils.writeBlockState((BlockState)recipe.stateTo));
                buffer.writeFloat(recipe.chance);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.fromDisplay.orElse(Ingredient.EMPTY));
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.toDisplay.orElse(Ingredient.EMPTY));
                buffer.writeBoolean(recipe.pollinates);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing block conversion recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

