/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ConfigurableHoneycombRecipe
implements CraftingRecipe {
    public final Integer count;

    public ConfigurableHoneycombRecipe(Integer count) {
        this.count = count;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput inv, Level level) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        ResourceLocation type = null;
        if (stacks.size() == this.count.intValue()) {
            for (ItemStack itemstack : stacks) {
                if (!itemstack.isEmpty() && itemstack.getItem().equals(ModItems.CONFIGURABLE_HONEYCOMB.get()) && itemstack.has(ModDataComponents.BEE_TYPE)) {
                    if (type == null) {
                        type = (ResourceLocation)itemstack.get(ModDataComponents.BEE_TYPE);
                    }
                    if (type == null || type.equals(itemstack.get(ModDataComponents.BEE_TYPE))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() > 0) {
            ItemStack inStack = stacks.get(0);
            ItemStack outStack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            outStack.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)inStack.get(ModDataComponents.BEE_TYPE)));
            return outStack;
        }
        return ItemStack.EMPTY;
    }

    private List<ItemStack> getItemsInInventory(CraftingInput inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.count;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        for (int i = 0; i < this.count; ++i) {
            nonnulllist.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get())}));
        }
        return nonnulllist;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.CONFIGURABLE_HONEYCOMB.get();
    }

    public static class Serializer
    implements RecipeSerializer<ConfigurableHoneycombRecipe> {
        private static final MapCodec<ConfigurableHoneycombRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("count").orElse((Object)4).forGetter(recipe -> recipe.count)).apply((Applicative)builder, ConfigurableHoneycombRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConfigurableHoneycombRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ConfigurableHoneycombRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConfigurableHoneycombRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ConfigurableHoneycombRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new ConfigurableHoneycombRecipe(buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading config honeycomb recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, ConfigurableHoneycombRecipe recipe) {
            try {
                buffer.writeInt(recipe.count.intValue());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing config honeycomb recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

